/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.forcefield;

import chiropraxis.forcefield.EnergyTerm;

public class AngleTerm
implements EnergyTerm {
    int a;
    int b;
    int c;
    double k;
    double cos_t0;

    public AngleTerm(int n, int n2, int n3, double d, double d2) {
        this.a = n * 3;
        this.b = n2 * 3;
        this.c = n3 * 3;
        this.k = d2;
        this.cos_t0 = Math.cos(Math.toRadians(d));
    }

    public double eval(double[] dArray, double[] dArray2) {
        double d = dArray[this.a] - dArray[this.b];
        double d2 = dArray[this.a + 1] - dArray[this.b + 1];
        double d3 = dArray[this.a + 2] - dArray[this.b + 2];
        double d4 = dArray[this.c] - dArray[this.b];
        double d5 = dArray[this.c + 1] - dArray[this.b + 1];
        double d6 = dArray[this.c + 2] - dArray[this.b + 2];
        double d7 = d * d4 + d2 * d5 + d3 * d6;
        double d8 = (d * d + d2 * d2 + d3 * d3) * (d4 * d4 + d5 * d5 + d6 * d6);
        double d9 = Math.sqrt(d8);
        double d10 = d7 / d9;
        double d11 = d10 - this.cos_t0;
        double d12 = this.k * (d11 * d11);
        double d13 = 2.0 * this.k * d11 / d9;
        double d14 = d + d4;
        double d15 = d2 + d5;
        double d16 = d3 + d6;
        int n = this.a;
        dArray2[n] = dArray2[n] + d13 * (d4 - d7 * d / d8);
        int n2 = this.a + 1;
        dArray2[n2] = dArray2[n2] + d13 * (d5 - d7 * d2 / d8);
        int n3 = this.a + 2;
        dArray2[n3] = dArray2[n3] + d13 * (d6 - d7 * d3 / d8);
        int n4 = this.c;
        dArray2[n4] = dArray2[n4] + d13 * (d - d7 * d4 / d8);
        int n5 = this.c + 1;
        dArray2[n5] = dArray2[n5] + d13 * (d2 - d7 * d5 / d8);
        int n6 = this.c + 2;
        dArray2[n6] = dArray2[n6] + d13 * (d3 - d7 * d6 / d8);
        int n7 = this.b;
        dArray2[n7] = dArray2[n7] + d13 * (d7 * d14 / d8 - d14);
        int n8 = this.b + 1;
        dArray2[n8] = dArray2[n8] + d13 * (d7 * d15 / d8 - d15);
        int n9 = this.b + 2;
        dArray2[n9] = dArray2[n9] + d13 * (d7 * d16 / d8 - d16);
        return d12;
    }

    public double eval(double[] dArray) {
        double d = dArray[this.a] - dArray[this.b];
        double d2 = dArray[this.a + 1] - dArray[this.b + 1];
        double d3 = dArray[this.a + 2] - dArray[this.b + 2];
        double d4 = dArray[this.c] - dArray[this.b];
        double d5 = dArray[this.c + 1] - dArray[this.b + 1];
        double d6 = dArray[this.c + 2] - dArray[this.b + 2];
        double d7 = d * d4 + d2 * d5 + d3 * d6;
        double d8 = (d * d + d2 * d2 + d3 * d3) * (d4 * d4 + d5 * d5 + d6 * d6);
        double d9 = Math.sqrt(d8);
        double d10 = d7 / d9;
        double d11 = d10 - this.cos_t0;
        return this.k * (d11 * d11);
    }
}

