/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.forcefield;

import chiropraxis.forcefield.AngleTerm;
import chiropraxis.forcefield.BondTerm;
import chiropraxis.forcefield.EnergyTerm;
import chiropraxis.forcefield.GradientMinimizer;
import driftwood.r3.MutableTuple3;
import driftwood.r3.Triple;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;

public class StateManager {
    static final EnergyTerm[] emptyTerms = new EnergyTerm[0];
    MutableTuple3[] points;
    int nMobile;
    double[] state;
    double[] testState;
    public double[] gradient;
    double[] gBond;
    double[] gAngle;
    double[] gNonbond;
    double[] gExtra;
    EnergyTerm[] bondTerms = new EnergyTerm[0];
    EnergyTerm[] angleTerms = new EnergyTerm[0];
    EnergyTerm[] nbTerms = new EnergyTerm[0];
    EnergyTerm[] extraTerms = new EnergyTerm[0];
    double wBond = 1.0;
    double wAngle = 1.0;
    double wNonbond = 1.0;
    double wExtra = 1.0;
    Map indexTable;

    public StateManager(MutableTuple3[] mutableTuple3Array, int n) {
        this.points = (MutableTuple3[])mutableTuple3Array.clone();
        this.nMobile = n * 3;
        this.state = new double[mutableTuple3Array.length * 3];
        this.testState = new double[mutableTuple3Array.length * 3];
        this.gradient = new double[mutableTuple3Array.length * 3];
        this.gBond = new double[mutableTuple3Array.length * 3];
        this.gAngle = new double[mutableTuple3Array.length * 3];
        this.gNonbond = new double[mutableTuple3Array.length * 3];
        this.gExtra = new double[mutableTuple3Array.length * 3];
        this.indexTable = new IdentityHashMap();
        for (int i = 0; i < mutableTuple3Array.length; ++i) {
            this.indexTable.put(mutableTuple3Array[i], new Integer(i));
        }
        this.setState();
    }

    public void setState(MutableTuple3[] mutableTuple3Array) {
        if (mutableTuple3Array.length != this.points.length) {
            throw new IndexOutOfBoundsException("Must provide exactly " + this.points.length + " points");
        }
        int n = 0;
        for (int i = 0; i < mutableTuple3Array.length; ++i) {
            this.state[n] = this.testState[n] = mutableTuple3Array[i].getX();
            this.state[++n] = this.testState[n] = mutableTuple3Array[i].getY();
            this.state[++n] = this.testState[n] = mutableTuple3Array[i].getZ();
            ++n;
        }
    }

    public void setState() {
        this.setState(this.points);
    }

    public void getState(MutableTuple3[] mutableTuple3Array) {
        if (mutableTuple3Array.length != this.points.length) {
            throw new IndexOutOfBoundsException("Must provide exactly " + this.points.length + " points");
        }
        int n = 0;
        for (int i = 0; i < mutableTuple3Array.length; ++i) {
            mutableTuple3Array[i].setX(this.state[n++]);
            mutableTuple3Array[i].setY(this.state[n++]);
            mutableTuple3Array[i].setZ(this.state[n++]);
        }
    }

    public void getState() {
        this.getState(this.points);
    }

    public void setPoint(int n, double d, double d2, double d3) {
        int n2 = n * 3;
        this.state[n2] = d;
        this.state[n2 + 1] = d2;
        this.state[n2 + 2] = d3;
    }

    public void setPoint(int n) {
        int n2 = n * 3;
        this.state[n2] = this.points[n].getX();
        this.state[n2 + 1] = this.points[n].getY();
        this.state[n2 + 2] = this.points[n].getZ();
    }

    public void getPoint(int n, MutableTuple3 mutableTuple3) {
        int n2 = n * 3;
        mutableTuple3.setXYZ(this.state[n2], this.state[n2 + 1], this.state[n2 + 2]);
    }

    public int getIndex(MutableTuple3 mutableTuple3) {
        Integer n = (Integer)this.indexTable.get(mutableTuple3);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public void setBondTerms(Collection collection, double d) {
        this.bondTerms = collection.toArray(new EnergyTerm[collection.size()]);
        this.wBond = d;
    }

    public void setBondTerms(Collection collection) {
        this.setBondTerms(collection, 1.0);
    }

    public EnergyTerm[] getBondTerms() {
        return (EnergyTerm[])this.bondTerms.clone();
    }

    public void setAngleTerms(Collection collection, double d) {
        this.angleTerms = collection.toArray(new EnergyTerm[collection.size()]);
        this.wAngle = d;
    }

    public void setAngleTerms(Collection collection) {
        this.setAngleTerms(collection, 1.0);
    }

    public EnergyTerm[] getAngleTerms() {
        return (EnergyTerm[])this.angleTerms.clone();
    }

    public void setNbTerms(Collection collection, double d) {
        this.nbTerms = collection.toArray(new EnergyTerm[collection.size()]);
        this.wNonbond = d;
    }

    public void setNbTerms(Collection collection) {
        this.setNbTerms(collection, 1.0);
    }

    public EnergyTerm[] getNbTerms() {
        return (EnergyTerm[])this.nbTerms.clone();
    }

    public void setExtraTerms(Collection collection, double d) {
        this.extraTerms = collection.toArray(new EnergyTerm[collection.size()]);
        this.wExtra = d;
    }

    public void setExtraTerms(Collection collection) {
        this.setExtraTerms(collection, 1.0);
    }

    public EnergyTerm[] getExtraTerms() {
        return (EnergyTerm[])this.extraTerms.clone();
    }

    public double test(double d, double[] dArray) {
        for (int i = 0; i < this.nMobile; ++i) {
            this.testState[i] = this.state[i] + d * dArray[i];
        }
        return this.eval(this.testState);
    }

    public double accept() {
        double[] dArray = this.state;
        this.state = this.testState;
        this.testState = dArray;
        return this.eval(this.state, this.gradient);
    }

    public double accept(double d, double[] dArray) {
        for (int i = 0; i < this.nMobile; ++i) {
            this.testState[i] = this.state[i] + d * dArray[i];
        }
        double[] dArray2 = this.state;
        this.state = this.testState;
        this.testState = dArray2;
        return this.eval(this.state, this.gradient);
    }

    public double eval(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.bondTerms != null && this.wBond != 0.0) {
            Arrays.fill(this.gBond, 0.0);
            n2 = this.bondTerms.length;
            for (n = 0; n < n2; ++n) {
                d += this.bondTerms[n].eval(dArray, this.gBond);
            }
        }
        if (this.angleTerms != null && this.wAngle != 0.0) {
            Arrays.fill(this.gAngle, 0.0);
            n2 = this.angleTerms.length;
            for (n = 0; n < n2; ++n) {
                d2 += this.angleTerms[n].eval(dArray, this.gAngle);
            }
        }
        if (this.nbTerms != null && this.wNonbond != 0.0) {
            Arrays.fill(this.gNonbond, 0.0);
            n2 = this.nbTerms.length;
            for (n = 0; n < n2; ++n) {
                d3 += this.nbTerms[n].eval(dArray, this.gNonbond);
            }
        }
        if (this.extraTerms != null && this.wExtra != 0.0) {
            Arrays.fill(this.gExtra, 0.0);
            n2 = this.extraTerms.length;
            for (n = 0; n < n2; ++n) {
                d4 += this.extraTerms[n].eval(dArray, this.gExtra);
            }
        }
        n2 = dArray2.length;
        for (n = 0; n < n2; ++n) {
            dArray2[n] = this.wBond * this.gBond[n] + this.wAngle * this.gAngle[n] + this.wNonbond * this.gNonbond[n] + this.wExtra * this.gExtra[n];
        }
        return this.wBond * d + this.wAngle * d2 + this.wNonbond * d3 + this.wExtra * d4;
    }

    public double eval(double[] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.bondTerms != null && this.wBond != 0.0) {
            n2 = this.bondTerms.length;
            for (n = 0; n < n2; ++n) {
                d += this.bondTerms[n].eval(dArray);
            }
        }
        if (this.angleTerms != null && this.wAngle != 0.0) {
            n2 = this.angleTerms.length;
            for (n = 0; n < n2; ++n) {
                d2 += this.angleTerms[n].eval(dArray);
            }
        }
        if (this.nbTerms != null && this.wNonbond != 0.0) {
            n2 = this.nbTerms.length;
            for (n = 0; n < n2; ++n) {
                d3 += this.nbTerms[n].eval(dArray);
            }
        }
        if (this.extraTerms != null && this.wExtra != 0.0) {
            n2 = this.extraTerms.length;
            for (n = 0; n < n2; ++n) {
                d4 += this.extraTerms[n].eval(dArray);
            }
        }
        return this.wBond * d + this.wAngle * d2 + this.wNonbond * d3 + this.wExtra * d4;
    }

    public static void main(String[] stringArray) {
        int n;
        MutableTuple3[] mutableTuple3Array = new Triple[42];
        for (int i = 0; i < mutableTuple3Array.length - 2; ++i) {
            mutableTuple3Array[i] = new Triple(10.0 * Math.random(), 10.0 * Math.random(), 10.0 * Math.random());
        }
        mutableTuple3Array[mutableTuple3Array.length - 2] = new Triple(0.0, 0.0, 0.0);
        mutableTuple3Array[mutableTuple3Array.length - 1] = new Triple(10.0, 10.0, 10.0);
        ArrayList<BondTerm> arrayList = new ArrayList<BondTerm>();
        for (int i = 0; i < mutableTuple3Array.length - 3; ++i) {
            arrayList.add(new BondTerm(i, i + 1, 1.0, 1.0));
        }
        arrayList.add(new BondTerm(mutableTuple3Array.length - 3, mutableTuple3Array.length - 1, 0.0, 1.0));
        arrayList.add(new BondTerm(0, mutableTuple3Array.length - 2, 0.0, 1.0));
        ArrayList<AngleTerm> arrayList2 = new ArrayList<AngleTerm>();
        for (int i = 0; i < mutableTuple3Array.length - 4; ++i) {
            arrayList2.add(new AngleTerm(i, i + 1, i + 2, 120.0, 1.0));
        }
        StateManager stateManager = new StateManager(mutableTuple3Array, mutableTuple3Array.length - 2);
        stateManager.setBondTerms(arrayList);
        stateManager.setAngleTerms(arrayList2);
        GradientMinimizer gradientMinimizer = new GradientMinimizer(stateManager);
        PrintStream printStream = System.out;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@kinemage 1");
        int n2 = 0;
        for (n = 0; n < 100; ++n) {
            printStream.println("@group {step " + n + "} animate dominant");
            printStream.println("@vectorlist {step " + n + "}");
            for (int i = 0; i < mutableTuple3Array.length - 2; ++i) {
                printStream.println("{} " + ((Triple)mutableTuple3Array[i]).format(decimalFormat));
            }
            if (!gradientMinimizer.step()) break;
            System.err.println(n + ": " + gradientMinimizer.getFuncEvals() + " evals; dE = " + decimalFormat.format(100.0 * gradientMinimizer.getFracDeltaEnergy()) + "% (" + decimalFormat.format(gradientMinimizer.getDeltaEnergy()) + "); |G| = " + decimalFormat.format(gradientMinimizer.getGradMag()));
            n2 += gradientMinimizer.getFuncEvals();
            stateManager.getState();
        }
        System.err.println("Average " + n2 / (n + 1) + " evals per step");
    }
}

