/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelManager2;
import chiropraxis.kingtools.Remodeler;
import chiropraxis.kingtools.SidechainRotator;
import chiropraxis.mc.CaRotation;
import chiropraxis.rotarama.Ramachandran;
import chiropraxis.rotarama.TauByPhiPsi;
import driftwood.gui.AngleDial;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.util.SoftLog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.KinCanvas;
import king.KingMain;
import king.core.AHE;
import king.core.KList;
import king.core.KPalette;
import king.points.BallPoint;

public class BackrubWindow
implements Remodeler,
ChangeListener,
WindowListener {
    static final DecimalFormat df1 = new DecimalFormat("+0.0;-0.0");
    static final DecimalFormat df0 = new DecimalFormat("0");
    static final Color normalColor = new Color(0.0f, 0.0f, 0.0f);
    static final Color alertColor = new Color(0.6f, 0.0f, 0.0f);
    KingMain kMain;
    KinCanvas kCanvas;
    ModelManager2 modelman;
    Window dialog;
    Residue anchor1;
    Residue ctrRes;
    Residue anchor2;
    KList anchorList;
    Ramachandran rama = null;
    TauByPhiPsi tauscorer = null;
    TablePane2 toolpane;
    AngleDial hingeDial;
    AngleDial pept1Dial;
    AngleDial pept2Dial;
    JLabel[] headerLabels;
    JLabel[] res1Labels;
    JLabel[] res2Labels;
    JLabel[] res3Labels;
    JCheckBox cbIdealizeSC;

    public BackrubWindow(KingMain kingMain, Residue residue, ModelManager2 modelManager2) {
        this.kMain = kingMain;
        this.kCanvas = kingMain.getCanvas();
        this.modelman = modelManager2;
        this.ctrRes = residue;
        this.anchorList = new KList("ball");
        this.anchorList.setColor(KPalette.peach);
        this.buildGUI(kingMain.getTopWindow());
        try {
            this.rama = Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.tauscorer = TauByPhiPsi.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Model model = this.modelman.getModel();
        ModelState modelState = this.modelman.getMoltenState();
        this.anchor1 = this.ctrRes.getPrev(model);
        this.anchor2 = this.ctrRes.getNext(model);
        if (this.anchor1 == null || this.anchor2 == null) {
            this.dialog.dispose();
            throw new IllegalArgumentException("Can't find neighbor residues for " + residue);
        }
        this.markAnchor(this.anchor1, modelState);
        this.markAnchor(this.anchor2, modelState);
        Collection collection = CaRotation.makeMobileGroup(this.modelman.getModel(), this.anchor1, this.anchor2);
        this.modelman.registerTool(this, collection);
        this.stateChanged(null);
    }

    private void buildGUI(Frame frame) {
        this.hingeDial = new AngleDial();
        this.hingeDial.addChangeListener(this);
        this.pept1Dial = new AngleDial();
        this.pept1Dial.addChangeListener(this);
        this.pept2Dial = new AngleDial();
        this.pept2Dial.addChangeListener(this);
        JButton jButton = new JButton(new ReflectiveAction("Finished", null, this, "onReleaseResidues"));
        JButton jButton2 = new JButton(new ReflectiveAction("Rotate sidechain", null, this, "onRotateSidechain"));
        this.headerLabels = new JLabel[]{new JLabel("Residue"), new JLabel("Tau dev"), new JLabel("Karplus"), new JLabel("Ramachdrn"), new JLabel("phi,psi")};
        this.res1Labels = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
        this.res2Labels = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
        this.res3Labels = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
        this.cbIdealizeSC = new JCheckBox(new ReflectiveAction("Idealize sidechains", null, this, "onToggleIdealSC"));
        this.cbIdealizeSC.setSelected(false);
        this.toolpane = new TablePane2();
        this.toolpane.skip();
        this.toolpane.addCell(this.pept1Dial);
        this.toolpane.addCell(this.hingeDial);
        this.toolpane.addCell(this.pept2Dial);
        this.toolpane.newRow();
        for (int i = 0; i < this.headerLabels.length; ++i) {
            if (i == 2) continue;
            this.toolpane.add(this.headerLabels[i]);
            this.toolpane.add(this.res1Labels[i]);
            this.toolpane.add(this.res2Labels[i]);
            this.toolpane.add(this.res3Labels[i]);
            this.toolpane.newRow();
        }
        this.toolpane.newRow();
        this.toolpane.addCell(TablePane2.strut(0, 10));
        this.toolpane.newRow();
        this.toolpane.startSubtable(4, 1);
        this.toolpane.addCell(jButton);
        this.toolpane.addCell(this.cbIdealizeSC);
        this.toolpane.addCell(jButton2);
        this.toolpane.endSubtable();
        if (this.kMain.getPrefs().getBoolean("minimizableTools")) {
            JFrame jFrame = new JFrame("BACKRUB: " + this.ctrRes.toString());
            jFrame.setDefaultCloseOperation(0);
            jFrame.setContentPane(this.toolpane);
            this.dialog = jFrame;
        } else {
            JDialog jDialog = new JDialog(frame, "BACKRUB: " + this.ctrRes.toString(), false);
            jDialog.setDefaultCloseOperation(0);
            jDialog.setContentPane(this.toolpane);
            this.dialog = jDialog;
        }
        this.dialog.addWindowListener(this);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    void markAnchor(Residue residue, ModelState modelState) {
        Atom atom = residue.getAtom(" CA ");
        if (atom == null) {
            return;
        }
        try {
            AtomState atomState = modelState.get(atom);
            BallPoint ballPoint = new BallPoint("C-alpha axis endpoint");
            ballPoint.r0 = 0.3f;
            ballPoint.setX(atomState.getX());
            ballPoint.setY(atomState.getY());
            ballPoint.setZ(atomState.getZ());
            this.anchorList.add((AHE)ballPoint);
            this.kCanvas.repaint();
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.modelman.requestStateRefresh();
        this.updateLabels();
        this.kCanvas.repaint();
    }

    public ModelState updateModelState(ModelState modelState) {
        try {
            Collection collection = CaRotation.makeMobileGroup(this.modelman.getModel(), this.anchor1, this.anchor2);
            boolean bl = this.cbIdealizeSC.isSelected();
            ModelState modelState2 = CaRotation.makeConformation(collection, modelState, this.hingeDial.getDegrees(), bl);
            Residue[] residueArray = collection.toArray(new Residue[collection.size()]);
            double[] dArray = new double[]{this.pept1Dial.getDegrees(), this.pept2Dial.getDegrees()};
            boolean[] blArray = new boolean[]{bl, bl, bl};
            modelState2 = CaRotation.twistPeptides(residueArray, modelState2, dArray, blArray);
            return modelState2;
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
            return modelState;
        }
    }

    public void onToggleIdealSC(ActionEvent actionEvent) {
        this.stateChanged(null);
    }

    void updateLabels() {
        this.updateLabels(this.anchor1, this.res1Labels);
        this.updateLabels(this.ctrRes, this.res2Labels);
        this.updateLabels(this.anchor2, this.res3Labels);
    }

    /*
     * Unable to fully structure code
     */
    void updateLabels(Residue var1_1, JLabel[] var2_2) {
        for (var3_3 = 0; var3_3 < var2_2.length; ++var3_3) {
            var2_2[var3_3].setForeground(BackrubWindow.normalColor);
        }
        if (var1_1 == null) {
            for (var3_3 = 0; var3_3 < var2_2.length; ++var3_3) {
                var2_2[var3_3].setText("");
            }
        } else {
            var2_2[0].setText(var1_1.toString());
            var3_4 = this.modelman.getModel();
            var4_5 = this.modelman.getMoltenState();
            try {
                var5_6 = AminoAcid.getTauDeviation(var1_1, var4_5);
                var2_2[1].setText(BackrubWindow.df1.format(var5_6));
                if (Math.abs(var5_6) >= 3.0) {
                    var2_2[1].setForeground(BackrubWindow.alertColor);
                }
            }
            catch (AtomException var5_7) {
                var2_2[1].setText("-?-");
            }
            try {
                var5_6 = AminoAcid.getPhi(var3_4, var1_1, var4_5);
                var7_10 = AminoAcid.getPsi(var3_4, var1_1, var4_5);
                var2_2[4].setText(BackrubWindow.df0.format(var5_6) + " , " + BackrubWindow.df0.format(var7_10));
                if (this.rama == null) {
                    var2_2[3].setText("[no data]");
                } else if (this.rama.isOutlier(var3_4, var1_1, var4_5)) {
                    var2_2[3].setText("OUTLIER");
                    var2_2[3].setForeground(BackrubWindow.alertColor);
                } else if (this.rama.rawScore(var3_4, var1_1, var4_5) > 0.02) {
                    var2_2[3].setText("favored");
                } else {
                    var2_2[3].setText("allowed");
                }
                if (this.tauscorer == null) {
                    var2_2[2].setText("[no data]");
                }
                var9_11 = this.tauscorer.getTauDeviation(var3_4, var1_1, var4_5);
                var2_2[2].setText(BackrubWindow.df1.format(var9_11));
                if (!(Math.abs(var9_11) >= 3.0)) ** GOTO lbl52
                var2_2[2].setForeground(BackrubWindow.alertColor);
            }
            catch (AtomException var5_8) {
                var2_2[2].setText("-?-");
                var2_2[3].setText("[no phi,psi]");
                var2_2[4].setText("? , ?");
            }
            catch (ResidueException var5_9) {
                var2_2[2].setText("-?-");
                var2_2[3].setText("[no phi,psi]");
                var2_2[4].setText("? , ?");
            }
        }
lbl52:
        // 6 sources

        this.dialog.pack();
    }

    public void onReleaseResidues(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "Do you want to keep the changes\nyou've made to these residues?", "Keep changes?", 1, 3);
        if (n == 2) {
            return;
        }
        if (n == 0) {
            this.modelman.requestStateChange(this);
            this.modelman.addUserMod("Refit backbone of " + this.ctrRes);
        } else {
            this.modelman.unregisterTool(this);
        }
        this.dialog.dispose();
        this.kCanvas.repaint();
    }

    public void onRotateSidechain(ActionEvent actionEvent) {
        try {
            new SidechainRotator(this.kMain, this.ctrRes, this.modelman);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.onReleaseResidues(null);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

