/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelManager2;
import chiropraxis.kingtools.Remodeler;
import chiropraxis.kingtools.SidechainRotator;
import chiropraxis.rotarama.Rotamer;
import chiropraxis.sc.RotamerDef;
import chiropraxis.sc.SidechainAngles2;
import chiropraxis.sc.SidechainIdealizer;
import chiropraxis.sc.SidechainsLtoD;
import driftwood.gui.AngleDial;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.gui.TablePane2;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.SoftLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import king.KingMain;

public class MethylRotator
implements Remodeler,
ChangeListener,
ListSelectionListener,
WindowListener {
    static final DecimalFormat df1 = new DecimalFormat("+0.0;-0.0");
    static final DecimalFormat df0 = new DecimalFormat("0");
    static final Color normalColor = new Color(0.0f, 0.0f, 0.0f);
    static final Color mediumColor = new Color(0.3f, 0.0f, 0.0f);
    static final Color alertColor = new Color(0.6f, 0.0f, 0.0f);
    KingMain kMain;
    Residue targetRes;
    ModelManager2 modelman;
    SidechainAngles2 scAngles;
    Rotamer rotamer;
    SidechainIdealizer scIdealizer = null;
    SidechainsLtoD scFlipper = null;
    Window dialog;
    JCheckBox cbIdealize;
    JCheckBox useDaa;
    JList rotamerList;
    AngleDial[] dials;
    JLabel[] labels;
    boolean isUpdating = false;

    public MethylRotator(KingMain kingMain, Residue residue, ModelManager2 modelManager2) throws IOException {
        this.kMain = kingMain;
        this.targetRes = residue;
        this.modelman = modelManager2;
        this.scAngles = new SidechainAngles2();
        try {
            this.scIdealizer = new SidechainIdealizer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
        this.buildGUI(kingMain.getTopWindow());
        this.modelman.registerTool(this, Collections.singleton(this.targetRes));
    }

    private void buildGUI(Frame frame) {
        TablePane tablePane = new TablePane();
        String[] stringArray = this.scAngles.nameMethylAngles(this.targetRes);
        if (stringArray == null) {
            throw new IllegalArgumentException("Bad residue code '" + this.targetRes.getName() + "' isn't recognized");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Residue type '" + this.targetRes.getName() + "' doesn't have any methyls");
        }
        double[] dArray = this.scAngles.measureMethylAngles(this.targetRes, this.modelman.getMoltenState());
        this.dials = new AngleDial[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            tablePane.add(new JLabel(stringArray[i]));
            this.dials[i] = new AngleDial();
            this.dials[i].setOrigDegrees(dArray[i]);
            this.dials[i].setDegrees(dArray[i]);
            this.dials[i].addChangeListener(this);
            tablePane.add(this.dials[i]);
            tablePane.newRow();
        }
        TablePane tablePane2 = new TablePane();
        this.labels = new JLabel[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels[i] = new JLabel();
            this.labels[i].setToolTipText("Quality assessment for the current methyl rotation");
            tablePane2.add(this.labels[i]);
            tablePane2.newRow();
        }
        this.setFeedback();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)tablePane, "West");
        jPanel.add((Component)tablePane2, "Center");
        TablePane tablePane3 = new TablePane();
        this.cbIdealize = new JCheckBox(new ReflectiveAction("Idealize sidechain", null, this, "onIdealizeOnOff"));
        if (this.scIdealizer != null) {
            this.cbIdealize.setSelected(true);
        } else {
            this.cbIdealize.setEnabled(false);
        }
        tablePane3.addCell(this.cbIdealize);
        jPanel.add((Component)tablePane3, "North");
        JButton jButton = new JButton(new ReflectiveAction("Finished", null, this, "onReleaseResidue"));
        JButton jButton2 = new JButton(new ReflectiveAction("Rotate sidechain", null, this, "onRotateSidechain"));
        TablePane2 tablePane22 = new TablePane2();
        tablePane22.addCell(jButton);
        tablePane22.addCell(jButton2);
        jPanel.add((Component)tablePane22, "South");
        if (this.kMain.getPrefs().getBoolean("minimizableTools")) {
            JFrame jFrame = new JFrame(this.targetRes.toString() + " methyl rotator");
            jFrame.setDefaultCloseOperation(0);
            jFrame.setContentPane(jPanel);
            this.dialog = jFrame;
        } else {
            JDialog jDialog = new JDialog(frame, this.targetRes.toString() + " methyl rotator", false);
            jDialog.setDefaultCloseOperation(0);
            jDialog.setContentPane(jPanel);
            this.dialog = jDialog;
        }
        this.dialog.addWindowListener(this);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void onReleaseResidue(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this.dialog, "Do you want to keep the changes\nyou've made to this residue?", "Keep changes?", 1, 3);
        if (n == 2) {
            return;
        }
        if (n == 0) {
            this.modelman.requestStateChange(this);
            this.modelman.addUserMod("Refit sidechain methyl(s) of " + this.targetRes);
        } else {
            this.modelman.unregisterTool(this);
        }
        this.dialog.dispose();
    }

    public void onRotateSidechain(ActionEvent actionEvent) {
        try {
            new SidechainRotator(this.kMain, this.targetRes, this.modelman);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void onIdealizeOnOff(ActionEvent actionEvent) {
        this.stateChanged(null);
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public void isUpdating(boolean bl) {
        this.isUpdating = bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.isUpdating()) {
            this.modelman.requestStateRefresh();
        }
        this.setFeedback();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        RotamerDef rotamerDef = (RotamerDef)this.rotamerList.getSelectedValue();
        if (rotamerDef != null) {
            this.initSomeAngles(rotamerDef.chiAngles);
        }
    }

    public boolean getValueIsAdjusting() {
        if (this.isUpdating()) {
            return true;
        }
        for (int i = 0; i < this.dials.length; ++i) {
            if (!this.dials[i].getValueIsAdjusting()) continue;
            return true;
        }
        return false;
    }

    public double[] getAllAngles() {
        double[] dArray = new double[this.dials.length];
        for (int i = 0; i < this.dials.length; ++i) {
            dArray[i] = this.dials[i].getDegrees();
        }
        return dArray;
    }

    public void setAllAngles(double[] dArray) {
        if (dArray.length < this.dials.length) {
            throw new IllegalArgumentException("Not enough angles provided!");
        }
        this.isUpdating(true);
        for (int i = 0; i < this.dials.length; ++i) {
            this.dials[i].setDegrees(dArray[i]);
        }
        this.isUpdating(false);
        this.stateChanged(new ChangeEvent(this));
    }

    public void initAllAngles(double[] dArray) {
        if (dArray.length < this.dials.length) {
            throw new IllegalArgumentException("Not enough angles provided!");
        }
        this.initSomeAngles(dArray);
    }

    public void initSomeAngles(double[] dArray) {
        int n = Math.min(dArray.length, this.dials.length);
        this.isUpdating(true);
        for (int i = 0; i < n; ++i) {
            this.dials[i].setOrigDegrees(dArray[i]);
            this.dials[i].setDegrees(dArray[i]);
        }
        this.isUpdating(false);
        this.stateChanged(new ChangeEvent(this));
    }

    public void setFeedback() {
        for (int i = 0; i < this.dials.length; ++i) {
            double d = Math.abs(this.dials[i].getDegrees() - this.dials[i].getOrigDegrees());
            if (Double.isNaN(d)) {
                this.labels[i].setText("-?-");
                continue;
            }
            if (d > 15.0) {
                this.labels[i].setText("LARGE CHANGE");
                this.labels[i].setForeground(alertColor);
                continue;
            }
            if (d > 10.0) {
                this.labels[i].setText("medium change");
                this.labels[i].setForeground(alertColor);
                continue;
            }
            if (d > 5.0) {
                this.labels[i].setText("medium change");
                this.labels[i].setForeground(mediumColor);
                continue;
            }
            if (d > 0.0) {
                this.labels[i].setText("small change");
                this.labels[i].setForeground(normalColor);
                continue;
            }
            this.labels[i].setText("no change");
            this.labels[i].setForeground(normalColor);
        }
    }

    public ModelState updateModelState(ModelState modelState) {
        ModelState modelState2 = modelState;
        if (this.scIdealizer != null && this.cbIdealize.isSelected()) {
            modelState2 = this.scIdealizer.idealizeSidechain(this.targetRes, modelState);
        }
        modelState2 = this.scAngles.setMethylAngles(this.targetRes, modelState2, this.getAllAngles());
        return modelState2;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.onReleaseResidue(null);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

