/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import driftwood.data.UberSet;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.util.Props;
import driftwood.util.SoftLog;
import driftwood.util.StreamTank;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import king.core.AGE;
import king.core.AHE;
import king.core.KGroup;
import king.core.KIterator;
import king.core.KList;
import king.core.KPaint;
import king.core.KPalette;
import king.core.KPoint;
import king.core.Kinemage;
import king.io.KinfileParser;
import king.points.VectorPoint;
import molikin.Quickin;
import molikin.logic.BallAndStickLogic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelPlotter {
    static final DecimalFormat df2 = new DecimalFormat("0.00");
    Props scProps;
    VectorPoint prev = null;
    KList listCa = null;
    KList listMc = null;
    KList listMcH = null;
    KList listSc = null;
    KList listScH = null;
    public KPaint mainColor = KPalette.defaultColor;
    public KPaint sideColor = KPalette.defaultColor;
    public KPaint hyColor = KPalette.defaultColor;
    public int modelWidth = 2;

    public ModelPlotter() {
        this.scProps = new Props();
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("sc-connect.props");
            if (inputStream != null) {
                this.scProps.load(inputStream);
                inputStream.close();
            } else {
                SoftLog.err.println("Couldn't find sc-connect.props");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void plotAminoAcids(Model model, Collection collection, ModelState modelState) {
        if (this.listCa == null || this.listMc == null || this.listMcH == null || this.listSc == null || this.listScH == null) {
            this.createLists();
        }
        this.clearLists();
        StreamTank streamTank = new StreamTank();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(streamTank));
        BallAndStickLogic ballAndStickLogic = Quickin.getLotsLogic(false);
        printWriter.println("@kinemage 1");
        ballAndStickLogic.printKinemage(printWriter, model, Collections.singletonList(modelState), new UberSet(collection), "", this.mainColor.toString());
        printWriter.flush();
        streamTank.close();
        KinfileParser kinfileParser = new KinfileParser();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(streamTank.getInputStream()));
        try {
            kinfileParser.parse(lineNumberReader);
            ArrayList arrayList = new ArrayList(kinfileParser.getKinemages());
            for (Kinemage kinemage : arrayList) {
                KIterator kIterator = KIterator.allLists((AGE)kinemage);
                for (KList kList : kIterator) {
                    KIterator kIterator2 = KIterator.allPoints((AGE)kList);
                    if (kList.getName().endsWith("mc")) {
                        this.moveAllPoints(this.listMc, (KIterator<KPoint>)kIterator2);
                        continue;
                    }
                    if (kList.getName().endsWith("mcH")) {
                        this.moveAllPoints(this.listMcH, (KIterator<KPoint>)kIterator2);
                        continue;
                    }
                    if (kList.getName().endsWith("sc")) {
                        this.moveAllPoints(this.listSc, (KIterator<KPoint>)kIterator2);
                        continue;
                    }
                    if (!kList.getName().endsWith("scH")) continue;
                    this.moveAllPoints(this.listScH, (KIterator<KPoint>)kIterator2);
                }
            }
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException in streamtank in ModelPlotter?");
        }
        kinfileParser = null;
        streamTank = null;
    }

    public static Kinemage buildKinObject(Model model, Collection collection, ModelState modelState) {
        StreamTank streamTank = new StreamTank();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(streamTank));
        BallAndStickLogic ballAndStickLogic = Quickin.getLotsLogic(false);
        printWriter.println("@kinemage 1");
        ballAndStickLogic.printKinemage(printWriter, model, Collections.singletonList(modelState), new UberSet(collection), "", "grey");
        printWriter.flush();
        streamTank.close();
        KinfileParser kinfileParser = new KinfileParser();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(streamTank.getInputStream()));
        Kinemage kinemage = null;
        try {
            kinfileParser.parse(lineNumberReader);
            ArrayList arrayList = new ArrayList(kinfileParser.getKinemages());
            kinemage = (Kinemage)arrayList.get(0);
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException in streamtank in Quickin?");
            iOException.printStackTrace();
        }
        kinfileParser = null;
        streamTank = null;
        return kinemage;
    }

    public void moveAllPoints(KList kList, KIterator<KPoint> kIterator) {
        for (KPoint kPoint : kIterator) {
            kList.add((AHE)kPoint);
        }
    }

    void plotString(Residue residue, ModelState modelState, String string, KList kList) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) continue;
            if (string2.equals(";")) {
                bl = false;
                continue;
            }
            Atom atom = residue.getAtom(string2);
            if (atom == null) {
                bl = false;
                continue;
            }
            try {
                this.plotAtom(modelState.get(atom), bl, kList);
                bl = true;
            }
            catch (AtomException atomException) {
                SoftLog.err.println(atomException.getMessage());
                bl = false;
            }
        }
    }

    void plotAtom(AtomState atomState, boolean bl, KList kList) {
        Residue residue = atomState.getResidue();
        String string = (atomState.getName() + atomState.getAltConf() + residue.getName() + " " + residue.getChain() + " " + residue.getSequenceNumber() + residue.getInsertionCode()).toLowerCase() + (atomState.getOccupancy() < 1.0 ? " " + df2.format(atomState.getOccupancy()) : "") + (atomState.getTempFactor() > 1.0 ? " B" + df2.format(atomState.getTempFactor()) : "");
        if (!bl) {
            this.prev = null;
        }
        VectorPoint vectorPoint = new VectorPoint(string, this.prev);
        vectorPoint.setX(atomState.getX());
        vectorPoint.setY(atomState.getY());
        vectorPoint.setZ(atomState.getZ());
        kList.add((AHE)vectorPoint);
        this.prev = vectorPoint;
    }

    public void createLists() {
        if (this.listCa == null) {
            this.listCa = new KList("vector");
            this.listCa.setName("Calphas");
            this.listCa.addMaster("refit Calphas");
            this.listCa.setOn(false);
        }
        if (this.listMc == null) {
            this.listMc = new KList("vector");
            this.listMc.setName("mc");
            this.listMc.addMaster("refit mainchain");
        }
        if (this.listMcH == null) {
            this.listMcH = new KList("vector");
            this.listMcH.setName("mcH");
            this.listMcH.addMaster("refit mainchain");
            this.listMcH.addMaster("refit H");
        }
        if (this.listSc == null) {
            this.listSc = new KList("vector");
            this.listSc.setName("sc");
            this.listSc.addMaster("refit sidechains");
        }
        if (this.listScH == null) {
            this.listScH = new KList("vector");
            this.listScH.setName("scH");
            this.listScH.addMaster("refit sidechains");
            this.listScH.addMaster("refit H");
        }
        this.listCa.setWidth(this.modelWidth);
        this.listCa.setColor(this.mainColor);
        this.listMc.setWidth(this.modelWidth);
        this.listMc.setColor(this.mainColor);
        this.listMcH.setWidth(this.modelWidth);
        this.listMcH.setColor(this.hyColor);
        this.listSc.setWidth(this.modelWidth);
        this.listSc.setColor(this.sideColor);
        this.listScH.setWidth(this.modelWidth);
        this.listScH.setColor(this.hyColor);
    }

    public KGroup createGroup(String string) {
        if (this.listCa == null || this.listMc == null || this.listMcH == null || this.listSc == null || this.listScH == null) {
            this.createLists();
        }
        KGroup kGroup = new KGroup();
        kGroup.setName(string);
        kGroup.setDominant(true);
        KGroup kGroup2 = new KGroup("mainchain");
        kGroup.add((AHE)kGroup2);
        KGroup kGroup3 = new KGroup("sidechain");
        kGroup.add((AHE)kGroup3);
        kGroup2.add((AHE)this.listMc);
        kGroup2.add((AHE)this.listMcH);
        kGroup2.add((AHE)this.listCa);
        kGroup3.add((AHE)this.listSc);
        kGroup3.add((AHE)this.listScH);
        return kGroup;
    }

    public KGroup createSubgroup(String string) {
        if (this.listMc == null || this.listMcH == null || this.listSc == null || this.listScH == null) {
            this.createLists();
        }
        KGroup kGroup = new KGroup();
        kGroup.setName(string);
        kGroup.setDominant(true);
        kGroup.add((AHE)this.listMc);
        kGroup.add((AHE)this.listMcH);
        kGroup.add((AHE)this.listCa);
        kGroup.add((AHE)this.listSc);
        kGroup.add((AHE)this.listScH);
        return kGroup;
    }

    public void clearLists() {
        if (this.listCa != null) {
            this.listCa.clear();
        }
        if (this.listMc != null) {
            this.listMc.clear();
        }
        if (this.listMcH != null) {
            this.listMcH.clear();
        }
        if (this.listSc != null) {
            this.listSc.clear();
        }
        if (this.listScH != null) {
            this.listScH.clear();
        }
    }

    public void setHOn(boolean bl) {
        if (this.listMcH != null) {
            this.listMcH.setOn(bl);
        }
        if (this.listScH != null) {
            this.listScH.setOn(bl);
        }
    }
}

