/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelingTool;
import chiropraxis.kingtools.PhiPsiWindow;
import chiropraxis.rotarama.Ramachandran;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import king.ToolBox;
import king.core.KPoint;

public class PhiPsiTool
extends ModelingTool {
    public PhiPsiTool(ToolBox toolBox) {
        super(toolBox);
    }

    protected Container getToolPanel() {
        return null;
    }

    public String getHelpAnchor() {
        return "#phipsi-tool";
    }

    public String toString() {
        return "Tweak phi/psi tool";
    }

    public void start() {
        super.start();
        try {
            Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.modelman.onShowDialog(null);
        this.services.setID("Ctrl-click, option-click, or middle-click the residue to change phi,psi");
        this.kCanvas.repaint();
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint != null) {
            Model model = this.modelman.getModel();
            ModelState modelState = this.modelman.getMoltenState();
            Residue residue = this.getResidueNearest(model, modelState, kPoint.getX(), kPoint.getY(), kPoint.getZ());
            try {
                new PhiPsiWindow(this.kMain, residue, this.modelman);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), residue + "doesn't have neighbors in the same chain.", "Sorry!", 0);
            }
        }
    }
}

