/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelManager2;
import chiropraxis.kingtools.Remodeler;
import chiropraxis.kingtools.SidechainRotator;
import chiropraxis.mc.PhiPsiRotation;
import chiropraxis.rotarama.Ramachandran;
import driftwood.gui.AngleDial;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane2;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.util.SoftLog;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.KinCanvas;
import king.KingMain;

public class PhiPsiWindow
implements Remodeler,
ChangeListener,
WindowListener {
    static final DecimalFormat df2 = new DecimalFormat("0.0");
    static final DecimalFormat df1 = new DecimalFormat("+0.0;-0.0");
    static final DecimalFormat df0 = new DecimalFormat("0");
    static final Color normalColor = new Color(0.0f, 0.0f, 0.0f);
    static final Color alertColor = new Color(0.6f, 0.0f, 0.0f);
    KingMain kMain;
    KinCanvas kCanvas;
    ModelManager2 modelman;
    JDialog dialog;
    Residue ctrRes;
    Ramachandran rama = null;
    double origPhiVal = Double.NaN;
    double origPsiVal = Double.NaN;
    TablePane2 toolpane;
    AngleDial phiDial;
    AngleDial psiDial;
    JLabel phiLabel;
    JLabel psiLabel;
    JLabel ramaLabel;
    JCheckBox rotRes;
    JCheckBox rotUpstream;
    JCheckBox idealizeSC;
    JTextField rotResNum;

    public PhiPsiWindow(KingMain kingMain, Residue residue, ModelManager2 modelManager2) {
        this.kMain = kingMain;
        this.kCanvas = kingMain.getCanvas();
        this.modelman = modelManager2;
        this.ctrRes = residue;
        this.buildGUI(kingMain.getTopWindow());
        try {
            this.initDials();
        }
        catch (ResidueException residueException) {
            residueException.printStackTrace();
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
        }
        try {
            this.rama = Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Collection collection = PhiPsiRotation.makeMobileGroup(this.modelman.getModel(), this.ctrRes, this.rotUpstream.isSelected(), this.parseNumRes());
        this.modelman.registerTool(this, collection);
        this.stateChanged(null);
    }

    private void buildGUI(Frame frame) {
        this.phiDial = new AngleDial();
        this.phiDial.addChangeListener(this);
        this.psiDial = new AngleDial();
        this.psiDial.addChangeListener(this);
        this.phiLabel = new JLabel("phi");
        this.psiLabel = new JLabel("psi");
        this.ramaLabel = new JLabel();
        this.rotUpstream = new JCheckBox(new ReflectiveAction("Rotate upstream", null, this, "onToggleUpstream"));
        this.rotRes = new JCheckBox(new ReflectiveAction("Number of residues:", null, this, "onToggleRotRes"));
        this.rotRes.setSelected(true);
        this.rotResNum = new JTextField("3");
        this.rotResNum.setColumns(3);
        this.rotResNum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhiPsiWindow.this.updateProtein();
            }
        });
        this.idealizeSC = new JCheckBox(new ReflectiveAction("Idealize sidechain", null, this, "onToggleIdealSC"));
        this.idealizeSC.setSelected(true);
        JButton jButton = new JButton(new ReflectiveAction("Finished", null, this, "onReleaseResidues"));
        JButton jButton2 = new JButton(new ReflectiveAction("Rotate sidechain", null, this, "onRotateSidechain"));
        this.toolpane = new TablePane2();
        this.toolpane.center();
        this.toolpane.addCell(this.phiDial);
        this.toolpane.addCell(this.psiDial);
        this.toolpane.newRow();
        this.toolpane.add(this.phiLabel);
        this.toolpane.add(this.psiLabel);
        this.toolpane.newRow();
        this.toolpane.addCell(TablePane2.strut(0, 10));
        this.toolpane.newRow();
        this.toolpane.add(this.ramaLabel);
        this.toolpane.newRow();
        this.toolpane.addCell(TablePane2.strut(0, 10));
        this.toolpane.newRow();
        this.toolpane.startSubtable(4, 1);
        this.toolpane.addCell(this.rotUpstream);
        this.toolpane.newRow();
        this.toolpane.addCell(this.rotRes);
        this.toolpane.addCell(this.rotResNum);
        this.toolpane.endSubtable();
        this.toolpane.newRow();
        this.toolpane.startSubtable(4, 1);
        this.toolpane.addCell(this.idealizeSC);
        this.toolpane.endSubtable();
        this.toolpane.newRow();
        this.toolpane.startSubtable(4, 1);
        this.toolpane.addCell(jButton);
        this.toolpane.addCell(jButton2);
        this.toolpane.endSubtable();
        this.dialog = new JDialog(frame, "Tweak phi/psi: " + this.ctrRes.toString(), false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(this);
        this.dialog.setContentPane(this.toolpane);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void initDials() throws ResidueException, AtomException {
        if (Double.isNaN(this.origPhiVal)) {
            this.origPhiVal = AminoAcid.getPhi(this.modelman.getModel(), this.ctrRes, this.modelman.getMoltenState());
        }
        if (Double.isNaN(this.origPsiVal)) {
            this.origPsiVal = AminoAcid.getPsi(this.modelman.getModel(), this.ctrRes, this.modelman.getMoltenState());
        }
        this.phiDial.setOrigDegrees(this.origPhiVal);
        this.psiDial.setOrigDegrees(this.origPsiVal);
        this.phiDial.setDegrees(this.origPhiVal);
        this.psiDial.setDegrees(this.origPsiVal);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.modelman.requestStateRefresh();
        this.updateLabels();
        this.kCanvas.repaint();
    }

    public ModelState updateModelState(ModelState modelState) {
        try {
            boolean bl = this.idealizeSC.isSelected();
            boolean bl2 = this.rotUpstream.isSelected();
            int n = Integer.MAX_VALUE;
            if (this.rotRes.isSelected()) {
                n = Integer.parseInt(this.rotResNum.getText());
            }
            if (n == 0) {
                return modelState;
            }
            Collection collection = PhiPsiRotation.makeMobileGroup(this.modelman.getModel(), this.ctrRes, bl2, n);
            ModelState modelState2 = PhiPsiRotation.makeConformation(collection, modelState, this.phiDial.getDegrees() - this.origPhiVal, true, bl2, n, bl);
            modelState2 = PhiPsiRotation.makeConformation(collection, modelState2, this.psiDial.getDegrees() - this.origPsiVal, false, bl2, n, bl);
            return modelState2;
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
            return modelState;
        }
    }

    public int parseNumRes() {
        try {
            int n = Integer.MAX_VALUE;
            if (this.rotRes.isSelected()) {
                n = Integer.parseInt(this.rotResNum.getText());
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            String string = "*** Can't parse " + this.rotResNum.getText() + " as an integer number of residues!";
            JOptionPane.showMessageDialog(null, string, string, 0);
            return Integer.MAX_VALUE;
        }
    }

    public void onToggleRotRes(ActionEvent actionEvent) {
        this.updateProtein();
    }

    public void onToggleRotResNum(ActionEvent actionEvent) {
        this.updateProtein();
    }

    public void onToggleUpstream(ActionEvent actionEvent) {
        this.updateProtein();
    }

    public void onToggleIdealSC(ActionEvent actionEvent) {
        this.stateChanged(null);
    }

    public void updateProtein() {
        try {
            this.initDials();
        }
        catch (ResidueException residueException) {
            residueException.printStackTrace();
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
        }
        this.modelman.unregisterTool(this);
        Collection collection = PhiPsiRotation.makeMobileGroup(this.modelman.getModel(), this.ctrRes, this.rotUpstream.isSelected(), this.parseNumRes());
        this.modelman.registerTool(this, collection);
        this.stateChanged(null);
    }

    public void updateLabels() {
        this.ramaLabel.setForeground(normalColor);
        if (this.ctrRes == null) {
            this.ramaLabel.setText("");
        } else {
            Model model = this.modelman.getModel();
            ModelState modelState = this.modelman.getMoltenState();
            try {
                if (this.rama == null) {
                    this.ramaLabel.setText("Ramachdrn: [no data]");
                } else if (this.rama.isOutlier(model, this.ctrRes, modelState)) {
                    this.ramaLabel.setText("Ramachdrn: OUTLIER");
                    this.ramaLabel.setForeground(alertColor);
                } else if (this.rama.rawScore(model, this.ctrRes, modelState) > 0.02) {
                    this.ramaLabel.setText("Ramachdrn: favored");
                } else {
                    this.ramaLabel.setText("Ramachdrn: allowed");
                }
            }
            catch (ResidueException residueException) {
                this.ramaLabel.setText("Ramachdrn: [no phi,psi]");
            }
        }
        this.dialog.pack();
    }

    public void onReleaseResidues(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "Do you want to keep the changes\nyou've made to these residues?", "Keep changes?", 1, 3);
        if (n == 2) {
            return;
        }
        if (n == 0) {
            this.modelman.requestStateChange(this);
            this.modelman.addUserMod("Refit backbone of " + this.ctrRes);
        } else {
            this.modelman.unregisterTool(this);
        }
        this.dialog.dispose();
        this.kCanvas.repaint();
    }

    public void onRotateSidechain(ActionEvent actionEvent) {
        try {
            new SidechainRotator(this.kMain, this.ctrRes, this.modelman);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(SoftLog.err);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.onReleaseResidues(null);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

