/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelingTool;
import chiropraxis.kingtools.ShearWindow;
import chiropraxis.rotarama.Ramachandran;
import chiropraxis.rotarama.TauByPhiPsi;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JOptionPane;
import king.ToolBox;
import king.core.KPoint;

public class ShearTool
extends ModelingTool {
    public ShearTool(ToolBox toolBox) {
        super(toolBox);
    }

    protected Container getToolPanel() {
        return null;
    }

    public String getHelpAnchor() {
        return "#shear-tool";
    }

    public String toString() {
        return "Shear tool";
    }

    public void start() {
        super.start();
        try {
            Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            TauByPhiPsi.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.modelman.onShowDialog(null);
        this.services.setID("Ctrl-click, option-click, or middle-click the residue to shear");
        this.kCanvas.repaint();
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint != null) {
            Model model = this.modelman.getModel();
            ModelState modelState = this.modelman.getMoltenState();
            Residue residue = this.getResidueNearest(model, modelState, kPoint.getX(), kPoint.getY(), kPoint.getZ());
            try {
                new ShearWindow(this.kMain, residue, this.modelman);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), residue + "doesn't have enough neighbors in the same chain.", "Sorry!", 0);
            }
        }
    }
}

