/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.mc.SupKitchen;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.SuffixFileFilter;
import driftwood.gui.TablePane;
import driftwood.gui.TablePane2;
import driftwood.moldb2.CoordinateFile;
import driftwood.util.SoftLog;
import driftwood.util.StreamTank;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import king.BasicTool;
import king.ToolBox;
import king.core.KPoint;
import king.core.Kinemage;

public class SupKitchenTool
extends BasicTool {
    TablePane2 pane;
    JCheckBox cbVerbose;
    JTextField tfRefFile;
    JRadioButton rbMdlDir;
    JTextField tfMdlDir;
    JRadioButton rbMdlFile;
    JTextField tfMdlFile;
    JTextField tfMaxEnsemSize;
    JCheckBox cbSplitChains;
    JRadioButton rbBbAtmsCa;
    JRadioButton rbBbAtmsAllHvy;
    JRadioButton rbBbAtmsAllHvyCb;
    JTextField tfLesk;
    JCheckBox cbKinEnsem;
    JTextField tfPcChoice;
    JTextField tfPcScale;
    JRadioButton rbDistort;
    JRadioButton rbRigidXform;
    JCheckBox cbKinPca;
    SupKitchen kitchen = new SupKitchen();

    public SupKitchenTool(ToolBox toolBox) {
        super(toolBox);
        this.buildGUI();
    }

    private void buildGUI() {
        JLabel jLabel = new JLabel("***  INPUT  ***");
        this.cbVerbose = new JCheckBox("Spit extra messages to stderr (for debugging)", false);
        this.rbMdlDir = new JRadioButton("Models directory: ", true);
        this.rbMdlFile = new JRadioButton("Models NMR file: ", false);
        JLabel jLabel2 = new JLabel("       Reference file (opt'l):  ");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbMdlDir);
        buttonGroup.add(this.rbMdlFile);
        this.tfMdlDir = new JTextField("none selected");
        this.tfMdlFile = new JTextField("none selected");
        this.tfRefFile = new JTextField("none selected");
        this.tfMdlDir.setEditable(false);
        this.tfMdlFile.setEditable(false);
        this.tfRefFile.setEditable(false);
        JButton jButton = new JButton(new ReflectiveAction("Choose...", null, (Object)this, "onSetMdlDir"));
        JButton jButton2 = new JButton(new ReflectiveAction("Choose...", null, (Object)this, "onSetMdlFile"));
        JButton jButton3 = new JButton(new ReflectiveAction("Choose...", null, (Object)this, "onSetRefFile"));
        jButton.setEnabled(true);
        jButton2.setEnabled(true);
        jButton3.setEnabled(true);
        JLabel jLabel3 = new JLabel("Max ensem size: ");
        this.tfMaxEnsemSize = new JTextField("" + this.kitchen.getMaxEnsemSize());
        JLabel jLabel4 = new JLabel("                ");
        JLabel jLabel5 = new JLabel("======================================");
        JLabel jLabel6 = new JLabel("***  ENSEMBLE SUPERPOSITION  ***");
        this.cbSplitChains = new JCheckBox("Split input into chains", true);
        JLabel jLabel7 = new JLabel("Atoms for superposition:");
        this.rbBbAtmsCa = new JRadioButton("Calphas only", false);
        this.rbBbAtmsAllHvy = new JRadioButton("All bb heavy atoms", true);
        this.rbBbAtmsAllHvyCb = new JRadioButton("All bb heavy atoms + Cbetas", false);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.rbBbAtmsCa);
        buttonGroup2.add(this.rbBbAtmsAllHvy);
        buttonGroup2.add(this.rbBbAtmsAllHvyCb);
        JLabel jLabel8 = new JLabel("Trim w/ Lesk sieve to max RMSD:");
        this.tfLesk = new JTextField("" + this.kitchen.getRmsdLesk());
        this.tfLesk.setEditable(true);
        JLabel jLabel9 = new JLabel("(-1 = no trimming)");
        JButton jButton4 = new JButton(new ReflectiveAction("Superpose! Yay!!", null, (Object)this, "onSup"));
        this.cbKinEnsem = new JCheckBox("kin", true);
        JButton jButton5 = new JButton(new ReflectiveAction("Save ensemble PDB", null, (Object)this, "onSaveEnsemPdb"));
        JLabel jLabel10 = new JLabel("======================================");
        JLabel jLabel11 = new JLabel("***  PRINCIPAL COMPONENT ANALYSIS  ***");
        JLabel jLabel12 = new JLabel("How does your ensemble \"like to move\"?");
        JLabel jLabel13 = new JLabel("Weighted avg of PCs: ");
        this.tfPcChoice = new JTextField("1-3");
        this.tfPcChoice.setEditable(true);
        JLabel jLabel14 = new JLabel(" x");
        this.tfPcScale = new JTextField("1.0");
        this.tfPcScale.setEditable(true);
        this.rbRigidXform = new JRadioButton("Rigid xform onto PC-distorted bb", true);
        this.rbDistort = new JRadioButton("Allow PCs to distort bb geom", false);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.rbDistort);
        buttonGroup3.add(this.rbRigidXform);
        JButton jButton6 = new JButton(new ReflectiveAction("Do PCA! Yay!!", null, (Object)this, "onPca"));
        this.cbKinPca = new JCheckBox("kin", true);
        JButton jButton7 = new JButton(new ReflectiveAction("Save PCA-transformed PDB", null, (Object)this, "onSavePcaPdb"));
        this.pane = new TablePane2().top().weights(10.0, 1.0);
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.add(this.cbVerbose);
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(this.rbMdlDir);
        this.pane.add(this.tfMdlDir);
        this.pane.add(jButton);
        this.pane.newRow();
        this.pane.add(this.rbMdlFile);
        this.pane.add(this.tfMdlFile);
        this.pane.add(jButton2);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel2);
        this.pane.add(this.tfRefFile);
        this.pane.add(jButton3);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel3);
        this.pane.add(this.tfMaxEnsemSize);
        this.pane.add(jLabel4);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.add(jLabel5);
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel6);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.add(this.cbSplitChains);
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel7);
        this.pane.newRow();
        this.pane.add(this.rbBbAtmsCa);
        this.pane.newRow();
        this.pane.add(this.rbBbAtmsAllHvy);
        this.pane.newRow();
        this.pane.add(this.rbBbAtmsAllHvyCb);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel8);
        this.pane.add(this.tfLesk);
        this.pane.add(jLabel9);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jButton4);
        this.pane.add(this.cbKinEnsem);
        this.pane.newRow();
        this.pane.add(jButton5);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.add(jLabel10);
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel11);
        this.pane.newRow();
        this.pane.add(jLabel12);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jLabel13);
        this.pane.add(this.tfPcChoice);
        this.pane.add(jLabel14);
        this.pane.add(this.tfPcScale);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(this.rbRigidXform);
        this.pane.newRow();
        this.pane.add(this.rbDistort);
        this.pane.endSubtable();
        this.pane.newRow();
        this.pane.startSubtable(1, 1).hfill(true).memorize();
        this.pane.add(jButton6);
        this.pane.add(this.cbKinPca);
        this.pane.newRow();
        this.pane.add(jButton7);
        this.pane.endSubtable();
    }

    public void onSetMdlDir(ActionEvent actionEvent) {
        TablePane tablePane = new TablePane();
        JFileChooser jFileChooser = new JFileChooser();
        String string = System.getProperty("user.dir");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        jFileChooser.setAccessory(tablePane);
        jFileChooser.setDialogTitle("Choose directory of model PDB files");
        jFileChooser.setFileSelectionMode(1);
        if (0 == jFileChooser.showOpenDialog(this.kMain.getTopWindow())) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.tfMdlDir.setText(file.getName());
                this.rbMdlDir.setSelected(true);
                this.tfMdlFile.setText("none selected");
                this.rbMdlFile.setSelected(false);
                System.err.println("Set models dir: " + file.getName());
                this.kitchen.setMdlFilename(file.getPath());
                System.setProperty("user.dir", file.getParentFile().getAbsolutePath());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong file format was chosen, or file is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
                System.err.println("*** Error opening models dir:" + file.getName() + "!");
            }
        }
    }

    public void onSetMdlFile(ActionEvent actionEvent) {
        TablePane tablePane = new TablePane();
        JFileChooser jFileChooser = new JFileChooser();
        String string = System.getProperty("user.dir");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        jFileChooser.setAccessory(tablePane);
        jFileChooser.setDialogTitle("Choose models PDB file");
        if (0 == jFileChooser.showOpenDialog(this.kMain.getTopWindow())) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.tfMdlFile.setText(file.getName());
                this.rbMdlFile.setSelected(true);
                this.tfMdlDir.setText("none selected");
                this.rbMdlDir.setSelected(false);
                System.err.println("Set models file: " + file.getName());
                this.kitchen.setMdlFilename(file.getPath());
                System.setProperty("user.dir", file.getAbsolutePath());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong file format was chosen, or file is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
                System.err.println("*** Error opening models file: " + file.getName() + "!");
            }
        }
    }

    public void onSetRefFile(ActionEvent actionEvent) {
        TablePane tablePane = new TablePane();
        JFileChooser jFileChooser = new JFileChooser();
        String string = System.getProperty("user.dir");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        jFileChooser.setAccessory(tablePane);
        jFileChooser.setDialogTitle("Choose reference PDB file");
        if (0 == jFileChooser.showOpenDialog(this.kMain.getTopWindow())) {
            File file = jFileChooser.getSelectedFile();
            try {
                this.tfRefFile.setText(file.getName());
                System.err.println("Set ref file: " + file.getName());
                this.kitchen.setRefFilename(file.getPath());
                System.setProperty("user.dir", file.getAbsolutePath());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong file format was chosen, or file is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
                System.err.println("*** Error opening ref file: " + file.getName() + "!");
            }
        }
    }

    public void onSup(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this.pane, "Just a warning before your (slow) calculation gets started...", "Sup Kitchen Tool is currently in the \"alpha test\" stage!", 2);
        if (this.tfMdlDir.getText().equals("none selected") && this.tfMdlFile.getText().equals("none selected")) {
            String string = "No models directory/file specified yet -- can't superpose!";
            JOptionPane.showMessageDialog(null, string, string, 0);
            return;
        }
        this.kitchen.setVerbose(this.cbVerbose.isSelected());
        if (this.rbBbAtmsCa.isSelected()) {
            this.kitchen.setSuperimpose(this.kitchen.SELECT_CA);
        } else if (this.rbBbAtmsAllHvy.isSelected()) {
            this.kitchen.setSuperimpose(this.kitchen.SELECT_BB_HEAVY);
        } else {
            this.kitchen.setSuperimpose(this.kitchen.SELECT_BB_HEAVY_CB);
        }
        try {
            double d = Double.parseDouble(this.tfLesk.getText());
            this.kitchen.setRmsdLesk(d);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("*** Error: Can't parse " + this.tfLesk.getText() + " as double for Lesk rmsd!");
            System.err.println("*** Simply using default: " + this.kitchen.getRmsdLesk() + "...");
        }
        try {
            int n = Integer.parseInt(this.tfMaxEnsemSize.getText());
            this.kitchen.setMaxEnsemSize(n);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("*** Error: Can't parse " + this.tfMaxEnsemSize.getText() + " as integer for max ensem size!");
            System.err.println("*** Simply using default: " + this.kitchen.getMaxEnsemSize() + "...");
        }
        try {
            this.kitchen.makeSup();
            if (this.cbKinEnsem.isSelected()) {
                this.visEnsem(this.kitchen.getEnsemCoordFile(), this.kitchen.getTitle());
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog((Component)this.kMain.getCanvas(), iOException.getMessage());
        }
    }

    public void onPca(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this.pane, "Just a warning before your (slow) calculation gets started...", "Sup Kitchen Tool is currently in the \"alpha test\" stage!", 2);
        if (this.kitchen.getEnsemCoordFile() == null) {
            JOptionPane.showMessageDialog(null, "No ensemble constructed yet -- can't do PCA!", "No ensemble constructed yet -- can't do PCA!", 0);
            return;
        }
        this.kitchen.setVerbose(this.cbVerbose.isSelected());
        if (this.rbBbAtmsCa.isSelected()) {
            this.kitchen.setSuperimpose(this.kitchen.SELECT_CA);
        } else if (this.rbBbAtmsAllHvy.isSelected()) {
            this.kitchen.setSuperimpose(this.kitchen.SELECT_BB_HEAVY);
        } else {
            this.kitchen.setSuperimpose(this.kitchen.SELECT_BB_HEAVY_CB);
        }
        try {
            double d = Double.parseDouble(this.tfPcScale.getText());
            this.kitchen.setScale(d);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("*** Error: Can't format " + this.tfPcScale.getText() + " as double for scale!");
            System.err.println("*** Simply using default: " + this.kitchen.getScale() + "...");
        }
        this.kitchen.parsePcChoice(this.tfPcChoice.getText());
        this.kitchen.setDistort(this.rbDistort.isSelected());
        this.kitchen.doPca();
        if (this.cbKinPca.isSelected()) {
            this.visEnsem(this.kitchen.getPcaCoordFile(), this.kitchen.getTitle() + "_PCA");
        }
    }

    public void onSaveEnsemPdb(ActionEvent actionEvent) {
        if (this.kitchen.getEnsemCoordFile() == null) {
            String string = "No ensemble constructed yet -- can't save!";
            JOptionPane.showMessageDialog(null, string, string, 0);
            return;
        }
        TablePane tablePane = new TablePane();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAccessory(tablePane);
        jFileChooser.setDialogTitle("Save ensemble PDB file");
        String string = System.getProperty("user.dir");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter("PDB files (*.pdb)");
        suffixFileFilter.addSuffix(".pdb");
        jFileChooser.addChoosableFileFilter(suffixFileFilter);
        jFileChooser.setFileFilter(suffixFileFilter);
        File file = new File(this.kitchen.getTitle() + ".pdb");
        jFileChooser.setSelectedFile(file);
        if (0 == jFileChooser.showSaveDialog(this.kMain.getTopWindow())) {
            try {
                File file2 = jFileChooser.getSelectedFile();
                if (!file2.exists() || JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file exists -- do you want to overwrite it?", "Overwrite file?", 0) == 0) {
                    System.err.println("Writing PDB: " + file2.getName() + "...");
                    try {
                        PrintStream printStream = new PrintStream(file2);
                        this.kitchen.writePdb(printStream, this.kitchen.getEnsemCoordFile());
                        System.err.println("Done writing PDB to " + file2.getName());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        String string2 = "Error writing to " + file2.getName() + "!";
                        System.err.println(string2);
                        JOptionPane.showMessageDialog(null, string2, string2, 0);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong file format was chosen, or file is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
                System.err.println("*** Error writing ensemble to PDB!");
            }
        }
    }

    public void onSavePcaPdb(ActionEvent actionEvent) {
        if (this.kitchen.getPcaCoordFile() == null) {
            String string = "PCA \"ensemble\" not constructed yet -- can't save!";
            JOptionPane.showMessageDialog(null, string, string, 0);
            return;
        }
        TablePane tablePane = new TablePane();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setAccessory(tablePane);
        jFileChooser.setDialogTitle("Save PCA-transformed reference PDB file");
        String string = System.getProperty("user.dir");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        SuffixFileFilter suffixFileFilter = new SuffixFileFilter("PDB files (*.pdb)");
        suffixFileFilter.addSuffix(".pdb");
        jFileChooser.addChoosableFileFilter(suffixFileFilter);
        jFileChooser.setFileFilter(suffixFileFilter);
        File file = new File(this.kitchen.getTitle() + "_PCA.pdb");
        jFileChooser.setSelectedFile(file);
        if (0 == jFileChooser.showSaveDialog(this.kMain.getTopWindow())) {
            try {
                File file2 = jFileChooser.getSelectedFile();
                if (!file2.exists() || JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "This file exists -- do you want to overwrite it?", "Overwrite file?", 0) == 0) {
                    System.err.println("Writing PDB: " + file2.getName() + "...");
                    try {
                        PrintStream printStream = new PrintStream(file2);
                        this.kitchen.writePdb(printStream, this.kitchen.getPcaCoordFile());
                        System.err.println("Done writing PDB to " + file2.getName());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        String string2 = "Error writing to " + file2.getName() + "!";
                        System.err.println(string2);
                        JOptionPane.showMessageDialog(null, string2, string2, 0);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                JOptionPane.showMessageDialog(this.kMain.getTopWindow(), "Wrong file format was chosen, or file is corrupt:\n" + illegalArgumentException.getMessage(), "Sorry!", 0);
                System.err.println("*** Error writing ensemble to PDB!");
            }
        }
    }

    public void visEnsem(CoordinateFile coordinateFile, String string) {
        StreamTank streamTank = new StreamTank();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(streamTank));
        this.kitchen.writeKin(printWriter, coordinateFile, string);
        streamTank.close();
        Kinemage kinemage = new Kinemage(string);
        this.kMain.getKinIO().loadStream((InputStream)streamTank.getInputStream(), streamTank.size(), kinemage);
        this.kMain.getStable().append(Arrays.asList(kinemage));
    }

    public void click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        super.click(n, n2, kPoint, mouseEvent);
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        super.click(n, n2, kPoint, mouseEvent);
    }

    protected Container getToolPanel() {
        return this.pane;
    }

    public URL getHelpURL() {
        URL uRL = ((Object)((Object)this)).getClass().getResource("/chiropraxis/kingtools/tools-manual.html");
        String string = this.getHelpAnchor();
        if (uRL != null && string != null) {
            try {
                uRL = new URL(uRL, string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace(SoftLog.err);
            }
            return uRL;
        }
        return null;
    }

    public String getHelpAnchor() {
        return "#supkitchen-tool";
    }

    public String toString() {
        return "Sup Kitchen Tool";
    }
}

