/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.ShearFit;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class AltConfShearFinder {
    DecimalFormat df1 = new DecimalFormat("0.0##");
    DecimalFormat df2 = new DecimalFormat("0.0");
    boolean verbose = false;
    Collection inputFiles = new ArrayList();
    double maxTheta;
    double maxRmsdChange;

    void searchModel(PrintStream printStream, String string, Model model) {
        Collection collection = model.getStates().values();
        ModelState[] modelStateArray = collection.toArray(new ModelState[collection.size()]);
        for (Residue residue : model.getResidues()) {
            Object object;
            Object object2;
            Object object3;
            Residue residue2;
            Residue residue3;
            Residue residue4;
            if (!AminoAcid.isAminoAcid(residue) || (residue4 = residue.getNext(model)) == null || (residue3 = residue4.getNext(model)) == null || (residue2 = residue3.getNext(model)) == null) continue;
            Atom atom = residue.getAtom(" CA ");
            Atom atom2 = residue4.getAtom(" CA ");
            Atom atom3 = residue3.getAtom(" CA ");
            Atom atom4 = residue2.getAtom(" CA ");
            Atom atom5 = residue4.getAtom(" CB ");
            Atom atom6 = residue3.getAtom(" CB ");
            Atom atom7 = residue4.getAtom(" O  ");
            Triple triple = new Triple(1.0, 0.0, 0.0);
            Triple triple2 = new Triple(1.0, 0.0, 0.0);
            Triple triple3 = new Triple(1.0, 0.0, 0.0);
            Triple triple4 = new Triple(1.0, 0.0, 0.0);
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            int n = -1;
            int n2 = -1;
            for (int i = 0; i < modelStateArray.length; ++i) {
                for (int j = i + 1; j < modelStateArray.length; ++j) {
                    try {
                        double d6;
                        object3 = modelStateArray[i].get(atom);
                        object2 = modelStateArray[j].get(atom);
                        object = modelStateArray[i].get(atom4);
                        AtomState atomState = modelStateArray[j].get(atom4);
                        if (((Triple)object3).distance((Tuple3)object2) > 0.01 || ((Triple)object).distance(atomState) > 0.01) continue;
                        AtomState atomState2 = modelStateArray[i].get(atom2);
                        AtomState atomState3 = modelStateArray[j].get(atom2);
                        AtomState atomState4 = modelStateArray[i].get(atom3);
                        AtomState atomState5 = modelStateArray[j].get(atom3);
                        double d7 = atomState2.distance(atomState3);
                        if (!(d7 + (d6 = atomState4.distance(atomState5)) > d + d2)) continue;
                        d = d7;
                        d2 = d6;
                        Triple triple5 = new Triple().likeMidpoint((Tuple3)object3, (Tuple3)object2);
                        Triple triple6 = new Triple().likeMidpoint((Tuple3)object, atomState);
                        triple.likeVector(triple5, triple6);
                        AtomState atomState6 = modelStateArray[i].get(atom5);
                        AtomState atomState7 = modelStateArray[j].get(atom5);
                        AtomState atomState8 = modelStateArray[i].get(atom6);
                        AtomState atomState9 = modelStateArray[j].get(atom6);
                        d3 = atomState6.distance(atomState7);
                        d4 = atomState8.distance(atomState9);
                        triple2.likeVector(atomState6, atomState7);
                        triple3.likeVector(atomState8, atomState9);
                        AtomState atomState10 = modelStateArray[i].get(atom7);
                        AtomState atomState11 = modelStateArray[j].get(atom7);
                        d5 = atomState10.distance(atomState11);
                        triple4.likeVector(atomState10, atomState11);
                        n = i;
                        n2 = j;
                        continue;
                    }
                    catch (AtomException atomException) {
                        // empty catch block
                    }
                }
            }
            if (n == -1 || n2 == -1 || !(d > 0.0) || !(d2 > 0.0)) continue;
            String string2 = this.getStateName(modelStateArray[n], model);
            String string3 = this.getStateName(modelStateArray[n2], model);
            object3 = ",";
            printStream.print(string.toLowerCase() + (String)object3 + string2 + (String)object3 + string3 + (String)object3 + residue.getChain() + (String)object3 + residue.getSequenceInteger() + (String)object3 + residue.getInsertionCode() + (String)object3 + residue.getName() + (String)object3 + residue2.getChain() + (String)object3 + residue2.getSequenceInteger() + (String)object3 + residue2.getInsertionCode() + (String)object3 + residue2.getName() + (String)object3 + this.df1.format(d) + (String)object3 + this.df1.format(d2) + (String)object3 + this.df1.format(d3) + (String)object3 + this.df1.format(d4) + (String)object3 + this.df1.format(d5) + (String)object3 + this.df2.format(triple.angle(triple2)) + (String)object3 + this.df2.format(triple.angle(triple3)) + (String)object3 + this.df2.format(triple.angle(triple4)));
            if (this.verbose) {
                printStream.println();
            }
            object2 = new ShearFit();
            ((ShearFit)object2).initData(model, residue, residue4, residue3, residue2, string2, string3, "ca+o", this.verbose, (String)object3, this.maxTheta, this.maxRmsdChange);
            object = ((ShearFit)object2).interrelateAltConfs();
            if (!this.verbose) {
                printStream.println();
            }
            System.err.println();
        }
    }

    String getStateName(ModelState modelState, Model model) {
        Map map = model.getStates();
        for (String string : map.keySet()) {
            ModelState modelState2 = (ModelState)map.get(string);
            if (!modelState2.equals(modelState)) continue;
            return string;
        }
        return null;
    }

    public void Main() {
        if (Double.isNaN(this.maxTheta)) {
            this.maxTheta = 1.0;
            System.err.println("-maxtheta=#.# not provided -- using default of " + this.maxTheta);
        }
        if (Double.isNaN(this.maxRmsdChange)) {
            this.maxRmsdChange = 0.001;
            System.err.println("-maxrmsdchange=#.# not provided -- using default of " + this.maxRmsdChange);
        }
        PdbReader pdbReader = new PdbReader();
        for (File file : this.inputFiles) {
            try {
                CoordinateFile coordinateFile = pdbReader.read(file);
                for (Model model : coordinateFile.getModels()) {
                    String string = file.toString();
                    if (coordinateFile.getIdCode() != null) {
                        string = coordinateFile.getIdCode();
                    }
                    this.searchModel(System.out, string, model);
                }
            }
            catch (IOException iOException) {
                System.err.println("IOException when processing " + file);
            }
        }
    }

    public static void main(String[] stringArray) {
        AltConfShearFinder altConfShearFinder = new AltConfShearFinder();
        try {
            altConfShearFinder.parseArguments(stringArray);
            altConfShearFinder.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            altConfShearFinder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AltConfShearFinder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AltConfShearFinder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AltConfShearFinder");
        System.err.println("Copyright (C) 2010 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            throw new IllegalArgumentException("'" + string + "' is not a valid file name.");
        }
        this.inputFiles.add(file);
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        }
        if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-maxtheta")) {
            try {
                this.maxTheta = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing " + string2 + " as a double!");
            }
        } else if (string.equals("-maxrmsdchange")) {
            try {
                this.maxRmsdChange = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Error parsing " + string2 + " as a double!");
            }
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

