/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.isosurface.CrystalVertexSource;
import driftwood.isosurface.OMapVertexSource;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.PrincipleAxes;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class AnisoOxygenSearch {
    File pdbFile = null;
    File mapFile = null;
    boolean verbose = false;
    boolean textOutput = true;
    boolean shearTest = false;

    void searchModel(PrintStream printStream, String string, Model model, ModelState modelState, CrystalVertexSource crystalVertexSource) {
        double d = 2.0 * crystalVertexSource.sigma;
        double d2 = 1.2 * crystalVertexSource.sigma;
        Builder builder = new Builder();
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00");
        if (this.textOutput) {
            if (this.shearTest) {
                printStream.println("#file:model:chain1:resnum1:inscode1:restype1:chain4:resnum4:inscode4:restype4:ox2_bfactor:angle:ellipse_ratio");
            } else {
                printStream.println("#file:model:residue:ox_bfactor:angle:ellipse_ratio");
            }
        } else {
            printStream.println("@kinemage 1");
            printStream.println("@group {O-rings} dominant");
        }
        for (Residue residue : model.getResidues()) {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                AtomState atomState = modelState.get(residue.getAtom(" O  "));
                AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
                AtomState atomState4 = modelState.get(residue.getNext(model).getAtom(" CA "));
                Triple triple = new Triple().likeVector(atomState3, atomState4);
                Triple triple2 = new Triple().likeVector(atomState2, atomState).unit();
                triple2.mult(triple.dot(triple2));
                triple.sub(triple2);
                double d3 = crystalVertexSource.evaluateAtPoint(atomState.getX(), atomState.getY(), atomState.getZ());
                if (Double.isNaN(d3) || d3 < d) {
                    if (!this.textOutput) continue;
                    if (this.shearTest) {
                        object5 = residue.getPrev(model);
                        object4 = residue.getNext(model).getNext(model);
                        if (object5 == null || object4 == null) continue;
                        printStream.println(string.toLowerCase() + ":" + model + ":" + ((Residue)object5).getChain() + ":" + ((Residue)object5).getSequenceInteger() + ":" + ((Residue)object5).getInsertionCode() + ":" + ((Residue)object5).getName() + ":" + ((Residue)object4).getChain() + ":" + ((Residue)object4).getSequenceInteger() + ":" + ((Residue)object4).getInsertionCode() + ":" + ((Residue)object4).getName() + ":" + decimalFormat2.format(atomState.getTempFactor()) + ":bad_density:bad_density");
                        continue;
                    }
                    printStream.println(string + ":" + model + ":" + residue.getCNIT() + ":bad_density:bad_density");
                    continue;
                }
                object5 = new ArrayList();
                for (double d4 = 0.0; d4 < 64.0; d4 += 1.0) {
                    object3 = builder.construct4(atomState3, atomState2, atomState, 1.0, 90.0, 360.0 * d4 / 64.0);
                    ((Triple)object3).sub(atomState);
                    ((ArrayList)object5).add(this.findBelow(d2, crystalVertexSource, atomState, (Tuple3)object3));
                }
                object4 = new PrincipleAxes((Collection)object5);
                Tuple3[] tuple3Array = ((PrincipleAxes)object4).getAxes();
                object3 = ((PrincipleAxes)object4).getLengths();
                double d5 = triple.angle(tuple3Array[0]);
                if (d5 > 90.0) {
                    d5 = 180.0 - d5;
                }
                reference var30_27 = object3[0] / object3[1];
                if (this.verbose) {
                    System.err.println(residue + ": " + (double)object3[0] + " / " + (double)object3[1]);
                }
                if (this.textOutput) {
                    if (this.shearTest) {
                        object2 = residue.getPrev(model);
                        object = residue.getNext(model).getNext(model);
                        if (object2 == null || object == null) continue;
                        printStream.println(string.toLowerCase() + ":" + model + ":" + ((Residue)object2).getChain() + ":" + ((Residue)object2).getSequenceInteger() + ":" + ((Residue)object2).getInsertionCode() + ":" + ((Residue)object2).getName() + ":" + ((Residue)object).getChain() + ":" + ((Residue)object).getSequenceInteger() + ":" + ((Residue)object).getInsertionCode() + ":" + ((Residue)object).getName() + ":" + decimalFormat2.format(atomState.getTempFactor()) + ":" + decimalFormat.format(d5) + ":" + decimalFormat.format((double)var30_27));
                        continue;
                    }
                    printStream.println(string.toLowerCase() + ":" + model + ":" + residue.getCNIT() + ":" + decimalFormat2.format(atomState.getTempFactor()) + ":" + decimalFormat.format(d5) + ":" + decimalFormat.format((double)var30_27));
                    continue;
                }
                printStream.println("@vectorlist {" + string + ":" + model + ":" + residue.getCNIT() + "} color= orange");
                object2 = ((ArrayList)object5).iterator();
                while (object2.hasNext()) {
                    object = (Triple)object2.next();
                    printStream.println("{} " + ((Triple)object).format(decimalFormat));
                }
                object2 = new Triple(atomState).add(((Triple)tuple3Array[0]).mult((double)object3[0]));
                object = new Triple(atomState).add(((Triple)tuple3Array[1]).mult((double)object3[1]));
                printStream.println("@vectorlist {" + string + ":" + model + ":" + residue.getCNIT() + "} color= lilactint");
                printStream.println("{}P " + atomState.format(decimalFormat));
                printStream.println("{} " + ((Triple)object2).format(decimalFormat));
                printStream.println("@vectorlist {" + string + ":" + model + ":" + residue.getCNIT() + "} color= greentint");
                printStream.println("{}P " + atomState.format(decimalFormat));
                printStream.println("{} " + ((Triple)object).format(decimalFormat));
            }
            catch (Exception exception) {}
        }
    }

    void searchModel2(PrintStream printStream, String string, Model model, ModelState modelState, CrystalVertexSource crystalVertexSource) {
        double d = 3.0 * crystalVertexSource.sigma;
        Builder builder = new Builder();
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0.00");
        DecimalFormat decimalFormat3 = new DecimalFormat("0.0");
        if (this.textOutput) {
            if (this.shearTest) {
                printStream.println("#file:model:chain1:resnum1:inscode1:restype1:chain4:resnum4:inscode4:restype4:ox2_bfactor:angle:max_ellipse_ratio");
            } else {
                printStream.println("#file:model:residue:ox_bfactor:angle:max_ellipse_ratio");
            }
        } else {
            printStream.println("@kinemage 1");
            printStream.println("@group {O-rings} dominant");
        }
        for (Residue residue : model.getResidues()) {
            try {
                AtomState atomState = modelState.get(residue.getAtom(" O  "));
                AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
                AtomState atomState4 = modelState.get(residue.getNext(model).getAtom(" CA "));
                Triple triple = new Triple().likeVector(atomState3, atomState4);
                Triple triple2 = new Triple().likeVector(atomState2, atomState).unit();
                triple2.mult(triple.dot(triple2));
                triple.sub(triple2);
                double d2 = crystalVertexSource.evaluateAtPoint(atomState.getX(), atomState.getY(), atomState.getZ());
                if (Double.isNaN(d2) || d2 < d) {
                    if (!this.textOutput) continue;
                    if (this.shearTest) {
                        Residue residue2 = residue.getPrev(model);
                        Residue residue3 = residue.getNext(model).getNext(model);
                        if (residue2 == null || residue3 == null) continue;
                        printStream.println(string.toLowerCase() + ":" + model + ":" + residue2.getChain() + ":" + residue2.getSequenceInteger() + ":" + residue2.getInsertionCode() + ":" + residue2.getName() + ":" + residue3.getChain() + ":" + residue3.getSequenceInteger() + ":" + residue3.getInsertionCode() + ":" + residue3.getName() + ":" + decimalFormat2.format(atomState.getTempFactor()) + ":bad_density:bad_density");
                        continue;
                    }
                    printStream.println(string.toLowerCase() + ":" + model + ":" + residue.getCNIT() + ":bad_density:bad_density");
                    continue;
                }
                Object object2 = Double.NEGATIVE_INFINITY;
                double d3 = Double.NaN;
                ArrayList<Triple> arrayList = null;
                Object object3 = null;
                Tuple3[] tuple3Array = null;
                for (double d4 = 1.2; d4 <= 2.4; d4 += 0.1) {
                    reference var44_43;
                    Object object;
                    double d5 = d4 * crystalVertexSource.sigma;
                    ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
                    for (double d6 = 0.0; d6 < 64.0; d6 += 1.0) {
                        object = builder.construct4(atomState3, atomState2, atomState, 1.0, 90.0, 360.0 * d6 / 64.0);
                        ((Triple)object).sub(atomState);
                        arrayList2.add(this.findBelow(d5, crystalVertexSource, atomState, (Tuple3)object));
                    }
                    PrincipleAxes principleAxes = new PrincipleAxes(arrayList2);
                    Tuple3[] tuple3Array2 = principleAxes.getAxes();
                    object = principleAxes.getLengths();
                    double d7 = triple.angle(tuple3Array2[0]);
                    if (d7 > 90.0) {
                        d7 = 180.0 - d7;
                    }
                    if ((var44_43 = object[0] / object[1]) > object2) {
                        object2 = var44_43;
                        d3 = d7;
                        arrayList = arrayList2;
                        object3 = object;
                        tuple3Array = tuple3Array2;
                    }
                    if (!this.verbose) continue;
                    System.err.println(residue + " " + decimalFormat3.format(d4) + "sigma: " + d7 + ", " + (double)var44_43);
                }
                if (this.textOutput) {
                    if (this.shearTest) {
                        Residue residue4 = residue.getPrev(model);
                        Residue residue2 = residue.getNext(model).getNext(model);
                        if (residue4 == null || residue2 == null) continue;
                        printStream.println(string.toLowerCase() + ":" + model + ":" + residue4.getChain() + ":" + residue4.getSequenceInteger() + ":" + residue4.getInsertionCode() + ":" + residue4.getName() + ":" + residue2.getChain() + ":" + residue2.getSequenceInteger() + ":" + residue2.getInsertionCode() + ":" + residue2.getName() + ":" + decimalFormat2.format(atomState.getTempFactor()) + ":" + decimalFormat.format(d3) + ":" + decimalFormat.format((double)object2));
                        continue;
                    }
                    printStream.println(string.toLowerCase() + ":" + model + ":" + residue.getCNIT() + ":" + decimalFormat2.format(atomState.getTempFactor()) + ":" + decimalFormat.format(d3) + ":" + decimalFormat.format((double)object2));
                    continue;
                }
                printStream.println("@vectorlist {" + string + ":" + model + ":" + residue.getCNIT() + "} color= orange");
                for (Triple triple3 : arrayList) {
                    printStream.println("{} " + triple3.format(decimalFormat));
                }
                Triple triple3 = new Triple(atomState).add(((Triple)tuple3Array[0]).mult((double)object3[0]));
                Triple triple4 = new Triple(atomState).add(((Triple)tuple3Array[1]).mult((double)object3[1]));
                printStream.println("@arrowlist {" + string + ":" + model + ":" + residue.getCNIT() + " 1st PC} radius= 0.05 color= purple");
                printStream.println("{}P " + atomState.format(decimalFormat));
                printStream.println("{} " + triple3.format(decimalFormat));
                printStream.println("@arrowlist {" + string + ":" + model + ":" + residue.getCNIT() + " 2nd PC} radius= 0.05 color= lilactint");
                printStream.println("{}P " + atomState.format(decimalFormat));
                printStream.println("{} " + triple4.format(decimalFormat));
            }
            catch (Exception exception) {}
        }
    }

    Triple findBelow(double d, CrystalVertexSource crystalVertexSource, Tuple3 tuple3, Tuple3 tuple32) {
        double d2;
        Triple triple = new Triple();
        double d3 = 0.0;
        do {
            triple.like(tuple32).unit().mult(d3 += 0.025);
            triple.add(tuple3);
        } while ((d2 = crystalVertexSource.evaluateAtPoint(triple.getX(), triple.getY(), triple.getZ())) > d);
        return triple;
    }

    public void Main() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(this.pdbFile);
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        String string = this.pdbFile.toString();
        if (coordinateFile.getIdCode() != null) {
            string = coordinateFile.getIdCode();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.mapFile));
        OMapVertexSource oMapVertexSource = new OMapVertexSource(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        this.searchModel2(System.out, string, model, modelState, oMapVertexSource);
    }

    public static void main(String[] stringArray) {
        AnisoOxygenSearch anisoOxygenSearch = new AnisoOxygenSearch();
        try {
            anisoOxygenSearch.parseArguments(stringArray);
            if (anisoOxygenSearch.pdbFile == null || anisoOxygenSearch.mapFile == null) {
                throw new IllegalArgumentException("Must specify both a PDB file and an O map");
            }
            anisoOxygenSearch.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            anisoOxygenSearch.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AnisoOxygenSearch.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AnisoOxygenSearch.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AnisoOxygenSearch");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.pdbFile == null) {
            this.pdbFile = new File(string);
        } else if (this.mapFile == null) {
            this.mapFile = new File(string);
        } else {
            throw new IllegalArgumentException("Unneccessary parameter '" + string + "'");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-shear") || string.equals("-s")) {
            this.shearTest = true;
        } else if (string.equals("-text")) {
            this.textOutput = true;
        } else if (string.equals("-kin")) {
            this.textOutput = false;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

