/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.TreeSet;

public class AvgStrucGenerator {
    String bbAtomsNoCb = " N  , CA , C  , O  ";
    String bbAtomsCb = " N  , CA , C  , O  , CB ";
    DecimalFormat df = new DecimalFormat("###.###");
    File resnumFile = null;
    ArrayList<String> pdbFilenames = null;
    TreeMap<String, String> pdbidsToFilenames = null;
    Model refModel = null;
    ModelState refState = null;
    Model refModel2 = null;
    ModelState refState2 = null;
    double[] refCoords = null;
    ArrayList<double[]> localCoords = null;
    double[] avgCoords = null;
    double[] stdevs = null;
    int mdlCount = 0;
    int resnumIdx = 2;
    int resnum2idx = Integer.MAX_VALUE;
    int initIdx = -2;
    int finalIdx = 2;
    double distCutoff = 2.0;
    String bbAtoms = this.bbAtomsNoCb;
    boolean verbose = false;

    public AvgStrucGenerator() {
        this.pdbFilenames = new ArrayList();
        this.localCoords = new ArrayList();
    }

    public void populatePdbidMap() {
        this.pdbidsToFilenames = new TreeMap();
        try {
            String string;
            Scanner scanner = new Scanner(this.resnumFile);
            while (scanner.hasNextLine()) {
                String string2 = scanner.nextLine();
                int n = string2.indexOf(".pdb");
                string = string2.substring(n - 6, n - 2);
                for (String string3 : this.pdbFilenames) {
                    String[] stringArray = Strings.explode(string3, '/');
                    String string4 = stringArray[stringArray.length - 1];
                    String string5 = string4.substring(0, 4);
                    if (!string.equals(string5)) continue;
                    this.pdbidsToFilenames.put(string, string3);
                }
            }
            if (this.verbose) {
                for (String string6 : this.pdbidsToFilenames.keySet()) {
                    string = this.pdbidsToFilenames.get(string6);
                    System.err.println(string6 + " --> " + string);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.flush();
            System.err.println("Trouble with a file in populatePdbidMap()");
        }
    }

    public void getLocalCoords() {
        try {
            Scanner scanner = new Scanner(this.resnumFile);
            while (scanner.hasNextLine()) {
                try {
                    String string;
                    String string2 = scanner.nextLine();
                    int n = string2.indexOf(".pdb");
                    String string3 = string2.substring(n - 6, n - 2);
                    String string4 = string2.substring(n - 2, n - 1);
                    int n2 = this.getResnum(string2, this.resnumIdx);
                    int n3 = Integer.MAX_VALUE;
                    if (this.resnum2idx != Integer.MAX_VALUE) {
                        n3 = this.getResnum(string2, this.resnum2idx);
                    }
                    if ((string = this.pdbidsToFilenames.get(string3)) == null) continue;
                    if (this.verbose) {
                        System.err.println("Finding coords for " + n2 + " in " + string3);
                    }
                    PdbReader pdbReader = new PdbReader();
                    File file = new File(string);
                    CoordinateFile coordinateFile = pdbReader.read(file);
                    Iterator iterator = coordinateFile.getModels().iterator();
                    Model model = (Model)iterator.next();
                    ModelState modelState = model.getState();
                    Model model2 = new Model("local model " + string3 + " " + n2);
                    ModelState modelState2 = new ModelState();
                    Model model3 = n3 == Integer.MAX_VALUE ? null : new Model("local model2 " + string3 + " " + n3);
                    ModelState modelState3 = n3 == Integer.MAX_VALUE ? null : new ModelState();
                    for (Residue residue : model.getResidues()) {
                        AtomState atomState;
                        int n4 = residue.getSequenceInteger();
                        if (residue != null && string4.equals(residue.getChain()) && n4 >= n2 + this.initIdx && n4 <= n2 + this.finalIdx) {
                            if (this.verbose) {
                                System.err.println("... found " + residue);
                            }
                            for (Atom atom : residue.getAtoms()) {
                                if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                                if (!model2.contains(residue)) {
                                    model2.add(residue);
                                }
                                atomState = modelState.get(atom);
                                modelState2.add(atomState);
                            }
                            continue;
                        }
                        if (residue == null || !string4.equals(residue.getChain()) || n3 == Integer.MAX_VALUE || n4 < n3 + this.initIdx || n4 > n3 + this.finalIdx) continue;
                        if (this.verbose) {
                            System.err.println("... found " + residue);
                        }
                        for (Atom atom : residue.getAtoms()) {
                            if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                            if (!model3.contains(residue)) {
                                model3.add(residue);
                            }
                            atomState = modelState.get(atom);
                            modelState3.add(atomState);
                        }
                    }
                    if (this.refModel == null && this.refState == null) {
                        this.refModel = model2;
                        this.refState = modelState2;
                        if (this.resnum2idx != Integer.MAX_VALUE) {
                            this.refModel2 = model3;
                            this.refState2 = modelState3;
                        }
                        this.setRefCoords();
                        if (!this.verbose) continue;
                        System.err.println("Setting " + model2 + (this.resnum2idx != Integer.MAX_VALUE ? " and " + model3 : "") + " as reference");
                        continue;
                    }
                    this.addToLocalCoords(model2, modelState2, model3, modelState3);
                }
                catch (ResidueException residueException) {
                    System.err.println("Trouble with a residue in getLocalCoords()...");
                }
                catch (AtomException atomException) {
                    System.err.println("Trouble with an atom in getLocalCoords()...");
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Trouble with I/O in getLocalCoords()...");
        }
    }

    public int getResnum(String string, int n) {
        try {
            String[] stringArray = Strings.explode(string, ':');
            String string2 = stringArray[n];
            int n2 = Integer.MAX_VALUE;
            String string3 = null;
            string3 = string2.startsWith("Ncap") ? string2.substring(6, string2.length() - 3).trim() : string2.substring(1, string2.length() - 3).trim();
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = Integer.parseInt(string3.substring(0, string3.length() - 1));
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Trouble with a number in getLocalCoords()...");
            return Integer.MAX_VALUE;
        }
    }

    public void addToLocalCoords(Model model, ModelState modelState, Model model2, ModelState modelState2) {
        try {
            int n;
            int n2;
            Alignment alignment = Alignment.needlemanWunsch(this.refModel.getResidues().toArray(), model.getResidues().toArray(), new SimpleResAligner());
            if (this.verbose) {
                System.err.println("Residue alignments:");
                for (int i = 0; i < alignment.a.length; ++i) {
                    System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
                }
            }
            Alignment alignment2 = null;
            if (model2 != null && modelState2 != null) {
                alignment2 = Alignment.needlemanWunsch(this.refModel2.getResidues().toArray(), model2.getResidues().toArray(), new SimpleResAligner());
                if (this.verbose) {
                    System.err.println("Residue2 alignments:");
                    for (n2 = 0; n2 < alignment2.a.length; ++n2) {
                        System.err.println("  " + alignment2.a[n2] + " <==> " + alignment2.b[n2]);
                    }
                }
            }
            n2 = 1;
            int n3 = alignment.a.length;
            for (n = 0; n < n3; ++n) {
                if (alignment.a[n] != null && alignment.b[n] != null) continue;
                n2 = 0;
            }
            if (alignment2 != null) {
                n3 = alignment2.a.length;
                for (n = 0; n < n3; ++n) {
                    if (alignment2.a[n] != null && alignment2.b[n] != null) continue;
                    n2 = 0;
                }
            }
            if (n2 != 0) {
                AtomState atomState;
                Residue residue;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                int n4 = alignment.a.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    residue = (Residue)alignment.b[n3];
                    for (Atom atom : residue.getAtoms()) {
                        if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                        atomState = modelState.get(atom);
                        arrayList.add(atomState.getX());
                        arrayList.add(atomState.getY());
                        arrayList.add(atomState.getZ());
                    }
                }
                if (alignment2 != null) {
                    n4 = alignment2.a.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        residue = (Residue)alignment2.a[n3];
                        for (Atom atom : residue.getAtoms()) {
                            if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                            atomState = modelState2.get(atom);
                            arrayList.add(atomState.getX());
                            arrayList.add(atomState.getY());
                            arrayList.add(atomState.getZ());
                        }
                    }
                }
                double[] dArray = new double[arrayList.size()];
                for (n4 = 0; n4 < arrayList.size(); ++n4) {
                    dArray[n4] = (Double)arrayList.get(n4);
                }
                this.localCoords.add(dArray);
            } else if (this.verbose) {
                System.err.println("... bad alnmt => not using these coords for avg struc");
            }
            if (this.verbose) {
                System.err.println();
            }
        }
        catch (AtomException atomException) {
            System.err.println("Trouble with an atom in addToLocalCoords()...");
        }
    }

    public void setRefCoords() {
        try {
            int n;
            int n2;
            Alignment alignment = Alignment.needlemanWunsch(this.refModel.getResidues().toArray(), this.refModel.getResidues().toArray(), new SimpleResAligner());
            if (this.verbose) {
                System.err.println("setRefCoords residue alignments:");
                for (int i = 0; i < alignment.a.length; ++i) {
                    System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
                }
            }
            Alignment alignment2 = null;
            if (this.refModel2 != null) {
                alignment2 = Alignment.needlemanWunsch(this.refModel2.getResidues().toArray(), this.refModel2.getResidues().toArray(), new SimpleResAligner());
                if (this.verbose) {
                    System.err.println("setRefCoords residue2 alignments:");
                    for (n2 = 0; n2 < alignment2.a.length; ++n2) {
                        System.err.println("  " + alignment2.a[n2] + " <==> " + alignment2.b[n2]);
                    }
                }
            }
            n2 = 1;
            int n3 = alignment.a.length;
            for (n = 0; n < n3; ++n) {
                if (alignment.a[n] != null && alignment.b[n] != null) continue;
                n2 = 0;
            }
            if (alignment2 != null) {
                n3 = alignment2.a.length;
                for (n = 0; n < n3; ++n) {
                    if (alignment2.a[n] != null && alignment2.b[n] != null) continue;
                    n2 = 0;
                }
            }
            if (n2 != 0) {
                AtomState atomState;
                Residue residue;
                ArrayList<Double> arrayList = new ArrayList<Double>();
                int n4 = alignment.a.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    residue = (Residue)alignment.a[n3];
                    for (Atom atom : residue.getAtoms()) {
                        if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                        atomState = this.refState.get(atom);
                        arrayList.add(atomState.getX());
                        arrayList.add(atomState.getY());
                        arrayList.add(atomState.getZ());
                    }
                }
                if (alignment2 != null) {
                    n4 = alignment2.a.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        residue = (Residue)alignment2.a[n3];
                        for (Atom atom : residue.getAtoms()) {
                            if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                            atomState = this.refState2.get(atom);
                            arrayList.add(atomState.getX());
                            arrayList.add(atomState.getY());
                            arrayList.add(atomState.getZ());
                        }
                    }
                }
                this.refCoords = new double[arrayList.size()];
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    this.refCoords[n3] = (Double)arrayList.get(n3);
                }
            } else if (this.verbose) {
                System.err.println("... bad alnmt during setRefCoords");
            }
            if (this.verbose) {
                System.err.println();
            }
        }
        catch (AtomException atomException) {
            System.err.println("Trouble with an atom in setRefCoords...");
        }
    }

    public void averageCoords() {
        int n;
        System.err.println("localCoords.size()  " + this.localCoords.size());
        System.err.println("pdbFilenames.size() " + this.pdbFilenames.size());
        System.err.println("equal? " + (this.localCoords.size() == this.pdbFilenames.size()));
        int n2 = 3 * Strings.explode(this.bbAtoms, ',').length * (this.finalIdx - this.initIdx + 1);
        if (this.resnum2idx != Integer.MAX_VALUE) {
            n2 *= 2;
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = 0.0;
        }
        this.mdlCount = 0;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < this.localCoords.size(); ++i) {
            double[] dArray2 = this.localCoords.get(i);
            if (dArray2.length == n2 && !this.tooFarAway(dArray2)) {
                int n3;
                treeSet.add(i);
                for (n3 = 0; n3 < dArray2.length; ++n3) {
                    dArray[n3] = dArray[n3] + dArray2[n3];
                }
                ++this.mdlCount;
                if (!this.verbose) continue;
                System.err.print("contrib struc " + this.mdlCount);
                if (this.avgCoords == null) {
                    System.err.print(": ");
                } else {
                    System.err.print(" (close enough): ");
                }
                for (n3 = 0; n3 < dArray2.length; ++n3) {
                    System.err.print(this.df.format(dArray2[n3]) + ",");
                }
                System.err.println();
                continue;
            }
            System.err.println(dArray2 + " too far away or not right length (" + dArray2.length + " instead of " + n2 + ")");
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        for (n = 0; n < this.localCoords.size(); ++n) {
            if (!treeSet.contains(n)) continue;
            arrayList.add(this.localCoords.get(n));
        }
        this.localCoords = arrayList;
        System.err.println("# contributors to average structure: " + this.mdlCount);
        this.avgCoords = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.avgCoords[n] = dArray[n] / (1.0 * (double)this.mdlCount);
        }
        if (this.verbose) {
            System.err.println("# entries per n(xyz) vector: " + this.avgCoords.length);
            System.err.print("avg coords: ");
            for (n = 0; n < this.avgCoords.length; ++n) {
                if (n % 3 == 0) {
                    System.err.print(this.df.format(this.avgCoords[n]) + "  ");
                    continue;
                }
                System.err.print(this.df.format(this.avgCoords[n]) + ", ");
            }
            System.err.println();
        }
        this.stdevs = new double[n2];
        for (n = 0; n < n2; ++n) {
            this.stdevs[n] = 0.0;
        }
        this.mdlCount = 0;
        for (double[] dArray3 : this.localCoords) {
            if (dArray3.length != n2) continue;
            for (int i = 0; i < dArray3.length; ++i) {
                this.stdevs[i] = this.stdevs[i] + Math.pow(dArray3[i] - this.avgCoords[i], 2.0);
            }
            ++this.mdlCount;
        }
        for (int i = 0; i < n2; ++i) {
            this.stdevs[i] = Math.sqrt(this.stdevs[i] / (1.0 * (double)this.mdlCount));
        }
    }

    public boolean tooFarAway(double[] dArray) {
        if (this.avgCoords == null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(Math.abs(dArray[i] - this.refCoords[i]) > this.distCutoff)) continue;
                if (this.verbose) {
                    System.err.println(this.df.format(dArray[i]) + " too far away from ref: " + this.df.format(this.refCoords[i]));
                }
                return true;
            }
            if (this.verbose) {
                System.err.println(dArray + " not too far from ref");
            }
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (!(Math.abs(dArray[i] - this.avgCoords[i]) > 2.0)) continue;
            if (this.verbose) {
                System.err.println(this.df.format(dArray[i]) + " too far away from avg: " + this.df.format(this.avgCoords[i]));
            }
            return true;
        }
        if (this.verbose) {
            System.err.println(dArray + " not too far from avg");
        }
        return false;
    }

    public void printAvgStruc() {
        try {
            Model model = new Model("avg model");
            ModelState modelState = new ModelState();
            int n = 0;
            for (Residue residue : this.refModel.getResidues()) {
                for (Atom atom : residue.getAtoms()) {
                    if (this.bbAtoms.indexOf(atom.getName()) == -1) continue;
                    AtomState atomState = this.refState.get(atom);
                    double d = 0.0;
                    atomState.setX(this.avgCoords[n]);
                    d += this.stdevs[n];
                    atomState.setY(this.avgCoords[++n]);
                    d += this.stdevs[n];
                    atomState.setZ(this.avgCoords[++n]);
                    d += this.stdevs[n];
                    ++n;
                    atomState.setTempFactor(d /= 3.0);
                    atomState.setOccupancy(1.0);
                    if (!model.contains(residue)) {
                        model.add(residue);
                    }
                    modelState.add(atomState);
                }
            }
            if (this.verbose) {
                System.err.println("Printing average structure...");
            }
            System.out.println("USER  MOD " + this.mdlCount + " contributing structures");
            PdbWriter pdbWriter = new PdbWriter(System.out);
            pdbWriter.writeResidues(model.getResidues(), modelState);
            pdbWriter.close();
        }
        catch (ResidueException residueException) {
            System.err.println("Trouble with a residue in printAvgStruc()...");
        }
        catch (AtomException atomException) {
            System.err.println("Trouble with an atom in printAvgStruc()...");
        }
    }

    public void Main() {
        if (this.resnumFile == null) {
            System.err.println("Need a file supplying res #'s!");
            System.exit(0);
        }
        this.populatePdbidMap();
        this.getLocalCoords();
        this.averageCoords();
        this.printAvgStruc();
    }

    public static void main(String[] stringArray) {
        AvgStrucGenerator avgStrucGenerator = new AvgStrucGenerator();
        try {
            avgStrucGenerator.parseArguments(stringArray);
            avgStrucGenerator.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            avgStrucGenerator.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AvgStrucGenerator.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AvgStrucGenerator.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AvgStrucGenerator");
        System.err.println("Copyright (C) 2008 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.resnumFile == null) {
            this.resnumFile = new File(string);
        } else {
            this.pdbFilenames.add(string);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        }
        if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-range")) {
            Scanner scanner = new Scanner(string2).useDelimiter(",");
            int n = 999;
            int n2 = 999;
            while (scanner.hasNext()) {
                String string3 = scanner.next();
                int n3 = Integer.parseInt(string3);
                if (n == 999) {
                    n = n3;
                    continue;
                }
                if (n2 == 999) {
                    n2 = n3;
                    continue;
                }
                System.err.println("Wrong format: should be -range=#,#");
            }
            if (n != 999 && n2 != 999) {
                this.initIdx = n;
                this.finalIdx = n2;
            } else {
                System.err.println("Wrong format: should be -range=#,#");
            }
        } else if (string.equals("-residx")) {
            try {
                this.resnumIdx = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Couldn't parse " + string2 + " as an integer for resnumIdx");
            }
        } else if (string.equals("-res2idx")) {
            try {
                this.resnum2idx = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Couldn't parse " + string2 + " as an integer for resnum2idx");
            }
            System.err.println("Warning: -res2idx=# doesn't work quite right!");
        } else if (string.equals("-distcutoff")) {
            try {
                this.distCutoff = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Couldn't parse " + string2 + " as a double for distCutoff");
            }
        } else if (string.equals("-cb")) {
            this.bbAtoms = this.bbAtomsCb;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class SimpleResAligner
    implements Alignment.Scorer {
        SimpleResAligner() {
        }

        public double score(Object object, Object object2) {
            Residue residue = (Residue)object;
            Residue residue2 = (Residue)object2;
            if (residue == null || residue2 == null) {
                return -1.0;
            }
            if (residue.getName().equals(residue2.getName())) {
                return 2.0;
            }
            return 0.0;
        }

        public double open_gap(Object object) {
            return this.extend_gap(object);
        }

        public double extend_gap(Object object) {
            return this.score(object, null);
        }
    }
}

