/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.r3.Triple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class AvgStrucGenerator2 {
    DecimalFormat df = new DecimalFormat("###.###");
    boolean verbose = false;
    ArrayList<File> files = new ArrayList();
    Triple[][] original;
    Triple[] averaged;
    double[] pseudoBs;
    File refFile;
    Model refModel;
    Range[] refRanges;
    HashMap<Range, Integer> refIndices;
    double maxDist = 2.0;

    public void getCoords() {
        int n;
        PdbReader pdbReader = new PdbReader();
        for (n = 0; n < this.files.size(); ++n) {
            File file = this.files.get(n);
            if (file.isDirectory()) {
                throw new IllegalArgumentException(file + " is a directory, not a PDB!");
            }
            try {
                CoordinateFile coordinateFile = pdbReader.read(file);
                Model model = coordinateFile.getFirstModel();
                Range[] rangeArray = this.getRanges(model);
                if (this.refFile == null) {
                    this.refFile = file;
                    this.getRefCoords(file, model, rangeArray, n);
                    continue;
                }
                this.getOtherCoords(file, model, rangeArray, n);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error reading " + file + "!");
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Error getting atoms from " + file + "!");
            }
        }
        if (this.verbose) {
            System.err.println("Original coordinates:");
            for (n = 0; n < this.original.length; ++n) {
                for (int i = 0; i < this.original[n].length; ++i) {
                    System.err.print(" " + this.original[n][i]);
                }
                System.err.println("");
            }
        }
    }

    public void getRefCoords(File file, Model model, Range[] rangeArray, int n) throws AtomException {
        this.refModel = model;
        this.refRanges = rangeArray;
        int n2 = this.refModel.getResidues().size() * 5;
        int n3 = this.files.size();
        this.original = new Triple[n2][n3];
        this.refIndices = new HashMap();
        int n4 = 0;
        for (Range range : this.refRanges) {
            this.refIndices.put(range, n4);
            AtomState[] atomStateArray = range.getAtoms();
            for (int i = 0; i < atomStateArray.length; ++i) {
                this.original[n4 + i][n] = new Triple(atomStateArray[i]);
            }
            n4 += range.getAtoms().length;
            System.err.println("Chose " + file + " as 'reference structure'");
        }
    }

    public void getOtherCoords(File file, Model model, Range[] rangeArray, int n) throws AtomException {
        for (Range range : rangeArray) {
            int n2;
            double d = Double.NEGATIVE_INFINITY;
            Range range2 = null;
            Range[] rangeArray2 = this.refRanges;
            int n3 = rangeArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Range range3 = rangeArray2[n2];
                Alignment alignment = Alignment.needlemanWunsch(range3.getAtoms(), range.getAtoms(), new StructureBasedAligner());
                double d2 = alignment.score(new StructureBasedAligner());
                if (this.verbose) {
                    System.err.println("Score = " + d2 + " for atom alignment:");
                    for (int i = 0; i < alignment.a.length; ++i) {
                        System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
                    }
                }
                if (!(d2 > d)) continue;
                d = d2;
                range2 = range3;
            }
            if (d == 0.0) {
                throw new IllegalArgumentException("*** Can't use " + file + " because best structure-based alignment score is 0!  " + "Structure not pre-superposed? ***");
            }
            if (this.verbose) {
                System.err.println(range + " goes with... " + "\n" + range2 + "\n");
            }
            int n4 = this.refIndices.get(range2);
            AtomState[] atomStateArray = range.getAtoms();
            for (n2 = 0; n2 < atomStateArray.length; ++n2) {
                this.original[n4 + n2][n] = new Triple(atomStateArray[n2]);
            }
            System.err.println("Used " + file + " for average structure");
        }
    }

    public Range[] getRanges(Model model) {
        ArrayList<Range> arrayList = new ArrayList<Range>();
        ArrayList<Residue> arrayList2 = new ArrayList<Residue>();
        for (Residue residue : model.getResidues()) {
            if (residue.getPrev(model) == null || !residue.getChain().equals(residue.getPrev(model).getChain()) || residue.getSequenceInteger() - residue.getPrev(model).getSequenceInteger() > 1) {
                if (arrayList2.size() > 0) {
                    arrayList.add(new Range(model, arrayList2));
                }
                arrayList2 = new ArrayList();
                arrayList2.add(residue);
                continue;
            }
            arrayList2.add(residue);
        }
        if (arrayList2.size() > 0) {
            arrayList.add(new Range(model, arrayList2));
        }
        Range[] rangeArray = new Range[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            rangeArray[i] = (Range)arrayList.get(i);
        }
        return rangeArray;
    }

    public void averageCoords() {
        this.averaged = new Triple[this.original.length];
        this.pseudoBs = new double[this.original.length];
        for (int i = 0; i < this.original.length; ++i) {
            int n;
            this.averaged[i] = new Triple(0.0, 0.0, 0.0);
            int n2 = 0;
            for (n = 0; n < this.original[i].length; ++n) {
                if (this.original[i][n] == null) continue;
                this.averaged[i].add(this.original[i][n]);
                ++n2;
            }
            this.averaged[i].div(1.0 * (double)n2);
            this.pseudoBs[i] = 0.0;
            for (n = 0; n < this.original[i].length; ++n) {
                if (this.original[i][n] == null) continue;
                int n3 = i;
                this.pseudoBs[n3] = this.pseudoBs[n3] + Math.pow(Triple.distance(this.averaged[i], this.original[i][n]), 2.0);
            }
            this.pseudoBs[i] = Math.sqrt(this.pseudoBs[i] / (1.0 * (double)n2)) * 100.0;
        }
    }

    public void printAvgStruc() {
        try {
            Model model = new Model("avg model");
            ModelState modelState = new ModelState();
            boolean bl = false;
            for (Range range : this.refRanges) {
                int n = this.refIndices.get(range);
                AtomState[] atomStateArray = range.getAtoms();
                for (int i = 0; i < atomStateArray.length; ++i) {
                    AtomState atomState = atomStateArray[i];
                    atomState.setX(this.averaged[n + i].getX());
                    atomState.setY(this.averaged[n + i].getY());
                    atomState.setZ(this.averaged[n + i].getZ());
                    atomState.setTempFactor(this.pseudoBs[i]);
                    atomState.setOccupancy(1.0);
                    Residue residue = atomState.getAtom().getResidue();
                    if (!model.contains(residue)) {
                        model.add(residue);
                    }
                    modelState.add(atomState);
                }
            }
            if (this.verbose) {
                System.err.println("Printing average structure...");
            }
            System.out.println("USER  MOD " + this.files.size() + " contributing structures");
            PdbWriter pdbWriter = new PdbWriter(System.out);
            pdbWriter.writeResidues(model.getResidues(), modelState);
            pdbWriter.close();
        }
        catch (ResidueException residueException) {
            System.err.println("Error adding a residue to average structure!");
        }
        catch (AtomException atomException) {
            System.err.println("Error adding an atom to average structure!");
        }
    }

    public void Main() {
        if (this.files.isEmpty()) {
            throw new IllegalArgumentException("Must supply at least two input PDBs!");
        }
        this.getCoords();
        this.averageCoords();
        this.printAvgStruc();
    }

    public static void main(String[] stringArray) {
        AvgStrucGenerator2 avgStrucGenerator2 = new AvgStrucGenerator2();
        try {
            avgStrucGenerator2.parseArguments(stringArray);
            avgStrucGenerator2.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            avgStrucGenerator2.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AvgStrucGenerator2.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AvgStrucGenerator2.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AvgStrucGenerator2");
        System.err.println("Copyright (C) 2008 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        if (file != null) {
            this.files.add(file);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        }
        if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-distcutoff") || string.equals("-maxdist")) {
            try {
                this.maxDist = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Couldn't parse " + string2 + " as a double for maxDist");
            }
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class StructureBasedAligner
    implements Alignment.Scorer {
        StructureBasedAligner() {
        }

        public double score(Object object, Object object2) {
            AtomState atomState = (AtomState)object;
            AtomState atomState2 = (AtomState)object2;
            if (atomState == null || atomState2 == null) {
                return -1.0;
            }
            if (!atomState.getAtom().getName().equals(atomState2.getAtom().getName())) {
                return 0.0;
            }
            if (atomState.distance(atomState2) > 2.0) {
                return 0.0;
            }
            if (atomState.distance(atomState2) <= 2.0 && atomState.distance(atomState2) > 1.0) {
                return 1.0;
            }
            if (atomState.distance(atomState2) <= 1.0 && atomState.distance(atomState2) > 0.5) {
                return 2.0;
            }
            if (atomState.distance(atomState2) <= 0.5) {
                return 3.0;
            }
            System.err.println("Not sure how to score " + atomState + " vs. " + atomState2 + "!");
            return 0.0;
        }

        public double open_gap(Object object) {
            return this.extend_gap(object);
        }

        public double extend_gap(Object object) {
            return this.score(object, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Range {
        final String bbAtoms = " N  , H  ,  CA ,  C  ,  O  ";
        public Model model;
        public Residue[] residues;

        public Range(Model model, ArrayList<Residue> arrayList) {
            this.model = model;
            this.residues = new Residue[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.residues[i] = arrayList.get(i);
            }
        }

        public AtomState[] getAtoms() throws AtomException {
            ModelState modelState = this.model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (int i = 0; i < this.residues.length; ++i) {
                for (Atom atom : this.residues[i].getAtoms()) {
                    if (" N  , H  ,  CA ,  C  ,  O  ".indexOf(atom.getName()) == -1) continue;
                    arrayList.add(modelState.get(atom));
                }
            }
            AtomState[] atomStateArray = new AtomState[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                atomStateArray[i] = (AtomState)arrayList.get(i);
            }
            return atomStateArray;
        }

        public String toString() {
            if (this.residues == null || this.residues.length == 0) {
                return "empty range";
            }
            String string = "'";
            for (int i = 0; i < this.residues.length; ++i) {
                string = string + this.residues[i].nickname() + (i < this.residues.length - 1 ? "-" : "'");
            }
            return string;
        }
    }
}

