/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.r3.Triple;
import driftwood.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class AvgStrucGenerator3 {
    boolean verbose = false;
    ArrayList<File> files;
    int maxNumFiles = 555;
    HashMap<AtomState, AtomState[]> atomMap;
    double minRmsf = Double.NaN;
    int refIndex = 0;

    public void readCoordinates() {
        Object object;
        PdbReader pdbReader = new PdbReader();
        Range[] rangeArray = null;
        File file = this.files.get(0);
        try {
            CoordinateFile coordinateFile = pdbReader.read(file);
            object = coordinateFile.getFirstModel();
            rangeArray = this.getRanges((Model)object, file);
        }
        catch (IOException iOException) {
            System.err.println("Error reading " + file + "!");
        }
        this.atomMap = new HashMap();
        for (int i = 0; i < this.files.size(); ++i) {
            file = this.files.get(i);
            try {
                object = pdbReader.read(file);
                Model model = ((CoordinateFile)object).getFirstModel();
                Range[] rangeArray2 = this.getRanges(model, file);
                this.alignRanges(rangeArray2, rangeArray);
                continue;
            }
            catch (IOException iOException) {
                System.err.println("Error reading " + file + "!");
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Error getting atoms from " + file + "!");
            }
        }
    }

    public Range[] getRanges(Model model, File file) {
        ArrayList<Range> arrayList = new ArrayList<Range>();
        ArrayList<Residue> arrayList2 = new ArrayList<Residue>();
        for (Residue residue : model.getResidues()) {
            if (residue.getPrev(model) == null || !residue.getChain().equals(residue.getPrev(model).getChain()) || residue.getSequenceInteger() - residue.getPrev(model).getSequenceInteger() > 1) {
                if (arrayList2.size() > 0) {
                    arrayList.add(new Range(model, arrayList2, file));
                }
                arrayList2 = new ArrayList();
                arrayList2.add(residue);
                continue;
            }
            arrayList2.add(residue);
        }
        if (arrayList2.size() > 0) {
            arrayList.add(new Range(model, arrayList2, file));
        }
        Range[] rangeArray = new Range[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            rangeArray[i] = (Range)arrayList.get(i);
        }
        return rangeArray;
    }

    public void alignRanges(Range[] rangeArray, Range[] rangeArray2) throws AtomException {
        for (Range range : rangeArray) {
            double d = 0.0;
            Range atomStateArray = null;
            Alignment alignment = null;
            for (Range range2 : rangeArray2) {
                try {
                    Alignment n = Alignment.needlemanWunsch(range.getAtoms(), range2.getAtoms(), new StructureBasedAligner());
                    double d2 = n.score(new StructureBasedAligner());
                    if (!(d2 > d)) continue;
                    d = d2;
                    atomStateArray = range2;
                    alignment = n;
                }
                catch (AtomException atomException) {
                    System.err.println("Error aligning " + range + " to " + range2 + "!");
                }
            }
            if (d == 0.0) {
                throw new IllegalArgumentException("*** Can't use " + range + " because best structure-based" + " alignment score is 0!  Structure not pre-superposed? ***");
            }
            if (this.verbose) {
                System.err.println(range + " goes with... " + "\n" + atomStateArray);
                System.err.println("Best atom alignment (score = " + d + "):");
                for (int i = 0; i < alignment.a.length; ++i) {
                    System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
                }
            }
            for (int i = 0; i < alignment.a.length; ++i) {
                AtomState atomState = (AtomState)alignment.a[i];
                AtomState atomState2 = (AtomState)alignment.b[i];
                AtomState[] atomStateArray2 = this.atomMap.keySet().contains(atomState2) ? this.atomMap.get(atomState2) : new AtomState[]{};
                int n = atomStateArray2.length;
                AtomState[] atomStateArray3 = new AtomState[n + 1];
                System.arraycopy(atomStateArray2, 0, atomStateArray3, 0, n);
                atomStateArray3[n] = atomState;
                this.atomMap.put(atomState2, atomStateArray3);
            }
            System.err.println("Using " + range + " for averaging");
            if (!this.verbose) continue;
            System.err.println();
        }
    }

    public void averageCoordinates() {
        Model model = new Model("avg model");
        ModelState modelState = new ModelState();
        boolean bl = true;
        for (AtomState atomState : this.atomMap.keySet()) {
            int n;
            AtomState[] atomStateArray = this.atomMap.get(atomState);
            if (this.verbose) {
                System.err.println("Contributors for " + atomState + ":");
                for (n = 0; n < atomStateArray.length; ++n) {
                    if (atomStateArray[n] == null) continue;
                    System.err.println("  " + atomStateArray[n]);
                }
                System.err.println();
            }
            n = 0;
            Triple triple = new Triple();
            for (int i = 0; i < atomStateArray.length; ++i) {
                if (atomStateArray[i] == null) continue;
                triple.add(atomStateArray[i]);
                ++n;
            }
            triple.div(n);
            double d = 0.0;
            for (int i = 0; i < atomStateArray.length; ++i) {
                if (atomStateArray[i] == null) continue;
                d += Math.pow(Triple.distance(triple, atomStateArray[i]), 2.0);
            }
            d = Math.sqrt(d / (double)n) * 100.0;
            atomState.like(triple);
            atomState.setTempFactor(d);
            atomState.setOccupancy(1.0);
            Residue residue = atomState.getResidue();
            try {
                if (!model.contains(residue)) {
                    model.add(residue);
                }
                modelState.add(atomState);
            }
            catch (ResidueException residueException) {
                System.err.println("Error adding " + residue + " to average model!");
            }
            catch (AtomException atomException) {
                System.err.println("Error adding " + atomState + " to average model state!");
            }
        }
        if (this.verbose) {
            System.err.println("Printing average structure...");
        }
        System.out.println("USER  MOD " + this.files.size() + " contributing structures");
        PdbWriter pdbWriter = new PdbWriter(System.out);
        pdbWriter.writeResidues(model.getResidues(), modelState);
        pdbWriter.close();
    }

    public void Main() {
        if (this.files.size() < 2) {
            throw new IllegalArgumentException("Only " + this.files.size() + " files -- need at least 2 to average!");
        }
        this.readCoordinates();
        this.averageCoordinates();
    }

    public static void main(String[] stringArray) {
        AvgStrucGenerator3 avgStrucGenerator3 = new AvgStrucGenerator3();
        try {
            avgStrucGenerator3.parseArguments(stringArray);
            avgStrucGenerator3.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            avgStrucGenerator3.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("AvgStrucGenerator3.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'AvgStrucGenerator3.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.AvgStrucGenerator3");
        System.err.println("Copyright (C) 2011 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        File file = new File(string);
        if (file != null) {
            if (this.files == null) {
                this.files = new ArrayList();
            }
            if (this.files.size() < this.maxNumFiles) {
                this.files.add(file);
            }
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        }
        if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Range {
        final String bbAtoms = " N  , H  , CA , CB , HA3,2HA , HA , HA2,1HA , C  , O  ";
        public File file;
        public Model model;
        public Residue[] residues;

        public Range(Model model, ArrayList<Residue> arrayList, File file) {
            this.file = file;
            this.model = model;
            this.residues = new Residue[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                this.residues[i] = arrayList.get(i);
            }
        }

        public AtomState[] getAtoms() throws AtomException {
            ModelState modelState = this.model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (int i = 0; i < this.residues.length; ++i) {
                String[] stringArray = Strings.explode(" N  , H  , CA , CB , HA3,2HA , HA , HA2,1HA , C  , O  ", ',');
                for (int j = 0; j < stringArray.length; ++j) {
                    for (Atom atom : this.residues[i].getAtoms()) {
                        if (!atom.getName().equals(stringArray[j]) && (j != 1 || !atom.getName().equals(" CD ") || !atom.getResidue().getName().equals("PRO"))) continue;
                        arrayList.add(modelState.get(atom));
                    }
                }
            }
            AtomState[] atomStateArray = new AtomState[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                atomStateArray[i] = (AtomState)arrayList.get(i);
            }
            return atomStateArray;
        }

        public String toString() {
            if (this.residues == null || this.residues.length == 0) {
                return "'empty range'";
            }
            String string = "'";
            for (int i = 0; i < this.residues.length; ++i) {
                string = string + this.residues[i].nickname() + (i < this.residues.length - 1 ? "-" : "");
            }
            string = string + (this.file != null ? " " + this.file.getName() + "'" : " ??file??'");
            return string;
        }
    }

    static class StructureBasedAligner
    implements Alignment.Scorer {
        StructureBasedAligner() {
        }

        public boolean atomsAreEquivalant(AtomState atomState, AtomState atomState2) {
            if (atomState.getName().equals(atomState2.getName())) {
                return true;
            }
            if (atomState.getName().equals(" H  ") && atomState2.getName().equals(" CD ") || atomState.getName().equals(" HA ") && atomState2.getName().equals(" HA2") || atomState.getName().equals(" HA ") && atomState2.getName().equals("1HA ") || atomState.getName().equals(" CB ") && atomState2.getName().equals(" HA3") || atomState.getName().equals(" CB ") && atomState2.getName().equals("2HA ")) {
                return true;
            }
            return atomState.getName().equals(" CD ") && atomState2.getName().equals(" H  ") || atomState.getName().equals(" HA2") && atomState2.getName().equals(" HA ") || atomState.getName().equals("1HA ") && atomState2.getName().equals(" HA ") || atomState.getName().equals(" HA3") && atomState2.getName().equals(" CB ") || atomState.getName().equals("2HA ") && atomState2.getName().equals(" CB ");
        }

        public double score(Object object, Object object2) {
            AtomState atomState = (AtomState)object;
            AtomState atomState2 = (AtomState)object2;
            if (atomState == null || atomState2 == null) {
                return -1.0;
            }
            if (!this.atomsAreEquivalant(atomState, atomState2)) {
                return 0.0;
            }
            if (atomState.distance(atomState2) > 2.0) {
                return 0.0;
            }
            if (atomState.distance(atomState2) <= 2.0 && atomState.distance(atomState2) > 1.0) {
                return 1.0;
            }
            if (atomState.distance(atomState2) <= 1.0 && atomState.distance(atomState2) > 0.5) {
                return 2.0;
            }
            if (atomState.distance(atomState2) <= 0.5) {
                return 3.0;
            }
            System.err.println("Not sure how to score " + atomState + " vs. " + atomState2 + "!");
            return 0.0;
        }

        public double open_gap(Object object) {
            return this.extend_gap(object);
        }

        public double extend_gap(Object object) {
            return this.score(object, null);
        }
    }
}

