/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.MutableTuple3;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class BackboneMoveFinder {
    DecimalFormat df = new DecimalFormat("0.0##");
    static final String BACKRUB = "Backrubs";
    static final String SHEAR = "Shears";
    static final String PEPFLIP = "Peptide flips";
    static final String SMEAR = "Diagonal smears";
    double rmsdLimit = 0.1;
    double backrubAngleLimit = 10.0;
    double shearAngleLimit = 5.0;
    double shearDistanceLimit = 0.3;
    String moveType = "Backrubs";
    boolean pairwise = true;

    AtomState[][] getCalphas(Collection collection) {
        AtomState[][] atomStateArray = new AtomState[collection.size()][0];
        int n = 0;
        for (Model model : collection) {
            ModelState modelState = model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (Residue residue : model.getResidues()) {
                Atom atom = residue.getAtom(" CA ");
                if (atom == null) continue;
                try {
                    arrayList.add(modelState.get(atom));
                }
                catch (AtomException atomException) {
                    atomException.printStackTrace();
                }
            }
            atomStateArray[n] = arrayList.toArray(atomStateArray[n]);
            ++n;
        }
        return atomStateArray;
    }

    AtomState[][] getCbetas(Collection collection) {
        AtomState[][] atomStateArray = new AtomState[collection.size()][0];
        int n = 0;
        for (Model model : collection) {
            ModelState modelState = model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (Residue residue : model.getResidues()) {
                Atom atom = residue.getAtom(" CB ");
                if (atom == null) {
                    atom = residue.getAtom("2HA ");
                }
                if (atom == null) continue;
                try {
                    arrayList.add(modelState.get(atom));
                }
                catch (AtomException atomException) {
                    atomException.printStackTrace();
                }
            }
            atomStateArray[n] = arrayList.toArray(atomStateArray[n]);
            ++n;
        }
        return atomStateArray;
    }

    AtomState[][] getOxygens(Collection collection) {
        AtomState[][] atomStateArray = new AtomState[collection.size()][0];
        int n = 0;
        for (Model model : collection) {
            ModelState modelState = model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (Residue residue : model.getResidues()) {
                Atom atom = residue.getAtom(" O  ");
                if (atom == null) continue;
                try {
                    arrayList.add(modelState.get(atom));
                }
                catch (AtomException atomException) {
                    atomException.printStackTrace();
                }
            }
            atomStateArray[n] = arrayList.toArray(atomStateArray[n]);
            ++n;
        }
        return atomStateArray;
    }

    void printBackrubPairs(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("residue,ref_model,mobile_model,Ca_rmsd(1245),backrub_angle");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        for (int i = 2; i < atomStateArray[0].length - 2; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = j + 1; k < n; ++k) {
                    Tuple3[] tuple3Array = new Triple[]{new Triple(atomStateArray[j][i - 2]), new Triple(atomStateArray[j][i - 1]), new Triple(atomStateArray[j][i + 1]), new Triple(atomStateArray[j][i + 2])};
                    Tuple3[] tuple3Array2 = new Triple[]{new Triple(atomStateArray[k][i - 2]), new Triple(atomStateArray[k][i - 1]), new Triple(atomStateArray[k][i + 1]), new Triple(atomStateArray[k][i + 2])};
                    SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
                    Transform transform = superPoser.superpos();
                    double d = superPoser.calcRMSD(transform);
                    for (int i2 = 0; i2 < tuple3Array2.length; ++i2) {
                        transform.transform((MutableTuple3)tuple3Array2[i2]);
                    }
                    Triple triple = new Triple().likeMidpoint(tuple3Array[1], tuple3Array2[1]);
                    AtomState atomState = atomStateArray[j][i];
                    Triple triple2 = new Triple(atomStateArray[k][i]);
                    transform.transform(triple2);
                    Triple triple3 = new Triple().likeMidpoint(tuple3Array[2], tuple3Array2[2]);
                    double d2 = Triple.dihedral(atomState, triple, triple3, triple2);
                    if (!(d <= this.rmsdLimit) || !(Math.abs(d2) >= this.backrubAngleLimit)) continue;
                    printStream.println(atomStateArray[j][i].getResidue() + "," + (j + 1) + "," + (k + 1) + "," + this.df.format(d) + "," + this.df.format(d2));
                }
            }
        }
    }

    void printShearPairs(PrintStream printStream, AtomState[][] atomStateArray, AtomState[][] atomStateArray2) {
        printStream.println("residue,ref_model,mobile_model,Ca_rmsd(1256),shear_angle(O3Ca3Ca4O3p),O3_dist");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        for (int i = 2; i < atomStateArray[0].length - 3; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = j + 1; k < n; ++k) {
                    Tuple3[] tuple3Array = new Triple[]{new Triple(atomStateArray[j][i - 2]), new Triple(atomStateArray[j][i - 1]), new Triple(atomStateArray[j][i + 2]), new Triple(atomStateArray[j][i + 3])};
                    Tuple3[] tuple3Array2 = new Triple[]{new Triple(atomStateArray[k][i - 2]), new Triple(atomStateArray[k][i - 1]), new Triple(atomStateArray[k][i + 2]), new Triple(atomStateArray[k][i + 3])};
                    SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
                    Transform transform = superPoser.superpos();
                    double d = superPoser.calcRMSD(transform);
                    for (int i2 = 0; i2 < tuple3Array2.length; ++i2) {
                        transform.transform((MutableTuple3)tuple3Array2[i2]);
                    }
                    AtomState atomState = atomStateArray[j][i];
                    AtomState atomState2 = atomStateArray[j][i + 1];
                    AtomState atomState3 = atomStateArray2[j][i];
                    Triple triple = new Triple(atomStateArray2[k][i]);
                    transform.transform(triple);
                    double d2 = Triple.dihedral(atomState3, atomState, atomState2, triple);
                    double d3 = Triple.distance(atomState3, triple);
                    if (!(d <= this.rmsdLimit) || !(Math.abs(d2) < this.shearAngleLimit) || !(d3 > this.shearDistanceLimit)) continue;
                    printStream.println(atomStateArray[j][i].getResidue() + "," + (j + 1) + "," + (k + 1) + "," + this.df.format(d) + "," + this.df.format(d2) + "," + this.df.format(d3));
                }
            }
        }
    }

    void printPepFlipPairs(PrintStream printStream, AtomState[][] atomStateArray) {
        System.err.println("NOT YET IMPLEMENTED");
        System.exit(0);
    }

    void printSmearPairs(PrintStream printStream, AtomState[][] atomStateArray) {
        System.err.println("NOT YET IMPLEMENTED");
        System.exit(0);
    }

    void printBackrubStats(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("Residue,dist24,sd,theta124,sd,theta245,sd,phi1245,len,sd,phi1243,len,sd,phi3245,len,sd");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        int n2 = atomStateArray[0].length;
        if (n2 == 0) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = new double[n];
        for (int i = 2; i < n2 - 2; ++i) {
            for (int j = 0; j < n; ++j) {
                AtomState atomState = atomStateArray[j][i - 2];
                AtomState atomState2 = atomStateArray[j][i - 1];
                AtomState atomState3 = atomStateArray[j][i];
                AtomState atomState4 = atomStateArray[j][i + 1];
                AtomState atomState5 = atomStateArray[j][i + 2];
                dArray[j] = atomState.distance(atomState3);
                dArray2[j] = atomState2.distance(atomState4);
                dArray3[j] = atomState3.distance(atomState5);
                dArray4[j] = atomState.distance(atomState4);
                dArray5[j] = atomState2.distance(atomState5);
                dArray6[j] = atomState.distance(atomState5);
                dArray7[j] = Triple.angle(atomState, atomState2, atomState4);
                dArray8[j] = Triple.angle(atomState2, atomState4, atomState5);
                dArray9[j] = Triple.dihedral(atomState, atomState2, atomState4, atomState5);
                dArray10[j] = Triple.dihedral(atomState, atomState2, atomState4, atomState3);
                dArray11[j] = Triple.dihedral(atomState3, atomState2, atomState4, atomState5);
            }
            printStream.print("\"" + atomStateArray[0][i].getResidue());
            printStream.print("\",\"" + this.df.format(this.mean(dArray2)) + "\",\"" + this.df.format(this.stddev(dArray2)));
            printStream.print("\",\"" + this.df.format(this.mean(dArray7)) + "\",\"" + this.df.format(this.stddev(dArray7)));
            printStream.print("\",\"" + this.df.format(this.mean(dArray8)) + "\",\"" + this.df.format(this.stddev(dArray8)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray9)) + "\",\"" + this.df.format(this.circ_len(dArray9)) + "\",\"" + this.df.format(this.circ_stddev(dArray9)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray10)) + "\",\"" + this.df.format(this.circ_len(dArray10)) + "\",\"" + this.df.format(this.circ_stddev(dArray10)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray11)) + "\",\"" + this.df.format(this.circ_len(dArray11)) + "\",\"" + this.df.format(this.circ_stddev(dArray11)));
            printStream.println("\"");
        }
    }

    void printShearStats(PrintStream printStream, AtomState[][] atomStateArray, AtomState[][] atomStateArray2) {
        System.err.println("NOT YET IMPLEMENTED");
        System.exit(0);
    }

    void printPepFlipStats(PrintStream printStream, AtomState[][] atomStateArray) {
        System.err.println("NOT YET IMPLEMENTED");
        System.exit(0);
    }

    void printSmearStats(PrintStream printStream, AtomState[][] atomStateArray) {
        System.err.println("NOT YET IMPLEMENTED");
        System.exit(0);
    }

    double mean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    double stddev(double[] dArray) {
        double d = this.mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = d - dArray[i];
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    double circ_mean(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.cos(Math.toRadians(dArray[i]));
            d2 += Math.sin(Math.toRadians(dArray[i]));
        }
        return Math.toDegrees(Math.atan2(d2 / (double)dArray.length, d / (double)dArray.length));
    }

    double circ_len(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.cos(Math.toRadians(dArray[i]));
            d2 += Math.sin(Math.toRadians(dArray[i]));
        }
        return Math.sqrt((d /= (double)dArray.length) * d + (d2 /= (double)dArray.length) * d2);
    }

    double circ_stddev(double[] dArray) {
        double d = this.circ_mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = Math.abs(d - dArray[i]) % 360.0;
            if (d3 > 180.0) {
                d3 = 360.0 - d3;
            }
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    public void Main() throws IOException {
        System.err.println("Friendly reminder: Be sure you used \"command < file.pdb\" for input!");
        System.err.println("Mode: " + this.moveType + " " + (this.pairwise ? "(all-against-all pairwise model comparisons)" : "(full-ensemble per-residue stats)"));
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(System.in);
        AtomState[][] atomStateArray = this.getCalphas(coordinateFile.getModels());
        if (this.moveType == BACKRUB) {
            if (this.pairwise) {
                this.printBackrubPairs(System.out, atomStateArray);
            } else {
                this.printBackrubStats(System.out, atomStateArray);
            }
        } else if (this.moveType == SHEAR) {
            AtomState[][] atomStateArray2 = this.getOxygens(coordinateFile.getModels());
            if (this.pairwise) {
                this.printShearPairs(System.out, atomStateArray, atomStateArray2);
            } else {
                this.printShearStats(System.out, atomStateArray, atomStateArray2);
            }
        } else if (this.moveType == PEPFLIP) {
            if (this.pairwise) {
                this.printPepFlipPairs(System.out, atomStateArray);
            } else {
                this.printPepFlipStats(System.out, atomStateArray);
            }
        } else if (this.moveType == SMEAR) {
            if (this.pairwise) {
                this.printSmearPairs(System.out, atomStateArray);
            } else {
                this.printSmearStats(System.out, atomStateArray);
            }
        }
    }

    public static void main(String[] stringArray) {
        BackboneMoveFinder backboneMoveFinder = new BackboneMoveFinder();
        try {
            backboneMoveFinder.parseArguments(stringArray);
            backboneMoveFinder.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            backboneMoveFinder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("BackboneMoveFinder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'BackboneMoveFinder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.BackboneMoveFinder");
        System.err.println("Copyright (C) 2011 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-backrub") || string.equals("-backrubs")) {
            this.moveType = BACKRUB;
        } else if (string.equals("-shear") || string.equals("-shears")) {
            this.moveType = SHEAR;
        } else if (string.equals("-flip") || string.equals("-flips")) {
            this.moveType = PEPFLIP;
        } else if (string.equals("-smear") || string.equals("-smears")) {
            this.moveType = SMEAR;
        } else if (string.equals("-pairs")) {
            this.pairwise = true;
        } else if (string.equals("-stats")) {
            this.pairwise = false;
        } else if (string.equals("-rmsd")) {
            this.rmsdLimit = Double.parseDouble(string2);
        } else if (string.equals("-backrubangle")) {
            this.backrubAngleLimit = Double.parseDouble(string2);
        } else if (string.equals("-shearangle")) {
            this.shearAngleLimit = Double.parseDouble(string2);
        } else if (string.equals("-sheardistance") || string.equals("-sheardist")) {
            this.shearDistanceLimit = Double.parseDouble(string2);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

