/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.MutableTuple3;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class BackboneMoveFinder2 {
    DecimalFormat df = new DecimalFormat("0.0##");
    static final String BACKRUB = "backrub";
    static final String SHEAR = "shear";
    boolean verbose = false;
    double rmsdLimit = 0.05;
    double backrubAngleLimit = 20.0;
    double shearAngleLimit = 4.0;
    double shearDistLimit = 0.3;
    String moveType = "backrub";
    boolean pairwise = true;

    AtomState[][] getCalphas(Collection collection) {
        AtomState[][] atomStateArray = new AtomState[collection.size()][0];
        int n = 0;
        for (Model model : collection) {
            ModelState modelState = model.getState();
            ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
            for (Residue residue : model.getResidues()) {
                Atom atom = residue.getAtom(" CA ");
                if (atom == null) continue;
                try {
                    arrayList.add(modelState.get(atom));
                }
                catch (AtomException atomException) {
                    atomException.printStackTrace();
                }
            }
            atomStateArray[n] = arrayList.toArray(atomStateArray[n]);
            ++n;
        }
        return atomStateArray;
    }

    void printBackrubPairs(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("residue,ref_model,mobile_model,Ca_rmsd(1245),backrub_angle");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        for (int i = 2; i < atomStateArray[0].length - 2; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = j + 1; k < n; ++k) {
                    Tuple3[] tuple3Array = new Triple[]{new Triple(atomStateArray[j][i - 2]), new Triple(atomStateArray[j][i - 1]), new Triple(atomStateArray[j][i + 1]), new Triple(atomStateArray[j][i + 2])};
                    Tuple3[] tuple3Array2 = new Triple[]{new Triple(atomStateArray[k][i - 2]), new Triple(atomStateArray[k][i - 1]), new Triple(atomStateArray[k][i + 1]), new Triple(atomStateArray[k][i + 2])};
                    SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
                    Transform transform = superPoser.superpos();
                    double d = superPoser.calcRMSD(transform);
                    for (int i2 = 0; i2 < tuple3Array2.length; ++i2) {
                        transform.transform((MutableTuple3)tuple3Array2[i2]);
                    }
                    Triple triple = new Triple().likeMidpoint(tuple3Array[1], tuple3Array2[1]);
                    AtomState atomState = atomStateArray[j][i];
                    Triple triple2 = new Triple(atomStateArray[k][i]);
                    transform.transform(triple2);
                    Triple triple3 = new Triple().likeMidpoint(tuple3Array[2], tuple3Array2[2]);
                    double d2 = Triple.dihedral(atomState, triple, triple3, triple2);
                    if (!(d <= this.rmsdLimit) || !(Math.abs(d2) >= this.backrubAngleLimit)) continue;
                    printStream.println(atomStateArray[j][i].getResidue() + "," + (j + 1) + "," + (k + 1) + "," + this.df.format(d) + "," + this.df.format(d2));
                }
            }
        }
    }

    void printBackrubStats(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("residue,dist24,dist24sd,theta124,theta124sd,theta245,theta245sd,phi1245,phi1245len,phi1245sd,phi1243,phi1243len,phi1243sd,phi3245,phi3245len,phi3245sd");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        int n2 = atomStateArray[0].length;
        if (n2 == 0) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        double[] dArray11 = new double[n];
        for (int i = 2; i < n2 - 2; ++i) {
            for (int j = 0; j < n; ++j) {
                AtomState atomState = atomStateArray[j][i - 2];
                AtomState atomState2 = atomStateArray[j][i - 1];
                AtomState atomState3 = atomStateArray[j][i];
                AtomState atomState4 = atomStateArray[j][i + 1];
                AtomState atomState5 = atomStateArray[j][i + 2];
                dArray[j] = atomState.distance(atomState3);
                dArray2[j] = atomState2.distance(atomState4);
                dArray3[j] = atomState3.distance(atomState5);
                dArray4[j] = atomState.distance(atomState4);
                dArray5[j] = atomState2.distance(atomState5);
                dArray6[j] = atomState.distance(atomState5);
                dArray7[j] = Triple.angle(atomState, atomState2, atomState4);
                dArray8[j] = Triple.angle(atomState2, atomState4, atomState5);
                dArray9[j] = Triple.dihedral(atomState, atomState2, atomState4, atomState5);
                dArray10[j] = Triple.dihedral(atomState, atomState2, atomState4, atomState3);
                dArray11[j] = Triple.dihedral(atomState3, atomState2, atomState4, atomState5);
            }
            printStream.print("\"" + atomStateArray[0][i].getResidue());
            printStream.print("\",\"" + this.df.format(this.mean(dArray2)) + "\",\"" + this.df.format(this.stddev(dArray2)));
            printStream.print("\",\"" + this.df.format(this.mean(dArray7)) + "\",\"" + this.df.format(this.stddev(dArray7)));
            printStream.print("\",\"" + this.df.format(this.mean(dArray8)) + "\",\"" + this.df.format(this.stddev(dArray8)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray9)) + "\",\"" + this.df.format(this.circ_len(dArray9)) + "\",\"" + this.df.format(this.circ_stddev(dArray9)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray10)) + "\",\"" + this.df.format(this.circ_len(dArray10)) + "\",\"" + this.df.format(this.circ_stddev(dArray10)));
            printStream.print("\",\"" + this.df.format(this.circ_mean(dArray11)) + "\",\"" + this.df.format(this.circ_len(dArray11)) + "\",\"" + this.df.format(this.circ_stddev(dArray11)));
            printStream.println("\"");
        }
    }

    void printShearPairs(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("residue,ref_model,mobile_model,Ca_rmsd(1256),shear_angle,shear_dist");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        for (int i = 2; i < atomStateArray[0].length - 3; ++i) {
            for (int j = 0; j < n; ++j) {
                for (int k = j + 1; k < n; ++k) {
                    Tuple3[] tuple3Array = new Triple[]{new Triple(atomStateArray[j][i - 2]), new Triple(atomStateArray[j][i - 1]), new Triple(atomStateArray[j][i + 2]), new Triple(atomStateArray[j][i + 3])};
                    Tuple3[] tuple3Array2 = new Triple[]{new Triple(atomStateArray[k][i - 2]), new Triple(atomStateArray[k][i - 1]), new Triple(atomStateArray[k][i + 2]), new Triple(atomStateArray[k][i + 3])};
                    SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
                    Transform transform = superPoser.superpos();
                    double d = superPoser.calcRMSD(transform);
                    for (int i2 = 0; i2 < tuple3Array2.length; ++i2) {
                        transform.transform((MutableTuple3)tuple3Array2[i2]);
                    }
                    AtomState atomState = atomStateArray[j][i];
                    Triple triple = new Triple(atomStateArray[k][i]);
                    AtomState atomState2 = atomStateArray[j][i + 1];
                    Triple triple2 = new Triple(atomStateArray[k][i + 1]);
                    transform.transform(triple);
                    transform.transform(triple2);
                    Triple triple3 = new Triple().likeMidpoint(tuple3Array[1], tuple3Array2[1]);
                    Triple triple4 = new Triple().likeMidpoint(atomState, triple);
                    Triple triple5 = new Triple().likeMidpoint(atomState2, triple2);
                    Triple triple6 = new Triple().likeMidpoint(tuple3Array[2], tuple3Array2[2]);
                    double d2 = Triple.dihedral(atomState, triple3, triple5, triple);
                    double d3 = Triple.dihedral(atomState2, triple4, triple6, triple2);
                    double d4 = d2;
                    if (Math.abs(d3) > Math.abs(d2)) {
                        d4 = d3;
                    }
                    double d5 = Triple.distance(atomState, triple);
                    double d6 = Triple.distance(atomState2, triple2);
                    double d7 = Math.min(d5, d6);
                    if (!(d <= this.rmsdLimit) || !(Math.abs(d4) < this.shearAngleLimit) || !(d7 > this.shearDistLimit)) continue;
                    printStream.println(atomStateArray[j][i].getResidue() + "," + (j + 1) + "," + (k + 1) + "," + this.df.format(d) + "," + this.df.format(d4) + "," + this.df.format(d7));
                }
            }
        }
    }

    void printShearStats(PrintStream printStream, AtomState[][] atomStateArray) {
        printStream.println("residue,dist25,dist25sd,dist16,dist16sd,theta126,theta126sd,theta256,theta256sd,phi1256,phi1256len,phi1256sd,dist24,dist24sd,dist35,dist35sd,theta234,theta234sd,theta345,theta345sd,phi3254,phi3254len,phi3254sd");
        int n = atomStateArray.length;
        if (n == 0) {
            return;
        }
        int n2 = atomStateArray[0].length;
        if (n2 == 0) {
            return;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[n];
        double[] dArray7 = new double[n];
        double[] dArray8 = new double[n];
        double[] dArray9 = new double[n];
        double[] dArray10 = new double[n];
        for (int i = 2; i < n2 - 3; ++i) {
            for (int j = 0; j < n; ++j) {
                AtomState atomState = atomStateArray[j][i - 2];
                AtomState atomState2 = atomStateArray[j][i - 1];
                AtomState atomState3 = atomStateArray[j][i];
                AtomState atomState4 = atomStateArray[j][i + 1];
                AtomState atomState5 = atomStateArray[j][i + 2];
                AtomState atomState6 = atomStateArray[j][i + 3];
                dArray[j] = atomState2.distance(atomState5);
                dArray2[j] = atomState.distance(atomState6);
                dArray3[j] = Triple.angle(atomState, atomState2, atomState6);
                dArray4[j] = Triple.angle(atomState2, atomState5, atomState6);
                dArray5[j] = Triple.dihedral(atomState, atomState2, atomState5, atomState6);
                dArray6[j] = atomState2.distance(atomState4);
                dArray7[j] = atomState3.distance(atomState5);
                dArray8[j] = Triple.angle(atomState2, atomState3, atomState4);
                dArray9[j] = Triple.angle(atomState3, atomState4, atomState5);
                dArray10[j] = Triple.dihedral(atomState3, atomState2, atomState5, atomState4);
            }
            printStream.print(atomStateArray[0][i].getResidue());
            printStream.print("," + this.df.format(this.mean(dArray)) + "," + this.df.format(this.stddev(dArray)));
            printStream.print("," + this.df.format(this.mean(dArray2)) + "," + this.df.format(this.stddev(dArray2)));
            printStream.print("," + this.df.format(this.mean(dArray3)) + "," + this.df.format(this.stddev(dArray3)));
            printStream.print("," + this.df.format(this.mean(dArray4)) + "," + this.df.format(this.stddev(dArray4)));
            printStream.print("," + this.df.format(this.circ_mean(dArray5)) + "," + this.df.format(this.circ_len(dArray5)) + "," + this.df.format(this.circ_stddev(dArray5)));
            printStream.print("," + this.df.format(this.mean(dArray6)) + "," + this.df.format(this.stddev(dArray6)));
            printStream.print("," + this.df.format(this.mean(dArray7)) + "," + this.df.format(this.stddev(dArray7)));
            printStream.print("," + this.df.format(this.mean(dArray8)) + "," + this.df.format(this.stddev(dArray8)));
            printStream.print("," + this.df.format(this.mean(dArray9)) + "," + this.df.format(this.stddev(dArray9)));
            printStream.print("," + this.df.format(this.circ_mean(dArray10)) + "," + this.df.format(this.circ_len(dArray10)) + "," + this.df.format(this.circ_stddev(dArray10)));
            printStream.println();
        }
    }

    double mean(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
        }
        return d / (double)dArray.length;
    }

    double stddev(double[] dArray) {
        double d = this.mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = d - dArray[i];
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    double circ_mean(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.cos(Math.toRadians(dArray[i]));
            d2 += Math.sin(Math.toRadians(dArray[i]));
        }
        return Math.toDegrees(Math.atan2(d2 / (double)dArray.length, d / (double)dArray.length));
    }

    double circ_len(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += Math.cos(Math.toRadians(dArray[i]));
            d2 += Math.sin(Math.toRadians(dArray[i]));
        }
        return Math.sqrt((d /= (double)dArray.length) * d + (d2 /= (double)dArray.length) * d2);
    }

    double circ_stddev(double[] dArray) {
        double d = this.circ_mean(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d3 = Math.abs(d - dArray[i]) % 360.0;
            if (d3 > 180.0) {
                d3 = 360.0 - d3;
            }
            d2 += d3 * d3;
        }
        return Math.sqrt(d2 / (double)dArray.length);
    }

    public void Main() throws IOException {
        if (this.verbose) {
            System.err.println("Mode: " + this.moveType + " " + (this.pairwise ? "pairs" : "stats"));
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(System.in);
        AtomState[][] atomStateArray = this.getCalphas(coordinateFile.getModels());
        if (this.moveType == BACKRUB) {
            if (this.pairwise) {
                this.printBackrubPairs(System.out, atomStateArray);
            } else {
                this.printBackrubStats(System.out, atomStateArray);
            }
        } else if (this.moveType == SHEAR) {
            if (this.pairwise) {
                this.printShearPairs(System.out, atomStateArray);
            } else {
                this.printShearStats(System.out, atomStateArray);
            }
        }
    }

    public static void main(String[] stringArray) {
        BackboneMoveFinder2 backboneMoveFinder2 = new BackboneMoveFinder2();
        try {
            backboneMoveFinder2.parseArguments(stringArray);
            backboneMoveFinder2.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            backboneMoveFinder2.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("BackboneMoveFinder2.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'BackboneMoveFinder2.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.BackboneMoveFinder2");
        System.err.println("Copyright (C) 2011 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-backrub") || string.equals("-backrubs")) {
            this.moveType = BACKRUB;
        } else if (string.equals("-shear") || string.equals("-shears")) {
            this.moveType = SHEAR;
        } else if (string.equals("-pairs")) {
            this.pairwise = true;
        } else if (string.equals("-stats")) {
            this.pairwise = false;
        } else if (string.equals("-rmsd")) {
            this.rmsdLimit = Double.parseDouble(string2);
        } else if (string.equals("-backrubangle")) {
            this.backrubAngleLimit = Double.parseDouble(string2);
        } else if (string.equals("-shearangle")) {
            this.shearAngleLimit = Double.parseDouble(string2);
        } else if (string.equals("-sheardistance") || string.equals("-sheardist")) {
            this.shearDistLimit = Double.parseDouble(string2);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

