/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.CaRotation;
import chiropraxis.mc.CaShear;
import chiropraxis.mc.ShearPioneer;
import chiropraxis.rotarama.Ramachandran;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class BackrubPioneer
extends ShearPioneer {
    public BackrubPioneer() {
        try {
            this.rama = Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Residue findResidue(Model model) {
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (residue2.getSequenceInteger() != this.resnum) continue;
            residue = residue2;
            break;
        }
        if (residue == null) {
            System.err.println("D'oh!  Can't find residue # " + this.resnum);
            System.exit(0);
        }
        if (residue.getPrev(model) == null) {
            System.err.println("D'oh!  Need a residue preceding " + residue);
            System.exit(0);
        }
        Object object = residue;
        for (int i = 0; i < 3; ++i) {
            if ((object = ((Residue)object).getNext(model)) != null) continue;
            System.err.println("D'oh!  Need 4 residues following " + residue);
            System.exit(0);
        }
        return residue;
    }

    void doMoveSeries(Model model, ModelState modelState, Residue residue, String string) {
        System.out.println("@group {brb" + this.resnum + "-" + (this.resnum + 2) + string + " ep" + this.df5.format(this.epsilon) + "} animate dominant");
        Residue residue2 = residue;
        Residue residue3 = residue2.getNext(model);
        Residue residue4 = residue3.getNext(model);
        if (residue2 == null || residue3 == null || residue4 == null) {
            System.err.println("Oops, missing residues somewhere in here: " + this.resnum + "-" + (this.resnum + 2));
            System.exit(0);
        }
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        arrayList.add(residue2);
        arrayList.add(residue3);
        arrayList.add(residue4);
        Residue[] residueArray = arrayList.toArray(new Residue[arrayList.size()]);
        ArrayList<BackrubbedRegion> arrayList2 = new ArrayList<BackrubbedRegion>();
        for (double d = -1.0 * this.maxTheta; d <= this.maxTheta; d += this.thetaSpacing) {
            try {
                ModelState modelState2 = CaRotation.makeConformation(arrayList, modelState, d, false);
                double d2 = this.calcPepRot(modelState, modelState2, residue2, residue3, d);
                double d3 = this.calcPepRot(modelState, modelState2, residue3, residue4, d);
                double[] dArray = new double[]{d2, d3};
                boolean[] blArray = new boolean[]{false, false, false};
                modelState2 = CaShear.twistPeptides(residueArray, modelState2, dArray, blArray);
                double[] dArray2 = new double[]{d, d2, d3};
                double[] dArray3 = new double[]{AminoAcid.getPhi(model, residue2, modelState2), AminoAcid.getPsi(model, residue2, modelState2), AminoAcid.getPhi(model, residue4, modelState2), AminoAcid.getPsi(model, residue4, modelState2)};
                boolean bl = AminoAcid.getTauDeviation(residue2, modelState2) > this.maxTauDev || AminoAcid.getTauDeviation(residue3, modelState2) > this.maxTauDev || AminoAcid.getTauDeviation(residue4, modelState2) > this.maxTauDev;
                boolean bl2 = this.rama.isOutlier(model, residue2, modelState) || this.rama.isOutlier(model, residue3, modelState) || this.rama.isOutlier(model, residue4, modelState);
                BackrubbedRegion backrubbedRegion = new BackrubbedRegion(residueArray, modelState2, dArray2, dArray3, bl, bl2);
                arrayList2.add(backrubbedRegion);
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Can't perform " + this.df.format(d) + " degree backrub!");
                continue;
            }
            catch (ResidueException residueException) {
                System.err.println("Can't get phi/psi after " + this.df.format(d) + " degree backrub!");
            }
        }
        if (this.outputMode == this.STREAKS) {
            this.printStreaks(arrayList2);
        } else if (this.outputMode == this.STRUCTS) {
            this.printStructs(arrayList2, model);
        } else {
            System.err.println("Cannot compute!  Bad output mode: " + this.outputMode);
        }
    }

    void printStreaks(ArrayList arrayList) {
        BackrubbedRegion backrubbedRegion;
        int n;
        System.out.println("@balllist {backrub i} radius= 0.3 master= {backrub i}");
        for (n = 0; n < arrayList.size(); ++n) {
            backrubbedRegion = (BackrubbedRegion)arrayList.get(n);
            System.out.println("{i " + backrubbedRegion.res1.getName().toLowerCase().trim() + backrubbedRegion.res1.getSequenceInteger() + " " + this.df.format(backrubbedRegion.theta) + "," + this.df.format(backrubbedRegion.pepRot1) + "," + this.df.format(backrubbedRegion.pepRot2) + " ep=" + this.df2.format(this.epsilon) + " (" + this.df.format(backrubbedRegion.phi1) + "," + this.df.format(backrubbedRegion.psi1) + ")}" + (backrubbedRegion.badTau || backrubbedRegion.ramaOut ? this.BAD_COLOR : this.GOOD_COLOR) + " " + this.df4.format(backrubbedRegion.phi1) + " " + this.df4.format(backrubbedRegion.psi1));
        }
        System.out.println("@balllist {backrub i+2} radius= 0.3 master= {backrub i+2}");
        for (n = 0; n < arrayList.size(); ++n) {
            backrubbedRegion = (BackrubbedRegion)arrayList.get(n);
            System.out.println("{i+3 " + backrubbedRegion.res3.getName().toLowerCase().trim() + backrubbedRegion.res3.getSequenceInteger() + " " + this.df.format(backrubbedRegion.theta) + "," + this.df.format(backrubbedRegion.pepRot1) + "," + this.df.format(backrubbedRegion.pepRot2) + " ep=" + this.df2.format(this.epsilon) + " (" + this.df.format(backrubbedRegion.phi3) + "," + this.df.format(backrubbedRegion.psi3) + ")}" + (backrubbedRegion.badTau || backrubbedRegion.ramaOut ? this.BAD_COLOR : this.GOOD_COLOR) + " " + this.df4.format(backrubbedRegion.phi3) + " " + this.df4.format(backrubbedRegion.psi3));
        }
    }

    void printStructs(ArrayList arrayList, Model model) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            BackrubbedRegion backrubbedRegion = (BackrubbedRegion)arrayList.get(i);
            if (this.pdbOut) {
                object = new PdbWriter(System.out);
                System.out.println("MODEL       " + (i + 1 < 10 ? " " : "") + (i + 1));
                ((PdbWriter)object).writeResidues(model.getResidues(), backrubbedRegion.state);
                continue;
            }
            object = backrubbedRegion.res1.getAtom(" CA ");
            Atom atom = backrubbedRegion.res1.getAtom(" C  ");
            Atom atom2 = backrubbedRegion.res1.getAtom(" O  ");
            Atom atom3 = backrubbedRegion.res2.getAtom(" N  ");
            Atom atom4 = backrubbedRegion.res2.getAtom(" CA ");
            Atom atom5 = backrubbedRegion.res2.getAtom(" C  ");
            Atom atom6 = backrubbedRegion.res2.getAtom(" O  ");
            Atom atom7 = backrubbedRegion.res3.getAtom(" N  ");
            Atom atom8 = backrubbedRegion.res3.getAtom(" CA ");
            try {
                AtomState atomState = backrubbedRegion.state.get((Atom)object);
                AtomState atomState2 = backrubbedRegion.state.get(atom);
                AtomState atomState3 = backrubbedRegion.state.get(atom2);
                AtomState atomState4 = backrubbedRegion.state.get(atom3);
                AtomState atomState5 = backrubbedRegion.state.get(atom4);
                AtomState atomState6 = backrubbedRegion.state.get(atom5);
                AtomState atomState7 = backrubbedRegion.state.get(atom6);
                AtomState atomState8 = backrubbedRegion.state.get(atom7);
                AtomState atomState9 = backrubbedRegion.state.get(atom8);
                System.out.println("@vectorlist {" + backrubbedRegion.toString() + " " + this.df.format(backrubbedRegion.theta) + "," + this.df.format(backrubbedRegion.pepRot1) + "," + this.df.format(backrubbedRegion.pepRot2) + "} width= 2 color= " + (backrubbedRegion.badTau || backrubbedRegion.ramaOut ? this.BAD_COLOR : this.GOOD_COLOR));
                this.printAtomCoords(atomState, backrubbedRegion.res1 + " 'CA'", true);
                this.printAtomCoords(atomState2, backrubbedRegion.res1 + " 'C'", false);
                this.printAtomCoords(atomState3, backrubbedRegion.res1 + " 'O'", false);
                this.printAtomCoords(atomState2, backrubbedRegion.res1 + " 'C'", true);
                this.printAtomCoords(atomState4, backrubbedRegion.res2 + " 'N'", false);
                this.printAtomCoords(atomState5, backrubbedRegion.res2 + " 'CA'", false);
                this.printAtomCoords(atomState6, backrubbedRegion.res2 + " 'C'", false);
                this.printAtomCoords(atomState7, backrubbedRegion.res2 + " 'O'", false);
                this.printAtomCoords(atomState6, backrubbedRegion.res2 + " 'C'", true);
                this.printAtomCoords(atomState8, backrubbedRegion.res3 + " 'N'", false);
                this.printAtomCoords(atomState9, backrubbedRegion.res3 + " 'CA'", false);
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Error printing structures for " + backrubbedRegion);
            }
        }
    }

    public void Main() {
        if (this.filename == null) {
            if (this.useIdealHelix) {
                if (this.verbose) {
                    System.err.println("Using ideal helix");
                }
            } else {
                System.err.println("Using ideal helix (no input file provided)");
                this.useIdealHelix = true;
            }
        }
        if (!(Double.isNaN(this.minEpsilon) || Double.isNaN(this.maxEpsilon) || Double.isNaN(this.phipsiRange))) {
            System.err.println("Can't use -epsilon=#,# AND -phipsirange=#, silly goose!");
            System.exit(0);
        }
        if (this.resnum == Integer.MAX_VALUE) {
            System.err.println("Need a residue number!  Use -res=i (for i to i+2 backrub)");
            System.exit(0);
        }
        if (this.phipsiRange > 15.0) {
            System.err.println("Init phi,psi range of " + this.df3.format(this.phipsiRange) + " too big!  Using 15");
            this.phipsiRange = 15.0;
        }
        if (this.phipsiRange > 0.0 && this.outputMode == this.STRUCTS && !this.pdbOut) {
            System.err.println("Warning: Exact kin coords w/ altered init phi/psi are not meaningful w.r.t. original coords!");
        }
        try {
            PdbReader pdbReader = new PdbReader();
            CoordinateFile coordinateFile = null;
            coordinateFile = this.filename != null ? pdbReader.read(new File(this.filename)) : pdbReader.read(this.getClass().getResourceAsStream("idealpolyala12-alpha.pdb"));
            Model model = coordinateFile.getFirstModel();
            this.processModel(model);
        }
        catch (IOException iOException) {
            System.err.println("Trouble parsing file!");
        }
    }

    public static void main(String[] stringArray) {
        BackrubPioneer backrubPioneer = new BackrubPioneer();
        try {
            backrubPioneer.parseArguments(stringArray);
            backrubPioneer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            backrubPioneer.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("BackrubPioneer.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'BackrubPioneer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.BackrubPioneer");
        System.err.println("Copyright (C) 2010 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public class BackrubbedRegion {
        protected Residue res1;
        protected Residue res2;
        protected Residue res3;
        protected ModelState state;
        protected double theta;
        protected double pepRot1;
        protected double pepRot2;
        protected double phi1;
        protected double psi1;
        protected double phi3;
        protected double psi3;
        protected boolean badTau;
        protected boolean ramaOut;

        public BackrubbedRegion(Residue[] residueArray, ModelState modelState, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
            this.res1 = residueArray[0];
            this.res2 = residueArray[1];
            this.res3 = residueArray[2];
            this.state = modelState;
            this.theta = dArray[0];
            this.pepRot1 = dArray[1];
            this.pepRot2 = dArray[2];
            this.phi1 = dArray2[0];
            this.psi1 = dArray2[1];
            this.phi3 = dArray2[2];
            this.psi3 = dArray2[3];
            this.badTau = bl;
            this.ramaOut = bl2;
        }

        public String toString() {
            return this.res1.getName().toLowerCase().trim() + this.res1.getSequenceInteger() + "-" + this.res3.getName().toLowerCase().trim() + this.res3.getSequenceInteger();
        }
    }
}

