/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.MutableTuple3;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class BackrubRama {
    PrintStream out = System.out;
    DecimalFormat df = new DecimalFormat("###.#");
    DecimalFormat df2 = new DecimalFormat("#");
    String filename = null;
    boolean verbose = false;
    boolean doStructKin = false;
    String group = null;
    int resnum = Integer.MAX_VALUE;
    double[] initPhiPsi = null;
    double[] finalPhiPsi = null;
    String alphaOrBeta = "alpha";
    double closeCutoff = Double.NaN;
    boolean noCloseCutoff = false;
    double maxTauDev = 5.5;
    double maxTheta13 = 15.0;
    double thetaSpacing = 1.0;
    double epsilon = 0.7;

    void doBackrubs(Model model) {
        if (!this.doStructKin && this.initPhiPsi != null) {
            this.out.println("@group {init phi,psi} dominant master= {all}");
            this.out.println("@balllist {init i-1 phi,psi} radius= 2.5 color= greentint master= {i-1}");
            this.out.println("{init i-1 phi,psi} " + this.df.format(this.initPhiPsi[0]) + " " + this.df.format(this.initPhiPsi[1]) + " 0");
            this.out.println("@balllist {init i+1 phi,psi} radius= 2.5 color= peachtint master= {i+1}");
            if (this.initPhiPsi.length == 4) {
                this.out.println("{init i+1 phi,psi} " + this.df.format(this.initPhiPsi[2]) + " " + this.df.format(this.initPhiPsi[3]) + " 0");
            } else if (this.initPhiPsi.length == 6) {
                this.out.println("{init i+1 phi,psi} " + this.df.format(this.initPhiPsi[4]) + " " + this.df.format(this.initPhiPsi[5]) + " 0");
            }
        }
        if (!this.doStructKin && this.finalPhiPsi != null) {
            this.out.println("@group {final phi,psi} dominant master= {all}");
            this.out.println("@balllist {final i-1 phi,psi} radius= 2.5 color= green master= {i-1}");
            this.out.println("{final i-1 phi,psi} " + this.df.format(this.finalPhiPsi[0]) + " " + this.df.format(this.finalPhiPsi[1]) + " 0");
            this.out.println("@balllist {final i+1 phi,psi} radius= 2.5 color= peach master= {i+1}");
            this.out.println("{final i+1 phi,psi} " + this.df.format(this.finalPhiPsi[2]) + " " + this.df.format(this.finalPhiPsi[3]) + " 0");
        }
        for (Residue residue : model.getResidues()) {
            double[] dArray;
            ModelState modelState;
            if (this.finalPhiPsi != null) {
                this.epsilon = 0.0;
            }
            if (residue.getSequenceInteger() != this.resnum) continue;
            if (this.finalPhiPsi != null) {
                this.epsilon = 0.0;
                while (this.epsilon <= 1.0) {
                    modelState = model.getState();
                    dArray = this.backrubSeries(model, modelState, residue);
                    if (!this.doStructKin && dArray != null) {
                        this.printStreaks(residue, dArray);
                    }
                    this.epsilon += 0.1;
                }
                continue;
            }
            modelState = model.getState();
            dArray = this.backrubSeries(model, modelState, residue);
            if (this.doStructKin || dArray == null) continue;
            this.printStreaks(residue, dArray);
        }
    }

    double[] backrubSeries(Model model, ModelState modelState, Residue residue) {
        Object object;
        if (this.doStructKin) {
            this.out.println("@group {e=" + this.df.format(this.epsilon) + " y13=[" + -1.0 * this.maxTheta13 + "," + this.maxTheta13 + "] " + residue + "} dominant animate master= {all}");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        try {
            object = residue.getPrev(model);
            Residue residue2 = residue.getNext(model);
            if (this.initPhiPsi != null) {
                modelState = this.setPhiPsi((Residue)object, model, modelState, "phi", this.initPhiPsi[0]);
                modelState = this.setPhiPsi((Residue)object, model, modelState, "psi", this.initPhiPsi[1]);
                if (this.initPhiPsi.length == 6) {
                    modelState = this.setPhiPsi(residue, model, modelState, "phi", this.initPhiPsi[2]);
                    modelState = this.setPhiPsi(residue, model, modelState, "psi", this.initPhiPsi[3]);
                    modelState = this.setPhiPsi(residue2, model, modelState, "phi", this.initPhiPsi[4]);
                    modelState = this.setPhiPsi(residue2, model, modelState, "psi", this.initPhiPsi[5]);
                } else if (this.initPhiPsi.length == 4) {
                    modelState = this.setPhiPsi(residue2, model, modelState, "phi", this.initPhiPsi[2]);
                    modelState = this.setPhiPsi(residue2, model, modelState, "psi", this.initPhiPsi[3]);
                }
            }
            Atom atom = ((Residue)object).getAtom(" CA ");
            Atom atom2 = residue2.getAtom(" CA ");
            AtomState atomState = modelState.get(atom);
            AtomState atomState2 = modelState.get(atom2);
            double d = Triple.angle(modelState.get(((Residue)object).getAtom(" N  ")), modelState.get(((Residue)object).getAtom(" CA ")), modelState.get(((Residue)object).getAtom(" C  ")));
            double d2 = Triple.angle(modelState.get(residue.getAtom(" N  ")), modelState.get(residue.getAtom(" CA ")), modelState.get(residue.getAtom(" C  ")));
            double d3 = Triple.angle(modelState.get(residue2.getAtom(" N  ")), modelState.get(residue2.getAtom(" CA ")), modelState.get(residue2.getAtom(" C  ")));
            for (double d4 = -1.0 * this.maxTheta13; d4 <= this.maxTheta13; d4 += this.thetaSpacing) {
                Object object2;
                double d5;
                double d6;
                double d7;
                if (this.verbose) {
                    System.err.println("Primary rot: " + this.df.format(d4));
                }
                Residue residue3 = ((Residue)object).getPrev(model);
                Residue residue4 = residue2.getNext(model);
                Triple triple = new Triple(modelState.get(residue3.getAtom(" C  ")));
                Triple triple2 = new Triple(modelState.get(((Residue)object).getAtom(" N  ")));
                Triple triple3 = new Triple(modelState.get(((Residue)object).getAtom(" CA ")));
                Triple triple4 = new Triple(modelState.get(((Residue)object).getAtom(" C  ")));
                Triple triple5 = new Triple(modelState.get(((Residue)object).getAtom(" O  ")));
                Triple triple6 = new Triple(modelState.get(residue.getAtom(" N  ")));
                Triple triple7 = new Triple(modelState.get(residue.getAtom(" CA ")));
                Triple triple8 = new Triple(modelState.get(residue.getAtom(" C  ")));
                Triple triple9 = new Triple(modelState.get(residue.getAtom(" O  ")));
                Triple triple10 = new Triple(modelState.get(residue2.getAtom(" N  ")));
                Triple triple11 = new Triple(modelState.get(residue2.getAtom(" CA ")));
                Triple triple12 = new Triple(modelState.get(residue2.getAtom(" C  ")));
                Triple triple13 = new Triple(modelState.get(residue4.getAtom(" N  ")));
                triple4 = this.rotate(atomState, atomState2, d4, triple4);
                triple5 = this.rotate(atomState, atomState2, d4, triple5);
                triple6 = this.rotate(atomState, atomState2, d4, triple6);
                triple7 = this.rotate(atomState, atomState2, d4, triple7);
                triple8 = this.rotate(atomState, atomState2, d4, triple8);
                triple9 = this.rotate(atomState, atomState2, d4, triple9);
                triple10 = this.rotate(atomState, atomState2, d4, triple10);
                AtomState atomState3 = modelState.get(((Residue)object).getAtom(" O  "));
                AtomState atomState4 = modelState.get(residue.getAtom(" O  "));
                double d8 = 0.0;
                double d9 = 0.0;
                if (this.epsilon != 0.0) {
                    d7 = Double.POSITIVE_INFINITY;
                    d6 = 0.0;
                    while (Math.abs(d6) <= Math.abs(d4)) {
                        d5 = d4 > 0.0 ? -1.0 * d6 : d6;
                        object2 = this.rotate(atomState, triple7, d5, new Triple(triple5));
                        if (Triple.distance((Tuple3)object2, atomState3) < d7) {
                            d7 = Triple.distance((Tuple3)object2, atomState3);
                            d8 = d5;
                        }
                        d6 += this.thetaSpacing;
                    }
                    d8 *= this.epsilon;
                    if (this.verbose) {
                        System.err.println("Secondary rot i-1: " + this.df.format(d8) + " (dist = " + d7 + ")");
                    }
                    triple4 = this.rotate(atomState, triple7, d8, triple4);
                    triple5 = this.rotate(atomState, triple7, d8, triple5);
                    triple6 = this.rotate(atomState, triple7, d8, triple6);
                    d7 = Double.POSITIVE_INFINITY;
                    d6 = 0.0;
                    while (Math.abs(d6) <= Math.abs(d4)) {
                        d5 = d4 > 0.0 ? -1.0 * d6 : d6;
                        object2 = this.rotate(triple7, atomState2, d5, new Triple(triple9));
                        if (Triple.distance((Tuple3)object2, atomState4) < d7) {
                            d7 = Triple.distance((Tuple3)object2, atomState4);
                            d9 = d5;
                        }
                        d6 += this.thetaSpacing;
                    }
                    d9 *= this.epsilon;
                    if (this.verbose) {
                        System.err.println("Secondary rot i+1: " + this.df.format(d9) + " (dist = " + d7 + ")");
                    }
                    triple8 = this.rotate(triple7, atomState2, d9, triple8);
                    triple9 = this.rotate(triple7, atomState2, d9, triple9);
                    triple10 = this.rotate(triple7, atomState2, d9, triple10);
                }
                d7 = Triple.angle(triple2, triple3, triple4);
                d6 = Triple.angle(triple6, triple7, triple8);
                d5 = Triple.angle(triple10, triple11, triple12);
                if (this.doStructKin) {
                    if (this.verbose) {
                        System.err.println("Testing tau for br(" + this.df.format(d4) + ", " + this.df.format(d8) + ", " + this.df.format(d9) + ") for '" + object + "' and '" + residue2 + "' ...");
                    }
                    if (!this.tauInRange(d7, d) || !this.tauInRange(d5, d3)) continue;
                    object2 = d4 > 0.0 ? "+" : "";
                    this.out.println("@vectorlist {" + residue + " br: " + (String)object2 + d4 + "," + d8 + "," + d9 + "} width= 2 color= peachtint");
                    this.printAtomCoords(triple2, object + "   ' N  '", true);
                    this.printAtomCoords(triple3, object + "   ' CA '", false);
                    this.printAtomCoords(triple4, object + "   ' C  '", false);
                    this.printAtomCoords(triple5, object + "   ' O  '", false);
                    this.printAtomCoords(triple4, object + "   ' C  '", true);
                    this.printAtomCoords(triple6, residue + "   ' N  '", false);
                    this.printAtomCoords(triple7, residue + "   ' CA '", false);
                    this.printAtomCoords(triple8, residue + "   ' C  '", false);
                    this.printAtomCoords(triple9, residue + "   ' O  '", false);
                    this.printAtomCoords(triple8, residue + "   ' C  '", true);
                    this.printAtomCoords(triple10, residue2 + "   ' N  '", false);
                    this.printAtomCoords(triple11, residue2 + "   ' CA '", false);
                    this.printAtomCoords(triple12, residue2 + "   ' C  '", false);
                    continue;
                }
                if (this.verbose) {
                    System.err.println("Testing tau for br(" + this.df.format(d4) + ", " + this.df.format(d8) + ", " + this.df.format(d9) + ") for '" + object + "' and '" + residue2 + "' ...");
                }
                if (!this.tauInRange(d7, d) || !this.tauInRange(d6, d2) || !this.tauInRange(d5, d3)) continue;
                double d10 = Triple.dihedral(triple, triple2, triple3, triple4);
                double d11 = Triple.dihedral(triple2, triple3, triple4, triple6);
                arrayList.add(d10);
                arrayList.add(d11);
                double d12 = Triple.dihedral(triple8, triple10, triple11, triple12);
                double d13 = Triple.dihedral(triple10, triple11, triple12, triple13);
                arrayList.add(d12);
                arrayList.add(d13);
                arrayList.add(d4);
                arrayList.add(d8);
                arrayList.add(d9);
            }
        }
        catch (AtomException atomException) {
            System.err.println("Trouble with backrub series for " + residue);
        }
        if (!this.doStructKin) {
            object = new double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                object[i] = (Double)arrayList.get(i);
            }
            if (this.finalPhiPsi == null || this.noCloseCutoff || this.closeEnoughToFinal((double[])object)) {
                return object;
            }
            return null;
        }
        return null;
    }

    void printStreaks(Residue residue, double[] dArray) {
        int n;
        int n2;
        int n3;
        double d;
        double d2;
        double d3;
        double d4;
        int n4;
        if (this.verbose) {
            System.err.println("phipsi.length = " + dArray.length);
        }
        this.out.println("@group {" + (this.group == null ? "e=" + this.df.format(this.epsilon) + " " + residue + " streaks" : this.group) + "} dominant animate master= {all}");
        this.out.println("@subgroup {" + residue + " i-1 streak} master= {i-1}");
        this.out.println("@balllist {" + residue + " i-1 streak} radius= 0.3");
        for (n4 = 0; n4 < dArray.length; n4 += 7) {
            d4 = dArray[n4];
            d3 = dArray[n4 + 1];
            d2 = dArray[n4 + 2];
            d = dArray[n4 + 3];
            n3 = (int)dArray[n4 + 4];
            n2 = (int)dArray[n4 + 5];
            n = (int)dArray[n4 + 6];
            this.out.print("{" + residue + "   i-1   phi,psi=(" + this.df.format(d4) + ", " + this.df.format(d3) + ", " + this.df.format(d2) + ", " + this.df.format(d) + ")   y13,y12,y23=(" + this.df2.format(n3) + " " + this.df2.format(n2) + " " + this.df2.format(n) + ")   e=" + this.df.format(this.epsilon) + "} ");
            this.out.println(this.df.format(d4) + " " + this.df.format(d3) + " 0.000");
        }
        this.out.println("@subgroup {" + residue + " i+1 streak} master= {i+1}");
        this.out.println("@balllist {" + residue + " i+1 streak} radius= 0.3");
        for (n4 = 0; n4 < dArray.length; n4 += 7) {
            d4 = dArray[n4];
            d3 = dArray[n4 + 1];
            d2 = dArray[n4 + 2];
            d = dArray[n4 + 3];
            n3 = (int)dArray[n4 + 4];
            n2 = (int)dArray[n4 + 5];
            n = (int)dArray[n4 + 6];
            this.out.print("{" + residue + "   i+1   phi,psi=(" + this.df.format(d4) + ", " + this.df.format(d3) + ", " + this.df.format(d2) + ", " + this.df.format(d) + ")   y13,y12,y23=(" + this.df2.format(n3) + " " + this.df2.format(n2) + " " + this.df2.format(n) + ")   e=" + this.df.format(this.epsilon) + "} ");
            this.out.println(this.df.format(d2) + " " + this.df.format(d) + " 0.000");
        }
    }

    Triple rotate(Triple triple, Triple triple2, double d, Triple triple3) {
        Triple triple4 = new Triple().likeVector(triple, triple2);
        Transform transform = new Transform();
        transform = transform.likeRotation(triple4, d);
        Triple triple5 = new Triple().likeVector(triple, triple3);
        transform.transform(triple5);
        Triple triple6 = new Triple().likeSum(triple, triple5);
        return triple6;
    }

    boolean tauInRange(double d, double d2) {
        if (d > 111.0 - this.maxTauDev && d < 111.0 + this.maxTauDev) {
            if (this.verbose) {
                System.err.println("   Tau (" + this.df.format(d) + ") in ideal range");
            }
            return true;
        }
        if (d > 111.0 + this.maxTauDev && d < d2) {
            if (this.verbose) {
                System.err.println("   Tau (" + this.df.format(d) + ") above ideal range" + " but < orig (" + this.df.format(d2) + ")");
            }
            return true;
        }
        if (d < 111.0 - this.maxTauDev && d > d2) {
            if (this.verbose) {
                System.err.println("   Tau (" + this.df.format(d) + ") below ideal range" + " but > orig (" + this.df.format(d2) + ")");
            }
            return true;
        }
        if (this.verbose) {
            System.err.println("   Tau (" + this.df.format(d) + ") unacceptable (orig: " + this.df.format(d2) + ")");
        }
        return false;
    }

    public boolean closeEnoughToFinal(double[] dArray) {
        if (this.finalPhiPsi == null) {
            return true;
        }
        double d = this.finalPhiPsi[0];
        double d2 = this.finalPhiPsi[1];
        double d3 = this.finalPhiPsi[2];
        double d4 = this.finalPhiPsi[3];
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < dArray.length; i += 7) {
            double d7 = dArray[i];
            double d8 = dArray[i + 1];
            double d9 = dArray[i + 2];
            double d10 = dArray[i + 3];
            double d11 = Math.sqrt(Math.pow(d7 - d, 2.0) + Math.pow(d8 - d2, 2.0));
            double d12 = Math.sqrt(Math.pow(d9 - d3, 2.0) + Math.pow(d10 - d4, 2.0));
            if (!(d11 < d5) || !(d12 < d6)) continue;
            d5 = d11;
            d6 = d12;
        }
        if (this.verbose) {
            System.err.println("prevClosest = " + d5);
        }
        if (this.verbose) {
            System.err.println("nextClosest = " + d6);
        }
        if (this.verbose) {
            if (d5 < this.closeCutoff && d6 < this.closeCutoff) {
                System.err.println("Close enough: " + d5 + " & " + d6);
            } else {
                System.err.println("*** Not close enough: " + d5 + " & " + d6);
            }
        }
        return d5 < this.closeCutoff && d6 < this.closeCutoff;
    }

    public ModelState setPhiPsi(Residue residue, Model model, ModelState modelState, String string, double d) throws AtomException {
        Object object;
        Object object22;
        Residue residue2 = residue.getPrev(model);
        Residue residue3 = residue.getNext(model);
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (Object object22 : model.getResidues()) {
            if (object22 == null) continue;
            object = ((Residue)object22).getAtoms().iterator();
            while (object.hasNext()) {
                arrayList.add((Atom)object.next());
            }
        }
        Object object3 = null;
        object22 = null;
        object = null;
        AtomState atomState = null;
        if (string.equals("phi")) {
            object3 = modelState.get(residue2.getAtom(" C  "));
            object22 = modelState.get(residue.getAtom(" N  "));
            object = modelState.get(residue.getAtom(" CA "));
            atomState = modelState.get(residue.getAtom(" C  "));
        } else if (string.equals("psi")) {
            object3 = modelState.get(residue.getAtom(" N  "));
            object22 = modelState.get(residue.getAtom(" CA "));
            object = modelState.get(residue.getAtom(" C  "));
            atomState = modelState.get(residue3.getAtom(" N  "));
        }
        double d2 = Triple.dihedral(object3, (Tuple3)object22, object, atomState);
        double d3 = d - d2;
        Transform transform = new Transform();
        transform.likeRotation((Tuple3)object22, (Tuple3)object, d3);
        ModelState modelState2 = new ModelState(modelState);
        int n = residue.getSequenceInteger();
        for (Atom atom : arrayList) {
            object3 = modelState.get(atom);
            object22 = (AtomState)((AtomState)object3).clone();
            int n2 = atom.getResidue().getSequenceInteger();
            String string2 = " H  , N  , CA , HA , C  , O  ";
            int n3 = string2.indexOf(atom.getName());
            if (!(n2 == n && string.equals("phi") && n3 >= 10 || n2 == n && string.equals("psi") && n3 >= 20) && n2 <= n) continue;
            if (this.verbose) {
                System.err.println("Rotating " + atom + " for " + string + " on " + residue);
            }
            transform.transform((MutableTuple3)object22);
            modelState2.add((AtomState)object22);
        }
        return modelState2;
    }

    void printAtomCoords(Triple triple, String string, boolean bl) {
        this.out.print("{" + string + "}");
        if (bl) {
            this.out.print("P ");
        } else {
            this.out.print("  ");
        }
        this.out.println(this.df.format(triple.getX()) + "," + this.df.format(triple.getY()) + "," + this.df.format(triple.getZ()));
    }

    double calcCounterRot(Triple triple, Triple triple2, Triple triple3, Triple triple4, double d) {
        Triple triple5 = new Triple().likeVector(triple, triple2);
        Triple triple6 = new Triple().likeVector(triple, triple4);
        double d2 = triple6.mag() * Math.cos(triple5.angle(triple6));
        if (d2 < 0.0) {
            d2 *= -1.0;
        }
        Triple triple7 = triple5.unit().mult(d2);
        Triple triple8 = new Triple(triple).add(triple7);
        Triple triple9 = new Triple(triple);
        triple = new Triple().likeVector(triple8, triple);
        triple2 = new Triple().likeVector(triple8, triple2);
        triple3 = new Triple().likeVector(triple8, triple3);
        triple4 = new Triple().likeVector(triple8, triple4);
        triple8 = new Triple().likeVector(triple8, triple8);
        Triple triple10 = triple2.unit();
        double d3 = triple3.mag() * Math.cos(triple10.angle(triple3));
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        System.err.println("scalarProjOntoNormal = " + d3);
        triple10.mult(d3);
        Triple triple11 = new Triple(triple3).sub(triple10);
        this.printAtomCoords(new Triple().likeSum(triple9, triple11), "origOproj", false);
        double d4 = -1.0 * this.epsilon * Triple.angle(triple4, triple8, triple11);
        System.err.println("angle b4 mod = " + d4);
        if (Math.abs(d4) > Math.abs(d)) {
            double d5 = d4 * d > 0.0 ? 1.0 : -1.0;
            d4 = d5 * d;
        }
        return d4;
    }

    public void Main() {
        if (this.filename == null && this.finalPhiPsi == null) {
            System.err.println("Need a filename or -to=#,#,#,#!");
            System.exit(0);
        }
        if (this.filename == null && this.finalPhiPsi != null) {
            this.resnum = 3;
        }
        if (this.resnum == Integer.MAX_VALUE) {
            System.err.println("Need a residue number! (use -res=#)");
            System.exit(0);
        }
        if (this.finalPhiPsi != null && Double.isNaN(this.closeCutoff) && !this.noCloseCutoff) {
            this.closeCutoff = 30.0;
            System.err.println("No -close=# cutoff for approaching target was provided => using " + this.df2.format(this.closeCutoff) + " degrees");
        }
        try {
            Object object;
            PdbReader pdbReader = new PdbReader();
            CoordinateFile coordinateFile = null;
            if (this.filename != null) {
                object = new File(this.filename);
                coordinateFile = pdbReader.read((File)object);
            } else if (this.alphaOrBeta.equals("alpha")) {
                coordinateFile = pdbReader.read(this.getClass().getResourceAsStream("idealpolyala12-alpha.pdb"));
            } else if (this.alphaOrBeta.equals("beta")) {
                coordinateFile = pdbReader.read(this.getClass().getResourceAsStream("idealpolyala12-beta.pdb"));
            }
            object = coordinateFile.getModels().iterator();
            object.hasNext();
            Model model = (Model)object.next();
            this.doBackrubs(model);
        }
        catch (IOException iOException) {
            System.err.println("Trouble parsing file!");
        }
    }

    public static void main(String[] stringArray) {
        BackrubRama backrubRama = new BackrubRama();
        try {
            backrubRama.parseArguments(stringArray);
            backrubRama.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            backrubRama.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("BackrubRama.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'BackrubRama.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.BackrubRama");
        System.err.println("Copyright (C) 2008 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename != null) {
            throw new IllegalArgumentException("Only need 1 file!");
        }
        this.filename = string;
    }

    void interpretFlag(String string, String string2) {
        block45: {
            if (string.equals("-help") || string.equals("-h")) {
                this.showHelp(true);
                System.exit(0);
            } else if (string.equals("-verbose") || string.equals("-v")) {
                this.verbose = true;
            } else if (string.equals("-structurekin") || string.equals("-struct")) {
                this.doStructKin = true;
            } else if (string.equals("-res")) {
                try {
                    this.resnum = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as an integer for resnum!");
                }
            } else if (string.equals("-theta13") || string.equals("-theta")) {
                try {
                    this.maxTheta13 = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as a double for theta13!");
                }
            } else if (string.equals("-epsilon") || string.equals("-e")) {
                try {
                    this.epsilon = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as a double for epsilon!");
                }
            } else if (string.equals("-maxtaudev")) {
                try {
                    this.maxTauDev = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as a double for maxTauDev!");
                }
            } else if (string.equals("-from")) {
                try {
                    String[] stringArray = Strings.explode(string2, ',', false, true);
                    if (stringArray.length == 4 || stringArray.length == 6) {
                        this.initPhiPsi = new double[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.initPhiPsi[i] = Double.parseDouble(stringArray[i]);
                        }
                        break block45;
                    }
                    System.err.println("-from=#,#,#,# should have exactly 4 (phi/psi i-1,i+1) or 6 (phi/psi i-1,i,i+1) values");
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as doubles for initPhiPsi!");
                }
            } else if (string.equals("-to")) {
                try {
                    String[] stringArray = Strings.explode(string2, ',', false, true);
                    if (stringArray.length == 4) {
                        this.finalPhiPsi = new double[4];
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.finalPhiPsi[i] = Double.parseDouble(stringArray[i]);
                        }
                        break block45;
                    }
                    System.err.println("-to=#,#,#,# should have exactly 4 values (phi/psi i-1,i+1)");
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as doubles for finalPhiPsi!");
                }
            } else if (string.equals("-alpha")) {
                this.alphaOrBeta = "alpha";
            } else if (string.equals("-beta")) {
                this.alphaOrBeta = "beta";
            } else if (string.equals("-close")) {
                try {
                    this.closeCutoff = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as a double for closeCutoff!");
                }
            } else if (string.equals("-noclose")) {
                this.noCloseCutoff = true;
            } else if (!string.equals("-dummy_option")) {
                throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
            }
        }
    }
}

