/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Peptide;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class BetaArom {
    public String modelName;
    public Model model;
    public Residue aromRes;
    public Residue oppRes;
    boolean parallel;
    public double chi1;
    public double chi2;
    public double aromMaxB;
    public double oppMaxB;
    public int aromNumBetaResN;
    public int aromNumBetaResC;
    public int oppNumBetaResN;
    public int oppNumBetaResC;
    public boolean aromEdge;
    public boolean oppEdge;
    public double cacaDist;
    public double cbcacaAngle;
    public double nwardTwist;
    public double cwardTwist;
    public double nwardCrossTwist;
    public double cwardCrossTwist;
    public double fray;
    public double tilt;
    public double aromCaAngle;
    public double oppCaAngle;
    public double aromPrevPhi;
    public double aromPrevPsi;
    public double aromPhi;
    public double aromPsi;
    public double aromNextPhi;
    public double aromNextPsi;
    public double aromPrevTau;
    public double aromTau;
    public double aromNextTau;
    public double cgcbcaAngle;

    public BetaArom(Residue residue, Residue residue2, boolean bl, Collection collection, Model model, String string) {
        this.modelName = string;
        this.model = model;
        this.aromRes = residue;
        this.oppRes = residue2;
        this.parallel = bl;
        this.aromMaxB = this.maxB(residue, model);
        this.oppMaxB = this.maxB(residue2, model);
        this.aromNumBetaResN = this.numNward(residue, model, collection);
        this.aromNumBetaResC = this.numCward(residue, model, collection);
        this.oppNumBetaResN = this.numNward(residue2, model, collection);
        this.oppNumBetaResC = this.numCward(residue2, model, collection);
        this.aromEdge = this.isEdgeStrand(residue, collection);
        this.oppEdge = this.isEdgeStrand(residue2, collection);
    }

    double maxB(Residue residue, Model model) {
        double d = Double.NEGATIVE_INFINITY;
        ModelState modelState = model.getState();
        Iterator iterator = residue.getAtoms().iterator();
        while (iterator.hasNext()) {
            try {
                Atom atom = (Atom)iterator.next();
                AtomState atomState = modelState.get(atom);
                double d2 = atomState.getTempFactor();
                if (!(d2 > d)) continue;
                d = d2;
            }
            catch (AtomException atomException) {
                System.err.println("Error getting max B-factor for " + residue);
            }
        }
        return d;
    }

    int numNward(Residue residue, Model model, Collection collection) {
        int n = 0;
        boolean bl = false;
        Residue residue2 = residue;
        while (!bl) {
            if (residue2.getPrev(model) != null) {
                if (!this.isBeta(residue2 = residue2.getPrev(model), model, collection)) {
                    bl = true;
                    continue;
                }
                ++n;
                continue;
            }
            bl = true;
        }
        return n;
    }

    int numCward(Residue residue, Model model, Collection collection) {
        int n = 0;
        boolean bl = false;
        Residue residue2 = residue;
        while (!bl) {
            if (residue2.getNext(model) != null) {
                if (!this.isBeta(residue2 = residue2.getNext(model), model, collection)) {
                    bl = true;
                    continue;
                }
                ++n;
                continue;
            }
            bl = true;
        }
        return n;
    }

    boolean isBeta(Residue residue, Model model, Collection collection) {
        Peptide peptide = null;
        Peptide peptide2 = null;
        for (Peptide peptide3 : collection) {
            if (residue.equals(peptide3.nRes)) {
                peptide = peptide3;
            }
            if (!residue.equals(peptide3.cRes)) continue;
            peptide2 = peptide3;
        }
        if (peptide == null || peptide2 == null) {
            return false;
        }
        return peptide.isBeta && peptide2.isBeta;
    }

    boolean isEdgeStrand(Residue residue, Collection collection) {
        Peptide peptide = null;
        Peptide peptide2 = null;
        for (Peptide peptide3 : collection) {
            if (residue.equals(peptide3.nRes)) {
                peptide = peptide3;
            }
            if (!residue.equals(peptide3.cRes)) continue;
            peptide2 = peptide3;
        }
        return peptide.hbondO == null && peptide2.hbondN == null;
    }

    public void calcGeometry() throws AtomException, NullPointerException {
        ModelState modelState = this.model.getState();
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        arrayList.add(modelState.get(this.aromRes.getPrev(this.model).getAtom(" CA ")));
        arrayList.add(modelState.get(this.aromRes.getAtom(" CA ")));
        arrayList.add(modelState.get(this.aromRes.getNext(this.model).getAtom(" CA ")));
        arrayList.add(modelState.get(this.aromRes.getAtom(" CB ")));
        ArrayList<AtomState> arrayList2 = new ArrayList<AtomState>();
        arrayList2.add(modelState.get(this.oppRes.getPrev(this.model).getAtom(" CA ")));
        arrayList2.add(modelState.get(this.oppRes.getAtom(" CA ")));
        arrayList2.add(modelState.get(this.oppRes.getNext(this.model).getAtom(" CA ")));
        if (this.oppRes.getName().equals("GLY")) {
            arrayList2.add(null);
        } else {
            arrayList2.add(modelState.get(this.oppRes.getAtom(" CB ")));
        }
        AtomState atomState = modelState.get(this.aromRes.getAtom(" CA "));
        AtomState atomState2 = modelState.get(this.oppRes.getAtom(" CA "));
        this.cacaDist = Triple.distance(atomState, atomState2);
        AtomState atomState3 = modelState.get(this.aromRes.getAtom(" CB "));
        this.cbcacaAngle = Triple.angle(atomState3, atomState, atomState2);
        AtomState atomState4 = modelState.get(this.aromRes.getNext(this.model).getAtom(" CA "));
        AtomState atomState5 = modelState.get(this.aromRes.getPrev(this.model).getAtom(" CA "));
        this.aromCaAngle = Triple.angle(atomState4, atomState, atomState5);
        AtomState atomState6 = modelState.get(this.oppRes.getNext(this.model).getAtom(" CA "));
        AtomState atomState7 = modelState.get(this.oppRes.getPrev(this.model).getAtom(" CA "));
        this.oppCaAngle = Triple.angle(atomState6, atomState2, atomState7);
        this.nwardTwist = Triple.dihedral(atomState5, atomState, atomState2, atomState6);
        this.cwardTwist = Triple.dihedral(atomState4, atomState, atomState2, atomState7);
        this.nwardCrossTwist = Triple.dihedral(atomState5, atomState, atomState2, atomState7);
        this.cwardCrossTwist = Triple.dihedral(atomState4, atomState, atomState2, atomState6);
        if (this.parallel) {
            double d = this.nwardTwist;
            this.nwardTwist = this.nwardCrossTwist;
            this.nwardCrossTwist = d;
            d = this.cwardTwist;
            this.cwardTwist = this.cwardCrossTwist;
            this.cwardCrossTwist = d;
        }
        this.fray = Math.abs(this.cwardTwist - this.nwardTwist) - Math.abs(this.aromCaAngle - this.oppCaAngle);
        Triple triple = new Triple().likeNormal(atomState5, atomState, atomState4);
        Triple triple2 = new Triple().likeNormal(atomState7, atomState2, atomState6);
        this.tilt = triple.angle(triple2);
        AtomState atomState8 = modelState.get(this.aromRes.getPrev(this.model).getPrev(this.model).getAtom(" C  "));
        AtomState atomState9 = modelState.get(this.aromRes.getPrev(this.model).getAtom(" N  "));
        AtomState atomState10 = modelState.get(this.aromRes.getPrev(this.model).getAtom(" CA "));
        AtomState atomState11 = modelState.get(this.aromRes.getPrev(this.model).getAtom(" C  "));
        AtomState atomState12 = modelState.get(this.aromRes.getAtom(" N  "));
        AtomState atomState13 = modelState.get(this.aromRes.getAtom(" C  "));
        AtomState atomState14 = modelState.get(this.aromRes.getNext(this.model).getAtom(" N  "));
        AtomState atomState15 = modelState.get(this.aromRes.getNext(this.model).getAtom(" CA "));
        AtomState atomState16 = modelState.get(this.aromRes.getNext(this.model).getAtom(" C  "));
        AtomState atomState17 = modelState.get(this.aromRes.getNext(this.model).getNext(this.model).getAtom(" N  "));
        this.aromPrevPhi = Triple.dihedral(atomState8, atomState9, atomState10, atomState11);
        this.aromPrevPsi = Triple.dihedral(atomState9, atomState10, atomState11, atomState12);
        this.aromPhi = Triple.dihedral(atomState11, atomState12, atomState, atomState13);
        this.aromPsi = Triple.dihedral(atomState12, atomState, atomState13, atomState14);
        this.aromNextPhi = Triple.dihedral(atomState13, atomState14, atomState15, atomState16);
        this.aromNextPsi = Triple.dihedral(atomState14, atomState15, atomState16, atomState17);
        AtomState atomState18 = modelState.get(this.aromRes.getAtom(" CD1"));
        AtomState atomState19 = modelState.get(this.aromRes.getAtom(" CG "));
        this.chi1 = Triple.dihedral(atomState12, atomState, atomState3, atomState19);
        this.chi2 = Triple.dihedral(atomState, atomState3, atomState19, atomState18);
        this.aromPrevTau = Triple.angle(atomState9, atomState10, atomState11);
        this.aromTau = Triple.angle(atomState12, atomState, atomState13);
        this.aromNextTau = Triple.angle(atomState14, atomState15, atomState16);
        this.cgcbcaAngle = Triple.angle(atomState19, atomState3, atomState);
    }

    public String toString() {
        return "aromatic " + this.aromRes + " across from " + this.oppRes + " from " + this.modelName;
    }
}

