/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.CaRotation;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CaShear
extends CaRotation {
    public static ModelState makeConformation(Collection collection, ModelState modelState, double d, boolean bl) throws AtomException {
        ModelState modelState2;
        Tuple3[] tuple3Array;
        Tuple3[] tuple3Array2;
        Atom[] atomArray;
        Atom[] atomArray2;
        Object object3;
        if (collection.size() != 4) {
            throw new AtomException("Need 4 residues for makeConformation(..)!");
        }
        Residue residue = null;
        Residue residue2 = null;
        Residue residue3 = null;
        Object object2 = null;
        for (Object object3 : collection) {
            if (residue == null) {
                residue = object3;
                continue;
            }
            if (residue2 == null) {
                residue2 = object3;
                continue;
            }
            if (residue3 == null) {
                residue3 = object3;
                continue;
            }
            if (object2 != null) continue;
            object2 = object3;
        }
        if (residue == null || residue2 == null || residue3 == null || object2 == null) {
            throw new AtomException("First, second, third, or fourth residue is missing!");
        }
        object3 = residue.getAtom(" CA ");
        Atom atom = residue2.getAtom(" CA ");
        Atom atom2 = residue3.getAtom(" CA ");
        Atom atom3 = ((Residue)object2).getAtom(" CA ");
        if (object3 == null || atom == null || atom2 == null || atom3 == null) {
            throw new AtomException("C-alpha is missing from " + residue + ", " + residue2 + ", " + residue3 + ", or " + object2);
        }
        Atom atom4 = residue2.getAtom(" C  ");
        Atom atom5 = residue2.getAtom(" O  ");
        if (atom4 == null || atom5 == null) {
            throw new AtomException("Carbonyl is missing from " + residue2);
        }
        Atom[] atomArray3 = CaShear.getMobileAtoms(collection);
        ArrayList<Atom[]> arrayList = new ArrayList<Atom[]>();
        ArrayList<Atom[]> arrayList2 = new ArrayList<Atom[]>();
        ArrayList<Atom[]> arrayList3 = new ArrayList<Atom[]>();
        for (int i = 0; i < atomArray3.length; ++i) {
            atomArray2 = atomArray3[i];
            atomArray = atomArray2.getResidue();
            if (atomArray.equals(residue)) {
                arrayList.add(atomArray2);
                continue;
            }
            if (atomArray.equals(residue2)) {
                if (atomArray2.getName().equals(" C  ") || atomArray2.getName().equals(" O  ")) {
                    arrayList2.add(atomArray2);
                    continue;
                }
                arrayList.add(atomArray2);
                continue;
            }
            if (atomArray.equals(residue3)) {
                if (atomArray2.getName().equals(" N  ") || atomArray2.getName().equals(" H  ")) {
                    arrayList2.add(atomArray2);
                    continue;
                }
                arrayList3.add(atomArray2);
                continue;
            }
            arrayList3.add(atomArray2);
        }
        Atom[] atomArray4 = arrayList.toArray(new Atom[arrayList.size()]);
        atomArray2 = arrayList2.toArray(new Atom[arrayList2.size()]);
        atomArray = arrayList3.toArray(new Atom[arrayList3.size()]);
        Triple triple = new Triple().likeNormal(modelState.get((Atom)object3), modelState.get(atom), modelState.get(atom2));
        triple.add(modelState.get((Atom)object3));
        Transform transform = new Transform().likeRotation(modelState.get((Atom)object3), triple, d);
        ModelState modelState3 = CaShear.transformAtoms(transform, atomArray4, modelState);
        Triple triple2 = new Triple().likeNormal(modelState3.get(atom), modelState3.get(atom2), modelState3.get(atom3));
        triple2.add(modelState3.get(atom3));
        double d2 = Triple.distance(modelState.get(atom), modelState.get(atom2));
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = 0.0;
        double d6 = Math.min(Math.abs(d), Math.abs(Math.abs(d) - 360.0));
        for (double d7 = -1.5 * d6; d7 < 1.5 * d6; d7 += 0.1) {
            tuple3Array2 = new Transform().likeRotation(modelState3.get(atom3), triple2, d7);
            tuple3Array = CaShear.transformAtoms((Transform)tuple3Array2, atomArray, modelState3);
            double d8 = Triple.distance(tuple3Array.get(atom), tuple3Array.get(atom2));
            double d9 = Math.abs(d8 - d2);
            if (!(d9 < d4)) continue;
            d3 = d8;
            d4 = d9;
            d5 = d7;
        }
        Transform transform2 = new Transform().likeRotation(modelState3.get(atom3), triple2, d5);
        ModelState modelState4 = CaShear.transformAtoms(transform2, atomArray, modelState3);
        tuple3Array2 = new AtomState[]{modelState.get(atom), modelState.get(atom2)};
        tuple3Array = new AtomState[]{modelState4.get(atom), modelState4.get(atom2)};
        SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
        Transform transform3 = superPoser.superpos();
        ModelState modelState5 = modelState2 = CaShear.transformAtoms(transform3, atomArray2, modelState4);
        if (bl && sidechainIdealizer != null) {
            modelState5 = sidechainIdealizer.idealizeSidechain(residue, modelState5);
            modelState5 = sidechainIdealizer.idealizeSidechain(residue2, modelState5);
            modelState5 = sidechainIdealizer.idealizeSidechain(residue3, modelState5);
            modelState5 = sidechainIdealizer.idealizeSidechain((Residue)object2, modelState5);
        }
        return modelState5.createCollapsed(modelState);
    }

    static Atom[] getMobileAtoms(Collection collection) {
        String string;
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Iterator iterator = collection.iterator();
        Residue residue = (Residue)iterator.next();
        for (Atom atom : residue.getAtoms()) {
            string = atom.getName();
            if (!string.equals(" C  ") && !string.equals(" O  ")) continue;
            arrayList.add(atom);
        }
        residue = (Residue)iterator.next();
        while (iterator.hasNext()) {
            for (Atom atom : residue.getAtoms()) {
                arrayList.add(atom);
            }
            residue = (Residue)iterator.next();
        }
        for (Atom atom : residue.getAtoms()) {
            string = atom.getName();
            if (!string.equals(" N  ") && !string.equals(" H  ")) continue;
            arrayList.add(atom);
        }
        return arrayList.toArray(new Atom[arrayList.size()]);
    }
}

