/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Helix;
import chiropraxis.mc.Ncap;
import chiropraxis.mc.Peptide;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class DsspHelixBuilder {
    DecimalFormat df = new DecimalFormat("###.###");
    String filename = null;
    ArrayList<NTurn> nTurns = null;
    ArrayList<MinHelix> minHelices = null;
    ArrayList<NTurn[]> stretches = null;
    ArrayList<Helix> helices = null;
    boolean doNcaps = true;
    boolean onlyHbNcaps = false;
    boolean doKin = false;
    boolean doPrint = true;
    boolean smoothAxes = false;
    int smoothAxesTimes = 0;
    boolean vectorSumAxis = false;
    boolean verbose = false;
    boolean append = false;

    void processModel(String string, Model model, ModelState modelState) {
        Collection collection = this.createPeptides(model, modelState);
        this.connectPeptides(collection);
        if (this.verbose) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                System.err.println((Peptide)iterator.next());
            }
        }
        this.findHBonds(collection, modelState);
        this.getPsiPhis(collection, modelState);
        this.buildMinHelices(collection, model);
        this.buildHelices(model, modelState);
        this.findAxes(model, modelState);
        if (this.smoothAxes) {
            for (int i = 0; i < this.smoothAxesTimes; ++i) {
                this.smoothAxes();
            }
        }
        if (this.doNcaps) {
            this.findNcaps(model, modelState);
        }
        if (this.doKin) {
            if (!this.append) {
                System.out.println("@kinemage {" + this.filename + " helices}");
            }
            this.sketchHbonds(System.out, collection, modelState);
            this.sketchNcaps(System.out, modelState);
            this.sketchAxes(System.out);
        }
    }

    Collection createPeptides(Model model, ModelState modelState) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (!AminoAcid.isAminoAcid(residue2)) continue;
            try {
                Peptide peptide = new Peptide(residue, residue2, modelState);
                if (residue == null) {
                    arrayList.add(peptide);
                } else {
                    AtomState atomState;
                    AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                    if (atomState2.sqDistance(atomState = modelState.get(residue2.getAtom(" N  "))) < 4.0) {
                        arrayList.add(peptide);
                    } else {
                        arrayList.add(new Peptide(residue, null, modelState));
                        arrayList.add(new Peptide(null, residue2, modelState));
                    }
                }
            }
            catch (AtomException atomException) {
                try {
                    arrayList.add(new Peptide(residue, null, modelState));
                }
                catch (AtomException atomException2) {
                    // empty catch block
                }
                try {
                    arrayList.add(new Peptide(null, residue2, modelState));
                }
                catch (AtomException atomException3) {
                    // empty catch block
                }
            }
            residue = residue2;
        }
        try {
            arrayList.add(new Peptide(residue, null, modelState));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return arrayList;
    }

    void connectPeptides(Collection collection) {
        Peptide peptide = null;
        int n = 0;
        for (Peptide peptide2 : collection) {
            if (peptide != null && peptide.nRes != null && peptide2.cRes != null && peptide.nRes == peptide2.cRes) {
                peptide.next = peptide2;
                peptide2.prev = peptide;
                peptide2.chain = peptide.chain;
                peptide2.index = peptide.index + 1;
            } else {
                peptide2.chain = ++n;
                peptide2.index = 1;
            }
            peptide = peptide2;
        }
    }

    void findHBonds(Collection collection, ModelState modelState) {
        Peptide[] peptideArray = collection.toArray(new Peptide[collection.size()]);
        AtomState[] atomStateArray = new AtomState[peptideArray.length];
        AtomState[] atomStateArray2 = new AtomState[peptideArray.length];
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].cRes == null) continue;
            try {
                atomStateArray[i] = modelState.get(peptideArray[i].cRes.getAtom(" C  "));
                atomStateArray2[i] = modelState.get(peptideArray[i].cRes.getAtom(" O  "));
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].nRes == null) continue;
            try {
                AtomState atomState = modelState.get(peptideArray[i].nRes.getAtom(" N  "));
                AtomState atomState2 = modelState.get(peptideArray[i].nRes.getAtom(" H  "));
                Peptide peptide = null;
                double d = -0.5;
                for (int j = 0; j < peptideArray.length; ++j) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if (i == j || peptideArray[i].chain == peptideArray[j].chain && Math.abs(peptideArray[i].index - peptideArray[j].index) <= 2 || atomStateArray[j] == null || atomStateArray2[j] == null || atomState.sqDistance(atomStateArray2[j]) > 27.040000000000003 || !((d6 = 27.9 * (1.0 / (d5 = atomStateArray2[j].distance(atomState)) + 1.0 / (d4 = atomStateArray[j].distance(atomState2)) - 1.0 / (d3 = atomStateArray2[j].distance(atomState2)) - 1.0 / (d2 = atomStateArray[j].distance(atomState)))) < d) || peptideArray[j].hbondO != null) continue;
                    peptide = peptideArray[j];
                    d = d6;
                }
                if (peptide == null) continue;
                peptideArray[i].hbondN = peptide;
                peptide.hbondO = peptideArray[i];
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    void getPsiPhis(Collection collection, ModelState modelState) {
        Peptide[] peptideArray = collection.toArray(new Peptide[collection.size()]);
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].nRes == null || peptideArray[i].cRes == null) continue;
            try {
                AtomState atomState = modelState.get(peptideArray[i].nRes.getAtom(" N  "));
                AtomState atomState2 = modelState.get(peptideArray[i].nRes.getAtom(" CA "));
                AtomState atomState3 = modelState.get(peptideArray[i].nRes.getAtom(" C  "));
                AtomState atomState4 = modelState.get(peptideArray[i].cRes.getAtom(" N  "));
                new Triple();
                peptideArray[i].psiN = Triple.dihedral(atomState, atomState2, atomState3, atomState4);
                AtomState atomState5 = modelState.get(peptideArray[i].cRes.getAtom(" CA "));
                AtomState atomState6 = modelState.get(peptideArray[i].cRes.getAtom(" C  "));
                new Triple();
                peptideArray[i].phiC = Triple.dihedral(atomState3, atomState4, atomState5, atomState6);
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    void buildMinHelices(Collection collection, Model model) {
        Residue residue;
        Object object;
        if (this.verbose) {
            System.err.println("Starting buildMinHelices...");
        }
        this.nTurns = new ArrayList();
        for (Peptide peptide : collection) {
            if (peptide == null) continue;
            if (this.verbose) {
                System.err.println("Making n-turn(s) with '" + peptide + "'...");
            }
            if (peptide.hbondO != null) {
                Peptide object22 = peptide.hbondO;
                object = peptide.cRes;
                residue = object22.nRes;
                if (object == null || residue == null) continue;
                int n = residue.getSequenceInteger() - ((Residue)object).getSequenceInteger();
                if (n == 3 || n == 4) {
                    NTurn nTurn = new NTurn((Residue)object, residue, n);
                    if (this.verbose) {
                        System.err.println(".. made & added '" + nTurn + "' !");
                    }
                    this.nTurns.add(nTurn);
                    continue;
                }
                if (!this.verbose) continue;
                System.err.println(".. '" + peptide.cRes + "' HB's through " + "its CO to a residue " + n + " away => not making an NTurn!");
                continue;
            }
            if (!this.verbose) continue;
            System.err.println(".. no HB partner for '" + peptide.cRes + "'" + " through its CO => not making an NTurn!");
        }
        this.minHelices = new ArrayList();
        ArrayList<NTurn> arrayList = new ArrayList();
        for (int i = 0; i < this.nTurns.size(); ++i) {
            NTurn nTurn = this.nTurns.get(i);
            if (arrayList.size() == 0) {
                arrayList.add(nTurn);
                continue;
            }
            object = (NTurn)arrayList.get(0);
            if (((NTurn)object).firstRes.getNext(model).equals(nTurn.firstRes)) {
                residue = ((NTurn)object).firstRes;
                Residue residue2 = nTurn.lastRes;
                int n = residue2.getSequenceInteger() - residue.getSequenceInteger();
                MinHelix minHelix = new MinHelix(residue, residue2, n);
                this.minHelices.add(minHelix);
            }
            arrayList = new ArrayList<NTurn>();
            arrayList.add(nTurn);
        }
        if (this.verbose) {
            System.err.println("Minimal helices: ");
            for (MinHelix minHelix : this.minHelices) {
                System.err.println("   " + minHelix);
            }
            System.err.println();
        }
    }

    void buildHelices(Model model, ModelState modelState) {
        Iterator<Residue> iterator;
        Object object;
        Object object2;
        if (this.verbose) {
            System.err.println("Staring buildHelices...");
        }
        this.helices = new ArrayList();
        ArrayList<MinHelix> arrayList = new ArrayList<MinHelix>();
        boolean bl = false;
        for (int i = 0; i < this.minHelices.size(); ++i) {
            MinHelix object3 = this.minHelices.get(i);
            if (arrayList.size() == 0) {
                if (this.verbose) {
                    System.err.println("Starting new consecMinHelices with '" + object3 + "'");
                }
                arrayList.add(object3);
            } else {
                object2 = (MinHelix)arrayList.get(arrayList.size() - 1);
                if (object3.overlap((MinHelix)object2) >= 1) {
                    if (this.verbose) {
                        System.err.println("Adding '" + object3 + "' to consecMinHelices");
                    }
                    arrayList.add(object3);
                } else {
                    bl = true;
                }
            }
            if (i == this.minHelices.size() - 1) {
                bl = true;
            }
            if (!bl) continue;
            if (this.verbose) {
                System.err.println("Completed AL consecMinHelices; size = " + arrayList.size());
            }
            object2 = new TreeSet<Residue>();
            for (Object object4 : arrayList) {
                ((TreeSet)object2).add((Residue)((MinHelix)object4).firstRes);
                object = ((MinHelix)object4).firstRes;
                for (int atomState = 0; atomState < ((MinHelix)object4).n; ++atomState) {
                    object = ((Residue)object).getNext(model);
                    ((TreeSet)object2).add((Residue)object);
                }
                ((TreeSet)object2).add((Residue)((MinHelix)object4).lastRes);
            }
            if (this.verbose) {
                System.err.println("About to make new Helix from resSet:");
                iterator = ((TreeSet)object2).iterator();
                while (iterator.hasNext()) {
                    System.err.println("   " + iterator.next());
                }
            }
            iterator = new Helix((TreeSet<Residue>)object2);
            this.helices.add((Helix)((Object)iterator));
            if (this.verbose) {
                System.err.println("Added '" + iterator + "' made from MinHelix set:" + "\n   (" + arrayList.get(0) + ") to " + "(" + arrayList.get(arrayList.size() - 1) + ")");
            }
            arrayList = new ArrayList();
            arrayList.add(object3);
            bl = false;
        }
        if (this.verbose) {
            System.err.println("After connecting MinHelices but before adding putative N-cap residue, # helices = " + this.helices.size());
        }
        for (Helix helix : this.helices) {
            try {
                Object object4;
                object2 = helix.getRes("first");
                iterator = ((Residue)object2).getPrev(model);
                object4 = ((Residue)object2).getNext(model).getNext(model);
                if (iterator == null || object4 == null) continue;
                object = modelState.get(((Residue)((Object)iterator)).getAtom(" CA "));
                AtomState atomState = modelState.get(((Residue)object4).getAtom(" CA "));
                if (object == null || atomState == null || !(((Triple)object).distance(atomState) < 5.9)) continue;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                arrayList2.add(iterator);
                for (Residue residue : helix.residues) {
                    arrayList2.add(residue);
                }
                helix.residues = arrayList2;
                if (!this.verbose) continue;
                System.err.println("Added '" + iterator + "' to '" + helix + "' b/c Ca(i)-Ca(i+3) dist = " + this.df.format(((Triple)object).distance(atomState)));
            }
            catch (AtomException atomException) {
                System.err.println("Couldn't find one/both of res i-1 or i+2 for the first residue of " + helix + "...");
            }
        }
    }

    public void findAxes(Model model, ModelState modelState) {
        for (Helix helix : this.helices) {
            int n;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
            for (n = 0; n < helix.residues.size() - 3; ++n) {
                int n2;
                Residue[] residueArray = new Residue[4];
                residueArray[0] = helix.residues.get(n);
                for (int i = 0; i < 3; ++i) {
                    if (residueArray[i].getNext(model) == null) continue;
                    residueArray[i + 1] = residueArray[i].getNext(model);
                }
                AtomState[] atomStateArray = new AtomState[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    if (residueArray[n2] == null) continue;
                    try {
                        atomStateArray[n2] = modelState.get(residueArray[n2].getAtom(" CA "));
                        continue;
                    }
                    catch (AtomException atomException) {
                        System.err.println("Can't find CA in res " + residueArray[n2]);
                    }
                }
                n2 = 0;
                for (int i = 0; i < atomStateArray.length; ++i) {
                    if (atomStateArray[i] == null) continue;
                    ++n2;
                }
                if (n2 == 4) {
                    Triple triple = new Triple().likeMidpoint(atomStateArray[0], atomStateArray[2]);
                    Triple triple2 = new Triple().likeMidpoint(atomStateArray[1], atomStateArray[3]);
                    Triple triple3 = new Triple().likeVector(triple, triple2);
                    Triple triple4 = triple3.unit().mult(2.0).add(triple);
                    Triple triple5 = triple;
                    arrayList.add(triple4);
                    arrayList2.add(triple5);
                    continue;
                }
                System.err.println("Wrong number Cas for this helical axis!");
                System.err.println("Expected 4 but got " + n2 + "...");
            }
            helix.axisTails = arrayList2;
            helix.axisHeads = arrayList;
            if (!this.verbose) continue;
            System.err.println(helix.axisTails.size() + " axis tails and " + helix.axisHeads.size() + " axis heads in " + helix);
            System.err.println("Residues:");
            for (n = 0; n < helix.residues.size(); ++n) {
                System.err.println("  " + helix.residues.get(n));
            }
            System.err.println("First residue: " + helix.getRes("first"));
            System.err.println("Last  residue: " + helix.getRes("last"));
            System.err.println();
        }
    }

    public void smoothAxes() {
        for (Helix helix : this.helices) {
            for (int i = 0; i < helix.axisHeads.size(); ++i) {
                Triple triple = helix.axisTails.get(i);
                Triple triple2 = helix.axisHeads.get(i);
                ArrayList<Triple> arrayList = new ArrayList<Triple>();
                ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
                arrayList.add(new Triple(triple));
                arrayList2.add(new Triple(triple2));
                if (i > 0) {
                    arrayList.add(new Triple(helix.axisTails.get(i - 1)));
                    arrayList2.add(new Triple(helix.axisHeads.get(i - 1)));
                }
                if (i < helix.axisHeads.size() - 1) {
                    arrayList.add(new Triple(helix.axisTails.get(i + 1)));
                    arrayList2.add(new Triple(helix.axisHeads.get(i + 1)));
                }
                Triple triple3 = new Triple();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                if (arrayList.size() > 1 && arrayList2.size() > 1) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        Triple triple4 = (Triple)arrayList.get(j);
                        Triple triple5 = (Triple)arrayList2.get(j);
                        Triple triple6 = new Triple(triple5.getX() - triple4.getX(), triple5.getY() - triple4.getY(), triple5.getZ() - triple4.getZ());
                        d += triple6.getX();
                        d2 += triple6.getY();
                        d3 += triple6.getZ();
                    }
                    triple3 = new Triple(d / (double)arrayList2.size(), d2 / (double)arrayList2.size(), d3 / (double)arrayList2.size());
                    triple3.add(triple);
                }
                helix.axisHeads.set(i, triple3);
            }
        }
    }

    public void findNcaps(Model model, ModelState modelState) {
        for (Helix helix : this.helices) {
            if (helix.ncap != null) continue;
            String string = this.typeOfNcapHbond(helix.getRes("first"), model, modelState);
            if (this.onlyHbNcaps && !string.equals("i+2") && !string.equals("i+3")) {
                helix.ncap = null;
                continue;
            }
            helix.ncap = new Ncap(helix.getRes("first"));
            if (string.equals("i+2")) {
                helix.ncap.hbType = "i+2";
            }
            if (!string.equals("i+3")) continue;
            helix.ncap.hbType = "i+3";
        }
        if (this.verbose) {
            System.err.println();
        }
        for (Helix helix : this.helices) {
            if (helix.ncap == null) continue;
            helix.setNcapDistances(model, modelState, this.verbose);
            helix.setNcapAngles(model, modelState);
            helix.setNcapPhiPsis(model, modelState);
            helix.setNcapScLengths(model);
            helix.setCappingBox(model, modelState, this.verbose);
            helix.setTypeAtNcap(model, modelState, this.verbose);
        }
    }

    public String typeOfNcapHbond(Residue residue, Model model, ModelState modelState) {
        try {
            Atom atom;
            Atom atom2;
            Residue residue2 = residue.getNext(model).getNext(model);
            Residue residue3 = residue2.getNext(model);
            Atom atom3 = residue2.getAtom(" H  ");
            Atom atom4 = residue3.getAtom(" H  ");
            Atom atom5 = residue2.getAtom(" N  ");
            Atom atom6 = residue3.getAtom(" N  ");
            Triple triple = null;
            Triple triple2 = null;
            Triple triple3 = null;
            Triple triple4 = null;
            if (atom3 != null) {
                triple = new Triple(modelState.get(atom3));
            }
            if (atom4 != null) {
                triple2 = new Triple(modelState.get(atom4));
            }
            if (atom5 != null) {
                triple3 = new Triple(modelState.get(atom5));
            }
            if (atom6 != null) {
                triple4 = new Triple(modelState.get(atom6));
            }
            Triple triple5 = null;
            Triple triple6 = null;
            Triple triple7 = null;
            if (residue.getName().equals("ASN")) {
                atom2 = residue.getAtom(" OD1");
                atom = residue.getAtom(" CG ");
                if (atom2 != null) {
                    triple5 = new Triple(modelState.get(atom2));
                }
                if (atom != null) {
                    triple7 = new Triple(modelState.get(atom));
                }
            }
            if (residue.getName().equals("ASP")) {
                atom2 = residue.getAtom(" OD1");
                atom = residue.getAtom(" OD2");
                Atom atom7 = residue.getAtom(" CG ");
                if (atom2 != null) {
                    triple5 = new Triple(modelState.get(atom2));
                }
                if (atom != null) {
                    triple6 = new Triple(modelState.get(atom));
                }
                if (atom7 != null) {
                    triple7 = new Triple(modelState.get(atom7));
                }
            }
            if (residue.getName().equals("SER")) {
                atom2 = residue.getAtom(" OG ");
                atom = residue.getAtom(" CB ");
                if (atom2 != null) {
                    triple5 = new Triple(modelState.get(atom2));
                }
                if (atom != null) {
                    triple7 = new Triple(modelState.get(atom));
                }
            }
            if (residue.getName().equals("THR")) {
                atom2 = residue.getAtom(" OG1");
                atom = residue.getAtom(" CB ");
                if (atom2 != null) {
                    triple5 = new Triple(modelState.get(atom2));
                }
                if (atom != null) {
                    triple7 = new Triple(modelState.get(atom));
                }
            }
            if (triple != null && triple2 != null && triple3 != null && triple4 != null && triple5 != null && triple7 != null) {
                double d = triple5.distance(triple4);
                double d2 = triple7.distance(triple2);
                double d3 = triple5.distance(triple2);
                double d4 = triple7.distance(triple4);
                double d5 = 27.9 * (1.0 / d + 1.0 / d2 - 1.0 / d3 - 1.0 / d4);
                d = triple5.distance(triple3);
                double d6 = 27.9 * (1.0 / d + 1.0 / (d2 = triple7.distance(triple)) - 1.0 / (d3 = triple5.distance(triple)) - 1.0 / (d4 = triple7.distance(triple3)));
                if (d6 < d5 && d6 < -0.5) {
                    if (this.verbose) {
                        System.err.println("'" + residue + "' makes an i+2 Hb" + "\t(energy2=" + this.df.format(d6) + " < energy3=" + this.df.format(d5) + ")");
                    }
                    return "i+2";
                }
                if (d5 < d6 && d5 < -0.5) {
                    if (this.verbose) {
                        System.err.println("'" + residue + "' makes an i+3 Hb" + "\t(energy2=" + this.df.format(d6) + " > energy3=" + this.df.format(d5) + ")");
                    }
                    return "i+3";
                }
            }
            if (this.verbose) {
                System.err.println("'" + residue + "' isn't an H-bonding NDST ...");
            }
            return "";
        }
        catch (AtomException atomException) {
            System.err.println("Problem figuring out if " + residue + " in '" + this.filename + "' is an Asn/Asp/Ser/Thr whose sc Hbonds to i+2 or i+3 mc and" + " is therefore an Ncap...");
            return "";
        }
    }

    void sketchHbonds(PrintStream printStream, Collection collection, ModelState modelState) {
        AtomState atomState;
        AtomState atomState2;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {peptides & hbonds}");
        printStream.println("@balllist {peptides} radius= 0.1 color= green");
        for (Peptide peptide : collection) {
            if (peptide.isHelix) {
                printStream.println("{" + peptide + "} r=0.3 " + peptide.midpoint.format(decimalFormat));
                continue;
            }
            printStream.println("{" + peptide + "} " + peptide.midpoint.format(decimalFormat));
        }
        printStream.println("@vectorlist {N hbonds} color= sky");
        for (Peptide peptide : collection) {
            if (peptide.hbondN == null) continue;
            try {
                atomState2 = modelState.get(peptide.nRes.getAtom(" H  "));
                atomState = modelState.get(peptide.hbondN.cRes.getAtom(" O  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(decimalFormat));
                printStream.println("{" + peptide.hbondN + "} " + atomState.format(decimalFormat));
            }
            catch (AtomException atomException) {}
        }
        printStream.println("@vectorlist {O hbonds} color= red");
        for (Peptide peptide : collection) {
            if (peptide.hbondO == null) continue;
            try {
                atomState2 = modelState.get(peptide.cRes.getAtom(" O  "));
                atomState = modelState.get(peptide.hbondO.nRes.getAtom(" H  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(decimalFormat));
                printStream.println("{" + peptide.hbondO + "} " + atomState.format(decimalFormat));
            }
            catch (AtomException atomException) {}
        }
    }

    void sketchNcaps(PrintStream printStream, ModelState modelState) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {ncaps}");
        printStream.println("@balllist {ncaps} radius= 0.3 color= hotpink");
        for (Helix helix : this.helices) {
            try {
                if (helix.ncap == null) continue;
                AtomState atomState = modelState.get(helix.ncap.res.getAtom(" CA "));
                printStream.println("{ncap '" + helix.toString() + "'   " + helix.ncap.hbType + " Hb, " + helix.typeAtNcap + " bb @ ncap} " + decimalFormat.format(atomState.getX()) + " " + decimalFormat.format(atomState.getY()) + " " + decimalFormat.format(atomState.getZ()));
            }
            catch (AtomException atomException) {
                System.err.println("Can't find atom ' CA ' in helix " + helix);
            }
        }
        printStream.println("@vectorlist {ncap normals} color= hotpink");
        for (Helix helix : this.helices) {
            if (helix.ncap == null || helix.ncap.normalTail == null || helix.ncap.normalHead == null) continue;
            printStream.println("{helix '" + helix.toString() + "' ncap normal tail}P " + decimalFormat.format(helix.ncap.normalTail.getX()) + " " + decimalFormat.format(helix.ncap.normalTail.getY()) + " " + decimalFormat.format(helix.ncap.normalTail.getZ()));
            printStream.println("{helix '" + helix.toString() + "' ncap normal head}P " + decimalFormat.format(helix.ncap.normalHead.getX()) + " " + decimalFormat.format(helix.ncap.normalHead.getY()) + " " + decimalFormat.format(helix.ncap.normalHead.getZ()));
        }
    }

    void sketchAxes(PrintStream printStream) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        String string = "";
        if (this.smoothAxes) {
            string = "smoothed ";
        } else if (this.vectorSumAxis) {
            string = "vector sum ";
        }
        printStream.println("@group {" + string + "helix axes}");
        printStream.println("@vectorlist {" + string + "helix axes} color= peach");
        if (this.vectorSumAxis) {
            for (Helix helix : this.helices) {
                if (helix.vectorSumAxisTail == null || helix.vectorSumAxisHead == null) continue;
                printStream.println("{helix (" + helix.toString() + ") vector sum axis " + "tail}P " + helix.vectorSumAxisTail.getX() + " " + helix.vectorSumAxisTail.getY() + " " + helix.vectorSumAxisTail.getZ());
                printStream.println("{helix (" + helix.toString() + ") vector sum axis " + "head} " + helix.vectorSumAxisHead.getX() + " " + helix.vectorSumAxisHead.getY() + " " + helix.vectorSumAxisHead.getZ());
            }
        } else {
            for (Helix helix : this.helices) {
                if (helix.axisHeads == null || helix.axisTails == null) continue;
                for (int i = 0; i < helix.axisHeads.size(); ++i) {
                    printStream.println("{helix (" + helix.toString() + ")" + " res" + (i + 1) + "-" + (i + 2) + " " + string + "axis tail}P " + decimalFormat.format(helix.axisTails.get(i).getX()) + " " + decimalFormat.format(helix.axisTails.get(i).getY()) + " " + decimalFormat.format(helix.axisTails.get(i).getZ()));
                    printStream.println("{helix (" + helix.toString() + ")" + " res" + (i + 1) + "-" + (i + 2) + " " + string + "axis head} " + decimalFormat.format(helix.axisHeads.get(i).getX()) + " " + decimalFormat.format(helix.axisHeads.get(i).getY()) + " " + decimalFormat.format(helix.axisHeads.get(i).getZ()));
                }
            }
        }
    }

    public void printHelices() {
        System.err.println("\nTotal number helices in " + this.filename + ": " + this.helices.size() + "\n");
        for (Helix helix : this.helices) {
            System.err.println("** " + helix.toString());
            System.err.println("  " + helix.residues.size() + " residues");
            for (Residue residue : helix.residues) {
                System.err.println("  " + residue);
            }
            if (this.doNcaps && helix.ncap != null) {
                System.err.println("  ncap: " + helix.ncap);
                if (helix.ncap.planeNormalAngle != Double.NaN) {
                    System.err.println("  ncap plane normal angle: " + this.df.format(helix.ncap.planeNormalAngle));
                }
                System.err.println("  " + helix.typeAtNcap + " at ncap");
            }
            System.err.println();
        }
    }

    public void printNcapAngles() {
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (this.doNcaps) {
            PrintStream printStream = System.out;
            printStream.println("file,helix,Ncap,CaCaCa_axis,CaCb_axis,Ca(i-1_i+1_i+2)_Ca(i-1_i_i+1),Ca(i-1_i+1_i+2),N3NH_Ca(i_i+1_i+2),N3NH_axis,tau(i-1),tau(i),tau(i+1),phi(i-1),psi(i-1),phi(i),psi(i),phi(i+1),psi(i+1),NcapO_N2H,NcapO_N3H,NcapCa_N3Ca,N'Ca_N3Ca,Ncap_HB_type,ncapResType,cappingBoxResType,NcapChis,N3Chis,helixTypeAtNcap,NcapHbEnergy3_10,NcapHbEnergyAlpha,NcapHbEnergySum,");
            for (Helix helix : this.helices) {
                Ncap ncap = helix.ncap;
                if (ncap != null) {
                    printStream.print(this.filename + "," + helix + "," + ncap + ",");
                    printStream.print(Double.isNaN(ncap.planeNormalAngle) ? "__?__," : decimalFormat.format(ncap.planeNormalAngle) + ",");
                    printStream.print(Double.isNaN(ncap.caCbAngle) ? "__?__," : decimalFormat.format(ncap.caCbAngle) + ",");
                    printStream.print(Double.isNaN(ncap.caPlanesAngle) ? "__?__," : decimalFormat.format(ncap.caPlanesAngle) + ",");
                    printStream.print(Double.isNaN(ncap.caEntryAngle) ? "__?__," : decimalFormat.format(ncap.caEntryAngle) + ",");
                    printStream.print(Double.isNaN(ncap.n3NH_precCaCaCa) ? "__?__," : decimalFormat.format(ncap.n3NH_precCaCaCa) + ",");
                    printStream.print(Double.isNaN(ncap.n3NH_axis) ? "__?__," : decimalFormat.format(ncap.n3NH_axis) + ",");
                    printStream.print(Double.isNaN(ncap.nprimeTau) ? "__?__," : decimalFormat.format(ncap.nprimeTau) + ",");
                    printStream.print(Double.isNaN(ncap.tau) ? "__?__," : decimalFormat.format(ncap.tau) + ",");
                    printStream.print(Double.isNaN(ncap.n1Tau) ? "__?__," : decimalFormat.format(ncap.n1Tau) + ",");
                    printStream.print(Double.isNaN(ncap.nprimePhi) ? "__?__," : decimalFormat.format(ncap.nprimePhi) + ",");
                    printStream.print(Double.isNaN(ncap.nprimePsi) ? "__?__," : decimalFormat.format(ncap.nprimePsi) + ",");
                    printStream.print(Double.isNaN(ncap.phi) ? "__?__," : decimalFormat.format(ncap.phi) + ",");
                    printStream.print(Double.isNaN(ncap.psi) ? "__?__," : decimalFormat.format(ncap.psi) + ",");
                    printStream.print(Double.isNaN(ncap.n1Phi) ? "__?__," : decimalFormat.format(ncap.n1Phi) + ",");
                    printStream.print(Double.isNaN(ncap.n1Psi) ? "__?__," : decimalFormat.format(ncap.n1Psi) + ",");
                    printStream.print(Double.isNaN(ncap.distNcapScToN2H) ? "__?__," : decimalFormat.format(ncap.distNcapScToN2H) + ",");
                    printStream.print(Double.isNaN(ncap.distNcapScToN3H) ? "__?__," : decimalFormat.format(ncap.distNcapScToN3H) + ",");
                    printStream.print(Double.isNaN(ncap.distNcapCaToN3Ca) ? "__?__," : decimalFormat.format(ncap.distNcapCaToN3Ca) + ",");
                    printStream.print(Double.isNaN(ncap.distNprimeCaToN3Ca) ? "__?__," : decimalFormat.format(ncap.distNprimeCaToN3Ca) + ",");
                    printStream.print(ncap.hbType + ",");
                    printStream.print(ncap.res.getName() + ",");
                    printStream.print(ncap.cappingBoxResType == null ? "__?__," : ncap.cappingBoxResType + ",");
                    printStream.print(ncap.ncapNumChis == 999 ? "__?__," : ncap.ncapNumChis + ",");
                    printStream.print(ncap.n3NumChis == 999 ? "__?__," : ncap.n3NumChis + ",");
                    printStream.print(helix.typeAtNcap + ",");
                    printStream.print(Double.isNaN(ncap.hbondEnergy3_10) ? "__?__," : decimalFormat.format(ncap.hbondEnergy3_10) + ",");
                    printStream.print(Double.isNaN(ncap.hbondEnergyAlpha) ? "__?__," : decimalFormat.format(ncap.hbondEnergyAlpha) + ",");
                    printStream.print(Double.isNaN(ncap.hbondEnergy3_10) || Double.isNaN(ncap.hbondEnergyAlpha) ? "__?__," : decimalFormat.format(ncap.hbondEnergyAlpha + ncap.hbondEnergy3_10) + ",");
                    printStream.println();
                    continue;
                }
                if (!this.verbose || !this.onlyHbNcaps) continue;
                printStream.println(this.filename + "," + helix + ",no_HBed_NDST_Ncap!");
            }
        }
    }

    public void Main() throws IOException {
        File file = new File(this.filename);
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(lineNumberReader);
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        this.processModel(coordinateFile.getIdCode(), model, modelState);
        if (this.doPrint) {
            if (this.verbose) {
                this.printHelices();
            }
            this.printNcapAngles();
        }
    }

    public static void main(String[] stringArray) {
        DsspHelixBuilder dsspHelixBuilder = new DsspHelixBuilder();
        try {
            dsspHelixBuilder.parseArguments(stringArray);
            dsspHelixBuilder.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            dsspHelixBuilder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("DsspHelixBuilder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'DsspHelixBuilder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.DsspHelixBuilder");
        System.err.println("Copyright (C) 2007 by Daniel Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename == null) {
            this.filename = string;
        } else {
            System.out.println("Didn't need " + string + "; already have file " + this.filename);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-kin")) {
            this.doKin = true;
            this.doPrint = false;
        } else if (string.equals("-print")) {
            this.doPrint = true;
        } else if (string.equals("-ncaps")) {
            this.doNcaps = true;
        } else if (string.equals("-onlyhbncaps")) {
            this.doNcaps = true;
            this.onlyHbNcaps = true;
        } else if (string.equals("-smoothaxes")) {
            this.smoothAxes = true;
            this.smoothAxesTimes = string2 != null ? Integer.parseInt(string2) : 1;
        } else if (string.equals("-vectorsumaxis")) {
            this.vectorSumAxis = true;
        } else if (string.equals("-v") || string.equals("-verbose")) {
            this.verbose = true;
        } else if (string.equals("-append")) {
            this.append = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    public static class MinHelix {
        int n = 0;
        Residue firstRes = null;
        Residue lastRes = null;

        public MinHelix(Residue residue, Residue residue2, int n) {
            this.firstRes = residue;
            this.lastRes = residue2;
            this.n = n;
        }

        public int overlap(MinHelix minHelix) {
            int n;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(this.firstRes.getSequenceInteger());
            treeSet.add(this.lastRes.getSequenceInteger());
            for (int i = 0; i < this.n; ++i) {
                n = this.firstRes.getSequenceInteger() + i;
                treeSet.add(n);
            }
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            treeSet2.add(minHelix.firstRes.getSequenceInteger());
            treeSet2.add(minHelix.lastRes.getSequenceInteger());
            for (n = 0; n < this.n; ++n) {
                int n2 = minHelix.firstRes.getSequenceInteger() + n;
                treeSet2.add(n2);
            }
            TreeSet<Integer> treeSet3 = new TreeSet<Integer>();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (!treeSet2.contains(n3)) continue;
                treeSet3.add(n3);
            }
            return treeSet3.size();
        }

        public String toString() {
            return "MinHelix from '" + this.firstRes + "' to '" + this.lastRes + "'";
        }
    }

    public static class NTurn {
        int n = 0;
        Residue firstRes = null;
        Residue lastRes = null;

        public NTurn(Residue residue, Residue residue2, int n) {
            this.firstRes = residue;
            this.lastRes = residue2;
            this.n = n;
        }

        public int overlap(NTurn nTurn) {
            int n;
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            treeSet.add(this.firstRes.getSequenceInteger());
            treeSet.add(this.lastRes.getSequenceInteger());
            for (int i = 0; i < this.n; ++i) {
                n = this.firstRes.getSequenceInteger() + i;
                treeSet.add(n);
            }
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            treeSet2.add(nTurn.firstRes.getSequenceInteger());
            treeSet2.add(nTurn.lastRes.getSequenceInteger());
            for (n = 0; n < this.n; ++n) {
                int n2 = nTurn.firstRes.getSequenceInteger() + n;
                treeSet2.add(n2);
            }
            TreeSet<Integer> treeSet3 = new TreeSet<Integer>();
            Iterator iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                if (!treeSet2.contains(n3)) continue;
                treeSet3.add(n3);
            }
            return treeSet3.size();
        }

        public String toString() {
            return this.n + "-turn from '" + this.firstRes + "' to '" + this.lastRes + "'";
        }
    }
}

