/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Ncap;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Helix {
    DecimalFormat df = new DecimalFormat("###.###");
    public ArrayList<Residue> residues;
    public String pdb;
    public Ncap ncap;
    public ArrayList<Triple> axisTails;
    public ArrayList<Triple> axisHeads;
    public Triple vectorSumAxisTail;
    public Triple vectorSumAxisHead;
    public String typeAtNcap;

    public Helix(TreeSet<Residue> treeSet) {
        Iterator<Residue> iterator = treeSet.iterator();
        this.residues = new ArrayList();
        while (iterator.hasNext()) {
            this.residues.add(iterator.next());
        }
        Collections.sort(this.residues);
        this.ncap = null;
        this.axisTails = null;
        this.axisHeads = null;
        this.vectorSumAxisTail = null;
        this.vectorSumAxisHead = null;
        this.typeAtNcap = "(unknown)";
    }

    public void setNcapDistances(Model model, ModelState modelState, boolean bl) {
        try {
            String string = this.ncap.res.getName();
            if (string.equals("SER") || string.equals("THR") || string.equals("ASN") || string.equals("ASP")) {
                double d;
                Residue residue = this.ncap.res;
                Residue residue2 = residue.getNext(model).getNext(model);
                Residue residue3 = residue2.getNext(model);
                Residue residue4 = residue.getPrev(model);
                Triple triple = new Triple(modelState.get(residue2.getAtom(" H  ")));
                Triple triple2 = new Triple(modelState.get(residue3.getAtom(" H  ")));
                Triple triple3 = null;
                Triple triple4 = null;
                if (string.equals("SER")) {
                    triple3 = new Triple(modelState.get(residue.getAtom(" OG ")));
                }
                if (string.equals("THR")) {
                    triple3 = new Triple(modelState.get(residue.getAtom(" OG1")));
                }
                if (string.equals("ASN")) {
                    triple3 = new Triple(modelState.get(residue.getAtom(" OD1")));
                }
                if (string.equals("ASP")) {
                    triple3 = new Triple(modelState.get(residue.getAtom(" OD1")));
                    triple4 = new Triple(modelState.get(residue.getAtom(" OD2")));
                }
                Triple triple5 = new Triple(modelState.get(residue.getAtom(" CA ")));
                Triple triple6 = new Triple(modelState.get(residue3.getAtom(" CA ")));
                Triple triple7 = new Triple(modelState.get(residue4.getAtom(" CA ")));
                double d2 = Triple.distance(triple3, triple);
                if (triple4 != null && (d = Triple.distance(triple4, triple)) < d2) {
                    d2 = d;
                }
                this.ncap.distNcapScToN2H = d2;
                d2 = Triple.distance(triple3, triple2);
                if (triple4 != null && (d = Triple.distance(triple4, triple2)) < d2) {
                    d2 = d;
                }
                this.ncap.distNcapScToN3H = d2;
                this.ncap.distNcapCaToN3Ca = d2 = Triple.distance(triple5, triple6);
                this.ncap.distNprimeCaToN3Ca = d2 = Triple.distance(triple5, triple7);
            }
        }
        catch (AtomException atomException) {
            System.err.println("Problem calculating distances at " + this.ncap + "...");
        }
    }

    public void setNcapAngles(Model model, ModelState modelState) {
        try {
            Triple triple;
            Object object;
            Triple triple2;
            Object object2;
            Triple triple3;
            Residue residue;
            Object object3;
            Object object4;
            Triple triple4;
            Residue residue2 = this.ncap.res;
            AtomState atomState = modelState.get(residue2.getAtom(" CA "));
            Triple triple5 = this.axisTails.get(0);
            Triple triple6 = this.axisHeads.get(0);
            Triple triple7 = new Triple(triple6.getX() - triple5.getX(), triple6.getY() - triple5.getY(), triple6.getZ() - triple5.getZ());
            if (residue2.getPrev(model) != null && residue2.getNext(model) != null) {
                triple4 = modelState.get(residue2.getPrev(model).getAtom(" CA "));
                object4 = modelState.get(residue2.getNext(model).getAtom(" CA "));
                object3 = new Triple().likeNormal(triple4, atomState, (Tuple3)object4);
                this.ncap.normalTail = atomState;
                this.ncap.normalHead = new Triple(atomState.getX() + ((Triple)object3).getX(), atomState.getY() + ((Triple)object3).getY(), atomState.getZ() + ((Triple)object3).getZ());
                this.ncap.planeNormalAngle = ((Triple)object3).angle(triple7);
            }
            triple4 = new Triple(atomState);
            if (!residue2.getName().equals("GLY")) {
                object4 = new Triple(modelState.get(residue2.getAtom(" CB ")));
                object3 = new Triple().likeVector(triple4, (Tuple3)object4);
                this.ncap.caCbAngle = ((Triple)object3).angle(triple7);
            }
            if (residue2.getPrev(model) != null && residue2.getNext(model) != null) {
                object4 = residue2.getNext(model);
                object3 = residue2.getPrev(model);
                if (((Residue)object4).getNext(model) != null) {
                    residue = ((Residue)object4).getNext(model);
                    triple3 = new Triple(modelState.get(((Residue)object3).getAtom(" CA ")));
                    triple4 = new Triple(modelState.get(residue2.getAtom(" CA ")));
                    object2 = new Triple(modelState.get(((Residue)object4).getAtom(" CA ")));
                    triple2 = new Triple(modelState.get(residue.getAtom(" CA ")));
                    object = new Triple().likeNormal(triple3, triple4, (Tuple3)object2);
                    triple = new Triple().likeNormal(triple3, (Tuple3)object2, triple2);
                    this.ncap.caPlanesAngle = ((Triple)object).angle(triple);
                    new Triple();
                    this.ncap.caEntryAngle = Triple.angle(triple3, (Tuple3)object2, triple2);
                }
            }
            object4 = new Triple(modelState.get(residue2.getAtom(" N  ")));
            triple4 = new Triple(modelState.get(residue2.getAtom(" CA ")));
            object3 = new Triple(modelState.get(residue2.getAtom(" C  ")));
            this.ncap.tau = Triple.angle((Tuple3)object4, triple4, (Tuple3)object3);
            if (residue2.getPrev(model) != null) {
                object4 = new Triple(modelState.get(residue2.getPrev(model).getAtom(" N  ")));
                triple4 = new Triple(modelState.get(residue2.getPrev(model).getAtom(" CA ")));
                object3 = new Triple(modelState.get(residue2.getPrev(model).getAtom(" C  ")));
                this.ncap.nprimeTau = Triple.angle((Tuple3)object4, triple4, (Tuple3)object3);
            }
            if (residue2.getNext(model) != null) {
                object4 = new Triple(modelState.get(residue2.getNext(model).getAtom(" N  ")));
                triple4 = new Triple(modelState.get(residue2.getNext(model).getAtom(" CA ")));
                object3 = new Triple(modelState.get(residue2.getNext(model).getAtom(" C  ")));
                this.ncap.n1Tau = Triple.angle((Tuple3)object4, triple4, (Tuple3)object3);
            }
            triple4 = new Triple(modelState.get(residue2.getAtom(" CA ")));
            if (residue2.getNext(model) != null) {
                residue = residue2.getNext(model);
                triple3 = new Triple(modelState.get(residue.getAtom(" CA ")));
                if (residue.getNext(model) != null) {
                    object2 = residue.getNext(model);
                    triple2 = new Triple(modelState.get(((Residue)object2).getAtom(" CA ")));
                    if (((Residue)object2).getNext(model) != null && !((Residue)(object = ((Residue)object2).getNext(model))).getName().equals("PRO")) {
                        triple = new Triple(modelState.get(((Residue)object).getAtom(" N  ")));
                        Triple triple8 = new Triple(modelState.get(((Residue)object).getAtom(" H  ")));
                        Triple triple9 = new Triple().likeVector(triple, triple8);
                        if (!residue2.getName().equals("GLY")) {
                            Triple triple10 = new Triple().likeNormal(triple4, triple3, triple2);
                            this.ncap.n3NH_precCaCaCa = triple9.angle(triple10);
                        }
                        this.ncap.n3NH_axis = triple9.angle(triple7);
                    }
                }
            }
        }
        catch (AtomException atomException) {
            System.err.println("Problem calculating N-cap angles...");
        }
    }

    public void setNcapPhiPsis(Model model, ModelState modelState) {
        try {
            Triple triple;
            Triple triple2;
            Triple triple3;
            Triple triple4;
            Object object;
            Triple triple5 = new Triple(modelState.get(this.ncap.res.getAtom(" CA ")));
            Triple triple6 = new Triple(modelState.get(this.ncap.res.getAtom(" N  ")));
            Triple triple7 = new Triple(modelState.get(this.ncap.res.getAtom(" C  ")));
            if (this.ncap.res.getPrev(model) != null) {
                object = new Triple(modelState.get(this.ncap.res.getPrev(model).getAtom(" C  ")));
                this.ncap.phi = Triple.dihedral((Tuple3)object, triple6, triple5, triple7);
            }
            if (this.ncap.res.getNext(model) != null) {
                object = new Triple(modelState.get(this.ncap.res.getNext(model).getAtom(" N  ")));
                this.ncap.psi = Triple.dihedral(triple6, triple5, triple7, (Tuple3)object);
            }
            if (this.ncap.res.getNext(model) != null) {
                object = this.ncap.res.getNext(model);
                triple4 = new Triple(modelState.get(((Residue)object).getAtom(" CA ")));
                triple3 = new Triple(modelState.get(((Residue)object).getAtom(" N  ")));
                triple2 = new Triple(modelState.get(((Residue)object).getAtom(" C  ")));
                this.ncap.n1Phi = Triple.dihedral(triple7, triple3, triple4, triple2);
                if (((Residue)object).getNext(model) != null) {
                    triple = new Triple(modelState.get(((Residue)object).getNext(model).getAtom(" N  ")));
                    this.ncap.n1Psi = Triple.dihedral(triple3, triple4, triple2, triple);
                }
            }
            if (this.ncap.res.getPrev(model) != null) {
                object = this.ncap.res.getPrev(model);
                triple4 = new Triple(modelState.get(((Residue)object).getAtom(" CA ")));
                triple3 = new Triple(modelState.get(((Residue)object).getAtom(" N  ")));
                triple2 = new Triple(modelState.get(((Residue)object).getAtom(" C  ")));
                if (((Residue)object).getPrev(model) != null) {
                    triple = new Triple(modelState.get(((Residue)object).getPrev(model).getAtom(" C  ")));
                    this.ncap.nprimePhi = Triple.dihedral(triple, triple3, triple4, triple2);
                }
                this.ncap.nprimePsi = Triple.dihedral(triple3, triple4, triple2, triple6);
            }
        }
        catch (AtomException atomException) {
            System.err.println("Problem calculating ncap i, i-1, and i+1 phi & psi...");
        }
    }

    public void setNcapScLengths(Model model) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("GLY");
        treeSet.add("ALA");
        TreeSet<String> treeSet2 = new TreeSet<String>();
        treeSet2.add("CYS");
        treeSet2.add("SER");
        treeSet2.add("VAL");
        treeSet2.add("THR");
        treeSet2.add("PRO");
        treeSet2.add("PHE");
        treeSet2.add("TYR");
        TreeSet<String> treeSet3 = new TreeSet<String>();
        treeSet3.add("TRP");
        treeSet3.add("HIS");
        treeSet3.add("LEU");
        treeSet3.add("ILE");
        treeSet3.add("ASP");
        treeSet3.add("ASN");
        TreeSet<String> treeSet4 = new TreeSet<String>();
        treeSet4.add("GLU");
        treeSet4.add("GLN");
        treeSet4.add("MET");
        TreeSet<String> treeSet5 = new TreeSet<String>();
        treeSet5.add("LYS");
        treeSet5.add("ARG");
        Residue residue = this.ncap.res.getNext(model).getNext(model).getNext(model);
        String string = residue.getName();
        String string2 = this.ncap.res.getName();
        if (this.ncap != null) {
            if (treeSet.contains(string2)) {
                this.ncap.ncapNumChis = 0;
            }
            if (treeSet2.contains(string2)) {
                this.ncap.ncapNumChis = 1;
            }
            if (treeSet3.contains(string2)) {
                this.ncap.ncapNumChis = 2;
            }
            if (treeSet4.contains(string2)) {
                this.ncap.ncapNumChis = 3;
            }
            if (treeSet5.contains(string2)) {
                this.ncap.ncapNumChis = 4;
            }
        }
        if (residue != null) {
            if (treeSet.contains(string)) {
                this.ncap.n3NumChis = 0;
            }
            if (treeSet2.contains(string)) {
                this.ncap.n3NumChis = 1;
            }
            if (treeSet3.contains(string)) {
                this.ncap.n3NumChis = 2;
            }
            if (treeSet4.contains(string)) {
                this.ncap.n3NumChis = 3;
            }
            if (treeSet5.contains(string)) {
                this.ncap.n3NumChis = 4;
            }
        }
    }

    public void setTypeAtNcap(Model model, ModelState modelState, boolean bl) {
        try {
            if (this.ncap == null) {
                System.err.println("N-cap null for " + this.toString() + " => not setting helix type (alpha vs. 3-10) at N-cap");
            } else {
                Residue residue = this.ncap.res.getNext(model).getNext(model).getNext(model);
                AtomState atomState = modelState.get(this.ncap.res.getAtom(" C  "));
                AtomState atomState2 = modelState.get(this.ncap.res.getAtom(" O  "));
                AtomState atomState3 = modelState.get(residue.getAtom(" N  "));
                AtomState atomState4 = modelState.get(residue.getAtom(" H  "));
                AtomState atomState5 = modelState.get(residue.getNext(model).getAtom(" N  "));
                AtomState atomState6 = modelState.get(residue.getNext(model).getAtom(" H  "));
                double d = atomState2.distance(atomState3);
                double d2 = atomState.distance(atomState4);
                double d3 = atomState2.distance(atomState4);
                double d4 = atomState.distance(atomState3);
                this.ncap.hbondEnergy3_10 = 27.9 * (1.0 / d + 1.0 / d2 - 1.0 / d3 - 1.0 / d4);
                d = atomState2.distance(atomState5);
                d2 = atomState.distance(atomState6);
                d3 = atomState2.distance(atomState6);
                d4 = atomState.distance(atomState5);
                this.ncap.hbondEnergyAlpha = 27.9 * (1.0 / d + 1.0 / d2 - 1.0 / d3 - 1.0 / d4);
                double d5 = -0.5;
                if (this.ncap.hbondEnergy3_10 < d5 && this.ncap.hbondEnergyAlpha > d5) {
                    this.typeAtNcap = "3_10";
                }
                if (this.ncap.hbondEnergyAlpha < d5 && this.ncap.hbondEnergy3_10 > d5) {
                    this.typeAtNcap = "alpha";
                }
                if (this.ncap.hbondEnergyAlpha > d5 && this.ncap.hbondEnergy3_10 > d5) {
                    this.typeAtNcap = "neither";
                }
                if (this.ncap.hbondEnergy3_10 < d5 && this.ncap.hbondEnergyAlpha < d5) {
                    this.typeAtNcap = Math.abs(this.ncap.hbondEnergyAlpha) - Math.abs(this.ncap.hbondEnergy3_10) < Math.abs(d5) ? "3_10" : "both/ambiguous";
                }
                if (bl) {
                    System.err.println(this.ncap + " is " + this.typeAtNcap + "   E(3_10)=" + this.df.format(this.ncap.hbondEnergy3_10) + ", E(alpha)=" + this.df.format(this.ncap.hbondEnergyAlpha));
                }
            }
        }
        catch (AtomException atomException) {
            System.err.println("Trouble w/ H-bonding for alpha vs. 3-10 at " + this.ncap);
        }
    }

    public void setCappingBox(Model model, ModelState modelState, boolean bl) {
        try {
            Residue residue;
            Residue residue2;
            Residue residue3 = this.ncap.res;
            if (residue3.getNext(model) != null && (residue2 = residue3.getNext(model)).getNext(model) != null && (residue = residue2.getNext(model)).getNext(model) != null) {
                Atom atom;
                Atom atom2;
                Atom atom3;
                Residue residue4;
                this.ncap.res3 = residue4 = residue.getNext(model);
                Atom atom4 = residue3.getAtom(" H  ");
                Atom atom5 = residue3.getAtom(" N  ");
                Triple triple = null;
                Triple triple2 = null;
                if (atom4 != null) {
                    triple = new Triple(modelState.get(atom4));
                }
                if (atom5 != null) {
                    triple2 = new Triple(modelState.get(atom5));
                }
                Triple triple3 = null;
                Triple triple4 = null;
                Triple triple5 = null;
                if (residue4.getName().equals("GLN")) {
                    atom3 = residue4.getAtom(" OE1");
                    atom2 = residue4.getAtom(" CD ");
                    if (atom3 != null) {
                        triple3 = new Triple(modelState.get(atom3));
                    }
                    if (atom2 != null) {
                        triple5 = new Triple(modelState.get(atom2));
                    }
                }
                if (residue4.getName().equals("GLU")) {
                    atom3 = residue4.getAtom(" OE1");
                    atom2 = residue4.getAtom(" OE2");
                    atom = residue4.getAtom(" CD ");
                    if (atom3 != null) {
                        triple3 = new Triple(modelState.get(atom3));
                    }
                    if (atom2 != null) {
                        triple4 = new Triple(modelState.get(atom2));
                    }
                    if (atom != null) {
                        triple5 = new Triple(modelState.get(atom));
                    }
                }
                if (residue4.getName().equals("ASN")) {
                    atom3 = residue4.getAtom(" OD1");
                    atom2 = residue4.getAtom(" CG ");
                    if (atom3 != null) {
                        triple3 = new Triple(modelState.get(atom3));
                    }
                    if (atom2 != null) {
                        triple5 = new Triple(modelState.get(atom2));
                    }
                }
                if (residue4.getName().equals("ASP")) {
                    atom3 = residue4.getAtom(" OD1");
                    atom2 = residue4.getAtom(" OD2");
                    atom = residue4.getAtom(" CG ");
                    if (atom3 != null) {
                        triple3 = new Triple(modelState.get(atom3));
                    }
                    if (atom2 != null) {
                        triple4 = new Triple(modelState.get(atom2));
                    }
                    if (atom != null) {
                        triple5 = new Triple(modelState.get(atom));
                    }
                }
                if (residue4.getName().equals("SER")) {
                    atom3 = residue4.getAtom(" OG ");
                    atom2 = residue4.getAtom(" CB ");
                    if (atom3 != null) {
                        triple3 = new Triple(modelState.get(atom3));
                    }
                    if (atom2 != null) {
                        triple5 = new Triple(modelState.get(atom2));
                    }
                }
                if (residue4.getName().equals("THR")) {
                    atom3 = residue4.getAtom(" OG1");
                    atom2 = residue4.getAtom(" CB ");
                    if (atom3 != null) {
                        triple3 = new Triple(modelState.get(atom3));
                    }
                    if (atom2 != null) {
                        triple5 = new Triple(modelState.get(atom2));
                    }
                }
                if (triple != null && triple2 != null && triple3 != null && triple5 != null) {
                    double d;
                    double d2;
                    double d3;
                    double d4 = triple3.distance(triple2);
                    double d5 = triple5.distance(triple);
                    double d6 = triple3.distance(triple);
                    double d7 = triple5.distance(triple2);
                    double d8 = 27.9 * (1.0 / d4 + 1.0 / d5 - 1.0 / d6 - 1.0 / d7);
                    if (triple4 != null && (d3 = 27.9 * (1.0 / (d2 = triple4.distance(triple2)) + 1.0 / d5 - 1.0 / (d = triple4.distance(triple)) - 1.0 / d7)) < d8) {
                        d8 = d3;
                    }
                    if (d8 < -0.5) {
                        this.ncap.cappingBoxResType = residue4.getName();
                        if (bl) {
                            System.err.println("'" + residue4 + "' makes capping " + "box Hb to '" + residue3 + "'\t(energy=" + this.df.format(d8) + ")");
                        }
                    }
                } else if (bl) {
                    System.err.println("No EQNDST capping box for " + this.toString());
                }
            }
        }
        catch (AtomException atomException) {
            System.err.println("Trouble looking for capping box in '" + this.toString() + "'");
        }
    }

    public Residue getRes(String string) {
        Residue residue;
        block3: {
            block2: {
                residue = this.residues.get(0);
                if (!string.equals("first")) break block2;
                for (Residue residue2 : this.residues) {
                    if (residue2.getSequenceInteger() >= residue.getSequenceInteger()) continue;
                    residue = residue2;
                }
                break block3;
            }
            if (!string.equals("last")) break block3;
            for (Residue residue3 : this.residues) {
                if (residue3.getSequenceInteger() <= residue.getSequenceInteger()) continue;
                residue = residue3;
            }
        }
        return residue;
    }

    public String toString() {
        return "helix from " + this.getRes("first") + " to " + this.getRes("last");
    }
}

