/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Helix;
import chiropraxis.mc.Ncap;
import chiropraxis.mc.Peptide;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.TreeSet;

public class HelixBuilder {
    DecimalFormat df = new DecimalFormat("###.###");
    String filename = null;
    ArrayList<Helix> helices = new ArrayList();
    boolean doNcaps = false;
    boolean onlyHbNcaps = false;
    boolean doKin = false;
    boolean doPrint = true;
    boolean smoothAxes = false;
    int smoothAxesTimes = 0;
    boolean verbose = false;
    boolean append = false;

    void processModel(String string, Model model, ModelState modelState) {
        Collection collection = this.createPeptides(model, modelState);
        this.connectPeptides(collection);
        this.findHBonds(collection, modelState);
        this.getPsiPhis(collection, modelState);
        this.assignSecStruct(collection);
        this.assignLeftoverSecStruct(collection);
        this.addHelices(collection, model, modelState);
        this.findAxes(model, modelState);
        if (this.smoothAxes) {
            for (int i = 0; i < this.smoothAxesTimes; ++i) {
                this.smoothAxes();
            }
        }
        if (this.doNcaps) {
            this.findNcaps(model, modelState);
        }
        if (this.doKin) {
            if (!this.append) {
                System.out.println("@kinemage {" + this.filename + " helices}");
            }
            this.sketchHbonds(System.out, collection, modelState);
            this.sketchNcaps(System.out, modelState);
            this.sketchAxes(System.out);
        }
    }

    Collection createPeptides(Model model, ModelState modelState) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (!AminoAcid.isAminoAcid(residue2)) continue;
            try {
                Peptide peptide = new Peptide(residue, residue2, modelState);
                if (residue == null) {
                    arrayList.add(peptide);
                } else {
                    AtomState atomState;
                    AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                    if (atomState2.sqDistance(atomState = modelState.get(residue2.getAtom(" N  "))) < 4.0) {
                        arrayList.add(peptide);
                    } else {
                        arrayList.add(new Peptide(residue, null, modelState));
                        arrayList.add(new Peptide(null, residue2, modelState));
                    }
                }
            }
            catch (AtomException atomException) {
                try {
                    arrayList.add(new Peptide(residue, null, modelState));
                }
                catch (AtomException atomException2) {
                    // empty catch block
                }
                try {
                    arrayList.add(new Peptide(null, residue2, modelState));
                }
                catch (AtomException atomException3) {
                    // empty catch block
                }
            }
            residue = residue2;
        }
        try {
            arrayList.add(new Peptide(residue, null, modelState));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return arrayList;
    }

    void connectPeptides(Collection collection) {
        Peptide peptide = null;
        int n = 0;
        for (Peptide peptide2 : collection) {
            if (peptide != null && peptide.nRes != null && peptide2.cRes != null && peptide.nRes == peptide2.cRes) {
                peptide.next = peptide2;
                peptide2.prev = peptide;
                peptide2.chain = peptide.chain;
                peptide2.index = peptide.index + 1;
            } else {
                peptide2.chain = ++n;
                peptide2.index = 1;
            }
            peptide = peptide2;
        }
    }

    void findHBonds(Collection collection, ModelState modelState) {
        Peptide[] peptideArray = collection.toArray(new Peptide[collection.size()]);
        AtomState[] atomStateArray = new AtomState[peptideArray.length];
        AtomState[] atomStateArray2 = new AtomState[peptideArray.length];
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].cRes == null) continue;
            try {
                atomStateArray[i] = modelState.get(peptideArray[i].cRes.getAtom(" C  "));
                atomStateArray2[i] = modelState.get(peptideArray[i].cRes.getAtom(" O  "));
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].nRes == null) continue;
            try {
                AtomState atomState = modelState.get(peptideArray[i].nRes.getAtom(" N  "));
                AtomState atomState2 = modelState.get(peptideArray[i].nRes.getAtom(" H  "));
                Peptide peptide = null;
                double d = -0.5;
                for (int j = 0; j < peptideArray.length; ++j) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if (i == j || peptideArray[i].chain == peptideArray[j].chain && Math.abs(peptideArray[i].index - peptideArray[j].index) <= 2 || atomStateArray[j] == null || atomStateArray2[j] == null || atomState.sqDistance(atomStateArray2[j]) > 28.09 || !((d6 = 27.9 * (1.0 / (d5 = atomStateArray2[j].distance(atomState)) + 1.0 / (d4 = atomStateArray[j].distance(atomState2)) - 1.0 / (d3 = atomStateArray2[j].distance(atomState2)) - 1.0 / (d2 = atomStateArray[j].distance(atomState)))) < d) || peptideArray[j].hbondO != null) continue;
                    peptide = peptideArray[j];
                    d = d6;
                }
                if (peptide == null) continue;
                peptideArray[i].hbondN = peptide;
                peptide.hbondO = peptideArray[i];
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    void getPsiPhis(Collection collection, ModelState modelState) {
        Peptide[] peptideArray = collection.toArray(new Peptide[collection.size()]);
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].nRes == null || peptideArray[i].cRes == null) continue;
            try {
                AtomState atomState = modelState.get(peptideArray[i].nRes.getAtom(" N  "));
                AtomState atomState2 = modelState.get(peptideArray[i].nRes.getAtom(" CA "));
                AtomState atomState3 = modelState.get(peptideArray[i].nRes.getAtom(" C  "));
                AtomState atomState4 = modelState.get(peptideArray[i].cRes.getAtom(" N  "));
                new Triple();
                peptideArray[i].psiN = Triple.dihedral(atomState, atomState2, atomState3, atomState4);
                AtomState atomState5 = modelState.get(peptideArray[i].cRes.getAtom(" CA "));
                AtomState atomState6 = modelState.get(peptideArray[i].cRes.getAtom(" C  "));
                new Triple();
                peptideArray[i].phiC = Triple.dihedral(atomState3, atomState4, atomState5, atomState6);
                if (!this.verbose) continue;
                System.err.println("**" + peptideArray[i]);
                System.err.println("psiN: " + peptideArray[i].psiN + ", phiC: " + peptideArray[i].phiC);
                System.err.println();
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    void assignSecStruct(Collection collection) {
        for (Peptide peptide : collection) {
            int n;
            if (peptide == null) continue;
            if (this.verbose) {
                System.err.println(peptide + " " + peptide.phiC + " " + peptide.psiN);
            }
            if (peptide.next == null || peptide.prev == null || peptide.nRes == null || peptide.cRes == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            if (peptide.hbondO != null && peptide.hbondO.nRes != null && (n = peptide.hbondO.nRes.getSequenceInteger() - peptide.nRes.getSequenceInteger()) == 3) {
                bl = true;
            }
            if (peptide.hbondN != null && peptide.hbondN.nRes != null && (n = peptide.nRes.getSequenceInteger() - peptide.hbondN.nRes.getSequenceInteger()) == 3) {
                bl2 = true;
            }
            if (!(peptide.phiC > -180.0 && peptide.phiC < 0.0 && bl) && (!(peptide.psiN > -90.0) || !(peptide.psiN < 45.0) || !bl2)) continue;
            peptide.isHelix = true;
        }
    }

    void assignLeftoverSecStruct(Collection collection) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        for (Peptide peptide : collection) {
            int n;
            if (peptide == null || peptide.next == null || peptide.prev == null || peptide.nRes == null || peptide.cRes == null) continue;
            boolean bl = false;
            boolean bl2 = false;
            if (peptide.hbondO != null && peptide.hbondO.nRes != null && (n = peptide.hbondO.cRes.getSequenceInteger() - peptide.cRes.getSequenceInteger()) == 3) {
                bl = true;
            }
            if (peptide.hbondN != null && peptide.hbondN.nRes != null && (n = peptide.nRes.getSequenceInteger() - peptide.hbondN.nRes.getSequenceInteger()) == 3) {
                bl2 = true;
            }
            n = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            for (Peptide peptide2 : collection) {
                if (peptide2 == null) continue;
                if (peptide2.isHelix && peptide2.cRes.equals(peptide.nRes)) {
                    n = 1;
                }
                if (!peptide2.isHelix || !peptide2.nRes.equals(peptide.cRes)) continue;
                bl3 = true;
            }
            if (peptide.psiN > -90.0 && peptide.psiN < 45.0) {
                bl4 = true;
            }
            if (peptide.phiC > -180.0 && peptide.phiC < 0.0) {
                bl5 = true;
            }
            if (bl2 && peptide.hbondN.isHelix) {
                bl6 = true;
            }
            if (bl && peptide.hbondO.isHelix) {
                bl7 = true;
            }
            if ((!bl3 || !bl4 && !bl6) && (n == 0 || !bl5 && !bl7)) continue;
            arrayList.add(peptide);
        }
        for (Peptide peptide : arrayList) {
            peptide.isHelix = true;
        }
    }

    void addHelices(Collection collection, Model model, ModelState modelState) {
        Object object = null;
        Object object2 = null;
        for (Object object3 : model.getResidues()) {
            if (object == null) {
                object = object3;
            }
            if (object2 == null) {
                object2 = object3;
            }
            if (((Residue)object3).getSequenceInteger() < ((Residue)object).getSequenceInteger()) {
                object = object3;
            }
            if (((Residue)object3).getSequenceInteger() <= ((Residue)object2).getSequenceInteger()) continue;
            object2 = object3;
        }
        TreeSet<Residue> treeSet = new TreeSet();
        for (Peptide peptide : collection) {
            Object object4;
            Cloneable cloneable;
            Object object5;
            if (!peptide.isHelix) continue;
            if (peptide.cRes != null && peptide.cRes.getSequenceInteger() <= ((Residue)object2).getSequenceInteger() - 3) {
                try {
                    object5 = peptide.cRes.getNext(model).getNext(model).getNext(model);
                    cloneable = modelState.get(peptide.cRes.getAtom(" CA "));
                    object4 = modelState.get(((Residue)object5).getAtom(" CA "));
                    if (cloneable != null && object4 != null && ((Triple)((Object)cloneable)).distance((Tuple3)object4) < 6.0) {
                        if (this.verbose) {
                            System.err.println("Looking at " + peptide);
                            System.err.println("  Did add pep.cRes " + peptide.cRes + " to a helix\tCa-Ca(i+3) dist " + this.df.format(((Triple)((Object)cloneable)).distance((Tuple3)object4)));
                        }
                        treeSet.add(peptide.cRes);
                    } else if (this.verbose) {
                        System.err.println("Looking at pep.cRes " + peptide);
                        System.err.println("  *Didn't* add residue " + peptide.cRes + " to a helix\tCa-Ca(i+3) dist " + this.df.format(((Triple)((Object)cloneable)).distance((Tuple3)object4)));
                    }
                }
                catch (AtomException atomException) {
                    System.err.println("Couldn't find res i+3 for res " + peptide.cRes);
                    cloneable = null;
                }
            }
            if (peptide.nRes != null && peptide.nRes.getSequenceInteger() >= ((Residue)object).getSequenceInteger() + 3) {
                try {
                    object5 = peptide.nRes.getPrev(model).getPrev(model).getPrev(model);
                    cloneable = modelState.get(peptide.nRes.getAtom(" CA "));
                    object4 = modelState.get(((Residue)object5).getAtom(" CA "));
                    if (cloneable != null && object4 != null && ((Triple)((Object)cloneable)).distance((Tuple3)object4) < 6.0) {
                        if (this.verbose) {
                            System.err.println("Looking at peptide " + peptide);
                            System.err.println("  Did add pep.nRes " + peptide.nRes + " to a helix\tCa-Ca(i-3) dist " + this.df.format(((Triple)((Object)cloneable)).distance((Tuple3)object4)));
                        }
                        treeSet.add(peptide.nRes);
                    } else if (this.verbose) {
                        System.err.println("Looking at peptide " + peptide);
                        System.err.println("  *Didn't* add pep.nRes " + peptide.nRes + " to a helix\tCa-Ca(i-3) dist " + this.df.format(((Triple)((Object)cloneable)).distance((Tuple3)object4)));
                    }
                }
                catch (AtomException atomException) {
                    System.err.println("Couldn't find res i-3 for res " + peptide.nRes);
                    cloneable = null;
                }
            }
            if (peptide.next.isHelix && peptide.next != null && peptide.cRes != null) continue;
            object5 = treeSet.iterator();
            cloneable = new ArrayList<Residue>();
            while (object5.hasNext()) {
                ((ArrayList)cloneable).add((Residue)object5.next());
            }
            Collections.sort(cloneable);
            if (treeSet.size() >= 5) {
                object4 = new Helix(treeSet);
                this.helices.add((Helix)object4);
                treeSet = new TreeSet();
                if (!this.verbose) continue;
                System.err.println("Making helix starting at '" + ((ArrayList)cloneable).get(0) + "'" + " b/c size is " + ((ArrayList)cloneable).size() + "\n");
                continue;
            }
            treeSet = new TreeSet<Residue>();
            if (!this.verbose) continue;
            System.err.println("Only " + ((ArrayList)cloneable).size() + " residues in " + "this helix" + " starting at '" + ((ArrayList)cloneable).get(0) + "', so not making it...");
        }
    }

    public void findAxes(Model model, ModelState modelState) {
        for (Helix helix : this.helices) {
            int n;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
            for (n = 0; n < helix.residues.size() - 3; ++n) {
                int n2;
                Residue[] residueArray = new Residue[4];
                residueArray[0] = helix.residues.get(n);
                for (int i = 0; i < 3; ++i) {
                    if (residueArray[i].getNext(model) == null) continue;
                    residueArray[i + 1] = residueArray[i].getNext(model);
                }
                AtomState[] atomStateArray = new AtomState[4];
                for (n2 = 0; n2 < 4; ++n2) {
                    if (residueArray[n2] == null) continue;
                    try {
                        atomStateArray[n2] = modelState.get(residueArray[n2].getAtom(" CA "));
                        continue;
                    }
                    catch (AtomException atomException) {
                        System.err.println("Can't find CA in res " + residueArray[n2]);
                    }
                }
                n2 = 0;
                for (int i = 0; i < atomStateArray.length; ++i) {
                    if (atomStateArray[i] == null) continue;
                    ++n2;
                }
                if (n2 == 4) {
                    Triple triple = new Triple().likeMidpoint(atomStateArray[0], atomStateArray[2]);
                    Triple triple2 = new Triple().likeMidpoint(atomStateArray[1], atomStateArray[3]);
                    Triple triple3 = new Triple().likeVector(triple, triple2);
                    Triple triple4 = triple3.unit().mult(2.0).add(triple);
                    Triple triple5 = triple;
                    arrayList.add(triple4);
                    arrayList2.add(triple5);
                    continue;
                }
                System.err.println("Wrong number Cas for this helical axis!");
                System.err.println("Expected 4 but got " + n2 + "...");
            }
            helix.axisTails = arrayList2;
            helix.axisHeads = arrayList;
            if (!this.verbose) continue;
            System.err.println(helix.axisTails.size() + " axis tails and " + helix.axisHeads.size() + " axis heads in " + helix);
            System.err.println("Residues:");
            for (n = 0; n < helix.residues.size(); ++n) {
                System.err.println("  " + helix.residues.get(n));
            }
            System.err.println("First residue: " + helix.getRes("first"));
            System.err.println("Last  residue: " + helix.getRes("last"));
            System.err.println();
        }
    }

    public void smoothAxes() {
        for (Helix helix : this.helices) {
            for (int i = 0; i < helix.axisHeads.size(); ++i) {
                Triple triple = helix.axisTails.get(i);
                Triple triple2 = helix.axisHeads.get(i);
                ArrayList<Triple> arrayList = new ArrayList<Triple>();
                ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
                arrayList.add(new Triple(triple));
                arrayList2.add(new Triple(triple2));
                if (i > 0) {
                    arrayList.add(new Triple(helix.axisTails.get(i - 1)));
                    arrayList2.add(new Triple(helix.axisHeads.get(i - 1)));
                }
                if (i < helix.axisHeads.size() - 1) {
                    arrayList.add(new Triple(helix.axisTails.get(i + 1)));
                    arrayList2.add(new Triple(helix.axisHeads.get(i + 1)));
                }
                Triple triple3 = new Triple();
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                if (arrayList.size() > 1 && arrayList2.size() > 1) {
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        Triple triple4 = (Triple)arrayList.get(j);
                        Triple triple5 = (Triple)arrayList2.get(j);
                        Triple triple6 = new Triple(triple5.getX() - triple4.getX(), triple5.getY() - triple4.getY(), triple5.getZ() - triple4.getZ());
                        d += triple6.getX();
                        d2 += triple6.getY();
                        d3 += triple6.getZ();
                    }
                    triple3 = new Triple(d / (double)arrayList2.size(), d2 / (double)arrayList2.size(), d3 / (double)arrayList2.size());
                    triple3.add(triple);
                }
                helix.axisHeads.set(i, triple3);
            }
        }
    }

    public void findNcaps(Model model, ModelState modelState) {
        for (Helix helix : this.helices) {
            if (helix.ncap != null) continue;
            String string = this.ncapMakesHb(helix.getRes("first"), model, modelState);
            if (this.onlyHbNcaps && !string.equals("i+2") && !string.equals("i+3")) {
                helix.ncap = null;
            } else {
                helix.ncap = new Ncap(helix.getRes("first"));
                if (string.equals("i+2")) {
                    helix.ncap.hbType = "i+2";
                }
                if (string.equals("i+3")) {
                    helix.ncap.hbType = "i+3";
                }
            }
            if (helix.ncap == null) continue;
            helix.setNcapDistances(model, modelState, this.verbose);
            helix.setNcapAngles(model, modelState);
            helix.setNcapPhiPsis(model, modelState);
            helix.setNcapScLengths(model);
            helix.setTypeAtNcap(model, modelState, this.verbose);
        }
    }

    public String ncapMakesHb(Residue residue, Model model, ModelState modelState) {
        try {
            double d;
            double d2;
            Triple triple;
            Residue residue2 = residue.getNext(model).getNext(model);
            Residue residue3 = residue2.getNext(model);
            Triple triple2 = new Triple(modelState.get(residue2.getAtom(" H  ")));
            Triple triple3 = new Triple(modelState.get(residue3.getAtom(" H  ")));
            if (residue.getName().equals("SER")) {
                triple = new Triple(modelState.get(residue.getAtom(" OG ")));
                d2 = Triple.distance(triple, triple2);
                d = Triple.distance(triple, triple3);
                if (this.verbose) {
                    System.err.println("N-cap " + residue + " makes an Hb with distance " + this.df.format(d2) + " or " + this.df.format(d));
                }
                if (d2 < 2.9 && d2 < d) {
                    return "i+2";
                }
                if (d < 2.9 && d < d2) {
                    return "i+3";
                }
            }
            if (residue.getName().equals("THR")) {
                triple = new Triple(modelState.get(residue.getAtom(" OG1")));
                d2 = Triple.distance(triple, triple2);
                d = Triple.distance(triple, triple3);
                if (this.verbose) {
                    System.err.println("N-cap " + residue + " makes an Hb with distance " + this.df.format(d2) + " or " + this.df.format(d));
                }
                if (d2 < 2.9 && d2 < d) {
                    return "i+2";
                }
                if (d < 2.9 && d < d2) {
                    return "i+3";
                }
            }
            if (residue.getName().equals("ASN")) {
                triple = new Triple(modelState.get(residue.getAtom(" OD1")));
                d2 = Triple.distance(triple, triple2);
                d = Triple.distance(triple, triple3);
                if (this.verbose) {
                    System.err.println("N-cap " + residue + " makes an Hb with distance " + this.df.format(d2) + " or " + this.df.format(d));
                }
                if (d2 < 2.9 && d2 < d) {
                    return "i+2";
                }
                if (d < 2.9 && d < d2) {
                    return "i+3";
                }
            }
            if (residue.getName().equals("ASP")) {
                triple = new Triple(modelState.get(residue.getAtom(" OD1")));
                d2 = Triple.distance(triple, triple2);
                d = Triple.distance(triple, triple3);
                Triple triple4 = new Triple(modelState.get(residue.getAtom(" OD2")));
                double d3 = Triple.distance(triple4, triple2);
                double d4 = Triple.distance(triple4, triple3);
                if (this.verbose) {
                    System.err.println("N-cap " + residue + " makes an Hb with distance " + this.df.format(d2) + ", " + this.df.format(d) + ", " + this.df.format(d3) + ", or " + this.df.format(d4));
                }
                if (d2 < 2.9 && d2 < d && d2 < d4 || d3 < 2.9 && d3 < d && d3 < d4) {
                    return "i+2";
                }
                if (d < 2.9 && d < d2 && d < d3 || d4 < 2.9 && d4 < d2 && d4 < d3) {
                    return "i+3";
                }
            }
            return "";
        }
        catch (AtomException atomException) {
            System.err.println("Problem figuring out if " + residue + " is an Asn/Asp/Ser/Thr" + " whose sc Hbonds to i+2 or i+3 mc and is therefore an Ncap...");
            return "";
        }
    }

    void sketchHbonds(PrintStream printStream, Collection collection, ModelState modelState) {
        AtomState atomState;
        AtomState atomState2;
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {peptides & hbonds}");
        printStream.println("@balllist {peptides} radius= 0.1 color= green");
        for (Peptide peptide : collection) {
            if (peptide.isHelix) {
                printStream.println("{" + peptide + "} r=0.3 " + peptide.midpoint.format(decimalFormat));
                continue;
            }
            printStream.println("{" + peptide + "} " + peptide.midpoint.format(decimalFormat));
        }
        printStream.println("@vectorlist {N hbonds} color= sky");
        for (Peptide peptide : collection) {
            if (peptide.hbondN == null) continue;
            try {
                atomState2 = modelState.get(peptide.nRes.getAtom(" H  "));
                atomState = modelState.get(peptide.hbondN.cRes.getAtom(" O  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(decimalFormat));
                printStream.println("{" + peptide.hbondN + "} " + atomState.format(decimalFormat));
            }
            catch (AtomException atomException) {}
        }
        printStream.println("@vectorlist {O hbonds} color= red");
        for (Peptide peptide : collection) {
            if (peptide.hbondO == null) continue;
            try {
                atomState2 = modelState.get(peptide.cRes.getAtom(" O  "));
                atomState = modelState.get(peptide.hbondO.nRes.getAtom(" H  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(decimalFormat));
                printStream.println("{" + peptide.hbondO + "} " + atomState.format(decimalFormat));
            }
            catch (AtomException atomException) {}
        }
    }

    void sketchNcaps(PrintStream printStream, ModelState modelState) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        printStream.println("@group {ncaps}");
        printStream.println("@balllist {ncaps} radius= 0.3 color= hotpink");
        for (Helix helix : this.helices) {
            try {
                if (helix.ncap == null) continue;
                AtomState atomState = modelState.get(helix.ncap.res.getAtom(" CA "));
                printStream.println("{helix '" + helix.toString() + "' ncap} " + decimalFormat.format(atomState.getX()) + " " + decimalFormat.format(atomState.getY()) + " " + decimalFormat.format(atomState.getZ()));
            }
            catch (AtomException atomException) {
                System.err.println("Can't find atom ' CA ' in helix " + helix);
            }
        }
        printStream.println("@vectorlist {ncap normals} color= hotpink");
        for (Helix helix : this.helices) {
            if (helix.ncap == null || helix.ncap.normalTail == null || helix.ncap.normalHead == null) continue;
            printStream.println("{helix '" + helix.toString() + "' ncap normal tail}P " + decimalFormat.format(helix.ncap.normalTail.getX()) + " " + decimalFormat.format(helix.ncap.normalTail.getY()) + " " + decimalFormat.format(helix.ncap.normalTail.getZ()));
            printStream.println("{helix '" + helix.toString() + "' ncap normal head}P " + decimalFormat.format(helix.ncap.normalHead.getX()) + " " + decimalFormat.format(helix.ncap.normalHead.getY()) + " " + decimalFormat.format(helix.ncap.normalHead.getZ()));
        }
    }

    void sketchAxes(PrintStream printStream) {
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        String string = "";
        if (this.smoothAxes) {
            string = "smoothed ";
        }
        printStream.println("@group {" + string + "helix axes}");
        printStream.println("@vectorlist {" + string + "helix axes} color= peach");
        for (Helix helix : this.helices) {
            if (helix.axisHeads == null || helix.axisTails == null) continue;
            for (int i = 0; i < helix.axisHeads.size(); ++i) {
                printStream.println("{helix (" + helix.toString() + ")" + " res" + (i + 1) + "-" + (i + 2) + " " + string + "axis tail}P " + decimalFormat.format(helix.axisTails.get(i).getX()) + " " + decimalFormat.format(helix.axisTails.get(i).getY()) + " " + decimalFormat.format(helix.axisTails.get(i).getZ()));
                printStream.println("{helix (" + helix.toString() + ")" + " res" + (i + 1) + "-" + (i + 2) + " " + string + "axis head} " + decimalFormat.format(helix.axisHeads.get(i).getX()) + " " + decimalFormat.format(helix.axisHeads.get(i).getY()) + " " + decimalFormat.format(helix.axisHeads.get(i).getZ()));
            }
        }
    }

    public void Main() throws IOException {
        File file = new File(this.filename);
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(lineNumberReader);
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        this.processModel(coordinateFile.getIdCode(), model, modelState);
        if (this.doPrint) {
            if (this.verbose) {
                this.printHelices();
            }
            this.printNcapAngles();
        }
    }

    public static void main(String[] stringArray) {
        HelixBuilder helixBuilder = new HelixBuilder();
        try {
            helixBuilder.parseArguments(stringArray);
            helixBuilder.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            helixBuilder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    public void printHelices() {
        System.err.println("\nTotal number helices in " + this.filename + ": " + this.helices.size() + "\n");
        for (Helix helix : this.helices) {
            System.err.println("** " + helix.toString());
            System.err.println("  " + helix.residues.size() + " residues");
            for (Residue residue : helix.residues) {
                System.err.println("  " + residue);
            }
            if (this.doNcaps && helix.ncap != null) {
                System.err.println("  ncap: " + helix.ncap);
                if (helix.ncap.planeNormalAngle != Double.NaN) {
                    System.err.println("  ncap plane normal angle: " + this.df.format(helix.ncap.planeNormalAngle));
                }
                System.err.println("  " + helix.typeAtNcap + " at ncap");
            }
            System.err.println();
        }
    }

    public void printNcapAngles() {
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (this.doNcaps) {
            System.out.print("file,helix,ncap,ca(i-1)_ca(i)_ca(i+1)-local_helix_axis_angle,ca(i)_cb(i)-local_helix_axis_angle,i-1_phi,i-1_psi,i_phi,i_psi,i+1_phi,i+1_psi,");
            System.out.print("ncapHbType,distNcapScToN2H,distNcapScToN3H,distNcapCaToN3Ca,distNprimeCaToN3Ca,");
            System.out.println("ncapNumChis,n3NumChis,helixTypeAtNcap,ncapResType");
            for (Helix helix : this.helices) {
                if (helix.ncap == null) continue;
                System.out.print(this.filename + "," + helix + "," + helix.ncap + ",");
                if (Double.isNaN(helix.ncap.planeNormalAngle)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.planeNormalAngle) + ",");
                }
                if (Double.isNaN(helix.ncap.caCbAngle)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.caCbAngle) + ",");
                }
                if (Double.isNaN(helix.ncap.nprimePhi)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.nprimePhi) + ",");
                }
                if (Double.isNaN(helix.ncap.nprimePsi)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.nprimePsi) + ",");
                }
                if (Double.isNaN(helix.ncap.phi)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.phi) + ",");
                }
                if (Double.isNaN(helix.ncap.psi)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.psi) + ",");
                }
                if (Double.isNaN(helix.ncap.n1Phi)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.n1Phi) + ",");
                }
                if (Double.isNaN(helix.ncap.n1Psi)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.n1Psi) + ",");
                }
                System.out.print(helix.ncap.hbType + ",");
                if (Double.isNaN(helix.ncap.distNcapScToN2H)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.distNcapScToN2H) + ",");
                }
                if (Double.isNaN(helix.ncap.distNcapScToN3H)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.distNcapScToN3H) + ",");
                }
                if (Double.isNaN(helix.ncap.distNcapCaToN3Ca)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.distNcapCaToN3Ca) + ",");
                }
                if (Double.isNaN(helix.ncap.distNprimeCaToN3Ca)) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(decimalFormat.format(helix.ncap.distNprimeCaToN3Ca) + ",");
                }
                if (helix.ncap.ncapNumChis == 999) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(helix.ncap.ncapNumChis + ",");
                }
                if (helix.ncap.n3NumChis == 999) {
                    System.out.print("__?__,");
                } else {
                    System.out.print(helix.ncap.n3NumChis + ",");
                }
                System.out.print(helix.typeAtNcap + ",");
                System.out.print(helix.ncap.res.getName() + ",");
                System.out.println();
            }
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("HelixBuilder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'HelixBuilder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.HelixBuilder");
        System.err.println("Copyright (C) 2007 by Daniel Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename == null) {
            this.filename = string;
        } else {
            System.out.println("Didn't need " + string + "; already have file " + this.filename);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-kin")) {
            this.doKin = true;
            this.doPrint = false;
        } else if (string.equals("-print")) {
            this.doPrint = true;
        } else if (string.equals("-ncaps")) {
            this.doNcaps = true;
        } else if (string.equals("-onlyhbncaps")) {
            this.doNcaps = true;
            this.onlyHbNcaps = true;
        } else if (string.equals("-smoothaxes")) {
            this.smoothAxes = true;
            this.smoothAxesTimes = string2 != null ? Integer.parseInt(string2) : 1;
        } else if (string.equals("-v") || string.equals("-verbose")) {
            this.verbose = true;
        } else if (string.equals("-append")) {
            this.append = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

