/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.sc.SidechainIdealizer;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.util.SoftLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PhiPsiRotation {
    static SidechainIdealizer sidechainIdealizer = null;

    public static Collection makeMobileGroup(Model model, Residue residue, boolean bl, int n) {
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        arrayList.add(residue);
        if (bl) {
            if (n == Integer.MAX_VALUE) {
                for (Residue residue2 = residue.getPrev(model); residue2 != null; residue2 = residue2.getPrev(model)) {
                    arrayList.add(residue2);
                }
            } else {
                for (Residue residue3 = residue.getPrev(model); residue3 != null && arrayList.size() < n; residue3 = residue3.getPrev(model)) {
                    arrayList.add(residue3);
                }
            }
        } else if (n == Integer.MAX_VALUE) {
            for (Residue residue4 = residue.getNext(model); residue4 != null; residue4 = residue4.getNext(model)) {
                arrayList.add(residue4);
            }
        } else {
            for (Residue residue5 = residue.getNext(model); residue5 != null && arrayList.size() < n; residue5 = residue5.getNext(model)) {
                arrayList.add(residue5);
            }
        }
        return arrayList;
    }

    public static ModelState makeConformation(Collection collection, ModelState modelState, double d, boolean bl, boolean bl2, int n, boolean bl3) throws AtomException {
        Residue residue;
        Iterator iterator = collection.iterator();
        Residue residue2 = residue = (Residue)iterator.next();
        while (iterator.hasNext()) {
            residue = (Residue)iterator.next();
        }
        Atom atom = null;
        Atom atom2 = null;
        if (bl2 && bl) {
            atom = residue2.getAtom(" N  ");
            atom2 = residue2.getAtom(" CA ");
        } else if (bl2 && !bl) {
            atom = residue2.getAtom(" CA ");
            atom2 = residue2.getAtom(" C  ");
        } else if (!bl2 && bl) {
            atom = residue2.getAtom(" N  ");
            atom2 = residue2.getAtom(" CA ");
        } else if (!bl2 && !bl) {
            atom = residue2.getAtom(" CA ");
            atom2 = residue2.getAtom(" C  ");
        }
        if (bl2 && bl && (atom == null || atom2 == null)) {
            throw new AtomException("N or CA missing from " + residue);
        }
        if (bl2 && !bl && (atom == null || atom2 == null)) {
            throw new AtomException("CA or C missing from " + residue);
        }
        if (!bl2 && bl && (atom == null || atom2 == null)) {
            throw new AtomException("N or CA missing from " + residue2);
        }
        if (!(bl2 || bl || atom != null && atom2 != null)) {
            throw new AtomException("CA or C missing from " + residue2);
        }
        Atom[] atomArray = PhiPsiRotation.getMobileAtoms(collection, bl, bl2, n);
        Transform transform = new Transform().likeRotation(modelState.get(atom), modelState.get(atom2), d);
        ModelState modelState2 = PhiPsiRotation.transformAtoms(transform, atomArray, modelState);
        if (bl3) {
            modelState2 = sidechainIdealizer.idealizeSidechain(residue2, modelState2);
        }
        return modelState2.createCollapsed(modelState);
    }

    static Atom[] getMobileAtoms(Collection collection, boolean bl, boolean bl2, int n) {
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = collection.iterator();
        Residue residue = (Residue)iterator.next();
        if (!bl2 && bl) {
            for (Object object2 : residue.getAtoms()) {
                object3 = ((Atom)object2).getName();
                if (!((String)object3).equals(" C  ") && !((String)object3).equals(" O  ")) continue;
                arrayList.add(object2);
            }
        } else if (bl2 && bl) {
            for (Object object2 : residue.getAtoms()) {
                object3 = ((Atom)object2).getName();
                if (!((String)object3).equals(" H  ")) continue;
                arrayList.add(object2);
            }
        } else if (bl2 && !bl) {
            for (Object object2 : residue.getAtoms()) {
                object3 = ((Atom)object2).getName();
                if (!((String)object3).equals(" N  ") && !((String)object3).equals(" H  ")) continue;
                arrayList.add(object2);
            }
        } else {
            for (Object object2 : residue.getAtoms()) {
                object3 = ((Atom)object2).getName();
                if (!((String)object3).equals(" O  ")) continue;
                arrayList.add(object2);
            }
        }
        for (int i = 1; iterator.hasNext() && i < n; ++i) {
            residue = (Residue)iterator.next();
            for (Object object3 : residue.getAtoms()) {
                arrayList.add(object3);
            }
        }
        return arrayList.toArray(new Atom[arrayList.size()]);
    }

    static ModelState transformAtoms(Transform transform, Atom[] atomArray, ModelState modelState) {
        ModelState modelState2 = new ModelState(modelState);
        for (int i = 0; i < atomArray.length; ++i) {
            try {
                AtomState atomState = modelState.get(atomArray[i]);
                AtomState atomState2 = (AtomState)atomState.clone();
                modelState2.add(atomState2);
                transform.transform(atomState2);
                continue;
            }
            catch (AtomException atomException) {
                SoftLog.err.println(atomException.getMessage());
            }
        }
        return modelState2;
    }

    static {
        try {
            sidechainIdealizer = new SidechainIdealizer();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

