/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.CaRotation;
import chiropraxis.mc.CaShear;
import chiropraxis.rotarama.Ramachandran;
import chiropraxis.rotarama.TauByPhiPsi;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.Triple;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class ShearFit {
    DecimalFormat df = new DecimalFormat("0.000");
    DecimalFormat df2 = new DecimalFormat("0.0");
    Builder builder;
    Model model = null;
    ModelState state1 = null;
    ModelState state2 = null;
    ArrayList<Residue> res = null;
    AtomState[] atoms1 = null;
    AtomState[] atoms2 = null;
    String whichAtoms = "ca+o";
    Ramachandran rama = null;
    TauByPhiPsi tauscorer = null;
    double origRmsd = Double.NaN;
    double bestShear = 0.0;
    double bestBackrub1 = 0.0;
    double bestBackrub2 = 0.0;
    double bestPepRot1 = 0.0;
    double bestPepRot2 = 0.0;
    double bestPepRot3 = 0.0;
    boolean idealizeSC = false;
    boolean verbose = false;
    String delim = ",";
    double maxTheta = Double.NaN;
    double maxRmsdChange = Double.NaN;

    public ShearFit() {
        this.builder = new Builder();
        try {
            this.rama = Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.tauscorer = TauByPhiPsi.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void initData(Model model, Residue residue, Residue residue2, Residue residue3, Residue residue4, String string, String string2, String string3, boolean bl, String string4, double d, double d2) {
        this.verbose = bl;
        this.delim = string4;
        this.model = model;
        this.state1 = (ModelState)this.model.getStates().get(string);
        this.state2 = (ModelState)this.model.getStates().get(string2);
        this.res = new ArrayList();
        this.res.add(residue);
        this.res.add(residue2);
        this.res.add(residue3);
        this.res.add(residue4);
        this.whichAtoms = string3;
        this.atoms1 = this.loadAtomStates(this.state1, new Residue[]{residue, residue2, residue3, residue4});
        this.atoms2 = this.loadAtomStates(this.state2, new Residue[]{residue, residue2, residue3, residue4});
        if (this.atoms1.length != this.atoms2.length) {
            throw new IllegalArgumentException("Selections must have same number of atoms");
        }
        this.maxTheta = d;
        this.maxRmsdChange = d2;
    }

    AtomState[] loadAtomStates(ModelState modelState, Residue[] residueArray) {
        if (modelState == null) {
            throw new IllegalArgumentException("Must supply ModelState");
        }
        if (!this.whichAtoms.equals("ca") && !this.whichAtoms.equals("ca+o")) {
            throw new IllegalArgumentException("Unrecognized atom selection: " + this.whichAtoms);
        }
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (int i = 0; i < residueArray.length; ++i) {
            Residue residue = residueArray[i];
            arrayList.add(residue.getAtom(" CA "));
            if (!this.whichAtoms.equals("ca+o") || i != 0 && i != 1 && i != 2) continue;
            arrayList.add(residue.getAtom(" O  "));
        }
        ArrayList<AtomState> arrayList2 = new ArrayList<AtomState>();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                Atom atom = (Atom)arrayList.get(i);
                if (atom == null) continue;
                arrayList2.add(modelState.get(atom));
                continue;
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        AtomState[] atomStateArray = arrayList2.toArray(new AtomState[arrayList2.size()]);
        return atomStateArray;
    }

    ModelState runTrials(int n, double d, boolean bl, boolean bl2, boolean bl3) {
        ModelState modelState = null;
        double d2 = Double.POSITIVE_INFINITY;
        this.bestShear = 0.0;
        this.bestBackrub1 = 0.0;
        this.bestBackrub2 = 0.0;
        this.bestPepRot1 = 0.0;
        this.bestPepRot2 = 0.0;
        this.bestPepRot3 = 0.0;
        ModelState modelState2 = this.state1.createCollapsed();
        for (int i = 0; i < n; ++i) {
            if (bl) {
                modelState2 = this.findBestShear(modelState2, d);
            }
            if (bl2) {
                modelState2 = this.findBestBackrub(modelState2, d, "first");
                modelState2 = this.findBestBackrub(modelState2, d, "second");
            }
            if (bl3) {
                modelState2 = this.findBestPeptideRotation(modelState2, d, "first");
                modelState2 = this.findBestPeptideRotation(modelState2, d, "second");
                modelState2 = this.findBestPeptideRotation(modelState2, d, "third");
            }
            this.atoms1 = this.loadAtomStates(modelState2, this.res.toArray(new Residue[this.res.size()]));
            double d3 = this.calcRmsd(this.atoms1, this.atoms2);
            if (modelState != null && !(d3 < d2)) continue;
            modelState = modelState2;
            d2 = d3;
        }
        if (this.verbose) {
            System.err.println(this.df.format(d2) + "  " + this.df2.format(this.bestShear) + "  " + this.df2.format(this.bestBackrub1) + this.delim + this.df2.format(this.bestBackrub2) + "  " + this.df2.format(this.bestPepRot1) + this.delim + this.df2.format(this.bestPepRot2) + this.delim + this.df2.format(this.bestPepRot3));
        } else {
            System.out.print(this.delim + this.df.format(d2));
        }
        return modelState;
    }

    ModelState interrelateAltConfs() {
        ModelState modelState = null;
        if (this.verbose) {
            System.err.print("Orig             ");
        }
        this.origRmsd = this.calcRmsd(this.atoms1, this.atoms2);
        if (this.verbose) {
            System.err.println(this.df.format(this.origRmsd) + "  0  0,0  0,0,0");
        } else {
            System.out.print(this.delim + this.df.format(this.origRmsd));
        }
        if (this.verbose) {
            System.err.print("Peps             ");
        }
        modelState = this.runTrials(false, false, true);
        if (this.verbose) {
            System.err.print("Brub             ");
        }
        modelState = this.runTrials(false, true, false);
        if (this.verbose) {
            System.err.print("Brub+Peps        ");
        }
        modelState = this.runTrials(false, true, true);
        if (this.verbose) {
            System.err.print("Shear            ");
        }
        modelState = this.runTrials(true, false, false);
        if (this.verbose) {
            System.err.print("Shear+Peps       ");
        }
        modelState = this.runTrials(true, false, true);
        if (this.verbose) {
            System.err.print("Shear+Brub       ");
        }
        modelState = this.runTrials(true, true, false);
        if (this.verbose) {
            System.err.print("Shear+Brub+Peps  ");
        }
        modelState = this.runTrials(true, true, true);
        if (this.verbose) {
            System.err.println();
        }
        return modelState;
    }

    ModelState runTrials(boolean bl, boolean bl2, boolean bl3) {
        ModelState modelState = null;
        this.bestShear = 0.0;
        this.bestBackrub1 = 0.0;
        this.bestBackrub2 = 0.0;
        this.bestPepRot1 = 0.0;
        this.bestPepRot2 = 0.0;
        this.bestPepRot3 = 0.0;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        int n = 0;
        ModelState modelState2 = this.state1.createCollapsed();
        while (Math.abs(d2) > this.maxRmsdChange) {
            if (bl) {
                modelState2 = this.findBestShear(modelState2, this.maxTheta);
            }
            if (bl2) {
                modelState2 = this.findBestBackrub(modelState2, this.maxTheta, "first");
                modelState2 = this.findBestBackrub(modelState2, this.maxTheta, "second");
            }
            if (bl3) {
                modelState2 = this.findBestPeptideRotation(modelState2, this.maxTheta, "first");
                modelState2 = this.findBestPeptideRotation(modelState2, this.maxTheta, "second");
                modelState2 = this.findBestPeptideRotation(modelState2, this.maxTheta, "third");
            }
            this.atoms1 = this.loadAtomStates(modelState2, this.res.toArray(new Residue[this.res.size()]));
            double d3 = this.calcRmsd(this.atoms1, this.atoms2);
            d2 = d == Double.POSITIVE_INFINITY ? d3 - this.origRmsd : d3 - d;
            modelState = modelState2;
            d = d3;
            ++n;
        }
        if (this.verbose) {
            System.err.println(this.df.format(d) + "  " + this.df2.format(this.bestShear) + "  " + this.df2.format(this.bestBackrub1) + this.delim + this.df2.format(this.bestBackrub2) + "  " + this.df2.format(this.bestPepRot1) + this.delim + this.df2.format(this.bestPepRot2) + this.delim + this.df2.format(this.bestPepRot3));
        } else {
            System.out.print(this.delim + this.df.format(d));
        }
        return modelState;
    }

    ModelState findBestShear(ModelState modelState, double d) {
        ModelState modelState2 = modelState.createCollapsed();
        ModelState modelState3 = null;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = 0.0;
        for (double d4 = -1.0 * d; d4 < d; d4 += 0.01) {
            try {
                ArrayList<Residue> arrayList = this.res;
                modelState3 = CaShear.makeConformation(arrayList, modelState, d4, this.idealizeSC);
                this.atoms1 = this.loadAtomStates(modelState3, new Residue[]{this.res.get(0), this.res.get(1), this.res.get(2), this.res.get(3)});
                double d5 = this.calcRmsd(this.atoms1, this.atoms2);
                if (!this.geometryIsValid(modelState3) || !(d5 < d2)) continue;
                d2 = d5;
                d3 = d4;
                modelState2 = modelState3;
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        this.bestShear += d3;
        return modelState2;
    }

    ModelState findBestBackrub(ModelState modelState, double d, String string) {
        ModelState modelState2 = modelState.createCollapsed();
        ModelState modelState3 = null;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = 0.0;
        for (double d4 = -1.0 * d; d4 < d; d4 += 0.01) {
            try {
                ArrayList<Residue> arrayList = new ArrayList<Residue>();
                if (string.equals("first")) {
                    arrayList.add(this.res.get(0));
                    arrayList.add(this.res.get(1));
                    arrayList.add(this.res.get(2));
                } else {
                    arrayList.add(this.res.get(1));
                    arrayList.add(this.res.get(2));
                    arrayList.add(this.res.get(3));
                }
                modelState3 = CaRotation.makeConformation(arrayList, modelState, d4, this.idealizeSC);
                this.atoms1 = this.loadAtomStates(modelState3, new Residue[]{this.res.get(0), this.res.get(1), this.res.get(2), this.res.get(3)});
                double d5 = this.calcRmsd(this.atoms1, this.atoms2);
                if (!this.geometryIsValid(modelState3) || !(d5 < d2)) continue;
                d2 = d5;
                d3 = d4;
                modelState2 = modelState3;
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        if (string.equals("first")) {
            this.bestBackrub1 += d3;
        } else {
            this.bestBackrub2 += d3;
        }
        return modelState2;
    }

    ModelState findBestPeptideRotation(ModelState modelState, double d, String string) {
        ModelState modelState2 = modelState.createCollapsed();
        ModelState modelState3 = null;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = 0.0;
        for (double d4 = -1.0 * d; d4 < d; d4 += 0.01) {
            try {
                Atom atom = null;
                Residue[] residueArray = new Residue[2];
                if (string.equals("first")) {
                    residueArray[0] = this.res.get(0);
                    residueArray[1] = this.res.get(1);
                    atom = this.res.get(0).getAtom(" O  ");
                } else if (string.equals("second")) {
                    residueArray[0] = this.res.get(1);
                    residueArray[1] = this.res.get(2);
                    atom = this.res.get(1).getAtom(" O  ");
                } else {
                    residueArray[0] = this.res.get(2);
                    residueArray[1] = this.res.get(3);
                    atom = this.res.get(2).getAtom(" O  ");
                }
                double[] dArray = new double[]{d4};
                boolean[] blArray = new boolean[]{this.idealizeSC, this.idealizeSC};
                modelState3 = CaRotation.twistPeptides(residueArray, modelState, dArray, blArray);
                this.atoms1 = this.loadAtomStates(modelState3, new Residue[]{this.res.get(0), this.res.get(1), this.res.get(2), this.res.get(3)});
                double d5 = this.calcRmsd(this.atoms1, this.atoms2);
                if (!this.geometryIsValid(modelState3) || !(d5 < d2)) continue;
                d2 = d5;
                d3 = d4;
                modelState2 = modelState3;
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        if (string.equals("first")) {
            this.bestPepRot1 += d3;
        } else if (string.equals("second")) {
            this.bestPepRot2 += d3;
        } else {
            this.bestPepRot3 += d3;
        }
        return modelState2;
    }

    boolean geometryIsValid(ModelState modelState) {
        if (this.rama.isOutlier(this.model, this.res.get(0), modelState) || this.rama.isOutlier(this.model, this.res.get(1), modelState) || this.rama.isOutlier(this.model, this.res.get(2), modelState) || this.rama.isOutlier(this.model, this.res.get(3), modelState)) {
            return false;
        }
        try {
            if (Math.abs(AminoAcid.getTauDeviation(this.res.get(0), modelState)) >= 5.5 || Math.abs(AminoAcid.getTauDeviation(this.res.get(1), modelState)) >= 5.5 || Math.abs(AminoAcid.getTauDeviation(this.res.get(2), modelState)) >= 5.5 || Math.abs(AminoAcid.getTauDeviation(this.res.get(3), modelState)) >= 5.5) {
                return false;
            }
        }
        catch (AtomException atomException) {
            return false;
        }
        return true;
    }

    double calcRmsd(Triple[] tripleArray, Triple[] tripleArray2) {
        double d = 0.0;
        for (int i = 0; i < tripleArray.length; ++i) {
            d += tripleArray[i].sqDistance(tripleArray2[i]);
        }
        d = Math.sqrt(d / (double)tripleArray.length);
        return d;
    }
}

