/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.CaShear;
import chiropraxis.rotarama.Ramachandran;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.r3.MutableTuple3;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class ShearPioneer {
    DecimalFormat df = new DecimalFormat("0");
    DecimalFormat df2 = new DecimalFormat("0.#");
    DecimalFormat df3 = new DecimalFormat("#");
    DecimalFormat df4 = new DecimalFormat("#.##");
    DecimalFormat df5 = new DecimalFormat("0.0");
    String STREAKS = "phi/psi streaks kin";
    String STRUCTS = "local structures kin";
    String GOOD_COLOR = "greentint";
    String BAD_COLOR = "hotpink";
    boolean verbose = false;
    String outputMode = this.STREAKS;
    boolean pdbOut = false;
    String filename = null;
    boolean useIdealHelix = false;
    int resnum = Integer.MAX_VALUE;
    double phipsiRange = Double.NaN;
    double phipsiSpacing = 1.0;
    Ramachandran rama = null;
    double maxTauDev = 5.5;
    double maxTheta = 15.0;
    double thetaSpacing = 1.0;
    double epsilon = 0.7;
    double minEpsilon = Double.NaN;
    double maxEpsilon = Double.NaN;

    public ShearPioneer() {
        try {
            this.rama = Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void processModel(Model model) {
        System.out.println("@kinemage {" + this.resnum + "-" + (this.resnum + 3) + " " + (this.outputMode == this.STREAKS ? "streaks" : "structs") + "}");
        Residue residue = this.findResidue(model);
        ModelState modelState = model.getState();
        if (!Double.isNaN(this.phipsiRange)) {
            try {
                double d = AminoAcid.getPhi(model, residue, modelState);
                double d2 = AminoAcid.getPsi(model, residue, modelState);
                double d3 = d - this.phipsiRange;
                double d4 = d + this.phipsiRange;
                double d5 = d2 - this.phipsiRange;
                double d6 = d2 + this.phipsiRange;
                boolean bl = true;
                for (double d7 = d3; d7 <= d4; d7 += this.phipsiSpacing) {
                    bl = !bl;
                    for (double d8 = d5; d8 <= d6; d8 += this.phipsiSpacing) {
                        double d9 = d8;
                        if (bl) {
                            d9 = d6 - (d8 - d5);
                        }
                        ModelState modelState2 = this.initalizePhiPsi(model, modelState, d7, d9);
                        String string = " (" + this.df.format(d7) + "," + this.df.format(d9) + ")";
                        this.doMoveSeries(model, modelState2, residue, string);
                    }
                }
            }
            catch (AtomException atomException) {
                System.err.println("D'oh!  Can't compute phi/psi for " + residue);
            }
            catch (ResidueException residueException) {
                System.err.println("D'oh!  Can't compute phi/psi for " + residue);
            }
        } else if (!Double.isNaN(this.minEpsilon) && !Double.isNaN(this.maxEpsilon)) {
            for (double d = this.minEpsilon; d <= this.maxEpsilon; d += 0.1) {
                this.epsilon = d;
                this.doMoveSeries(model, modelState, residue);
            }
        } else {
            System.out.println("@group {" + this.resnum + "-" + (this.resnum + 3) + " ep=" + this.df2.format(this.epsilon) + "} animate dominant");
            this.doMoveSeries(model, modelState, residue);
        }
    }

    Residue findResidue(Model model) {
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (residue2.getSequenceInteger() != this.resnum) continue;
            residue = residue2;
            break;
        }
        if (residue == null) {
            System.err.println("D'oh!  Can't find residue # " + this.resnum);
            System.exit(0);
        }
        if (residue.getPrev(model) == null) {
            System.err.println("D'oh!  Need a residue preceding " + residue);
            System.exit(0);
        }
        Object object = residue;
        for (int i = 0; i < 4; ++i) {
            if ((object = ((Residue)object).getNext(model)) != null) continue;
            System.err.println("D'oh!  Need 4 residues following " + residue);
            System.exit(0);
        }
        return residue;
    }

    ModelState initalizePhiPsi(Model model, ModelState modelState, double d, double d2) {
        ModelState modelState2 = new ModelState(modelState);
        for (Residue residue : model.getResidues()) {
            modelState2 = this.setPhiOrPsi(residue, model, modelState2, "phi", d);
            modelState2 = this.setPhiOrPsi(residue, model, modelState2, "psi", d2);
        }
        return modelState2;
    }

    ModelState setPhiOrPsi(Residue residue, Model model, ModelState modelState, String string, double d) {
        Object object;
        Object object22;
        Residue residue2 = residue.getPrev(model);
        Residue residue3 = residue.getNext(model);
        if (residue2 == null && string.equals("phi")) {
            if (this.verbose) {
                System.err.println("Setting " + string + " for " + residue + " ... ERROR: no previous residue!");
            }
            return modelState;
        }
        if (residue3 == null && string.equals("psi")) {
            if (this.verbose) {
                System.err.println("Setting " + string + " for " + residue + " ... ERROR: no next residue!");
            }
            return modelState;
        }
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        for (Object object22 : model.getResidues()) {
            if (object22 == null) continue;
            object = ((Residue)object22).getAtoms().iterator();
            while (object.hasNext()) {
                arrayList.add((Atom)object.next());
            }
        }
        Object object3 = null;
        object22 = null;
        object = null;
        AtomState atomState = null;
        try {
            if (string.equals("phi")) {
                object3 = modelState.get(residue2.getAtom(" C  "));
                object22 = modelState.get(residue.getAtom(" N  "));
                object = modelState.get(residue.getAtom(" CA "));
                atomState = modelState.get(residue.getAtom(" C  "));
            } else if (string.equals("psi")) {
                object3 = modelState.get(residue.getAtom(" N  "));
                object22 = modelState.get(residue.getAtom(" CA "));
                object = modelState.get(residue.getAtom(" C  "));
                atomState = modelState.get(residue3.getAtom(" N  "));
            }
            double d2 = Triple.dihedral(object3, (Tuple3)object22, object, atomState);
            double d3 = d - d2;
            Transform transform = new Transform();
            transform.likeRotation((Tuple3)object22, (Tuple3)object, d3);
            ModelState modelState2 = new ModelState(modelState);
            for (Atom atom : arrayList) {
                object3 = modelState.get(atom);
                object22 = (AtomState)((AtomState)object3).clone();
                int n = residue.getSequenceInteger();
                int n2 = atom.getResidue().getSequenceInteger();
                String string2 = " H  , N  , CA , HA , C  , O  ";
                int n3 = string2.indexOf(atom.getName());
                if (n2 <= n && (n2 != n || !string.equals("phi") || n3 < 10) && (n2 != n || !string.equals("psi") || n3 < 20)) continue;
                transform.transform((MutableTuple3)object22);
                modelState2.add((AtomState)object22);
            }
            if (this.verbose) {
                System.err.println("Setting " + string + " for " + residue + " ... done");
            }
            return modelState2;
        }
        catch (AtomException atomException) {
            if (this.verbose) {
                System.err.println("Setting " + string + " for " + residue + " ... ERROR: missing necessary atoms!");
            }
            return modelState;
        }
    }

    void doMoveSeries(Model model, ModelState modelState, Residue residue) {
        this.doMoveSeries(model, modelState, residue, "");
    }

    void doMoveSeries(Model model, ModelState modelState, Residue residue, String string) {
        System.out.println("@group {shr" + this.resnum + "-" + (this.resnum + 3) + string + " ep" + this.df5.format(this.epsilon) + "} animate dominant");
        Residue residue2 = residue;
        Residue residue3 = residue2.getNext(model);
        Residue residue4 = residue3.getNext(model);
        Residue residue5 = residue4.getNext(model);
        if (residue2 == null || residue3 == null || residue4 == null || residue5 == null) {
            System.err.println("Oops, missing residues somewhere in here: " + this.resnum + "-" + (this.resnum + 3));
            System.exit(0);
        }
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        arrayList.add(residue2);
        arrayList.add(residue3);
        arrayList.add(residue4);
        arrayList.add(residue5);
        Residue[] residueArray = arrayList.toArray(new Residue[arrayList.size()]);
        ArrayList<ShearedRegion> arrayList2 = new ArrayList<ShearedRegion>();
        for (double d = -1.0 * this.maxTheta; d <= this.maxTheta; d += this.thetaSpacing) {
            try {
                ModelState modelState2 = CaShear.makeConformation(arrayList, modelState, d, false);
                double d2 = this.calcPepRot(modelState, modelState2, residue2, residue3, d);
                double d3 = this.calcPepRot(modelState, modelState2, residue4, residue5, d);
                double[] dArray = new double[]{d2, 0.0, d3};
                boolean[] blArray = new boolean[]{false, false, false, false};
                modelState2 = CaShear.twistPeptides(residueArray, modelState2, dArray, blArray);
                double[] dArray2 = new double[]{d, d2, d3};
                double[] dArray3 = new double[]{AminoAcid.getPhi(model, residue2, modelState2), AminoAcid.getPsi(model, residue2, modelState2), AminoAcid.getPhi(model, residue5, modelState2), AminoAcid.getPsi(model, residue5, modelState2)};
                boolean bl = AminoAcid.getTauDeviation(residue2, modelState2) > this.maxTauDev || AminoAcid.getTauDeviation(residue3, modelState2) > this.maxTauDev || AminoAcid.getTauDeviation(residue4, modelState2) > this.maxTauDev || AminoAcid.getTauDeviation(residue5, modelState2) > this.maxTauDev;
                boolean bl2 = this.rama.isOutlier(model, residue2, modelState) || this.rama.isOutlier(model, residue3, modelState) || this.rama.isOutlier(model, residue4, modelState) || this.rama.isOutlier(model, residue5, modelState);
                ShearedRegion shearedRegion = new ShearedRegion(residueArray, modelState2, dArray2, dArray3, bl, bl2);
                arrayList2.add(shearedRegion);
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Can't perform " + this.df.format(d) + " degree shear!");
                continue;
            }
            catch (ResidueException residueException) {
                System.err.println("Can't get phi/psi after " + this.df.format(d) + " degree shear!");
            }
        }
        if (this.outputMode == this.STREAKS) {
            this.printStreaks(arrayList2);
        } else if (this.outputMode == this.STRUCTS) {
            this.printStructs(arrayList2, model);
        } else {
            System.err.println("Cannot compute!  Bad output mode: " + this.outputMode);
        }
    }

    double calcPepRot(ModelState modelState, ModelState modelState2, Residue residue, Residue residue2, double d) {
        if (this.epsilon == 0.0) {
            return 0.0;
        }
        try {
            Atom atom = residue.getAtom(" CA ");
            Atom atom2 = residue2.getAtom(" CA ");
            Atom atom3 = residue.getAtom(" O  ");
            AtomState atomState = modelState2.get(atom);
            AtomState atomState2 = modelState2.get(atom2);
            AtomState atomState3 = modelState2.get(atom3);
            AtomState atomState4 = modelState.get(atom3);
            double d2 = 0.0;
            double d3 = Double.POSITIVE_INFINITY;
            double d4 = -1.5 * Math.abs(d);
            double d5 = 1.5 * Math.abs(d);
            for (double d6 = d4; d6 < d5; d6 += 0.1) {
                Triple triple = this.rotate(atomState, atomState2, d6, new Triple(atomState3));
                double d7 = Triple.distance(triple, atomState4);
                if (!(d7 < d3)) continue;
                d3 = d7;
                d2 = d6;
            }
            return d2 * this.epsilon;
        }
        catch (AtomException atomException) {
            System.err.println("Error calculating peptide rotation for " + residue + " to " + residue2);
            return Double.NaN;
        }
    }

    Triple rotate(Triple triple, Triple triple2, double d, Triple triple3) {
        Triple triple4 = new Triple().likeVector(triple, triple2);
        Transform transform = new Transform();
        transform = transform.likeRotation(triple4, d);
        Triple triple5 = new Triple().likeVector(triple, triple3);
        transform.transform(triple5);
        Triple triple6 = new Triple().likeSum(triple, triple5);
        return triple6;
    }

    void printStreaks(ArrayList arrayList) {
        ShearedRegion shearedRegion;
        int n;
        System.out.println("@balllist {shear i} radius= 0.3 master= {shear i}");
        for (n = 0; n < arrayList.size(); ++n) {
            shearedRegion = (ShearedRegion)arrayList.get(n);
            System.out.println("{i " + shearedRegion.res1.getName().toLowerCase().trim() + shearedRegion.res1.getSequenceInteger() + " " + this.df.format(shearedRegion.theta) + "," + this.df.format(shearedRegion.pepRot1) + "," + this.df.format(shearedRegion.pepRot3) + " ep=" + this.df2.format(this.epsilon) + " (" + this.df.format(shearedRegion.phi1) + "," + this.df.format(shearedRegion.psi1) + ")}" + (shearedRegion.badTau || shearedRegion.ramaOut ? this.BAD_COLOR : this.GOOD_COLOR) + " " + this.df4.format(shearedRegion.phi1) + " " + this.df4.format(shearedRegion.psi1));
        }
        System.out.println("@balllist {shear i+3} radius= 0.3 master= {shear i+3}");
        for (n = 0; n < arrayList.size(); ++n) {
            shearedRegion = (ShearedRegion)arrayList.get(n);
            System.out.println("{i+3 " + shearedRegion.res4.getName().toLowerCase().trim() + shearedRegion.res4.getSequenceInteger() + " " + this.df.format(shearedRegion.theta) + "," + this.df.format(shearedRegion.pepRot1) + "," + this.df.format(shearedRegion.pepRot3) + " ep=" + this.df2.format(this.epsilon) + " (" + this.df.format(shearedRegion.phi4) + "," + this.df.format(shearedRegion.psi4) + ")}" + (shearedRegion.badTau || shearedRegion.ramaOut ? this.BAD_COLOR : this.GOOD_COLOR) + " " + this.df4.format(shearedRegion.phi4) + " " + this.df4.format(shearedRegion.psi4));
        }
    }

    void printStructs(ArrayList arrayList, Model model) {
        for (int i = 0; i < arrayList.size(); ++i) {
            Object object;
            ShearedRegion shearedRegion = (ShearedRegion)arrayList.get(i);
            if (this.pdbOut) {
                object = new PdbWriter(System.out);
                System.out.println("MODEL       " + (i + 1 < 10 ? " " : "") + (i + 1));
                ((PdbWriter)object).writeResidues(model.getResidues(), shearedRegion.state);
                continue;
            }
            object = shearedRegion.res1.getAtom(" CA ");
            Atom atom = shearedRegion.res1.getAtom(" C  ");
            Atom atom2 = shearedRegion.res1.getAtom(" O  ");
            Atom atom3 = shearedRegion.res2.getAtom(" N  ");
            Atom atom4 = shearedRegion.res2.getAtom(" CA ");
            Atom atom5 = shearedRegion.res2.getAtom(" C  ");
            Atom atom6 = shearedRegion.res2.getAtom(" O  ");
            Atom atom7 = shearedRegion.res3.getAtom(" N  ");
            Atom atom8 = shearedRegion.res3.getAtom(" CA ");
            Atom atom9 = shearedRegion.res3.getAtom(" C  ");
            Atom atom10 = shearedRegion.res3.getAtom(" O  ");
            Atom atom11 = shearedRegion.res4.getAtom(" N  ");
            Atom atom12 = shearedRegion.res4.getAtom(" CA ");
            try {
                AtomState atomState = shearedRegion.state.get((Atom)object);
                AtomState atomState2 = shearedRegion.state.get(atom);
                AtomState atomState3 = shearedRegion.state.get(atom2);
                AtomState atomState4 = shearedRegion.state.get(atom3);
                AtomState atomState5 = shearedRegion.state.get(atom4);
                AtomState atomState6 = shearedRegion.state.get(atom5);
                AtomState atomState7 = shearedRegion.state.get(atom6);
                AtomState atomState8 = shearedRegion.state.get(atom7);
                AtomState atomState9 = shearedRegion.state.get(atom8);
                AtomState atomState10 = shearedRegion.state.get(atom9);
                AtomState atomState11 = shearedRegion.state.get(atom10);
                AtomState atomState12 = shearedRegion.state.get(atom11);
                AtomState atomState13 = shearedRegion.state.get(atom12);
                System.out.println("@vectorlist {" + shearedRegion.toString() + " " + this.df.format(shearedRegion.theta) + "," + this.df.format(shearedRegion.pepRot1) + "," + this.df.format(shearedRegion.pepRot3) + "} width= 2 color= " + (shearedRegion.badTau || shearedRegion.ramaOut ? this.BAD_COLOR : this.GOOD_COLOR));
                this.printAtomCoords(atomState, shearedRegion.res1 + " 'CA'", true);
                this.printAtomCoords(atomState2, shearedRegion.res1 + " 'C'", false);
                this.printAtomCoords(atomState3, shearedRegion.res1 + " 'O'", false);
                this.printAtomCoords(atomState2, shearedRegion.res1 + " 'C'", true);
                this.printAtomCoords(atomState4, shearedRegion.res2 + " 'N'", false);
                this.printAtomCoords(atomState5, shearedRegion.res2 + " 'CA'", false);
                this.printAtomCoords(atomState6, shearedRegion.res2 + " 'C'", false);
                this.printAtomCoords(atomState7, shearedRegion.res2 + " 'O'", false);
                this.printAtomCoords(atomState6, shearedRegion.res2 + " 'C'", true);
                this.printAtomCoords(atomState8, shearedRegion.res3 + " 'N'", false);
                this.printAtomCoords(atomState9, shearedRegion.res3 + " 'CA'", false);
                this.printAtomCoords(atomState10, shearedRegion.res3 + " 'C'", false);
                this.printAtomCoords(atomState11, shearedRegion.res3 + " 'O'", false);
                this.printAtomCoords(atomState10, shearedRegion.res3 + " 'C'", true);
                this.printAtomCoords(atomState12, shearedRegion.res4 + " 'N'", false);
                this.printAtomCoords(atomState13, shearedRegion.res4 + " 'CA'", false);
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Error printing structures for " + shearedRegion);
            }
        }
    }

    void printAtomCoords(Triple triple, String string, boolean bl) {
        System.out.print("{" + string + "}");
        if (bl) {
            System.out.print("P ");
        } else {
            System.out.print("  ");
        }
        System.out.println(this.df4.format(triple.getX()) + "," + this.df4.format(triple.getY()) + "," + this.df4.format(triple.getZ()));
    }

    public void Main() {
        if (this.filename == null) {
            if (this.useIdealHelix) {
                if (this.verbose) {
                    System.err.println("Using ideal helix");
                }
            } else {
                System.err.println("Using ideal helix (no input file provided)");
                this.useIdealHelix = true;
            }
        }
        if (!(Double.isNaN(this.minEpsilon) || Double.isNaN(this.maxEpsilon) || Double.isNaN(this.phipsiRange))) {
            System.err.println("Can't use -epsilon=#,# AND -phipsirange=#, silly goose!");
            System.exit(0);
        }
        if (this.resnum == Integer.MAX_VALUE) {
            System.err.println("Need a residue number!  Use -res=i (for i to i+4 shear)");
            System.exit(0);
        }
        if (this.phipsiRange > 15.0) {
            System.err.println("Init phi,psi range of " + this.df3.format(this.phipsiRange) + " too big!  Using 15");
            this.phipsiRange = 15.0;
        }
        if (this.phipsiRange > 0.0 && this.outputMode == this.STRUCTS && !this.pdbOut) {
            System.err.println("Warning: Exact kin coords w/ altered init phi/psi are not meaningful w.r.t. original coords!");
        }
        try {
            PdbReader pdbReader = new PdbReader();
            CoordinateFile coordinateFile = null;
            coordinateFile = this.filename != null ? pdbReader.read(new File(this.filename)) : pdbReader.read(this.getClass().getResourceAsStream("idealpolyala12-alpha.pdb"));
            Model model = coordinateFile.getFirstModel();
            this.processModel(model);
        }
        catch (IOException iOException) {
            System.err.println("Trouble parsing file!");
        }
    }

    public static void main(String[] stringArray) {
        ShearPioneer shearPioneer = new ShearPioneer();
        try {
            shearPioneer.parseArguments(stringArray);
            shearPioneer.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            shearPioneer.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("ShearPioneer.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'ShearPioneer.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.ShearPioneer");
        System.err.println("Copyright (C) 2010 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename != null) {
            throw new IllegalArgumentException("Only need 1 file!");
        }
        this.filename = string;
    }

    void interpretFlag(String string, String string2) {
        block35: {
            if (string.equals("-help") || string.equals("-h")) {
                this.showHelp(true);
                System.exit(0);
            } else if (string.equals("-verbose") || string.equals("-v")) {
                this.verbose = true;
            } else if (string.equals("-structs") || string.equals("-struct")) {
                this.outputMode = this.STRUCTS;
            } else if (string.equals("-streaks") || string.equals("-streak")) {
                this.outputMode = this.STREAKS;
            } else if (string.equals("-res")) {
                try {
                    this.resnum = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as an integer for resnum!");
                }
            } else if (string.equals("-theta")) {
                try {
                    this.maxTheta = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as a double for maxTheta!");
                }
            } else if (string.equals("-epsilon") || string.equals("-e")) {
                try {
                    String[] stringArray = Strings.explode(string2, ',');
                    if (stringArray.length > 2) {
                        System.err.println("Sorry, should be -epsilon=# or -epsilon=#,#");
                        break block35;
                    }
                    if (stringArray.length == 2) {
                        this.minEpsilon = Double.parseDouble(stringArray[0]);
                        this.maxEpsilon = Double.parseDouble(stringArray[1]);
                        break block35;
                    }
                    this.epsilon = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as (a) double(s) for epsilon!");
                }
            } else if (string.equals("-maxtaudev")) {
                try {
                    this.maxTauDev = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as a double for maxTauDev!");
                }
            } else if (string.equals("-phipsirange") || string.equals("-initrange")) {
                try {
                    this.phipsiRange = Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't format " + string2 + " as doubles for phipsiRange!");
                }
            } else if (string.equals("-alpha")) {
                this.useIdealHelix = true;
            } else if (string.equals("-pdbout")) {
                this.pdbOut = true;
            } else if (!string.equals("-dummy_option")) {
                throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
            }
        }
    }

    public class ShearedRegion {
        protected Residue res1;
        protected Residue res2;
        protected Residue res3;
        protected Residue res4;
        protected ModelState state;
        protected double theta;
        protected double pepRot1;
        protected double pepRot3;
        protected double phi1;
        protected double psi1;
        protected double phi4;
        protected double psi4;
        protected boolean badTau;
        protected boolean ramaOut;

        public ShearedRegion(Residue[] residueArray, ModelState modelState, double[] dArray, double[] dArray2, boolean bl, boolean bl2) {
            this.res1 = residueArray[0];
            this.res2 = residueArray[1];
            this.res3 = residueArray[2];
            this.res4 = residueArray[3];
            this.state = modelState;
            this.theta = dArray[0];
            this.pepRot1 = dArray[1];
            this.pepRot3 = dArray[2];
            this.phi1 = dArray2[0];
            this.psi1 = dArray2[1];
            this.phi4 = dArray2[2];
            this.psi4 = dArray2[3];
            this.badTau = bl;
            this.ramaOut = bl2;
        }

        public String toString() {
            return this.res1.getName().toLowerCase().trim() + this.res1.getSequenceInteger() + "-" + this.res4.getName().toLowerCase().trim() + this.res4.getSequenceInteger();
        }
    }
}

