/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.BetaArom;
import chiropraxis.mc.Peptide;
import chiropraxis.mc.SheetAxes;
import chiropraxis.mc.SheetAxes2;
import chiropraxis.mc.SheetAxes3;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.LsqPlane;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;

public class SheetBuilder {
    String aaNames = "ALA,ARG,ASN,ASP,CYS,GLU,GLN,GLY,HIS,ILE,LEU,LYS,MET,PHE,PRO,SER,THR,TRP,TYR,VAL";
    String aromNames = "PHE,TYR";
    DecimalFormat df = new DecimalFormat("0.0##");
    String filename = null;
    boolean verbose = false;
    boolean doBetaAroms = false;
    boolean doKin = true;
    TreeSet<String> oppNames = null;
    ArrayList<BetaArom> betaAroms = null;

    void processModel(String string, Model model, ModelState modelState) {
        if (this.verbose) {
            System.err.println("Processing " + string + "[" + model + "]");
        }
        Collection collection = this.createPeptides(model, modelState);
        this.connectPeptides(collection);
        this.findHBonds(collection, modelState);
        this.assignSecStruct(collection);
        Map map = this.calcSheetNormals1(collection, model, modelState);
        Map map2 = this.measureSheetAngles1(collection, map, modelState);
        Map map3 = this.calcSheetNormals2(collection, model, modelState);
        Map map4 = this.measureSheetAngles2(collection, map3, modelState);
        Map map5 = this.calcSheetNormals3(collection, model, modelState);
        Map map6 = this.measureSheetAngles3(collection, map5, modelState);
        if (this.doBetaAroms) {
            this.addBetaAroms(collection, string, model, modelState);
        }
        if (this.doKin) {
            System.out.println("@kinemage {" + string + " sheets}");
            this.sketchHbonds(System.out, collection, modelState);
            System.out.println("@group {normals}");
            this.sketchNormals1(System.out, map, modelState);
            this.sketchNormals2(System.out, map3, modelState);
            this.sketchNormals3(System.out, map5, modelState);
            if (this.doBetaAroms) {
                this.sketchBetaAroms(System.out, modelState, map4, map6);
            }
        } else if (this.doBetaAroms) {
            this.printBetaAromStats(System.out, map2, map4, map6);
        } else {
            this.printNeighborAngles2(System.out, string, collection, map4);
            this.printNeighborAngles3(System.out, string, collection, map6);
        }
    }

    Collection createPeptides(Model model, ModelState modelState) {
        ArrayList<Peptide> arrayList = new ArrayList<Peptide>();
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (!AminoAcid.isAminoAcid(residue2)) continue;
            try {
                Peptide peptide = new Peptide(residue, residue2, modelState);
                if (residue == null) {
                    arrayList.add(peptide);
                } else {
                    AtomState atomState;
                    AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
                    if (atomState2.sqDistance(atomState = modelState.get(residue2.getAtom(" N  "))) < 4.0) {
                        arrayList.add(peptide);
                    } else {
                        arrayList.add(new Peptide(residue, null, modelState));
                        arrayList.add(new Peptide(null, residue2, modelState));
                    }
                }
            }
            catch (AtomException atomException) {
                try {
                    arrayList.add(new Peptide(residue, null, modelState));
                }
                catch (AtomException atomException2) {
                    // empty catch block
                }
                try {
                    arrayList.add(new Peptide(null, residue2, modelState));
                }
                catch (AtomException atomException3) {
                    // empty catch block
                }
            }
            residue = residue2;
        }
        try {
            arrayList.add(new Peptide(residue, null, modelState));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return arrayList;
    }

    void connectPeptides(Collection collection) {
        Peptide peptide = null;
        int n = 0;
        for (Peptide peptide2 : collection) {
            if (peptide != null && peptide.nRes != null && peptide2.cRes != null && peptide.nRes == peptide2.cRes) {
                peptide.next = peptide2;
                peptide2.prev = peptide;
                peptide2.chain = peptide.chain;
                peptide2.index = peptide.index + 1;
            } else {
                peptide2.chain = ++n;
                peptide2.index = 1;
            }
            peptide = peptide2;
        }
    }

    void findHBonds(Collection collection, ModelState modelState) {
        Peptide[] peptideArray = collection.toArray(new Peptide[collection.size()]);
        AtomState[] atomStateArray = new AtomState[peptideArray.length];
        AtomState[] atomStateArray2 = new AtomState[peptideArray.length];
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].cRes == null) continue;
            try {
                atomStateArray[i] = modelState.get(peptideArray[i].cRes.getAtom(" C  "));
                atomStateArray2[i] = modelState.get(peptideArray[i].cRes.getAtom(" O  "));
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        for (int i = 0; i < peptideArray.length; ++i) {
            if (peptideArray[i].nRes == null) continue;
            try {
                AtomState atomState = modelState.get(peptideArray[i].nRes.getAtom(" N  "));
                AtomState atomState2 = modelState.get(peptideArray[i].nRes.getAtom(" H  "));
                Peptide peptide = null;
                double d = -0.5;
                for (int j = 0; j < peptideArray.length; ++j) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if (i == j || peptideArray[i].chain == peptideArray[j].chain && Math.abs(peptideArray[i].index - peptideArray[j].index) <= 2 || atomStateArray[j] == null || atomStateArray2[j] == null || atomState.sqDistance(atomStateArray2[j]) > 28.09 || !((d6 = 27.9 * (1.0 / (d5 = atomStateArray2[j].distance(atomState)) + 1.0 / (d4 = atomStateArray[j].distance(atomState2)) - 1.0 / (d3 = atomStateArray2[j].distance(atomState2)) - 1.0 / (d2 = atomStateArray[j].distance(atomState)))) < d) || peptideArray[j].hbondO != null) continue;
                    peptide = peptideArray[j];
                    d = d6;
                }
                if (peptide == null) continue;
                peptideArray[i].hbondN = peptide;
                peptide.hbondO = peptideArray[i];
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
    }

    void assignSecStruct(Collection collection) {
        for (Peptide peptide : collection) {
            Peptide peptide2 = peptide.hbondN;
            if (peptide2 == null) continue;
            if (peptide.next != null && peptide2.prev != null && peptide.next.hbondO == peptide2.prev) {
                peptide2.isBeta = true;
                peptide.isBeta = true;
                peptide2.isParallelO = false;
                peptide.isParallelN = false;
                continue;
            }
            if (peptide.prev != null && peptide2.next != null && peptide.prev.hbondO == peptide2.next) {
                peptide2.isBeta = true;
                peptide.isBeta = true;
                peptide2.isParallelO = false;
                peptide.isParallelN = false;
                continue;
            }
            if (peptide.chain == peptide2.chain && Math.abs(peptide.index - peptide2.index) <= 5) continue;
            if (peptide.next != null && peptide2.next != null && peptide.next.hbondO == peptide2.next) {
                peptide2.isBeta = true;
                peptide.isBeta = true;
                peptide2.isParallelO = true;
                peptide.isParallelN = true;
                continue;
            }
            if (peptide.prev == null || peptide2.prev == null || peptide.prev.hbondO != peptide2.prev) continue;
            peptide2.isBeta = true;
            peptide.isBeta = true;
            peptide2.isParallelO = true;
            peptide.isParallelN = true;
        }
    }

    Map calcSheetNormals1(Collection collection, Model model, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : model.getResidues()) {
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide.hbondN == null || peptide.hbondO == null || peptide2 == null || peptide2.hbondN == null || peptide2.hbondO == null || !peptide.isBeta || !peptide.hbondN.isBeta || !peptide.hbondO.isBeta || !peptide2.isBeta || !peptide2.hbondN.isBeta || !peptide2.hbondO.isBeta) continue;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            arrayList.add(peptide.hbondN.midpoint);
            arrayList.add(peptide.midpoint);
            arrayList.add(peptide.hbondO.midpoint);
            arrayList.add(peptide2.hbondN.midpoint);
            arrayList.add(peptide2.midpoint);
            arrayList.add(peptide2.hbondO.midpoint);
            LsqPlane lsqPlane = new LsqPlane(arrayList);
            Triple triple = new Triple(lsqPlane.getNormal());
            hashMap3.put(residue, triple);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue.getAtom(" CB "));
                Triple triple2 = new Triple(atomState2).sub(atomState);
                if (!(triple2.dot(triple) < 0.0)) continue;
                triple.neg();
            }
            catch (AtomException atomException) {}
        }
        return hashMap3;
    }

    Map calcSheetNormals2(Collection collection, Model model, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : model.getResidues()) {
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide.hbondN == null || peptide.hbondO == null || peptide2 == null || peptide2.hbondN == null || peptide2.hbondO == null || !peptide.isBeta || !peptide.hbondN.isBeta || !peptide.hbondO.isBeta || !peptide2.isBeta || !peptide2.hbondN.isBeta || !peptide2.hbondO.isBeta) continue;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            arrayList.add(peptide.midpoint);
            arrayList.add(peptide2.midpoint);
            arrayList.add(peptide.hbondO.midpoint);
            arrayList.add(peptide2.hbondN.midpoint);
            LsqPlane lsqPlane = new LsqPlane(arrayList);
            Triple triple = new Triple(lsqPlane.getNormal());
            Triple triple2 = new Triple(lsqPlane.getAnchor());
            ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
            arrayList2.add(peptide.midpoint);
            arrayList2.add(peptide2.midpoint);
            arrayList2.add(peptide.hbondN.midpoint);
            arrayList2.add(peptide2.hbondO.midpoint);
            LsqPlane lsqPlane2 = new LsqPlane(arrayList2);
            Triple triple3 = new Triple(lsqPlane2.getNormal());
            Triple triple4 = new Triple(lsqPlane2.getAnchor());
            Triple triple5 = new Triple().likeVector(triple2, triple4);
            Triple triple6 = new Triple().likeVector(triple4, triple2);
            if (triple.dot(triple5) < 0.0) {
                triple.neg();
            }
            if (triple3.dot(triple6) < 0.0) {
                triple3.neg();
            }
            if (!(triple.angle(triple3) < 90.0)) continue;
            Triple[] tripleArray = new Triple[]{new Triple().likeSum(triple, triple3).unit(), new Triple(triple4).sub(triple2)};
            hashMap3.put(residue, tripleArray);
        }
        return hashMap3;
    }

    Map calcSheetNormals3(Collection collection, Model model, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : model.getResidues()) {
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide.hbondN == null || peptide.hbondO == null || peptide2 == null || peptide2.hbondN == null || peptide2.hbondO == null || !peptide.isBeta || !peptide.hbondN.isBeta || !peptide.hbondO.isBeta || !peptide2.isBeta || !peptide2.hbondN.isBeta || !peptide2.hbondO.isBeta) continue;
            Peptide peptide3 = null;
            Peptide peptide4 = null;
            Peptide peptide5 = null;
            Peptide peptide6 = null;
            peptide3 = peptide2.isParallelN ? peptide2.hbondN.prev : peptide2.hbondN.next;
            peptide4 = peptide2.isParallelO ? peptide2.hbondO.prev : peptide2.hbondO.next;
            peptide5 = peptide.isParallelN ? peptide.hbondN.next : peptide.hbondN.prev;
            peptide6 = peptide.isParallelO ? peptide.hbondO.next : peptide.hbondO.prev;
            if (peptide3 == null || peptide4 == null || peptide5 == null || peptide6 == null || !peptide3.isBeta || !peptide4.isBeta || !peptide5.isBeta || !peptide6.isBeta) continue;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            arrayList.add(peptide2.hbondN.midpoint);
            arrayList.add(peptide2.hbondO.midpoint);
            arrayList.add(peptide3.midpoint);
            arrayList.add(peptide4.midpoint);
            LsqPlane lsqPlane = new LsqPlane(arrayList);
            Triple triple = new Triple(lsqPlane.getNormal());
            Triple triple2 = new Triple(lsqPlane.getAnchor());
            ArrayList<Triple> arrayList2 = new ArrayList<Triple>();
            arrayList2.add(peptide.hbondN.midpoint);
            arrayList2.add(peptide.hbondO.midpoint);
            arrayList2.add(peptide5.midpoint);
            arrayList2.add(peptide6.midpoint);
            LsqPlane lsqPlane2 = new LsqPlane(arrayList2);
            Triple triple3 = new Triple(lsqPlane2.getNormal());
            Triple triple4 = new Triple(lsqPlane2.getAnchor());
            Triple triple5 = new Triple().likeVector(triple2, triple4);
            Triple triple6 = new Triple().likeVector(triple4, triple2);
            if (triple.dot(triple5) < 0.0) {
                triple.neg();
            }
            if (triple3.dot(triple6) < 0.0) {
                triple3.neg();
            }
            ArrayList<Triple> arrayList3 = new ArrayList<Triple>();
            arrayList3.add(peptide2.hbondN.midpoint);
            arrayList3.add(peptide2.hbondO.midpoint);
            arrayList3.add(peptide.hbondN.midpoint);
            arrayList3.add(peptide.hbondO.midpoint);
            LsqPlane lsqPlane3 = new LsqPlane(arrayList3);
            if (!(triple.angle(triple3) < 90.0)) continue;
            Triple[] tripleArray = new Triple[]{new Triple().likeSum(triple, triple3).unit(), new Triple(triple4).sub(triple2), new Triple(lsqPlane3.getNormal())};
            hashMap3.put(residue, tripleArray);
        }
        return hashMap3;
    }

    Map measureSheetAngles1(Collection collection, Map map, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : map.keySet()) {
            Triple triple = (Triple)map.get(residue);
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide2 == null) continue;
            Triple triple2 = new Triple(peptide.midpoint).sub(peptide2.midpoint);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue.getAtom(" CB "));
                Triple triple3 = new Triple(atomState2).sub(atomState);
                SheetAxes sheetAxes = new SheetAxes(triple, triple2, triple3);
                hashMap3.put(residue, sheetAxes);
            }
            catch (AtomException atomException) {}
        }
        return hashMap3;
    }

    Map measureSheetAngles2(Collection collection, Map map, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : map.keySet()) {
            Triple[] tripleArray = (Triple[])map.get(residue);
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide2 == null) continue;
            Triple triple = new Triple(peptide.midpoint).sub(peptide2.midpoint);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue.getAtom(" CB "));
                Triple triple2 = new Triple(atomState2).sub(atomState);
                SheetAxes2 sheetAxes2 = new SheetAxes2(tripleArray[0], tripleArray[1], triple, triple2);
                hashMap3.put(residue, sheetAxes2);
            }
            catch (AtomException atomException) {}
        }
        return hashMap3;
    }

    Map measureSheetAngles3(Collection collection, Map map, ModelState modelState) {
        HashMap<Residue, Object> hashMap = new HashMap<Residue, Object>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        HashMap hashMap3 = new HashMap();
        for (Residue residue : map.keySet()) {
            Triple[] tripleArray = (Triple[])map.get(residue);
            Peptide peptide = (Peptide)hashMap.get(residue);
            Peptide peptide2 = (Peptide)hashMap2.get(residue);
            if (peptide == null || peptide2 == null) continue;
            Triple triple = new Triple(peptide.midpoint).sub(peptide2.midpoint);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                AtomState atomState2 = modelState.get(residue.getAtom(" CB "));
                Triple triple2 = new Triple(atomState2).sub(atomState);
                SheetAxes3 sheetAxes3 = new SheetAxes3(tripleArray[0], tripleArray[1], tripleArray[2], triple2);
                hashMap3.put(residue, sheetAxes3);
            }
            catch (AtomException atomException) {}
        }
        return hashMap3;
    }

    void addBetaAroms(Collection collection, String string, Model model, ModelState modelState) {
        if (this.verbose) {
            System.err.println("Adding beta aromatics");
        }
        this.betaAroms = new ArrayList();
        for (Peptide peptide : collection) {
            Peptide peptide2;
            Residue residue;
            if (peptide == null || !peptide.isBeta || peptide.prev == null || !peptide.prev.isBeta || peptide.cRes == null || this.aromNames.indexOf((residue = peptide.cRes).getName()) == -1 || (peptide2 = peptide.hbondO) == null) continue;
            Residue residue2 = null;
            if (!peptide.isParallelO) {
                if (!peptide2.isBeta || peptide2.next == null || !peptide2.next.isBeta) continue;
                residue2 = peptide2.nRes;
            } else {
                if (!peptide2.isBeta || peptide2.prev == null || !peptide2.prev.isBeta) continue;
                residue2 = peptide2.cRes;
            }
            if (residue2 == null || !this.oppNames.contains(residue2.getName())) continue;
            BetaArom betaArom = new BetaArom(residue, residue2, peptide.isParallelO, collection, model, string);
            try {
                betaArom.calcGeometry();
                this.betaAroms.add(betaArom);
                if (!this.verbose) continue;
                System.err.println(".. Added " + betaArom);
            }
            catch (AtomException atomException) {
                System.err.println("Error creating " + betaArom);
            }
            catch (NullPointerException nullPointerException) {
                System.err.println("Error creating " + betaArom);
            }
        }
        if (this.verbose) {
            System.err.println("Beta aromatics found: " + this.betaAroms.size());
        }
    }

    void sketchHbonds(PrintStream printStream, Collection collection, ModelState modelState) {
        AtomState atomState;
        AtomState atomState2;
        printStream.println("@group {peptides & hbonds}");
        printStream.println("@balllist {peptides} radius= 0.1 color= green");
        for (Peptide peptide : collection) {
            if (peptide.isBeta) {
                printStream.println("{" + peptide + "} r=0.3 " + peptide.midpoint.format(this.df));
                continue;
            }
            if (this.doBetaAroms) continue;
            printStream.println("{" + peptide + "} " + peptide.midpoint.format(this.df));
        }
        printStream.println("@vectorlist {N hbonds} color= sky");
        for (Peptide peptide : collection) {
            if (peptide.hbondN == null || !peptide.isBeta && this.doBetaAroms) continue;
            try {
                atomState2 = modelState.get(peptide.nRes.getAtom(" H  "));
                atomState = modelState.get(peptide.hbondN.cRes.getAtom(" O  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(this.df));
                printStream.println("{" + peptide.hbondN + "} " + atomState.format(this.df));
            }
            catch (AtomException atomException) {}
        }
        printStream.println("@vectorlist {O hbonds} color= red");
        for (Peptide peptide : collection) {
            if (peptide.hbondO == null || !peptide.isBeta && this.doBetaAroms) continue;
            try {
                atomState2 = modelState.get(peptide.cRes.getAtom(" O  "));
                atomState = modelState.get(peptide.hbondO.nRes.getAtom(" H  "));
                printStream.println("{" + peptide + "}P " + atomState2.format(this.df));
                printStream.println("{" + peptide.hbondO + "} " + atomState.format(this.df));
            }
            catch (AtomException atomException) {}
        }
    }

    void sketchBetaAroms(PrintStream printStream, ModelState modelState, Map map, Map map2) {
        Triple triple;
        Triple triple2;
        Triple triple3;
        Triple triple4;
        Object object;
        AtomState atomState;
        printStream.println("@group {beta aroms}");
        printStream.println("@balllist {Calphas} radius= 0.3 color= hotpink");
        for (BetaArom betaArom : this.betaAroms) {
            try {
                Iterator iterator = modelState.get(betaArom.aromRes.getAtom(" CA "));
                printStream.println("{" + betaArom + "} " + ((Triple)((Object)iterator)).format(this.df));
            }
            catch (AtomException atomException) {
                System.err.println("Error sketching CA ball for " + betaArom);
            }
        }
        printStream.println("@vectorlist {cross-sheet} color= yellow off");
        for (BetaArom betaArom : this.betaAroms) {
            try {
                for (Residue residue : map.keySet()) {
                    if (!residue.equals(betaArom.aromRes)) continue;
                    atomState = modelState.get(betaArom.aromRes.getAtom(" CA "));
                    object = (SheetAxes2)map.get(residue);
                    triple4 = new Triple().likeSum(atomState, ((SheetAxes2)object).normal.mult(2.0));
                    printStream.println("{normal1+2 unit vector}P " + atomState.format(this.df));
                    printStream.println("{normal1+2 unit vector} " + triple4.format(this.df));
                    triple3 = new Triple().likeSum(atomState, ((SheetAxes2)object).strand.mult(2.0));
                    printStream.println("{strand}P " + atomState.format(this.df));
                    printStream.println("{strand} " + triple3.format(this.df));
                    triple2 = new Triple().likeSum(atomState, ((SheetAxes2)object).zAxis.mult(2.0));
                    printStream.println("{zAxis}P " + atomState.format(this.df));
                    printStream.println("{zAxis} " + triple2.format(this.df));
                    triple = new Triple().likeSum(atomState, ((SheetAxes2)object).cross.mult(2.0));
                    printStream.println("{cross}P " + atomState.format(this.df));
                    printStream.println("{cross} " + triple.format(this.df));
                }
            }
            catch (AtomException atomException) {
                System.err.println("Error sketching SheetAxes2 vectors for " + betaArom);
            }
        }
        printStream.println("@vectorlist {along-sheet} color= sky off");
        for (BetaArom betaArom : this.betaAroms) {
            try {
                for (Residue residue : map2.keySet()) {
                    if (!residue.equals(betaArom.aromRes)) continue;
                    atomState = modelState.get(betaArom.aromRes.getAtom(" CA "));
                    object = (SheetAxes3)map2.get(residue);
                    triple4 = new Triple().likeSum(atomState, ((SheetAxes3)object).normal.mult(2.0));
                    printStream.println("{normal1+2 unit vector}P " + atomState.format(this.df));
                    printStream.println("{normal1+2 unit vector} " + triple4.format(this.df));
                    triple3 = new Triple().likeSum(atomState, ((SheetAxes3)object).strand.mult(2.0));
                    printStream.println("{strand}P " + atomState.format(this.df));
                    printStream.println("{strand} " + triple3.format(this.df));
                    triple2 = new Triple().likeSum(atomState, ((SheetAxes3)object).zAxis.mult(2.0));
                    printStream.println("{zAxis}P " + atomState.format(this.df));
                    printStream.println("{zAxis} " + triple2.format(this.df));
                    triple = new Triple().likeSum(atomState, ((SheetAxes3)object).cross.mult(2.0));
                    printStream.println("{cross}P " + atomState.format(this.df));
                    printStream.println("{cross} " + triple.format(this.df));
                }
            }
            catch (AtomException atomException) {
                System.err.println("Error sketching SheetAxes3 vectors for " + betaArom);
            }
        }
    }

    void sketchNormals1(PrintStream printStream, Map map, ModelState modelState) {
        printStream.println("@arrowlist {6-Calpha} color= magenta radius= 0.25 off");
        for (Residue residue : map.keySet()) {
            Triple triple = (Triple)map.get(residue);
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                Triple triple2 = new Triple(triple).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(this.df));
                printStream.println("{normal: " + triple2.format(this.df) + "} " + triple2.format(this.df));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void sketchNormals2(PrintStream printStream, Map map, ModelState modelState) {
        printStream.println("@arrowlist {cross-sheet} color= lilac radius= 0.25");
        for (Residue residue : map.keySet()) {
            Triple[] tripleArray = (Triple[])map.get(residue);
            Triple triple = tripleArray[0];
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                Triple triple2 = new Triple(triple).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(this.df));
                printStream.println("{cross-sheet normal: " + triple2.format(this.df) + "} " + triple2.format(this.df));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void sketchNormals3(PrintStream printStream, Map map, ModelState modelState) {
        printStream.println("@arrowlist {along-sheet} color= pink radius= 0.25");
        for (Residue residue : map.keySet()) {
            Triple[] tripleArray = (Triple[])map.get(residue);
            Triple triple = tripleArray[0];
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                Triple triple2 = new Triple(triple).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(this.df));
                printStream.println("{along-sheet normal: " + triple2.format(this.df) + "} " + triple2.format(this.df));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void sketchLocalAxes(PrintStream printStream, Map map, ModelState modelState) {
        Triple triple;
        AtomState atomState;
        SheetAxes sheetAxes;
        printStream.println("@group {local axes}");
        printStream.println("@vectorlist {axes} color= brown");
        for (Residue residue : map.keySet()) {
            sheetAxes = (SheetAxes)map.get(residue);
            try {
                atomState = modelState.get(residue.getAtom(" CA "));
                triple = new Triple(sheetAxes.strand).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(this.df));
                printStream.println("{strand}red " + triple.format(this.df));
                triple.like(sheetAxes.cross).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(this.df));
                printStream.println("{cross}green " + triple.format(this.df));
                triple.like(sheetAxes.normal).add(atomState);
                printStream.println("{" + residue + "}P " + atomState.format(this.df));
                printStream.println("{normal}blue " + triple.format(this.df));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        printStream.println("@labellist {angles} color= peach");
        for (Residue residue : map.keySet()) {
            sheetAxes = (SheetAxes)map.get(residue);
            try {
                atomState = modelState.get(residue.getAtom(" CA "));
                triple = new Triple(sheetAxes.strand).add(atomState);
                printStream.println("{strand: " + this.df.format(sheetAxes.angleAlong) + "}red " + triple.format(this.df));
                triple.like(sheetAxes.cross).add(atomState);
                printStream.println("{cross: " + this.df.format(sheetAxes.angleAcross) + "}green " + triple.format(this.df));
                triple.like(sheetAxes.normal).add(atomState);
                printStream.println("{normal: " + this.df.format(sheetAxes.angleNormal) + "}blue " + triple.format(this.df));
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void sketchPlanes(PrintStream printStream, Map map, ModelState modelState) {
        Transform transform = new Transform();
        ArrayList arrayList = new ArrayList(map.keySet());
        Collections.sort(arrayList);
        for (Residue residue : arrayList) {
            SheetAxes sheetAxes = (SheetAxes)map.get(residue);
            printStream.println("@group {" + residue.getCNIT() + "} animate dominant");
            printStream.println("@vectorlist {axes} color= brown");
            try {
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                Triple triple = new Triple();
                for (int i = 0; i < 360; i += 5) {
                    triple.like(sheetAxes.strand).mult(5.0);
                    transform.likeRotation(sheetAxes.normal, i);
                    transform.transformVector(triple);
                    triple.add(atomState);
                    printStream.println("{" + residue + "}P " + atomState.format(this.df));
                    printStream.println("{plane} " + triple.format(this.df));
                }
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    void printNeighborAngles2(PrintStream printStream, String string, Collection collection, Map map) {
        HashMap<Residue, Peptide> hashMap = new HashMap<Residue, Peptide>();
        HashMap<Residue, Peptide> hashMap2 = new HashMap<Residue, Peptide>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, (Peptide)object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, (Peptide)object);
        }
        printStream.println("residue,normal,across,along,next-neighbor?,normal,across,along");
        for (Object object : map.keySet()) {
            SheetAxes sheetAxes = (SheetAxes)map.get(object);
            printStream.print(((Residue)object).getCNIT() + "," + this.df.format(sheetAxes.angleNormal) + "," + this.df.format(sheetAxes.angleAcross) + "," + this.df.format(sheetAxes.angleAlong));
            Peptide peptide = (Peptide)hashMap.get(object);
            SheetAxes sheetAxes2 = (SheetAxes)map.get(peptide.nRes);
            if (peptide.nRes != null && sheetAxes2 != null) {
                printStream.print("," + peptide.nRes.getCNIT() + "," + this.df.format(sheetAxes2.angleNormal) + "," + this.df.format(sheetAxes2.angleAcross) + "," + this.df.format(sheetAxes2.angleAlong));
            }
            printStream.println();
        }
    }

    void printNeighborAngles3(PrintStream printStream, String string, Collection collection, Map map) {
        HashMap<Residue, Peptide> hashMap = new HashMap<Residue, Peptide>();
        HashMap<Residue, Object> hashMap2 = new HashMap<Residue, Object>();
        for (Object object : collection) {
            if (((Peptide)object).cRes != null) {
                hashMap.put(((Peptide)object).cRes, (Peptide)object);
            }
            if (((Peptide)object).nRes == null) continue;
            hashMap2.put(((Peptide)object).nRes, object);
        }
        for (Object object : map.keySet()) {
            SheetAxes sheetAxes = (SheetAxes)map.get(object);
            printStream.print(string + "," + ((Residue)object).getCNIT() + "," + this.df.format(sheetAxes.angleNormal) + "," + this.df.format(sheetAxes.angleAcross) + "," + this.df.format(sheetAxes.angleAlong));
            Peptide peptide = (Peptide)hashMap2.get(object);
            if (peptide.hbondN != null) {
                Residue residue = peptide.isParallelN ? peptide.hbondN.nRes : peptide.hbondN.cRes;
                SheetAxes sheetAxes2 = (SheetAxes)map.get(residue);
                if (residue != null && sheetAxes2 != null) {
                    printStream.print("," + residue.getCNIT() + "," + this.df.format(sheetAxes2.angleNormal) + "," + this.df.format(sheetAxes2.angleAcross) + "," + this.df.format(sheetAxes2.angleAlong));
                }
            }
            printStream.println();
        }
    }

    void printBetaAromStats(PrintStream printStream, Map map, Map map2, Map map3) {
        printStream.println("model,arom_res,arom_restype,opp_res,opp_restype,parallel,chi1,chi2,arom_maxB,opp_maxB,arom_edge,opp_edge,arom_betaN,arom_betaC,opp_betaN,opp_betaC,Caa,Cgba,Cbaa,Nward_Caaaa,Cward_Caaaa,Nward_cross_Caaaa,Cward_cross_Caaaa,aromCaaa,oppCaaa,fray,tilt,phi_i-1,psi_i-1,phi_i,psi_i,phi_i+1,psi_i+1,tau_i-1,tau,tau_i+1,Cab_6CaNormal,Cab_acrossConcav,Cab_alongConcav");
        for (BetaArom betaArom : this.betaAroms) {
            Object object;
            printStream.print(betaArom.modelName + "," + betaArom.aromRes + "," + betaArom.aromRes.getName() + "," + betaArom.oppRes + "," + betaArom.oppRes.getName() + "," + betaArom.parallel + "," + this.df.format(betaArom.chi1) + "," + this.df.format(betaArom.chi2) + "," + this.df.format(betaArom.aromMaxB) + "," + this.df.format(betaArom.oppMaxB) + "," + betaArom.aromEdge + "," + betaArom.oppEdge + "," + betaArom.aromNumBetaResN + "," + betaArom.aromNumBetaResC + "," + betaArom.oppNumBetaResN + "," + betaArom.oppNumBetaResC + "," + this.df.format(betaArom.cacaDist) + "," + this.df.format(betaArom.cgcbcaAngle) + "," + this.df.format(betaArom.cbcacaAngle) + "," + this.df.format(betaArom.nwardTwist) + "," + this.df.format(betaArom.cwardTwist) + "," + this.df.format(betaArom.nwardCrossTwist) + "," + this.df.format(betaArom.cwardCrossTwist) + "," + this.df.format(betaArom.aromCaAngle) + "," + this.df.format(betaArom.oppCaAngle) + "," + this.df.format(betaArom.fray) + "," + this.df.format(betaArom.tilt) + "," + this.df.format(betaArom.aromPrevPhi) + "," + this.df.format(betaArom.aromPrevPsi) + "," + this.df.format(betaArom.aromPhi) + "," + this.df.format(betaArom.aromPsi) + "," + this.df.format(betaArom.aromNextPhi) + "," + this.df.format(betaArom.aromNextPsi) + "," + this.df.format(betaArom.aromPrevTau) + "," + this.df.format(betaArom.aromTau) + "," + this.df.format(betaArom.aromNextTau));
            for (Residue residue : map.keySet()) {
                if (!residue.equals(betaArom.aromRes)) continue;
                object = (SheetAxes)map.get(residue);
                printStream.print("," + this.df.format(((SheetAxes)object).angleNormal));
            }
            for (Residue residue : map2.keySet()) {
                if (!residue.equals(betaArom.aromRes)) continue;
                object = (SheetAxes2)map2.get(residue);
                printStream.print("," + this.df.format(((SheetAxes2)object).cacb_acrossConcavity));
            }
            for (Residue residue : map3.keySet()) {
                if (!residue.equals(betaArom.aromRes)) continue;
                object = (SheetAxes3)map3.get(residue);
                printStream.print("," + this.df.format(((SheetAxes3)object).cacb_alongConcavity));
            }
            printStream.println();
        }
    }

    public void Main() throws IOException {
        CoordinateFile coordinateFile = new PdbReader().read(new File(this.filename));
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        this.processModel(coordinateFile.getIdCode().toLowerCase(), model, modelState);
    }

    public static void main(String[] stringArray) {
        SheetBuilder sheetBuilder = new SheetBuilder();
        try {
            sheetBuilder.parseArguments(stringArray);
            sheetBuilder.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            sheetBuilder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
        if (this.oppNames == null) {
            this.oppNames = new TreeSet();
            Scanner scanner = new Scanner(this.aaNames).useDelimiter(",");
            while (scanner.hasNext()) {
                this.oppNames.add(scanner.next());
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SheetBuilder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SheetBuilder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.SheetBuilder");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename == null) {
            this.filename = string;
        } else {
            System.out.println("Didn't need " + string + "; already have file " + this.filename);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-betaarom")) {
            this.doBetaAroms = true;
        } else if (string.equals("-oppres") || string.equals("-opp")) {
            String[] stringArray;
            if (this.oppNames == null) {
                this.oppNames = new TreeSet();
            }
            for (String string3 : stringArray = Strings.explode(string2, ',')) {
                this.oppNames.add(string3);
            }
        } else if (string.equals("-kin")) {
            this.doKin = true;
        } else if (string.equals("-csv")) {
            this.doKin = false;
        } else if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

