/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Peptide;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.util.Collection;

public class SheetResiduePair {
    public String modelName;
    public Model model;
    public Residue res1;
    public Residue res2;
    boolean parallel;
    String type;
    public int res1NumBetaResN;
    public int res1NumBetaResC;
    public int res2NumBetaResN;
    public int res2NumBetaResC;
    public boolean res1Edge;
    public boolean res2Edge;
    public double cacaDist;
    public double cbcacaAngle;
    public double nwardTwist;
    public double cwardTwist;
    public double nwardCrossTwist;
    public double cwardCrossTwist;
    public double fray;
    public double tilt;
    public double res1CaAngle;
    public double res2CaAngle;

    public SheetResiduePair(Residue residue, Residue residue2, boolean bl, String string, Collection collection, Model model, String string2) {
        this.modelName = string2;
        this.model = model;
        this.res1 = residue;
        this.res2 = residue2;
        this.parallel = bl;
        this.type = string;
        this.res1NumBetaResN = this.numNward(residue, model, collection);
        this.res1NumBetaResC = this.numCward(residue, model, collection);
        this.res2NumBetaResN = this.numNward(residue2, model, collection);
        this.res2NumBetaResC = this.numCward(residue2, model, collection);
        this.res1Edge = this.isEdgeStrand(residue, collection);
        this.res2Edge = this.isEdgeStrand(residue2, collection);
        this.calcGeometry();
    }

    int numNward(Residue residue, Model model, Collection collection) {
        int n = 0;
        boolean bl = false;
        Residue residue2 = residue;
        while (!bl) {
            if (residue2.getPrev(model) != null) {
                if (!this.isBeta(residue2 = residue2.getPrev(model), model, collection)) {
                    bl = true;
                    continue;
                }
                ++n;
                continue;
            }
            bl = true;
        }
        return n;
    }

    int numCward(Residue residue, Model model, Collection collection) {
        int n = 0;
        boolean bl = false;
        Residue residue2 = residue;
        while (!bl) {
            if (residue2.getNext(model) != null) {
                if (!this.isBeta(residue2 = residue2.getNext(model), model, collection)) {
                    bl = true;
                    continue;
                }
                ++n;
                continue;
            }
            bl = true;
        }
        return n;
    }

    boolean isBeta(Residue residue, Model model, Collection collection) {
        Peptide peptide = null;
        Peptide peptide2 = null;
        for (Peptide peptide3 : collection) {
            if (residue.equals(peptide3.nRes)) {
                peptide = peptide3;
            }
            if (!residue.equals(peptide3.cRes)) continue;
            peptide2 = peptide3;
        }
        if (peptide == null || peptide2 == null) {
            return false;
        }
        return peptide.isBeta && peptide2.isBeta;
    }

    boolean isEdgeStrand(Residue residue, Collection collection) {
        Peptide peptide = null;
        Peptide peptide2 = null;
        for (Peptide peptide3 : collection) {
            if (residue.equals(peptide3.nRes)) {
                peptide = peptide3;
            }
            if (!residue.equals(peptide3.cRes)) continue;
            peptide2 = peptide3;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (peptide.hbondN != null || peptide2.hbondO != null) {
            bl = true;
        }
        if (peptide.hbondO != null || peptide2.hbondN != null) {
            bl2 = true;
        }
        return !bl || !bl2;
    }

    public void calcGeometry() {
        Atom atom = this.res1.getAtom(" CA ");
        Atom atom2 = this.res1.getAtom(" CB ");
        Atom atom3 = this.res2.getAtom(" CA ");
        Residue residue = this.res1.getNext(this.model);
        Residue residue2 = this.res1.getPrev(this.model);
        Residue residue3 = this.res2.getNext(this.model);
        Residue residue4 = this.res2.getPrev(this.model);
        Atom atom4 = null;
        if (residue != null) {
            atom4 = residue.getAtom(" CA ");
        }
        Atom atom5 = null;
        if (residue2 != null) {
            atom5 = residue2.getAtom(" CA ");
        }
        Atom atom6 = null;
        if (residue3 != null) {
            atom6 = residue3.getAtom(" CA ");
        }
        Atom atom7 = null;
        if (residue4 != null) {
            atom7 = residue4.getAtom(" CA ");
        }
        ModelState modelState = this.model.getState();
        try {
            this.cacaDist = Triple.distance(modelState.get(atom), modelState.get(atom3));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.cbcacaAngle = Triple.angle(modelState.get(atom2), modelState.get(atom), modelState.get(atom3));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.res1CaAngle = Triple.angle(modelState.get(atom4), modelState.get(atom), modelState.get(atom5));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.res2CaAngle = Triple.angle(modelState.get(atom6), modelState.get(atom3), modelState.get(atom7));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.nwardTwist = Triple.dihedral(modelState.get(atom5), modelState.get(atom), modelState.get(atom3), modelState.get(atom6));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.cwardTwist = Triple.dihedral(modelState.get(atom4), modelState.get(atom), modelState.get(atom3), modelState.get(atom7));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.nwardCrossTwist = Triple.dihedral(modelState.get(atom5), modelState.get(atom), modelState.get(atom3), modelState.get(atom7));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            this.cwardCrossTwist = Triple.dihedral(modelState.get(atom4), modelState.get(atom), modelState.get(atom3), modelState.get(atom6));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        if (this.parallel) {
            double d = this.nwardTwist;
            this.nwardTwist = this.nwardCrossTwist;
            this.nwardCrossTwist = d;
            d = this.cwardTwist;
            this.cwardTwist = this.cwardCrossTwist;
            this.cwardCrossTwist = d;
        }
        if (!(Double.isNaN(this.cwardTwist) || Double.isNaN(this.nwardTwist) || Double.isNaN(this.res1CaAngle) || Double.isNaN(this.res2CaAngle))) {
            this.fray = Math.abs(this.cwardTwist - this.nwardTwist) - Math.abs(this.res1CaAngle - this.res2CaAngle);
        }
        try {
            Triple triple = new Triple().likeNormal(modelState.get(atom5), modelState.get(atom), modelState.get(atom4));
            Triple triple2 = new Triple().likeNormal(modelState.get(atom7), modelState.get(atom3), modelState.get(atom6));
            this.tilt = triple.angle(triple2);
        }
        catch (AtomException atomException) {
            // empty catch block
        }
    }

    public String toString() {
        String string = this.res1.toString();
        string = string + (this.parallel ? " parallel" : " anti-parallel");
        string = string + " (" + this.type + ")" + " to " + this.res2 + " in " + this.modelName;
        return string;
    }
}

