/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.SubImpose;
import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import molikin.logic.BallAndStickLogic;

public class SidechainMainchainSwapper {
    DecimalFormat df = new DecimalFormat("0.0###");
    DecimalFormat df2 = new DecimalFormat("0.0");
    double[] sieves = new double[]{1.0, 0.95, 0.9, 0.85, 0.8, 0.75};
    double mcRadius = Double.POSITIVE_INFINITY;
    double scRadius = 5.0;
    static final String MC_PREV = "mainchain N-ward";
    static final String MC_NEXT = "mainchain C-ward";
    static final String SC = "sidechain";
    String structIn1 = null;
    String structIn2 = null;
    String title1 = null;
    String title2 = null;
    CoordinateFile coord1 = null;
    CoordinateFile coord2 = null;
    BallAndStickLogic bsl = null;
    Model m1min = null;

    public void compareModels(Model model, Model model2, Alignment alignment) {
        System.err.println("mdl1\t" + (this.title1.length() > 7 ? "\t" : "") + "mdl2\t" + (this.title2.length() > 7 ? "\t" : "") + "rmsdglb\tres1\tres2\trmsdnrm\trmsdswp\tswapped");
        this.globalKinemage(model2, alignment, "peach", "sky");
        for (int i = 0; i < alignment.b.length; ++i) {
            double d;
            Residue residue = (Residue)alignment.a[i];
            Residue residue2 = (Residue)alignment.b[i];
            if (residue == null || residue2 == null || !residue.getName().equals("ARG") && !residue.getName().equals("LYS") && !residue.getName().equals("MET") && !residue.getName().equals("GLN") && !residue.getName().equals("GLU") && !residue.getName().equals("ASN") && !residue.getName().equals("ASP") || Double.isNaN(d = this.compareResidues(residue, residue2, model, model2, alignment))) continue;
            this.localSwapKinemage(residue, this.m1min, "white", "cyan", d);
        }
    }

    public double compareResidues(Residue residue, Residue residue2, Model model, Model model2, Alignment alignment) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        this.m1min = null;
        try {
            for (double d4 : this.sieves) {
                Model model3 = (Model)model.clone();
                double d5 = this.globalSup(model3, model2, alignment, d4);
                if (d5 < d) {
                    d = d5;
                }
                double[] dArray = this.localCoCenter(residue, residue2, model3, model2);
                double d6 = dArray[0];
                double d7 = Math.min(dArray[1], dArray[2]);
                if (d6 < d2) {
                    d2 = d6;
                }
                if (!(d7 < d3)) continue;
                d3 = d7;
                this.m1min = model3;
            }
        }
        catch (ParseException parseException) {
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        boolean bl = d3 < d2;
        System.err.println(this.title1 + "\t" + this.title2 + "\t" + this.df.format(d) + "\t" + residue.nickname() + "\t" + residue2.nickname() + "\t" + this.df.format(d2) + "\t" + this.df.format(d3) + "\t" + (bl ? "YES!" : "no"));
        if (bl) {
            return d3;
        }
        return Double.NaN;
    }

    public double globalSup(Model model, Model model2, Alignment alignment, double d) throws AtomException, ParseException {
        ModelState modelState = model.getState();
        ModelState modelState2 = model2.getState();
        AtomState[][] atomStateArray = SubImpose.getAtomsForSelection(model.getResidues(), modelState, model2.getResidues(), modelState2, "atom_CA_", null, alignment, this.coord1, this.coord2);
        if (atomStateArray[0].length < 3) {
            throw new IllegalArgumentException("Can't superimpose on less than 3 atoms!");
        }
        SuperPoser superPoser = new SuperPoser(atomStateArray[1], atomStateArray[0]);
        Transform transform = new Transform();
        transform = superPoser.superpos();
        int n = atomStateArray[0].length;
        int n2 = (int)Math.round(d * (double)atomStateArray[0].length);
        if (n2 < 3) {
            System.err.println("WARNING: too few atoms for Lesk's sieve at " + this.df.format(d));
        } else {
            n = n2;
            SubImpose.sortByLeskSieve(atomStateArray[0], atomStateArray[1]);
            superPoser.reset(atomStateArray[1], 0, atomStateArray[0], 0, n2);
            transform = superPoser.superpos();
        }
        for (AtomState atomState : Model.extractOrderedStatesByName(model)) {
            transform.transform(atomState);
        }
        return superPoser.calcRMSD(transform);
    }

    public void globalKinemage(Model model, Alignment alignment, String string, String string2) {
        System.out.println("@kinemage {" + this.title1 + "." + this.title2 + "}");
        System.out.println("@master {sc ?= mc}");
        System.out.println("@group {" + this.title2 + "} dominant");
        TreeSet<Residue> treeSet = new TreeSet<Residue>();
        for (Residue residue : model.getResidues()) {
            if (residue == null) continue;
            treeSet.add(residue);
        }
        this.bsl.width = 3;
        this.bsl.scColor = string2;
        this.bsl.printKinemage(new PrintWriter(System.out), model, treeSet, this.title2, string);
    }

    public void localSwapKinemage(Residue residue, Model model, String string, String string2, double d) {
        System.out.println("@group {" + residue.nickname() + "  " + this.df2.format(d) + "} dominant animate master= {" + this.title1 + "} master= {" + residue.nickname() + "}");
        this.bsl.scColor = string2;
        this.bsl.width = -1;
        ModelState modelState = model.getState();
        TreeSet<Residue> treeSet = new TreeSet<Residue>();
        for (Residue residue2 : model.getResidues()) {
            try {
                if (residue2 == null || !this.residuesAreClose(residue2, residue, model, modelState, this.mcRadius, false)) continue;
                treeSet.add(residue2);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        this.bsl.doSidechains = false;
        this.bsl.doMainchain = true;
        this.bsl.printKinemage(new PrintWriter(System.out), model, treeSet, this.title1, string);
        treeSet = new TreeSet();
        for (Residue residue2 : model.getResidues()) {
            try {
                if (residue2 == null || !this.residuesAreClose(residue2, residue, model, modelState, this.scRadius, true)) continue;
                treeSet.add(residue2);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        this.bsl.doSidechains = true;
        this.bsl.doMainchain = false;
        this.bsl.printKinemage(new PrintWriter(System.out), model, treeSet, this.title1, string);
        System.out.println("@balllist {sc ?= mc} radius= 0.55 color= green master= {sc ?= mc}");
        try {
            AtomState atomState = modelState.get(residue.getAtom(" CA "));
            System.out.println("{" + residue + " sc ?= mc} " + atomState.getX() + " " + atomState.getY() + " " + atomState.getZ());
        }
        catch (AtomException atomException) {
            System.err.println("error drawing sc ?= mc ball for " + residue);
        }
    }

    public boolean residuesAreClose(Residue residue, Residue residue2, Model model, ModelState modelState, double d, boolean bl) throws AtomException {
        Iterator iterator = residue.getAtoms().iterator();
        while (iterator.hasNext()) {
            AtomState atomState = modelState.get((Atom)iterator.next());
            if (bl && this.isMainchain(atomState.getName())) continue;
            Iterator iterator2 = residue2.getAtoms().iterator();
            while (iterator2.hasNext()) {
                AtomState atomState2 = modelState.get((Atom)iterator2.next());
                if (bl && this.isMainchain(atomState2.getName()) || !(atomState.distance(atomState2) < d)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMainchain(String string) {
        return string.equals(" N  ") || string.equals(" CA ") || string.equals(" C  ") || string.equals(" O  ");
    }

    public double[] localCoCenter(Residue residue, Residue residue2, Model model, Model model2) throws AtomException {
        ModelState modelState = model.getState();
        ModelState modelState2 = model2.getState();
        AtomState atomState = modelState.get(residue.getAtom(" CA "));
        AtomState atomState2 = modelState2.get(residue2.getAtom(" CA "));
        Triple triple = new Triple(atomState2).sub(atomState);
        Object object = Model.extractOrderedStatesByName(model).iterator();
        while (object.hasNext()) {
            AtomState atomState3 = (AtomState)object.next();
            atomState3.add(triple);
        }
        Object object2 = object = (Object)new double[]{0.0, 0.0, 0.0};
        object2[0] = object2[0] + this.calcLocalRmsd(residue, residue2, model, model2, MC_PREV, MC_PREV);
        Object object3 = object;
        object3[0] = object3[0] + this.calcLocalRmsd(residue, residue2, model, model2, MC_NEXT, MC_NEXT);
        Object object4 = object;
        object4[0] = object4[0] / 2.0;
        Object object5 = object;
        object5[1] = object5[1] + this.calcLocalRmsd(residue, residue2, model, model2, MC_PREV, MC_PREV);
        Object object6 = object;
        object6[1] = object6[1] + this.calcLocalRmsd(residue, residue2, model, model2, MC_NEXT, SC);
        Object object7 = object;
        object7[1] = object7[1] + this.calcLocalRmsd(residue, residue2, model, model2, SC, MC_NEXT);
        Object object8 = object;
        object8[1] = object8[1] / 3.0;
        Object object9 = object;
        object9[2] = object9[2] + this.calcLocalRmsd(residue, residue2, model, model2, MC_PREV, SC);
        Object object10 = object;
        object10[2] = object10[2] + this.calcLocalRmsd(residue, residue2, model, model2, MC_NEXT, MC_NEXT);
        Object object11 = object;
        object11[2] = object11[2] + this.calcLocalRmsd(residue, residue2, model, model2, SC, MC_PREV);
        Object object12 = object;
        object12[2] = object12[2] / 3.0;
        return object;
    }

    public double calcLocalRmsd(Residue residue, Residue residue2, Model model, Model model2, String string, String string2) throws AtomException {
        Triple[] tripleArray = null;
        Triple[] tripleArray2 = null;
        Triple[] tripleArray3 = null;
        Triple[] tripleArray4 = null;
        tripleArray = this.getLocalAtoms(residue, model, string, false);
        tripleArray2 = this.getLocalAtoms(residue2, model2, string2, false);
        if (string.equals(SC) && this.isFlippable(residue)) {
            tripleArray3 = this.getLocalAtoms(residue, model, string, true);
        }
        if (string2.equals(SC) && this.isFlippable(residue2)) {
            tripleArray4 = this.getLocalAtoms(residue2, model2, string2, true);
        }
        if (tripleArray == null || tripleArray2 == null) {
            System.err.println("not enough atoms for co-center then rmsd of " + residue + " onto " + residue2);
            return Double.NaN;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        d = this.rmsd(tripleArray, tripleArray2);
        if (tripleArray3 != null) {
            d2 = this.rmsd(tripleArray3, tripleArray2);
        }
        if (tripleArray4 != null) {
            d3 = this.rmsd(tripleArray, tripleArray4);
        }
        if (tripleArray3 != null && tripleArray4 != null) {
            d4 = this.rmsd(tripleArray3, tripleArray4);
        }
        return Math.min(d, Math.min(d2, Math.min(d3, d4)));
    }

    private boolean isFlippable(Residue residue) {
        return residue.getName().equals("ARG") || residue.getName().equals("GLN") || residue.getName().equals("GLU") || residue.getName().equals("ASN") || residue.getName().equals("ASP");
    }

    private double rmsd(Triple[] tripleArray, Triple[] tripleArray2) {
        if (tripleArray.length != tripleArray2.length) {
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = 0; i < tripleArray2.length; ++i) {
            d += Triple.sqDistance(tripleArray2[i], tripleArray[i]);
        }
        d = Math.sqrt(d);
        return d;
    }

    public Triple[] getLocalAtoms(Residue residue, Model model, String string, boolean bl) throws AtomException {
        ModelState modelState = model.getState();
        Triple[] tripleArray = null;
        if (string.equals(SC)) {
            if (residue.getName().equals("ARG")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" CD "))), new Triple(modelState.get(residue.getAtom(" NE "))), new Triple(modelState.get(residue.getAtom(" CZ "))), new Triple(modelState.get(residue.getAtom(" NH1"))), new Triple(modelState.get(residue.getAtom(" NH2")))};
            } else if (residue.getName().equals("LYS")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" CD "))), new Triple(modelState.get(residue.getAtom(" CE "))), new Triple(modelState.get(residue.getAtom(" NZ ")))};
            } else if (residue.getName().equals("MET")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" SD "))), new Triple(modelState.get(residue.getAtom(" CE ")))};
            } else if (residue.getName().equals("GLN")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" CD "))), new Triple(modelState.get(residue.getAtom(" OE1"))), new Triple(modelState.get(residue.getAtom(" NE2")))};
            } else if (residue.getName().equals("GLU")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" CD "))), new Triple(modelState.get(residue.getAtom(" OE1"))), new Triple(modelState.get(residue.getAtom(" OE2")))};
            } else if (residue.getName().equals("ASN")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" OD1"))), new Triple(modelState.get(residue.getAtom(" ND2")))};
            } else if (residue.getName().equals("ASP")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" CB "))), new Triple(modelState.get(residue.getAtom(" CG "))), new Triple(modelState.get(residue.getAtom(" OD1"))), new Triple(modelState.get(residue.getAtom(" OD2")))};
            }
            if (bl) {
                Triple[] tripleArray2 = new Triple[tripleArray.length];
                for (int i = 0; i < tripleArray.length - 2; ++i) {
                    tripleArray2[i] = tripleArray[i];
                }
                tripleArray2[tripleArray.length - 2] = tripleArray[tripleArray.length - 1];
                tripleArray2[tripleArray.length - 1] = tripleArray[tripleArray.length - 2];
                tripleArray = tripleArray2;
            }
        } else if (string.equals(MC_PREV)) {
            Residue residue2 = null;
            Residue residue3 = null;
            residue2 = residue.getPrev(model);
            if (residue2 == null) {
                return null;
            }
            if ((residue.getName().equals("ARG") || residue.getName().equals("LYS")) && (residue3 = residue2.getPrev(model)) == null) {
                return null;
            }
            if (residue.getName().equals("ARG")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" N  "))), new Triple(modelState.get(residue2.getAtom(" C  "))), new Triple(modelState.get(residue2.getAtom(" CA "))), new Triple(modelState.get(residue2.getAtom(" N  "))), new Triple(modelState.get(residue3.getAtom(" C  "))), new Triple(modelState.get(residue3.getAtom(" O  "))), new Triple(modelState.get(residue3.getAtom(" CA ")))};
            } else if (residue.getName().equals("LYS")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" N  "))), new Triple(modelState.get(residue2.getAtom(" C  "))), new Triple(modelState.get(residue2.getAtom(" CA "))), new Triple(modelState.get(residue2.getAtom(" N  "))), new Triple(modelState.get(residue3.getAtom(" C  ")))};
            } else if (residue.getName().equals("MET")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" N  "))), new Triple(modelState.get(residue2.getAtom(" C  "))), new Triple(modelState.get(residue2.getAtom(" CA "))), new Triple(modelState.get(residue2.getAtom(" N  ")))};
            } else if (residue.getName().equals("GLN") || residue.getName().equals("GLU")) {
                Triple triple = new Triple().likeMidpoint(new Triple(modelState.get(residue2.getAtom(residue2.getName().equals("GLY") ? " HA3" : " CB "))), new Triple(modelState.get(residue2.getAtom(residue2.getName().equals("GLY") ? " HA2" : " HA "))));
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" N  "))), new Triple(modelState.get(residue2.getAtom(" C  "))), new Triple(modelState.get(residue2.getAtom(" CA "))), new Triple(modelState.get(residue2.getAtom(" N  "))), triple};
            } else if (residue.getName().equals("ASN") || residue.getName().equals("ASP")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" N  "))), new Triple(modelState.get(residue2.getAtom(" C  "))), new Triple(modelState.get(residue2.getAtom(" O  "))), new Triple(modelState.get(residue2.getAtom(" CA ")))};
            }
        } else if (string.equals(MC_NEXT)) {
            Residue residue4 = null;
            Residue residue5 = null;
            residue4 = residue.getNext(model);
            if (residue4 == null) {
                return null;
            }
            if ((residue.getName().equals("ARG") || residue.getName().equals("LYS")) && (residue5 = residue4.getNext(model)) == null) {
                return null;
            }
            if (residue.getName().equals("ARG")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" C  "))), new Triple(modelState.get(residue4.getAtom(" N  "))), new Triple(modelState.get(residue4.getAtom(" CA "))), new Triple(modelState.get(residue4.getAtom(" C  "))), new Triple(modelState.get(residue5.getAtom(" N  "))), new Triple(modelState.get(residue5.getAtom(residue4.getName().equals("PRO") ? " CD " : " H  "))), new Triple(modelState.get(residue5.getAtom(" CA ")))};
            } else if (residue.getName().equals("LYS")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" C  "))), new Triple(modelState.get(residue4.getAtom(" N  "))), new Triple(modelState.get(residue4.getAtom(" CA "))), new Triple(modelState.get(residue4.getAtom(" C  "))), new Triple(modelState.get(residue5.getAtom(" N  ")))};
            } else if (residue.getName().equals("MET")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" C  "))), new Triple(modelState.get(residue4.getAtom(" N  "))), new Triple(modelState.get(residue4.getAtom(" CA "))), new Triple(modelState.get(residue4.getAtom(" C  ")))};
            } else if (residue.getName().equals("GLN") || residue.getName().equals("GLU")) {
                Triple triple = new Triple().likeMidpoint(new Triple(modelState.get(residue4.getAtom(residue4.getName().equals("GLY") ? " HA3" : " CB "))), new Triple(modelState.get(residue4.getAtom(residue4.getName().equals("GLY") ? " HA2" : " HA "))));
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" C  "))), new Triple(modelState.get(residue4.getAtom(" N  "))), new Triple(modelState.get(residue4.getAtom(" CA "))), new Triple(modelState.get(residue4.getAtom(" C  "))), triple};
            } else if (residue.getName().equals("ASN") || residue.getName().equals("ASP")) {
                tripleArray = new Triple[]{new Triple(modelState.get(residue.getAtom(" CA "))), new Triple(modelState.get(residue.getAtom(" C  "))), new Triple(modelState.get(residue4.getAtom(" N  "))), new Triple(modelState.get(residue4.getAtom(residue4.getName().equals("PRO") ? " CD " : " H  "))), new Triple(modelState.get(residue4.getAtom(" CA ")))};
            }
        } else {
            System.err.println("unrecognized atom selection: " + string);
            return null;
        }
        return tripleArray;
    }

    public void Main() throws IOException {
        if (this.structIn1 == null || this.structIn2 == null) {
            throw new IllegalArgumentException("must provide two structures");
        }
        PdbReader pdbReader = new PdbReader();
        File file = new File(this.structIn1);
        File file2 = new File(this.structIn2);
        this.title1 = file.getName().replace(".pdb", "");
        this.title2 = file2.getName().replace(".pdb", "");
        this.title1 = this.title1.substring(0, Math.min(this.title1.length(), 10));
        this.title2 = this.title2.substring(0, Math.min(this.title2.length(), 10));
        this.coord1 = pdbReader.read(file);
        this.coord2 = pdbReader.read(file2);
        Model model = this.coord1.getFirstModel();
        Model model2 = this.coord2.getFirstModel();
        model.getState().setName(this.title1);
        model2.getState().setName(this.title2);
        Collection collection = SubImpose.getChains(model);
        Collection collection2 = SubImpose.getChains(model2);
        Alignment alignment = Alignment.alignChains(collection, collection2, new Alignment.NeedlemanWunsch(), new SubImpose.SimpleNonWaterResAligner());
        this.bsl = new BallAndStickLogic();
        this.bsl.doProtein = true;
        this.bsl.doMainchain = true;
        this.bsl.doSidechains = true;
        this.bsl.doHydrogens = true;
        this.compareModels(model, model2, alignment);
    }

    public static void main(String[] stringArray) {
        SidechainMainchainSwapper sidechainMainchainSwapper = new SidechainMainchainSwapper();
        try {
            sidechainMainchainSwapper.parseArguments(stringArray);
            sidechainMainchainSwapper.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            sidechainMainchainSwapper.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SidechainMainchainSwapper.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SidechainMainchainSwapper.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("cmdline.SidechainMainchainSwapper");
        System.err.println("Copyright (C) 2010 by Daniel Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.structIn1 == null) {
            this.structIn1 = string;
        } else if (this.structIn2 == null) {
            this.structIn2 = string;
        } else {
            throw new IllegalArgumentException("too many arguments!");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

