/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.Selection;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class SubImpose {
    DecimalFormat df = new DecimalFormat("0.0###");
    DecimalFormat df2 = new DecimalFormat("#0.0##");
    DecimalFormat df3 = new DecimalFormat("0.0###");
    boolean verbose = false;
    boolean showDists = false;
    boolean showTransform = false;
    boolean fix180flips = true;
    String structIn1 = null;
    String structIn2 = null;
    String kinOut = null;
    String pdbOut = null;
    boolean kinStdOut = false;
    boolean pdbStdOut = false;
    String superimpose1 = null;
    String superimpose2 = null;
    String chainIDs1 = null;
    String chainIDs2 = null;
    String alignFilename = null;
    Collection rmsd = new ArrayList();
    double leskSieve = Double.NaN;
    double rmsdCutoff = Double.NaN;
    double rmsdGoal = Double.NaN;
    boolean shuffle = false;
    CoordinateFile coord1 = null;
    CoordinateFile coord2 = null;
    Model m1 = null;
    Model m2 = null;
    ModelState s1 = null;
    ModelState s2 = null;
    Alignment align = null;
    AtomState[][] atoms = null;
    Transform R = null;
    int lenAtomsUsed = 0;

    ModelState fix180rotations(ModelState modelState, ModelState modelState2, Alignment alignment) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        int n = alignment.a.length;
        for (int i = 0; i < n; ++i) {
            if (alignment.a[i] == null || alignment.b[i] == null) continue;
            Residue residue = (Residue)alignment.a[i];
            Residue residue2 = (Residue)alignment.b[i];
            if (!residue.getName().equals(residue2.getName())) continue;
            String string = null;
            if ("PHE".equals(residue.getName())) {
                string = "chi2";
            } else if ("TYR".equals(residue.getName())) {
                string = "chi2";
            } else if ("ASP".equals(residue.getName())) {
                string = "chi2";
            } else {
                if (!"GLU".equals(residue.getName())) continue;
                string = "chi3";
            }
            try {
                double d;
                double d2;
                double d3 = sidechainAngles2.measureAngle(string, residue, modelState) % 360.0;
                if (d3 < 0.0) {
                    d3 += 360.0;
                }
                if ((d2 = sidechainAngles2.measureAngle(string, residue2, modelState2) % 360.0) < 0.0) {
                    d2 += 360.0;
                }
                if ((d = Math.abs(d3 - d2)) > 180.0) {
                    d = 360.0 - d;
                }
                if (!(d > 90.0)) continue;
                modelState = sidechainAngles2.setAngle(string, residue, modelState, d3 - 180.0);
                if (!this.verbose) continue;
                System.err.println("Flipped " + string + " for " + residue + "; " + decimalFormat.format(d3) + " - " + decimalFormat.format(d2) + " = " + decimalFormat.format(d) + "; " + decimalFormat.format(d3) + " --> " + decimalFormat.format(sidechainAngles2.measureAngle(string, residue, modelState)));
                continue;
            }
            catch (AtomException atomException) {
                System.err.println("Unable to flip " + string + " for " + residue + ": " + atomException.getMessage());
            }
        }
        return modelState.createCollapsed();
    }

    private void readAlignmentFile() throws IOException {
        int n;
        Object object;
        Object object2;
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        ArrayList<Residue> arrayList2 = new ArrayList<Residue>();
        FileInputStream fileInputStream = new FileInputStream(this.alignFilename);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            object2 = null;
            object = null;
            n = Integer.MIN_VALUE;
            int n2 = Integer.MIN_VALUE;
            try {
                if (string.equals("")) continue;
                String[] stringArray = Strings.explode(string, ',');
                if (stringArray.length != 4 && stringArray.length != 2) {
                    throw new IllegalArgumentException("Format for user-provided alignment file: chain1,resnum1,chain2,resnum2 per line");
                }
                n = Integer.parseInt(stringArray[1]);
                n2 = Integer.parseInt(stringArray[3]);
                if (stringArray.length == 4) {
                    object2 = stringArray[0];
                    object = stringArray[2];
                }
                if (object2 == null || object2.length() > 2 || object == null || ((String)object).length() > 2) {
                    throw new IllegalArgumentException("Format for user-provided alignment file: chain1,resnum1,chain2,resnum2 per line");
                }
                Residue residue = null;
                Residue residue2 = null;
                for (Residue residue3 : this.m1.getResidues()) {
                    if (stringArray.length == 4) {
                        if (object2 == null || !residue3.getChain().equals(object2) || n == Integer.MIN_VALUE || residue3.getSequenceInteger() != n) continue;
                        residue = residue3;
                        break;
                    }
                    if (n == Integer.MIN_VALUE || residue3.getSequenceInteger() != n) continue;
                    residue = residue3;
                    break;
                }
                for (Residue residue3 : this.m2.getResidues()) {
                    if (stringArray.length == 4) {
                        if (object == null || !residue3.getChain().equals(object) || n2 == Integer.MIN_VALUE || residue3.getSequenceInteger() != n2) continue;
                        residue2 = residue3;
                        break;
                    }
                    if (n2 == Integer.MIN_VALUE || residue3.getSequenceInteger() != n2) continue;
                    residue2 = residue3;
                    break;
                }
                if (residue != null && residue2 != null) {
                    arrayList.add(residue);
                    arrayList2.add(residue2);
                    continue;
                }
                throw new IllegalArgumentException("Can't find residues corresponding to " + string + "!");
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Can't parse number in " + string + "!");
            }
        }
        object2 = new Residue[arrayList.size()];
        object = new Residue[arrayList2.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            object2[n] = arrayList.get(n);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object[n] = arrayList2.get(n);
        }
        if (((Residue[])object2).length != ((Residue[])object).length) {
            throw new IllegalArgumentException("Different lengths for 2 sides of manual alignment!");
        }
        this.align.a = object2;
        this.align.b = object;
    }

    public static Collection getChains(Model model) {
        return SubImpose.getChains(model, null);
    }

    public static Collection getChains(Model model, String string) {
        ArrayList<Set> arrayList = new ArrayList<Set>();
        for (String string2 : model.getChainIDs()) {
            if (string != null && string.indexOf(string2) == -1) continue;
            arrayList.add(model.getChain(string2));
        }
        return arrayList;
    }

    public static AtomState[][] getAtomsForSelection(Collection collection, ModelState modelState, Collection collection2, ModelState modelState2, String string, String string2, Alignment alignment, CoordinateFile coordinateFile, CoordinateFile coordinateFile2) throws ParseException {
        Object object;
        Object object2;
        AtomState atomState;
        Iterator iterator2;
        AtomState[][] atomStateArray;
        Cloneable cloneable22;
        Selection selection = Selection.fromString(string);
        Collection collection3 = Model.extractOrderedStatesByName(collection, Collections.singleton(modelState));
        selection.init(collection3, coordinateFile);
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        for (Cloneable cloneable22 : collection3) {
            if (!selection.select((AtomState)cloneable22)) continue;
            arrayList.add(cloneable22);
        }
        int n = 0;
        cloneable22 = new ArrayList();
        if (string2 != null) {
            atomStateArray = Selection.fromString(string2);
            iterator2 = Model.extractOrderedStatesByName(collection2, Collections.singleton(modelState2));
            atomStateArray.init((Collection)((Object)iterator2), coordinateFile2);
            Iterator iterator3 = iterator2.iterator();
            while (iterator3.hasNext()) {
                atomState = (AtomState)iterator3.next();
                if (!atomStateArray.select(atomState)) continue;
                cloneable22.add(atomState);
                ++n;
            }
        } else {
            atomStateArray = new HashMap();
            for (int i = 0; i < alignment.a.length; ++i) {
                if (alignment.a[i] == null) continue;
                atomStateArray.put(alignment.a[i], alignment.b[i]);
            }
            for (AtomState atomState2 : arrayList) {
                atomState = null;
                object2 = (Residue)atomStateArray.get(atomState2.getResidue());
                if (object2 != null && (object = ((Residue)object2).getAtom(atomState2.getName())) != null) {
                    try {
                        atomState = modelState2.get((Atom)object);
                        ++n;
                    }
                    catch (AtomException atomException) {
                        atomException.printStackTrace();
                    }
                }
                cloneable22.add(atomState);
            }
        }
        if (arrayList.size() != cloneable22.size() || n > arrayList.size()) {
            throw new RuntimeException("logical error; sel1=" + arrayList.size() + ", sel2=" + cloneable22.size() + ", matched=" + n);
        }
        atomStateArray = new AtomState[2][n];
        iterator2 = arrayList.iterator();
        Iterator iterator = cloneable22.iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            object2 = (AtomState)iterator2.next();
            object = (AtomState)iterator.next();
            if (object == null) continue;
            atomStateArray[0][n2] = object2;
            atomStateArray[1][n2] = object;
            ++n2;
        }
        if (n2 != n) {
            throw new RuntimeException("logical error; idx=" + n2 + ", matched=" + n);
        }
        return atomStateArray;
    }

    AtomState[][] permuteAtoms() {
        int n;
        Tuple3[] tuple3Array;
        int n2;
        double d = Double.POSITIVE_INFINITY;
        int n3 = this.atoms[0].length;
        int[] nArray = new int[n3];
        int[] nArray2 = null;
        int[] nArray3 = new int[n3];
        int[] nArray4 = null;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = n2;
            nArray3[n2] = n2;
        }
        n2 = 0;
        do {
            tuple3Array = new AtomState[n3];
            for (n = 0; n < n3; ++n) {
                tuple3Array[n] = this.atoms[0][nArray[n]];
            }
            if (!this.validPermutation((AtomState[])tuple3Array)) continue;
            do {
                Tuple3[] tuple3Array2 = new AtomState[n3];
                for (int i = 0; i < n3; ++i) {
                    tuple3Array2[i] = this.atoms[1][nArray3[i]];
                }
                if (!this.validPermutation((AtomState[])tuple3Array2)) continue;
                ++n2;
                SuperPoser superPoser = new SuperPoser(tuple3Array2, tuple3Array);
                this.R = superPoser.superpos();
                double d2 = superPoser.calcRMSD(this.R);
                if (!(d2 < d)) continue;
                d = d2;
                nArray2 = (int[])nArray.clone();
                nArray4 = (int[])nArray3.clone();
            } while (SubImpose.next_permutation(nArray3));
        } while (SubImpose.next_permutation(nArray));
        if (this.verbose) {
            System.err.println("Tried " + n2 + " permutation(s); " + "best rmsd: " + this.df.format(d));
        }
        tuple3Array = new AtomState[2][n3];
        for (n = 0; n < n3; ++n) {
            tuple3Array[0][n] = this.atoms[0][nArray2[n]];
            tuple3Array[1][n] = this.atoms[1][nArray4[n]];
        }
        return tuple3Array;
    }

    private boolean validPermutation(AtomState[] atomStateArray) {
        for (int i = 0; i < atomStateArray.length - 1; ++i) {
            Residue residue = atomStateArray[i].getAtom().getResidue();
            Residue residue2 = atomStateArray[i + 1].getAtom().getResidue();
            if (residue.getSequenceInteger() <= residue2.getSequenceInteger()) continue;
            return false;
        }
        return true;
    }

    private static boolean next_permutation(int[] nArray) {
        if (nArray.length <= 1) {
            return false;
        }
        int n = nArray.length - 1;
        do {
            int n2;
            if (nArray[n] >= nArray[n2 = n--]) continue;
            int n3 = nArray.length;
            while (nArray[n] >= nArray[--n3]) {
            }
            int n4 = nArray[n];
            nArray[n] = nArray[n3];
            nArray[n3] = n4;
            SubImpose.reverse(nArray, n2, nArray.length);
            return true;
        } while (n != 0);
        SubImpose.reverse(nArray, 0, nArray.length);
        return false;
    }

    private static void reverse(int[] nArray, int n, int n2) {
        int n3 = n;
        for (int i = n2 - 1; n3 < i; ++n3, --i) {
            int n4 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n4;
        }
    }

    public static void sortByLeskSieve(Tuple3[] tuple3Array, Tuple3[] tuple3Array2) {
        SuperPoser superPoser = new SuperPoser(tuple3Array, tuple3Array2);
        Triple triple = new Triple();
        for (int i = tuple3Array.length; i > 0; --i) {
            superPoser.reset(tuple3Array, 0, tuple3Array2, 0, i);
            Transform transform = superPoser.superpos();
            double d = superPoser.calcRMSD(transform);
            int n = -1;
            double d2 = -1.0;
            for (int j = 0; j < i; ++j) {
                transform.transform(tuple3Array2[j], triple);
                double d3 = triple.sqDistance(tuple3Array[j]);
                if (!(d3 > d2)) continue;
                d2 = d3;
                n = j;
            }
            Tuple3 tuple3 = tuple3Array[i - 1];
            tuple3Array[i - 1] = tuple3Array[n];
            tuple3Array[n] = tuple3;
            tuple3 = tuple3Array2[i - 1];
            tuple3Array2[i - 1] = tuple3Array2[n];
            tuple3Array2[n] = tuple3;
        }
    }

    void writeKin() throws IOException {
        PrintStream printStream = null;
        printStream = this.kinOut != null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.kinOut))) : new PrintStream(System.out);
        if (printStream == null) {
            throw new IOException("*** Error writing kinemage!");
        }
        printStream.println("@kinemage");
        printStream.println("@group {correspondances} dominant");
        printStream.println("@vectorlist {pairs} color= green");
        for (int i = 0; i < this.lenAtomsUsed; ++i) {
            AtomState atomState = this.atoms[0][i];
            AtomState atomState2 = this.atoms[1][i];
            printStream.println("{" + atomState + "}P " + this.df3.format(atomState.getX()) + " " + this.df3.format(atomState.getY()) + " " + this.df3.format(atomState.getZ()));
            printStream.println("{" + atomState2 + "}L " + this.df3.format(atomState2.getX()) + " " + this.df3.format(atomState2.getY()) + " " + this.df3.format(atomState2.getZ()));
        }
        printStream.close();
    }

    public void writePdb() throws IOException {
        PdbWriter pdbWriter = null;
        pdbWriter = this.pdbOut != null ? new PdbWriter(new File(this.pdbOut)) : new PdbWriter(System.out);
        if (pdbWriter == null) {
            throw new IOException("*** Error writing PDB!");
        }
        pdbWriter.writeCoordinateFile(this.coord1);
        pdbWriter.close();
    }

    double rms(AtomState[] atomStateArray, AtomState[] atomStateArray2) {
        double d = 0.0;
        int n = atomStateArray.length;
        Triple triple = new Triple();
        for (int i = 0; i < n; ++i) {
            triple.likeDiff(atomStateArray[i], atomStateArray2[i]);
            d += triple.mag2();
        }
        return Math.sqrt(d / (double)n);
    }

    public void doSuperposition() throws IOException, ParseException {
        int n;
        if (this.superimpose1 == null) {
            this.superimpose1 = "atom_CA_";
            if (this.verbose) {
                System.err.print("No -super flag; using sequence-aligned CAs");
            }
            if (!Double.isNaN(this.rmsdGoal)) {
                if (this.verbose) {
                    System.err.println(" (sieve to " + this.rmsdGoal + "A rmsd)");
                }
                if (!Double.isNaN(this.leskSieve)) {
                    System.err.println("Using -rmsdgoal=" + this.rmsdGoal + " instead of -sieve=" + this.leskSieve);
                }
            } else if (Double.isNaN(this.leskSieve)) {
                if (this.verbose) {
                    System.err.println(" (no sieve)");
                } else if (this.verbose) {
                    System.err.println(" (best " + this.leskSieve * 100.0 + "%)");
                }
            }
        }
        if (this.alignFilename != null && this.superimpose2 != null) {
            System.err.print("Ignoring -super2 flag because alignment file provided");
            this.superimpose2 = null;
        }
        if (this.chainIDs1 != null) {
            System.err.println("Using subset of structure 1 chains: " + this.chainIDs1);
        }
        if (this.chainIDs2 != null) {
            System.err.println("Using subset of structure 2 chains: " + this.chainIDs2);
        }
        this.align = Alignment.alignChains(SubImpose.getChains(this.m1, this.chainIDs1), SubImpose.getChains(this.m2, this.chainIDs2), new Alignment.NeedlemanWunsch(), new SimpleNonWaterResAligner());
        if (this.align.a.length == 0) {
            System.err.println("No good chain-to-chain alignment; using chain-break-crossing method");
            this.align = Alignment.needlemanWunsch(this.m1.getResidues().toArray(), this.m2.getResidues().toArray(), new SimpleNonWaterResAligner());
        }
        if (this.alignFilename != null) {
            try {
                this.readAlignmentFile();
            }
            catch (IOException iOException) {
                System.err.println("Error reading alignment file: " + this.alignFilename + "!" + "  Using default automatic sequence alignment");
            }
        }
        if (this.verbose) {
            System.err.println("Residue alignments:");
            for (int i = 0; i < this.align.a.length; ++i) {
                System.err.println("  " + this.align.a[i] + " <==> " + this.align.b[i]);
            }
            System.err.println();
        }
        if (this.fix180flips) {
            this.s1 = this.fix180rotations(this.s1, this.s2, this.align);
        }
        this.R = new Transform();
        this.atoms = SubImpose.getAtomsForSelection(this.m1.getResidues(), this.s1, this.m2.getResidues(), this.s2, this.superimpose1, this.superimpose2, this.align, this.coord1, this.coord2);
        if (this.shuffle) {
            System.err.println("Shuffling intra-residue atoms");
            this.permuteAtoms();
        }
        if (this.verbose) {
            System.err.println("Atom alignments:");
            for (int i = 0; i < this.atoms[0].length; ++i) {
                System.err.println("  " + this.atoms[0][i] + " <==> " + this.atoms[1][i]);
            }
            System.err.println();
        }
        if (this.atoms[0].length < 3) {
            throw new IllegalArgumentException("Can't superimpose on less than 3 atoms!");
        }
        SuperPoser superPoser = new SuperPoser(this.atoms[1], this.atoms[0]);
        this.R = superPoser.superpos();
        System.err.println("rmsd\tn_atoms\tselection");
        System.err.println(this.df.format(superPoser.calcRMSD(this.R)) + "\t" + this.atoms[0].length + "\t" + this.superimpose1);
        this.lenAtomsUsed = this.atoms[0].length;
        if (!Double.isNaN(this.rmsdGoal)) {
            n = 0;
            while (superPoser.calcRMSD(this.R) > this.rmsdGoal) {
                ++n;
                SubImpose.sortByLeskSieve(this.atoms[0], this.atoms[1]);
                int n2 = this.atoms[0].length - 1;
                AtomState[][] atomStateArray = new AtomState[2][n2];
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        atomStateArray[i][j] = this.atoms[i][j];
                    }
                }
                this.atoms = atomStateArray;
                if (this.atoms[0].length < 3) {
                    throw new IllegalArgumentException("Can't achieve rmsd goal of " + this.rmsdGoal + "A .. would have to trim to < 3 atoms!");
                }
                superPoser.reset(this.atoms[1], this.atoms[0]);
                this.R = superPoser.superpos();
            }
            System.err.println(this.df.format(superPoser.calcRMSD(this.R)) + "\t" + this.atoms[0].length + "\t" + this.superimpose1 + "  [sieve #" + n + "]");
        } else if (!Double.isNaN(this.leskSieve)) {
            n = (int)Math.round(this.leskSieve * (double)this.atoms[0].length);
            if (n < 3) {
                System.err.println("WARNING: too few atoms for Lesk's sieve at " + this.df.format(this.leskSieve));
            } else {
                this.lenAtomsUsed = n;
                SubImpose.sortByLeskSieve(this.atoms[0], this.atoms[1]);
                superPoser.reset(this.atoms[1], 0, this.atoms[0], 0, n);
                this.R = superPoser.superpos();
                System.err.println(this.df.format(superPoser.calcRMSD(this.R)) + "\t" + n + "\t" + this.superimpose1 + "  [sieve = " + this.df.format(this.leskSieve) + "]");
            }
        }
        for (AtomState atomState : Model.extractOrderedStatesByName(this.m1)) {
            this.R.transform(atomState);
        }
        if (!Double.isNaN(this.rmsdCutoff)) {
            if (superPoser.calcRMSD(this.R) > this.rmsdCutoff) {
                System.err.println("No further output b/c RMSD=" + this.df.format(superPoser.calcRMSD(this.R)) + " > cutoff=" + this.rmsdCutoff);
                this.atoms = null;
                return;
            }
            System.err.println("Proceeding with output b/c RMSD=" + this.df.format(superPoser.calcRMSD(this.R)) + " <= cutoff=" + this.rmsdCutoff);
        }
    }

    public void doRmsd() throws ParseException {
        for (String string : this.rmsd) {
            this.atoms = SubImpose.getAtomsForSelection(this.m1.getResidues(), this.s1, this.m2.getResidues(), this.s2, string, null, this.align, this.coord1, this.coord2);
            if (this.verbose) {
                System.err.println("Atom alignments:");
                for (int i = 0; i < this.atoms[0].length; ++i) {
                    System.err.println("  " + this.atoms[0][i] + " <==> " + this.atoms[1][i]);
                }
                System.err.println();
            }
            System.out.println(this.df.format(this.rms(this.atoms[1], this.atoms[0])) + "\t" + this.atoms[0].length + "\t" + string);
        }
    }

    public void Main() throws IOException, ParseException {
        if (this.structIn1 == null || this.structIn2 == null) {
            throw new IllegalArgumentException("must provide two structures");
        }
        PdbReader pdbReader = new PdbReader();
        this.coord1 = pdbReader.read(new File(this.structIn1));
        this.coord2 = pdbReader.read(new File(this.structIn2));
        this.m1 = this.coord1.getFirstModel();
        this.m2 = this.coord2.getFirstModel();
        this.s1 = this.m1.getState();
        this.s2 = this.m2.getState();
        this.doSuperposition();
        if (this.atoms == null) {
            if (!this.showTransform && !this.showDists && this.rmsd.isEmpty() && this.kinOut == null && !this.kinStdOut && this.pdbOut == null) {
                System.err.println("WARNING: You'll still get empty files if you use 'subimpose > outfile'!\nUse 'subimpose -pdb=outfile' to be safe!");
            }
            return;
        }
        if (this.showTransform) {
            System.out.println("Transformation matrix (premult, Rx -> x'):\n" + this.R);
        } else if (this.showDists) {
            for (int i = 0; i < this.atoms[0].length; ++i) {
                System.out.println(this.atoms[0][i].getAtom() + "," + this.atoms[1][i].getAtom() + "," + this.df2.format(Triple.distance(this.atoms[0][i], this.atoms[1][i])));
            }
        } else if (!this.rmsd.isEmpty()) {
            this.doRmsd();
        } else if (this.kinOut != null || this.kinStdOut) {
            this.writeKin();
        } else {
            this.writePdb();
        }
    }

    public static void main(String[] stringArray) {
        SubImpose subImpose = new SubImpose();
        try {
            subImpose.parseArguments(stringArray);
            subImpose.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            subImpose.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SubImpose.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SubImpose.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.SubImpose");
        System.err.println("Copyright (C) 2007 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.structIn1 == null) {
            this.structIn1 = string;
        } else if (this.structIn2 == null) {
            this.structIn2 = string;
        } else {
            throw new IllegalArgumentException("too many arguments!");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-t")) {
            this.showTransform = true;
        } else if (string.equals("-d")) {
            this.showDists = true;
        } else if (string.equals("-noscflip")) {
            this.fix180flips = false;
        } else if (string.equals("-chains1") || string.equals("-chain1") || string.equals("-chains") || string.equals("-chain")) {
            this.chainIDs1 = string2;
        } else if (string.equals("-chains2") || string.equals("-chain2")) {
            this.chainIDs2 = string2;
        } else if (string.equals("-super1") || string.equals("-super")) {
            this.superimpose1 = string2;
        } else if (string.equals("-super2")) {
            this.superimpose2 = string2;
        } else if (string.equals("-pdb")) {
            if (string2 == null) {
                this.pdbStdOut = true;
            } else {
                this.pdbOut = string2;
            }
        } else if (string.equals("-kin")) {
            if (string2 == null) {
                this.kinStdOut = true;
            } else {
                this.kinOut = string2;
            }
        } else if (string.equals("-rms")) {
            if (string2 == null) {
                throw new IllegalArgumentException("-rms must be followed by a number!");
            }
            this.rmsd.add(string2);
        } else if (string.equals("-sieve")) {
            try {
                this.leskSieve = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
            if (this.leskSieve <= 0.0 || this.leskSieve > 1.0) {
                throw new IllegalArgumentException("value for -sieve out of range (0,1]");
            }
        } else if (string.equals("-rmsdgoal") || string.equals("-rmsdtarget")) {
            try {
                this.rmsdGoal = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
            if (Double.isNaN(this.rmsdGoal) || this.rmsdGoal < 0.0) {
                System.err.println("Problem with " + string2 + " as param for -rmsdgoal");
            }
        } else if (string.equals("-rmsdcutoff") || string.equals("-rmsdmax")) {
            try {
                this.rmsdCutoff = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
            if (Double.isNaN(this.rmsdCutoff) || this.rmsdCutoff < 0.0) {
                System.err.println("Problem with " + string2 + " as param for -rmsdcutoff");
            }
        } else if (string.equals("-align")) {
            this.alignFilename = string2;
        } else if (string.equals("-shuffle")) {
            this.shuffle = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class StructureBasedAligner
    implements Alignment.Scorer {
        StructureBasedAligner() {
        }

        public boolean atomsAreEquivalant(AtomState atomState, AtomState atomState2) {
            if (atomState.getName().equals(atomState2.getName())) {
                return true;
            }
            if (atomState.getName().equals(" H  ") && atomState2.getName().equals(" CD ") || atomState.getName().equals(" HA ") && atomState2.getName().equals(" HA2") || atomState.getName().equals(" HA ") && atomState2.getName().equals("1HA ") || atomState.getName().equals(" CB ") && atomState2.getName().equals(" HA3") || atomState.getName().equals(" CB ") && atomState2.getName().equals("2HA ")) {
                return true;
            }
            return atomState.getName().equals(" CD ") && atomState2.getName().equals(" H  ") || atomState.getName().equals(" HA2") && atomState2.getName().equals(" HA ") || atomState.getName().equals("1HA ") && atomState2.getName().equals(" HA ") || atomState.getName().equals(" HA3") && atomState2.getName().equals(" CB ") || atomState.getName().equals("2HA ") && atomState2.getName().equals(" CB ");
        }

        public double score(Object object, Object object2) {
            AtomState atomState = (AtomState)object;
            AtomState atomState2 = (AtomState)object2;
            if (atomState == null || atomState2 == null) {
                return -1.0;
            }
            if (!this.atomsAreEquivalant(atomState, atomState2)) {
                return 0.0;
            }
            if (atomState.distance(atomState2) > 2.0) {
                return 0.0;
            }
            if (atomState.distance(atomState2) <= 2.0 && atomState.distance(atomState2) > 1.0) {
                return 1.0;
            }
            if (atomState.distance(atomState2) <= 1.0 && atomState.distance(atomState2) > 0.5) {
                return 2.0;
            }
            if (atomState.distance(atomState2) <= 0.5) {
                return 3.0;
            }
            System.err.println("Not sure how to score " + atomState + " vs. " + atomState2 + "!");
            return 0.0;
        }

        public double open_gap(Object object) {
            return this.extend_gap(object);
        }

        public double extend_gap(Object object) {
            return this.score(object, null);
        }
    }

    public static class SimpleNonWaterResAligner
    extends SimpleResAligner {
        public double score(Object object, Object object2) {
            Residue residue = (Residue)object;
            Residue residue2 = (Residue)object2;
            if (residue.getName().equals("HOH") || residue2.getName().equals("HOH")) {
                return -1.0;
            }
            if (residue.getName().equals(residue2.getName())) {
                return 4.0;
            }
            return -1.0;
        }

        public double open_gap(Object object) {
            return -8.0;
        }

        public double extend_gap(Object object) {
            return -2.0;
        }
    }

    public static class SimpleResAligner
    implements Alignment.Scorer {
        public double score(Object object, Object object2) {
            Residue residue = (Residue)object;
            Residue residue2 = (Residue)object2;
            if (residue.getName().equals(residue2.getName())) {
                return 4.0;
            }
            return -1.0;
        }

        public double open_gap(Object object) {
            return -8.0;
        }

        public double extend_gap(Object object) {
            return -2.0;
        }
    }
}

