/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import chiropraxis.mc.SubImpose;
import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.moldb2.Selection;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import molikin.logic.BallAndStickLogic;
import molikin.logic.Logic;

public class SupKitchen {
    DecimalFormat df = new DecimalFormat("###0.00");
    DecimalFormat df2 = new DecimalFormat("###0.0");
    DecimalFormat df3 = new DecimalFormat("#0.00");
    public final String SELECT_CA = "(atom_CA_)";
    public final String SELECT_BB_HEAVY = "(atom_CA_|atom_N__|atom_C__|atom_O__)";
    public final String SELECT_BB_HEAVY_H = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_H__)";
    public final String SELECT_BB_HEAVY_CB = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_CB_)";
    public final String SELECT_BB_HEAVY_CB_H = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_CB_|atom_H__)";
    boolean verbose = false;
    String mdlFilename;
    File mdlDir;
    File mdlFile;
    String refFilename;
    File refFile;
    String title;
    String superimpose = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_H__)";
    boolean distort = true;
    double rmsdMax = -1.0;
    double rmsdLesk = 5.0;
    boolean splitChains = true;
    CoordinateFile refCoordFile;
    CoordinateFile[] mdlCoordFiles;
    CoordinateFile ensemCoordFile;
    Map ensemAtoms;
    Map rmsds;
    HashSet<AtomState> intersection;
    int nAtoms;
    int mEnsem;
    int maxEnsemSize = 50;
    ArrayList pcaAtoms;
    CoordinateFile pcaCoordFile;
    double scale = 1.0;
    int[] pcChoice;
    int roundsOfMinimization = 0;
    boolean kinOut = true;
    boolean append = false;
    String color;
    Logic[] logicList;
    String pdbsDirname;
    int bins = 5;

    public SupKitchen() {
        this.prepLogic();
    }

    public void prepLogic() {
        BallAndStickLogic ballAndStickLogic = new BallAndStickLogic();
        ballAndStickLogic.doProtein = true;
        ballAndStickLogic.doNucleic = true;
        ballAndStickLogic.doHets = true;
        ballAndStickLogic.doMetals = true;
        ballAndStickLogic.doWater = true;
        ballAndStickLogic.doVirtualBB = true;
        ballAndStickLogic.doMainchain = true;
        ballAndStickLogic.doSidechains = true;
        ballAndStickLogic.doHydrogens = true;
        ballAndStickLogic.doDisulfides = true;
        ballAndStickLogic.doBallsOnCarbon = false;
        ballAndStickLogic.doBallsOnAtoms = false;
        ballAndStickLogic.colorBy = BallAndStickLogic.COLOR_BY_MC_SC;
        this.logicList = new Logic[1];
        this.logicList[0] = ballAndStickLogic;
    }

    public String getTitle() {
        return this.title;
    }

    public double getRmsdLesk() {
        return this.rmsdLesk;
    }

    public CoordinateFile getEnsemCoordFile() {
        return this.ensemCoordFile;
    }

    public CoordinateFile getPcaCoordFile() {
        return this.pcaCoordFile;
    }

    public double getScale() {
        return this.scale;
    }

    public int getMaxEnsemSize() {
        return this.maxEnsemSize;
    }

    public void setRefFilename(String string) {
        this.refFilename = string;
    }

    public void setMdlFilename(String string) {
        this.mdlFilename = string;
    }

    public void setSuperimpose(String string) {
        this.superimpose = string;
    }

    public void setRmsdLesk(double d) {
        this.rmsdLesk = d;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public void setMaxEnsemSize(int n) {
        this.maxEnsemSize = n;
    }

    public void setDistort(boolean bl) {
        this.distort = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void makeSup() throws IOException {
        if (this.mdlFilename == null) {
            throw new IllegalArgumentException("*** Must provide models dir or file!");
        }
        File file = new File(this.mdlFilename);
        if (file.isDirectory()) {
            this.readMdlDir(file, this.splitChains);
        } else {
            this.readMdlFile(file, this.splitChains);
        }
        if (this.refFilename == null) {
            this.pickAdHocRefFile();
        } else {
            this.refFile = new File(this.refFilename);
        }
        this.readRefFile(this.refFile);
        Model model = this.refCoordFile.getFirstModel();
        if (model.getChainIDs().size() > 1) {
            throw new IllegalArgumentException("*** Ref (model 1 from " + this.refFile + ") has > 1 chain .. sup will be bad .. exiting!");
        }
        String[] stringArray = Strings.explode(this.refCoordFile.getFile().getName(), '/');
        String string = stringArray[stringArray.length - 1];
        model.getState().setName(string.substring(0, string.indexOf(".pdb")));
        String string2 = (String)this.refCoordFile.getFirstModel().getChainIDs().iterator().next();
        if (string2.equals(" ")) {
            string2 = "_";
        }
        String string3 = this.refFile.getName().replaceAll(".pdb", "") + string2;
        String string4 = (this.mdlFile != null ? this.mdlFile.getName() : this.mdlDir.getName()).replaceAll(".pdb", "");
        this.title = string4 + "." + string3;
        System.err.println("Making \"" + this.title + "\"");
        int n = 0;
        model.setName("" + n);
        this.ensemCoordFile = new CoordinateFile();
        this.ensemCoordFile.setIdCode(this.title);
        this.ensemCoordFile.add(model);
        this.ensemAtoms = new HashMap();
        this.rmsds = new HashMap();
        System.err.println("rmsd\tn_atoms\tselection\tmodel");
        for (int i = 0; i < this.mdlCoordFiles.length; ++i) {
            CoordinateFile coordinateFile = this.mdlCoordFiles[i];
            if (coordinateFile.getModels().size() != 0) {
                String string5;
                String string6 = coordinateFile.getFile().getName();
                if (string6.equals(string5 = this.refCoordFile.getFile().getName())) {
                    System.err.println("Skipping additional model from ref file: " + string5);
                    continue;
                }
                Iterator iterator = coordinateFile.getModels().iterator();
                while (iterator.hasNext() && n < this.maxEnsemSize - 1) {
                    Model model2 = (Model)iterator.next();
                    stringArray = Strings.explode(coordinateFile.getFile().getName(), '/');
                    string = stringArray[stringArray.length - 1];
                    String string7 = string.substring(0, string.indexOf(".pdb"));
                    model2.getState().setName(string7);
                    if (this.refDupl(model2, model)) {
                        System.err.println("Model " + model2.getState().getName() + " " + model2 + " is duplicate of ref " + model.getState().getName() + " " + model + " .. leaving out");
                        continue;
                    }
                    try {
                        AtomState[][] atomStateArray = this.sup(model2, model, coordinateFile);
                        if (atomStateArray == null) continue;
                        model2.setName("" + ++n);
                        this.ensemCoordFile.add(model2);
                        this.ensemAtoms.put(model2, atomStateArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println(illegalArgumentException.getMessage());
                    }
                }
                if (!iterator.hasNext() || n != this.maxEnsemSize - 1) continue;
                System.err.println("Ensemble has reached max size (" + this.maxEnsemSize + " members) - skipping the rest!");
                break;
            }
            System.err.println("Skipping: " + coordinateFile + " because no models found");
        }
        if (this.ensemAtoms.keySet().size() == 0) {
            System.err.println("No models left after superposition & trimming/pruning!");
            throw new IOException("No models left after superposition & trimming/pruning!");
        }
        this.mEnsem = this.ensemAtoms.keySet().size() + 1;
        this.intersect();
        if (this.splitChains) {
            this.trimEnsem();
        }
        System.err.println("M = " + this.mEnsem + "\tmodels");
        System.err.println("N = " + this.nAtoms + "\tatoms");
        if (this.nAtoms == 0) {
            System.err.println("Everything was trimmed!  Try a more similar set of structures.");
            System.exit(1);
        }
    }

    public Collection splitChains(CoordinateFile coordinateFile) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Model model : coordinateFile.getModels()) {
            for (String string : model.getChainIDs()) {
                Model model2 = (Model)model.clone();
                for (Residue residue : model.getResidues()) {
                    if (residue.getChain().equals(string) || !model2.contains(residue)) continue;
                    try {
                        model2.remove(residue);
                    }
                    catch (ResidueException residueException) {
                        System.err.println("*** Error removing " + residue + " from new chain" + string + " model!");
                    }
                }
                CoordinateFile coordinateFile2 = new CoordinateFile();
                coordinateFile2.add(model2);
                arrayList.add(coordinateFile2);
            }
        }
        return arrayList;
    }

    public boolean chainIsProt(CoordinateFile coordinateFile) {
        int n = 0;
        int n2 = 0;
        for (Residue residue : coordinateFile.getFirstModel().getResidues()) {
            if ("GLY:ALA:VAL:PHE:PRO:MET:MSE:ILE:LEU:ASP:GLU:LYS:ARG:SER:THR:TYR:HIS:CYS:ASN:GLN:TRP".indexOf(residue.getName()) != -1) {
                ++n;
                continue;
            }
            ++n2;
        }
        return n > n2;
    }

    public void pickAdHocRefFile() {
        if (this.mdlFile != null) {
            this.refFile = this.mdlFile;
        } else {
            File[] fileArray = this.mdlDir.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file = fileArray[i];
                    if (file.getName().indexOf(".pdb") == -1) continue;
                    this.refFile = file;
                    if (!this.verbose) break;
                    System.err.println("Picked " + file + " as ad hoc ref");
                    break;
                }
            }
        }
    }

    public boolean refDupl(Model model, Model model2) {
        AtomState atomState;
        Object object22;
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        ModelState modelState = model.getState();
        for (Object object22 : model.getResidues()) {
            for (Atom object3 : ((Residue)object22).getAtoms()) {
                try {
                    AtomState atomState2 = modelState.get(object3);
                    arrayList.add(atomState2);
                }
                catch (AtomException atomException) {
                    System.err.println("Can't find state for " + object3 + "!");
                }
            }
        }
        ArrayList arrayList2 = new ArrayList();
        object22 = model2.getState();
        for (Residue residue : model2.getResidues()) {
            for (Object object : residue.getAtoms()) {
                try {
                    atomState = ((ModelState)object22).get((Atom)object);
                    arrayList2.add(atomState);
                }
                catch (AtomException atomException) {
                    System.err.println("Can't find state for " + object + "!");
                }
            }
        }
        for (AtomState atomState3 : arrayList) {
            Object object;
            boolean bl = false;
            object = arrayList2.iterator();
            while (object.hasNext()) {
                atomState = (AtomState)object.next();
                if (!atomState3.equals(atomState)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public AtomState[][] sup(Model model, Model model2, CoordinateFile coordinateFile) throws IllegalArgumentException {
        if (this.verbose) {
            System.err.println("\nSuperposing model" + model + " (" + SubImpose.getChains(model, null).size() + " chains) onto model" + model2 + " (" + SubImpose.getChains(model2, null).size() + " chains)");
        }
        ModelState modelState = model.getState();
        ModelState modelState2 = model2.getState();
        Alignment alignment = Alignment.alignChains(SubImpose.getChains(model, null), SubImpose.getChains(model2, null), new Alignment.NeedlemanWunsch(), new SubImpose.SimpleResAligner());
        if (alignment.a.length == 0) {
            alignment = Alignment.needlemanWunsch(model.getResidues().toArray(), model2.getResidues().toArray(), new SubImpose.SimpleResAligner());
        }
        if (this.verbose) {
            System.err.println("Residue alignments:");
            for (int i = 0; i < alignment.a.length; ++i) {
                System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
            }
            System.err.println();
        }
        try {
            int n;
            int n2;
            AtomState[][] atomStateArray;
            AtomState[][] atomStateArray2 = this.getAtomsForSelection(model.getResidues(), modelState, model2.getResidues(), modelState2, this.superimpose, alignment, coordinateFile);
            if (this.verbose) {
                System.err.println("Atom alignments:");
                for (int i = 0; i < atomStateArray2[0].length; ++i) {
                    System.err.println("  " + atomStateArray2[0][i] + " <==> " + atomStateArray2[1][i]);
                }
                System.err.println();
            }
            if (atomStateArray2[0].length < 3) {
                throw new IllegalArgumentException("Can't superimpose on less than 3 atoms!");
            }
            SuperPoser superPoser = new SuperPoser(atomStateArray2[1], atomStateArray2[0]);
            Transform transform = new Transform();
            transform = superPoser.superpos();
            ArrayList<AtomState> arrayList = null;
            if (this.rmsdLesk >= 0.0) {
                arrayList = new ArrayList<AtomState>();
                int n3 = 0;
                System.err.println(this.df.format(superPoser.calcRMSD(transform)) + "\t" + atomStateArray2[0].length + "\t[Lesk's sieve start]");
                while (superPoser.calcRMSD(transform) > this.rmsdLesk) {
                    ++n3;
                    SubImpose.sortByLeskSieve(atomStateArray2[0], atomStateArray2[1]);
                    int n4 = atomStateArray2[0].length - 1;
                    arrayList.add(atomStateArray2[1][n4]);
                    atomStateArray = new AtomState[2][n4];
                    for (n2 = 0; n2 < 2; ++n2) {
                        for (n = 0; n < n4; ++n) {
                            atomStateArray[n2][n] = atomStateArray2[n2][n];
                        }
                    }
                    atomStateArray2 = atomStateArray;
                    if (atomStateArray2[0].length < 3) {
                        throw new IllegalArgumentException("Can't achieve target rmsd of " + this.rmsdLesk + "A .. would have to trim to < 3 atoms!");
                    }
                    superPoser.reset(atomStateArray2[1], atomStateArray2[0]);
                    transform = superPoser.superpos();
                    this.rmsds.put(model, superPoser.calcRMSD(transform));
                    System.err.println(this.df.format(superPoser.calcRMSD(transform)) + "\t" + atomStateArray2[0].length + "\t[Lesk's sieve #" + n3 + "]");
                }
            } else {
                if (this.rmsdMax >= 0.0 && superPoser.calcRMSD(transform) > this.rmsdMax) {
                    System.err.println(this.df.format(superPoser.calcRMSD(transform)) + "\t" + atomStateArray2[0].length + "\t" + this.superimpose + "\t" + model.getState().getName() + "\t" + " rmsd>" + this.rmsdMax + "A - skip");
                    return null;
                }
                this.rmsds.put(model, superPoser.calcRMSD(transform));
                System.err.println(this.df.format(superPoser.calcRMSD(transform)) + "\t" + atomStateArray2[0].length + "\t" + this.superimpose + "\t" + model.getState().getName());
            }
            for (AtomState atomState : Model.extractOrderedStatesByName(model)) {
                transform.transform(atomState);
            }
            AtomState[][] atomStateArray3 = this.getAtomsForSelection(model.getResidues(), modelState, model2.getResidues(), modelState2, this.superimpose, alignment, coordinateFile);
            if (arrayList == null || arrayList.size() == 0) {
                return atomStateArray3;
            }
            int n5 = atomStateArray3[0].length - arrayList.size();
            atomStateArray = new AtomState[2][n5];
            for (n2 = 0; n2 < 2; ++n2) {
                for (n = 0; n < atomStateArray[0].length; ++n) {
                    if (arrayList.contains(atomStateArray3[n2][n])) continue;
                    atomStateArray[n2][n] = atomStateArray3[n2][n];
                }
            }
            return atomStateArray;
        }
        catch (ParseException parseException) {
            System.err.println("*** Error parsing atom selection: '" + this.superimpose + "' for superposing model: " + model + " onto ref: " + model2);
            return null;
        }
    }

    AtomState[][] getAtomsForSelection(Collection collection, ModelState modelState, Collection collection2, ModelState modelState2, String string, Alignment alignment, CoordinateFile coordinateFile) throws ParseException {
        Object object;
        Object object2;
        Selection selection = Selection.fromString(string);
        Collection collection3 = Model.extractOrderedStatesByName(collection, Collections.singleton(modelState));
        selection.init(collection3, coordinateFile);
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        for (AtomState atomState : collection3) {
            if (!selection.select(atomState)) continue;
            arrayList.add(atomState);
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < alignment.a.length; ++i) {
            if (alignment.a[i] == null) continue;
            hashMap.put(alignment.a[i], alignment.b[i]);
        }
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        for (AtomState object32 : arrayList) {
            object2 = null;
            Residue n2 = (Residue)hashMap.get(object32.getResidue());
            if (n2 != null && (object = n2.getAtom(object32.getName())) != null) {
                try {
                    object2 = modelState2.get((Atom)object);
                    ++n;
                }
                catch (AtomException atomState) {
                    atomState.printStackTrace();
                }
            }
            arrayList2.add(object2);
        }
        if (arrayList.size() != arrayList2.size() || n > arrayList.size()) {
            throw new RuntimeException("logical error; sel1=" + arrayList.size() + ", sel2=" + arrayList2.size() + ", matched=" + n);
        }
        AtomState[][] atomStateArray = new AtomState[2][n];
        Iterator iterator = arrayList.iterator();
        object2 = arrayList2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            object = (AtomState)iterator.next();
            AtomState atomState = (AtomState)object2.next();
            if (atomState == null) continue;
            atomStateArray[0][n2] = object;
            atomStateArray[1][n2] = atomState;
            ++n2;
        }
        if (n2 != n) {
            throw new RuntimeException("logical error; idx=" + n2 + ", matched=" + n);
        }
        return atomStateArray;
    }

    public void intersect() {
        int n;
        Object object222;
        HashSet<AtomState> hashSet = new HashSet<AtomState>();
        for (Object object222 : this.ensemAtoms.keySet()) {
            AtomState[][] object3 = (AtomState[][])this.ensemAtoms.get(object222);
            for (n = 0; n < object3[1].length; ++n) {
                hashSet.add(object3[1][n]);
            }
        }
        HashSet hashSet2 = new HashSet();
        this.intersection = hashSet;
        for (AtomState atomState : this.intersection) {
            n = 1;
            for (Model model : this.ensemAtoms.keySet()) {
                AtomState[][] atomStateArray = (AtomState[][])this.ensemAtoms.get(model);
                boolean bl = false;
                for (int i = 0; i < atomStateArray[1].length; ++i) {
                    AtomState atomState2 = atomStateArray[1][i];
                    if (atomState2 == null || !atomState2.equals(atomState)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                n = 0;
            }
            if (n != 0) continue;
            hashSet2.add(atomState);
        }
        object222 = hashSet2.iterator();
        while (object222.hasNext()) {
            AtomState atomState = (AtomState)object222.next();
            this.intersection.remove(atomState);
        }
        this.nAtoms = this.intersection.size();
        if (this.verbose) {
            System.err.println("\nintersection (" + this.nAtoms + " atoms):");
            object222 = new ArrayList();
            Iterator<AtomState> iterator = this.intersection.iterator();
            while (iterator.hasNext()) {
                System.err.println("  " + iterator.next());
            }
        }
    }

    public void trimEnsem() {
        System.err.println("Trimming ensemble...");
        for (Model model : this.ensemAtoms.keySet()) {
            AtomState[][] atomStateArray = (AtomState[][])this.ensemAtoms.get(model);
            atomStateArray = this.trimAlignment(atomStateArray, model);
            this.ensemAtoms.put(model, atomStateArray);
            if (this.verbose) {
                System.err.println("\npost-trim alignment:");
                for (int i = 0; i < atomStateArray[0].length; ++i) {
                    System.err.println("  " + atomStateArray[0][i] + " <==> " + atomStateArray[1][i]);
                }
            }
            AtomState[] atomStateArray2 = atomStateArray[0];
            Model model2 = this.trimModel(model, atomStateArray2);
            this.ensemCoordFile.replace(model, model2);
            if (!this.verbose) continue;
            System.err.println("\npost-trim residues:");
            Iterator iterator = model2.getResidues().iterator();
            while (iterator.hasNext()) {
                System.err.println("  " + (Residue)iterator.next());
            }
        }
    }

    public AtomState[][] trimAlignment(AtomState[][] atomStateArray, Model model) {
        ModelState modelState = model.getState();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int i = 0; i < atomStateArray[1].length; ++i) {
            AtomState atomState = atomStateArray[1][i];
            boolean bl = false;
            for (AtomState atomState2 : this.intersection) {
                if (!atomState2.equals(atomState)) continue;
                bl = true;
            }
            if (!bl) continue;
            treeSet.add(i);
        }
        AtomState[][] atomStateArray2 = new AtomState[2][treeSet.size()];
        int n = 0;
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            atomStateArray2[0][n] = atomStateArray[0][n2];
            atomStateArray2[1][n] = atomStateArray[1][n2];
            ++n;
        }
        return atomStateArray2;
    }

    public Model trimModel(Model model, AtomState[] atomStateArray) {
        TreeSet<Residue> treeSet = new TreeSet<Residue>();
        for (int i = 0; i < atomStateArray.length; ++i) {
            Iterator iterator = atomStateArray[i].getAtom();
            Residue residue = ((Atom)((Object)iterator)).getResidue();
            treeSet.add(residue);
        }
        TreeSet<Residue> treeSet2 = new TreeSet<Residue>();
        for (Residue residue : model.getResidues()) {
            boolean bl = false;
            for (Residue residue2 : treeSet) {
                if (!residue2.getCNIT().equals(residue.getCNIT())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            treeSet2.add(residue);
        }
        for (Residue residue : treeSet2) {
            try {
                model.remove(residue);
            }
            catch (ResidueException residueException) {
                System.err.println("*** Error removing " + residue + " from model " + model);
            }
        }
        return model;
    }

    public void doPca() {
        System.err.println("Starting PCA on PCs " + Strings.arrayInParens(this.pcChoice));
        double[][] dArray = this.buildX();
        Matrix matrix = new Matrix(dArray);
        if (this.verbose) {
            System.err.print("Input X matrix:");
            matrix.print(new PrintWriter(System.err, true), new DecimalFormat("#.####"), 1);
        }
        if (this.verbose) {
            System.err.println("Doing SVD now");
        }
        SingularValueDecomposition singularValueDecomposition = new SingularValueDecomposition(matrix);
        Matrix matrix2 = singularValueDecomposition.getU();
        Matrix matrix3 = singularValueDecomposition.getS();
        if (this.verbose) {
            System.err.print("SVD output U Matrix:");
            matrix2.print(new PrintWriter(System.err, true), new DecimalFormat("#.####"), 1);
            System.err.print("SVD output S matrix:");
            matrix3.print(new PrintWriter(System.err, true), new DecimalFormat("#.####"), 1);
        }
        if (Double.isNaN(this.scale)) {
            this.scale = 1.0;
        }
        double[] dArray2 = this.avgPc(matrix2, matrix3);
        this.pcaCoordFile = new CoordinateFile();
        this.pcaCoordFile.setIdCode(this.title + "_PCA");
        double d = 1.0;
        int n = 1;
        int n2 = 10;
        System.err.println("Distorting ensemble via weighted-average PC...");
        for (double d2 = -1.0 * d; d2 <= d; d2 += 2.0 * d / (double)n2) {
            if (this.verbose) {
                System.err.print("  moving along weighted-average PC x " + this.df2.format(d2));
            }
            try {
                Model model = this.applyPcToRefModel(dArray2, d2, n);
                if (model != null) {
                    this.pcaCoordFile.add(model);
                }
            }
            catch (IOException iOException) {
                System.err.println("*** Error opening ref file: " + this.refFile.getName() + "!");
            }
            if (this.verbose) {
                System.err.println(" .. done");
            }
            ++n;
        }
    }

    public double[][] buildX() {
        Object object;
        int n;
        Object object2;
        if (this.verbose) {
            System.err.println("Building X matrix for PCA");
        }
        double[][] dArray = new double[3 * this.nAtoms][this.mEnsem];
        int n2 = 0;
        Iterator iterator = this.ensemAtoms.keySet().iterator();
        if (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            if (this.verbose) {
                System.err.println("Adding to X : ref   model" + model);
            }
            AtomState[][] atomStateArray = (AtomState[][])this.ensemAtoms.get(model);
            this.pcaAtoms = new ArrayList();
            object2 = new ArrayList();
            for (n = 0; n < atomStateArray[0].length; ++n) {
                if (((ArrayList)object2).size() >= 3 * this.nAtoms - 2 || atomStateArray[0][n] == null || atomStateArray[1][n] == null) continue;
                AtomState atomState = atomStateArray[1][n];
                object = atomState.getAtom();
                this.pcaAtoms.add(atomState);
                ((ArrayList)object2).add(atomStateArray[1][n].getX());
                ((ArrayList)object2).add(atomStateArray[1][n].getY());
                ((ArrayList)object2).add(atomStateArray[1][n].getZ());
            }
            for (n = 0; n < ((ArrayList)object2).size(); ++n) {
                dArray[n][n2] = (Double)((ArrayList)object2).get(n);
            }
            ++n2;
        }
        for (AtomState[][] atomStateArray : this.ensemAtoms.keySet()) {
            int n3;
            if (this.verbose) {
                System.err.println("Adding to X : ensem model" + atomStateArray);
            }
            object2 = (AtomState[][])this.ensemAtoms.get(atomStateArray);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            for (n3 = 0; n3 < object2[0].length; ++n3) {
                if (arrayList.size() >= 3 * this.nAtoms - 2 || object2[0][n3] == null || object2[1][n3] == null) continue;
                object = object2[1][n3];
                Atom atom = ((AtomState)object).getAtom();
                arrayList.add(((Triple)object2[0][n3]).getX());
                arrayList.add(((Triple)object2[0][n3]).getY());
                arrayList.add(((Triple)object2[0][n3]).getZ());
            }
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                dArray[n3][n2] = (Double)arrayList.get(n3);
            }
            ++n2;
        }
        if (this.verbose) {
            System.err.println("Making displacement vectors for X matrix");
        }
        for (int i = 0; i < 3 * this.nAtoms; ++i) {
            double d = 0.0;
            for (n = 0; n < this.mEnsem; ++n) {
                d += dArray[i][n];
            }
            d /= (double)this.mEnsem;
            for (n = 0; n < this.mEnsem; ++n) {
                dArray[i][n] = dArray[i][n] - d;
            }
        }
        return dArray;
    }

    public double[] avgPc(Matrix matrix, Matrix matrix2) {
        double[] dArray = new double[this.pcaAtoms.size() + 2];
        for (int i = 0; i < this.pcaAtoms.size(); ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int j = 0; j < this.pcChoice.length; ++j) {
                int n = this.pcChoice[j] - 1;
                d += matrix.get(i, n) * matrix2.get(n, n) * this.scale;
                d2 += matrix.get(i + 1, n) * matrix2.get(n, n) * this.scale;
                d3 += matrix.get(i + 2, n) * matrix2.get(n, n) * this.scale;
            }
            dArray[i] = d / (double)this.pcChoice.length;
            dArray[i + 1] = d2 / (double)this.pcChoice.length;
            dArray[i + 2] = d3 / (double)this.pcChoice.length;
        }
        return dArray;
    }

    public Model applyPcToRefModel(double[] dArray, double d, int n) throws IOException {
        Object object;
        Object object2;
        AtomState[] atomStateArray = new AtomState[this.intersection.size()];
        int n2 = 0;
        Object object3 = this.intersection.iterator();
        while (object3.hasNext()) {
            atomStateArray[n2] = object3.next();
            ++n2;
        }
        object3 = SupKitchen.readPdb(this.refFile);
        CoordinateFile coordinateFile = SupKitchen.readPdb(this.refFile);
        Model model = this.trimModel(((CoordinateFile)object3).getFirstModel(), atomStateArray);
        Model model2 = this.trimModel(coordinateFile.getFirstModel(), atomStateArray);
        model.setName("" + n);
        model2.setName("" + n);
        for (int i = 0; i < this.pcaAtoms.size(); ++i) {
            object2 = (AtomState)this.pcaAtoms.get(i);
            object = new Triple(d * dArray[i], d * dArray[i + 1], d * dArray[i + 2]);
            model = this.applyPcToAtom(model, (AtomState)object2, (Triple)object);
        }
        if (this.distort) {
            return model;
        }
        ModelState modelState = model.getState();
        object2 = model2.getState();
        object = Alignment.alignChains(SubImpose.getChains(model, null), SubImpose.getChains(model2, null), new Alignment.NeedlemanWunsch(), new SubImpose.SimpleResAligner());
        try {
            AtomState[][] atomStateArray2 = this.getAtomsForSelection(model.getResidues(), modelState, model2.getResidues(), (ModelState)object2, this.superimpose, (Alignment)object, (CoordinateFile)object3);
            SuperPoser superPoser = new SuperPoser(atomStateArray2[0], atomStateArray2[1]);
            Transform transform = new Transform();
            transform = superPoser.superpos();
            for (AtomState atomState : Model.extractOrderedStatesByName(model2)) {
                transform.transform(atomState);
            }
            return model2;
        }
        catch (ParseException parseException) {
            System.err.println("*** Error parsing atom selection: '" + this.superimpose + "' for superposing model: " + model2 + " onto ref: " + model);
            return null;
        }
    }

    public Model applyPcToAtom(Model model, AtomState atomState, Triple triple) {
        Atom atom = atomState.getAtom();
        String string = atom.getName();
        Residue residue = atom.getResidue();
        int n = residue.getSequenceInteger();
        String string2 = residue.getName();
        String string3 = residue.getChain();
        ModelState modelState = model.getState();
        for (Residue residue2 : model.getResidues()) {
            if (residue2.getSequenceInteger() != n || !residue2.getName().equals(string2) || !residue2.getChain().equals(string3)) continue;
            for (Atom atom2 : residue2.getAtoms()) {
                if (!atom2.getName().equals(string)) continue;
                try {
                    AtomState atomState2 = modelState.get(atom2);
                    atomState2.setX(atomState2.getX() + triple.getX());
                    atomState2.setY(atomState2.getY() + triple.getY());
                    atomState2.setZ(atomState2.getZ() + triple.getZ());
                }
                catch (AtomException atomException) {
                    System.err.println("*** Error extracting coords for " + atom2 + "!");
                }
            }
        }
        return model;
    }

    void minimizeBackbone() {
        System.err.println("\n*** Backbone minimization not yet implemented! ***\n");
        System.exit(1);
    }

    public void readMdlDir(File file, boolean bl) {
        this.mdlDir = file;
        this.mdlFile = null;
        File[] fileArray = this.mdlDir.listFiles();
        int n = fileArray.length;
        if (fileArray != null) {
            int n2;
            ArrayList<CoordinateFile> arrayList = new ArrayList<CoordinateFile>();
            for (n2 = 0; n2 < n; ++n2) {
                File file2 = fileArray[n2];
                if (file2.getName().indexOf(".pdb") != -1) {
                    try {
                        CoordinateFile coordinateFile = SupKitchen.readPdb(file2);
                        if (bl) {
                            for (CoordinateFile coordinateFile2 : this.splitChains(coordinateFile)) {
                                if (!this.chainIsProt(coordinateFile2)) continue;
                                coordinateFile2.setFile(file2);
                                arrayList.add(coordinateFile2);
                            }
                        } else {
                            coordinateFile.setFile(file2);
                            arrayList.add(coordinateFile);
                        }
                        System.err.println("Extracted model coords from " + coordinateFile.getFile().getName());
                    }
                    catch (IOException iOException) {
                        System.err.println("*** Error reading model .pdb:" + file2.getName() + "!");
                    }
                    continue;
                }
                System.err.println("Ignoring non-.pdb file: " + file2.getName());
            }
            this.mdlCoordFiles = new CoordinateFile[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.mdlCoordFiles[n2] = (CoordinateFile)arrayList.get(n2);
            }
        } else {
            System.err.println("Nothing in selected models dir: " + this.mdlDir);
        }
    }

    public void readMdlFile(File file, boolean bl) {
        this.mdlDir = null;
        this.mdlFile = file;
        if (this.mdlFile.getName().indexOf(".pdb") != -1) {
            try {
                ArrayList<CoordinateFile> arrayList = new ArrayList<CoordinateFile>();
                CoordinateFile coordinateFile = SupKitchen.readPdb(this.mdlFile);
                System.err.println("Found " + coordinateFile.getModels().size() + " models in " + coordinateFile.toString());
                if (bl) {
                    for (CoordinateFile coordinateFile2 : this.splitChains(coordinateFile)) {
                        if (!this.chainIsProt(coordinateFile2)) continue;
                        coordinateFile2.setFile(this.mdlFile);
                        arrayList.add(coordinateFile2);
                    }
                } else {
                    coordinateFile.setFile(this.mdlFile);
                    arrayList.add(coordinateFile);
                }
                this.mdlCoordFiles = new CoordinateFile[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.mdlCoordFiles[i] = (CoordinateFile)arrayList.get(i);
                }
                System.err.println("Extracted model coords from " + coordinateFile.getFile().getName());
            }
            catch (IOException iOException) {
                System.err.println("*** Error reading models .pdb:" + this.mdlFile.getName() + "!");
            }
        } else {
            System.err.println("Selected models file not a .pdb: " + this.mdlFile.toString());
        }
    }

    public static CoordinateFile readPdb(File file) throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(file);
        return coordinateFile;
    }

    public void readRefFile(File file) {
        if (file.getName().indexOf(".pdb") != -1) {
            try {
                CoordinateFile coordinateFile = SupKitchen.readPdb(file);
                System.err.println("Extracted ref coords from " + coordinateFile.getFile().getName());
                this.refCoordFile = this.pickRefChain(coordinateFile);
                this.refCoordFile.setFile(file);
            }
            catch (IOException iOException) {
                System.err.println("*** Error reading ref .pdb: " + file.getName() + "!");
            }
        } else {
            System.err.println("Selected ref file not a .pdb: " + file.toString());
        }
    }

    public CoordinateFile pickRefChain(CoordinateFile coordinateFile) {
        String string;
        CoordinateFile coordinateFile2;
        int n;
        ArrayList arrayList = (ArrayList)this.splitChains(coordinateFile);
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("No chains found in ref file " + this.refFile + "!");
        }
        CoordinateFile coordinateFile3 = null;
        String string2 = null;
        for (n = 0; n < arrayList.size(); ++n) {
            coordinateFile2 = (CoordinateFile)arrayList.get(n);
            if (!this.chainIsProt(coordinateFile2)) continue;
            string = (String)coordinateFile2.getFirstModel().getChainIDs().iterator().next();
            if (string.equals(" ")) {
                coordinateFile3 = coordinateFile2;
                string2 = string;
            }
            if (string.equals("A")) {
                coordinateFile3 = coordinateFile2;
                string2 = string;
            }
            if (!string.equals("_")) continue;
            coordinateFile3 = coordinateFile2;
            string2 = string;
        }
        if (coordinateFile3 == null) {
            for (n = 0; n < arrayList.size(); ++n) {
                coordinateFile2 = (CoordinateFile)arrayList.get(n);
                string = (String)coordinateFile2.getFirstModel().getChainIDs().iterator().next();
                if (!this.chainIsProt(coordinateFile2)) continue;
                coordinateFile3 = coordinateFile2;
                string2 = string;
            }
        }
        if (coordinateFile3 != null) {
            System.err.print("Using chain '" + string2 + "' from ref " + coordinateFile.getFile().getName());
            if (arrayList.size() > 1) {
                System.err.print(" - there was/were " + (arrayList.size() - 1) + " other(s)");
            }
            System.err.println();
            return coordinateFile3;
        }
        throw new IllegalArgumentException("*** Error: Ref file contains no protein chains - aborting!");
    }

    public PrintWriter writeKin(PrintWriter printWriter, CoordinateFile coordinateFile, String string) {
        if (!this.append) {
            printWriter.println("@kinemage {" + string + "}");
        }
        printWriter.println("@onewidth");
        String string2 = "models";
        printWriter.println("@master {" + string2 + "}");
        String string3 = "ref model";
        printWriter.println("@master {" + string3 + "}");
        Logic logic = this.logicList[0];
        for (Model model : coordinateFile.getModels()) {
            if (this.append && model.getName().equals("0")) continue;
            String string4 = model.getName();
            if (model.getState().getName().indexOf("null") == -1) {
                string4 = string4 + " " + model.getState().getName() + (String)model.getChainIDs().iterator().next();
            }
            if (model.getName().equals("0")) {
                printWriter.println("@group {" + string4 + "} dominant master= {" + string3 + "}");
            } else {
                printWriter.println("@group {" + string4 + "} dominant animate master= {" + string2 + "}");
            }
            for (String string5 : model.getChainIDs()) {
                String string6 = string5.equals(" ") ? "_" : string5;
                printWriter.println("@subgroup {chain" + string5 + "} dominant master= {chain" + string6 + "}");
                String string7 = null;
                string7 = model.getName().equals("0") ? "yellowtint" : (this.color != null ? this.color : "white");
                logic.printKinemage(printWriter, model, model.getChain(string5), string4, string7);
            }
        }
        printWriter.flush();
        return printWriter;
    }

    public void writePdb(PrintStream printStream, CoordinateFile coordinateFile) {
        PrintWriter printWriter = new PrintWriter(printStream);
        PdbWriter pdbWriter = new PdbWriter(printWriter);
        pdbWriter.writeCoordinateFile(coordinateFile, new HashMap());
        printWriter.flush();
        pdbWriter.close();
    }

    public void writePdbs(CoordinateFile coordinateFile) {
        File file = new File(this.pdbsDirname);
        if (!file.exists()) {
            boolean bl = new File(this.pdbsDirname).mkdir();
            if (bl) {
                System.err.println("Created " + this.pdbsDirname + "/");
            } else {
                System.err.println("ERROR: Couldn't create output PDBs directory: " + this.pdbsDirname + "/");
                System.exit(1);
            }
        }
        for (Model model : coordinateFile.getModels()) {
            if (this.refCoordFile.getFile().getName().indexOf(model.getState().getName()) != -1) {
                System.err.println("Skipping model from ref file: " + model.getState().getName());
                continue;
            }
            CoordinateFile coordinateFile2 = new CoordinateFile();
            coordinateFile2.add(model);
            String string = this.pdbsDirname + "/" + model.getState().getName() + "_" + model.getName() + ".pdb";
            File file2 = new File(string);
            try {
                System.err.println("Writing to " + string);
                PrintWriter printWriter = new PrintWriter(file2);
                PdbWriter pdbWriter = new PdbWriter(printWriter);
                pdbWriter.writeCoordinateFile(coordinateFile2, new HashMap());
                printWriter.flush();
                pdbWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error writing ensemble PDBs to " + string);
            }
            catch (IOException iOException) {
                System.err.println("Error writing ensemble PDBs to " + string);
            }
        }
    }

    public double[] getRmsdBins(CoordinateFile coordinateFile) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (Model model : coordinateFile.getModels()) {
            if (!this.rmsds.keySet().contains(model)) continue;
            arrayList.add((Double)this.rmsds.get(model));
        }
        Collections.sort(arrayList);
        double d = (Double)arrayList.get(arrayList.size() - 1) - (Double)arrayList.get(0);
        double d2 = d / (double)this.bins;
        double[] dArray = new double[this.bins * 2];
        double d3 = (Double)arrayList.get(0);
        for (int i = 0; i < this.bins; ++i) {
            dArray[2 * i] = d3;
            dArray[2 * i + 1] = d3 += d2;
        }
        return dArray;
    }

    public String[] getRmsdMasters(double[] dArray) {
        String[] stringArray = new String[this.bins];
        for (int i = 0; i < this.bins; ++i) {
            double d = dArray[2 * i];
            double d2 = dArray[2 * i + 1];
            stringArray[i] = "rmsd " + this.df3.format(d) + "-" + this.df3.format(d2);
        }
        return stringArray;
    }

    public int getRmsdMasterIdx(Model model, double[] dArray) {
        if (!this.rmsds.keySet().contains(model)) {
            System.err.println("*** Error: Can't find rmsd for " + model.getState().getName());
            return -1;
        }
        double d = (Double)this.rmsds.get(model);
        for (int i = 0; i < this.bins - 1; ++i) {
            double d2 = dArray[2 * i];
            double d3 = dArray[2 * i + 1];
            if (!(d >= d2) || !(d <= d3)) continue;
            return i;
        }
        if (d >= dArray[2 * (this.bins - 1)]) {
            return this.bins - 1;
        }
        System.err.println("*** Error: Can't find rmsd MASTER for " + model.getState().getName());
        return -1;
    }

    public void parsePcChoice(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string2 : Strings.explode(string, ',')) {
            String[] stringArray = Strings.explode(string2, '-');
            if (stringArray.length == 1) {
                try {
                    int n = Integer.parseInt(stringArray[0]);
                    arrayList.add(n);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("*** Can't parse PC range: '" + string2 + "'");
                }
                continue;
            }
            if (stringArray.length == 2) {
                try {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    for (int i = n; i <= n2; ++i) {
                        arrayList.add(i);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("*** Can't parse PC range: '" + string2 + "'");
                    continue;
                }
            }
            throw new IllegalArgumentException("*** Can't parse PC choice: '" + this.pcChoice + "'");
        }
        this.pcChoice = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this.pcChoice[i] = (Integer)arrayList.get(i);
        }
    }

    public void Main() throws IOException, ParseException {
        System.err.println("The SupKitchen is busy preparing your order...");
        if (this.append && !this.kinOut && this.pdbsDirname == null) {
            System.err.println("Assuming that -append implies -kin");
            this.kinOut = true;
        }
        if (!this.splitChains) {
            System.err.println("Not splitting models into chains precludes PCA!");
            this.pcChoice = null;
        } else {
            System.err.println("Splitting models into chains, so also trimming ensemble to consensus alignment");
        }
        if (this.rmsdLesk >= 0.0) {
            System.err.println("Trimming to " + this.rmsdLesk + " rmsd w/ Lesk sieve");
            if (this.rmsdMax >= 0.0) {
                this.rmsdMax = -1.0;
                System.err.println("(Ignoring straight " + this.rmsdMax + " rmsd cutoff)");
            }
        } else if (this.rmsdMax >= 0.0) {
            System.err.println("Using straight " + this.rmsdMax + " rmsd cutoff");
        } else {
            System.err.println("No trimming/pruning regardless of rmsd");
        }
        System.err.println("Output: " + (this.kinOut ? "kin" : (this.pdbsDirname == null ? "PDB" : "PDBs")));
        System.err.println("PCA: " + (this.pcChoice == null ? "off (just superposition)" : "on!"));
        try {
            this.makeSup();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            System.exit(1);
        }
        if (this.pcChoice == null) {
            if (this.kinOut) {
                this.writeKin(new PrintWriter(System.out), this.ensemCoordFile, this.title);
            } else if (this.pdbsDirname != null) {
                this.writePdbs(this.ensemCoordFile);
            } else {
                this.writePdb(System.out, this.ensemCoordFile);
            }
            System.err.println("... Your steaming-hot sup is served!");
        } else {
            this.doPca();
            if (this.roundsOfMinimization > 0) {
                this.minimizeBackbone();
            }
            if (this.kinOut) {
                this.writeKin(new PrintWriter(System.out), this.pcaCoordFile, this.title);
            } else if (this.pdbsDirname != null) {
                this.writePdbs(this.ensemCoordFile);
            } else {
                this.writePdb(System.out, this.pcaCoordFile);
            }
            System.err.println("... Your steaming-hot sup (w/ a side of PCA) is served!");
        }
    }

    public static void main(String[] stringArray) {
        SupKitchen supKitchen = new SupKitchen();
        try {
            supKitchen.parseArguments(stringArray);
            supKitchen.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            supKitchen.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SupKitchen.help");
            if (inputStream == null) {
                System.err.println("*** Unable to locate help information in 'SupKitchen.help' ***");
                System.err.println("\n*** Usage:  SupKitchen models_dir|multimodel_pdb [ref_pdb] ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.SupKitchen");
        System.err.println("Copyright (C) 2009 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.mdlFilename == null) {
            this.mdlFilename = string;
        } else if (this.refFilename == null) {
            this.refFilename = string;
        } else {
            throw new IllegalArgumentException("too many arguments!");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-append")) {
            this.append = true;
        } else if (string.equals("-color")) {
            this.color = string2;
        } else if (string.equals("-kin")) {
            this.kinOut = true;
        } else if (string.equals("-pdb")) {
            this.kinOut = false;
        } else if (string.equals("-pdbs")) {
            this.kinOut = false;
            this.pdbsDirname = string2;
        } else if (string.equals("-nosplit")) {
            this.splitChains = false;
        } else if (string.equals("-pc")) {
            this.parsePcChoice(string2);
        } else if (string.equals("-scale")) {
            try {
                this.scale = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("*** Error formatting " + string2 + " as double for scale!");
            }
        } else if (string.equals("-min")) {
            try {
                this.roundsOfMinimization = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
        } else if (string.equals("-maxensemsize") || string.equals("-maxm")) {
            try {
                this.maxEnsemSize = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
        } else if (string.equals("-rmsdmax")) {
            try {
                this.rmsdMax = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
        } else if (string.equals("-normsdmax")) {
            this.rmsdMax = -1.0;
        } else if (string.equals("-lesk")) {
            try {
                this.rmsdLesk = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string2 + " isn't a number!");
            }
        } else if (string.equals("-nolesk")) {
            this.rmsdLesk = -1.0;
        } else if (string.equals("-ca")) {
            this.superimpose = "(atom_CA_)";
        } else if (string.equals("-bbheavy")) {
            this.superimpose = "(atom_CA_|atom_N__|atom_C__|atom_O__)";
        } else if (string.equals("-bbheavyh")) {
            this.superimpose = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_H__)";
        } else if (string.equals("-bbheavycb")) {
            this.superimpose = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_CB_)";
        } else if (string.equals("-bbheavycbh")) {
            this.superimpose = "(atom_CA_|atom_N__|atom_C__|atom_O__|atom_CB_|atom_H__)";
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

