/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.Turn;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import driftwood.r3.Triple;
import java.util.ArrayList;

public class TightTurn
extends Turn {
    public Residue r0;
    public double phi0;
    public double psi0;

    public TightTurn(Model model, ModelState modelState, Residue residue, Residue residue2, Residue residue3, Residue residue4) throws AtomException, ResidueException {
        this.model = model;
        this.state = modelState;
        this.r0 = residue;
        this.r1 = residue2;
        this.r2 = residue3;
        this.r3 = residue4;
        this.calcHbondEnergies();
        this.calcDihedral();
        this.calcPhiPsis();
        this.calcHighB();
        this.decideType();
    }

    protected void calcHbondEnergies() throws AtomException, ResidueException {
        Residue residue = this.r3.getNext(this.model);
        if (residue == null) {
            throw new ResidueException("Need residue after " + this.r3 + "to complete turn!");
        }
        this.hbEnergy0to3 = this.calcHbondEnergy(this.r0, this.r3);
        this.hbEnergy0to4 = this.calcHbondEnergy(this.r0, residue);
    }

    protected double calcHbondEnergy(Residue residue, Residue residue2) throws AtomException {
        Atom atom = residue.getAtom(" C  ");
        Atom atom2 = residue.getAtom(" O  ");
        Atom atom3 = residue2.getAtom(" N  ");
        Atom atom4 = residue2.getAtom(" H  ");
        AtomState atomState = this.state.get(atom);
        AtomState atomState2 = this.state.get(atom2);
        AtomState atomState3 = this.state.get(atom3);
        AtomState atomState4 = this.state.get(atom4);
        double d = atomState2.distance(atomState3);
        double d2 = atomState.distance(atomState4);
        double d3 = atomState2.distance(atomState4);
        double d4 = atomState.distance(atomState3);
        return 27.9 * (1.0 / d + 1.0 / d2 - 1.0 / d3 - 1.0 / d4);
    }

    protected void calcDihedral() throws AtomException {
        Atom atom = this.r0.getAtom(" CA ");
        Atom atom2 = this.r1.getAtom(" CA ");
        Atom atom3 = this.r2.getAtom(" CA ");
        Atom atom4 = this.r3.getAtom(" CA ");
        if (atom == null || atom2 == null || atom3 == null || atom4 == null) {
            throw new AtomException("Can't find all 4 C-alphas!");
        }
        AtomState atomState = this.state.get(atom);
        AtomState atomState2 = this.state.get(atom2);
        AtomState atomState3 = this.state.get(atom3);
        AtomState atomState4 = this.state.get(atom4);
        this.dihedral = Triple.dihedral(atomState, atomState2, atomState3, atomState4);
    }

    protected void calcPhiPsis() throws AtomException, ResidueException {
        this.phi0 = AminoAcid.getPhi(this.model, this.r0, this.state);
        this.psi0 = AminoAcid.getPsi(this.model, this.r0, this.state);
        this.phi1 = AminoAcid.getPhi(this.model, this.r1, this.state);
        this.psi1 = AminoAcid.getPsi(this.model, this.r1, this.state);
        this.phi2 = AminoAcid.getPhi(this.model, this.r2, this.state);
        this.psi2 = AminoAcid.getPsi(this.model, this.r2, this.state);
        this.phi3 = AminoAcid.getPhi(this.model, this.r3, this.state);
        this.psi3 = AminoAcid.getPsi(this.model, this.r3, this.state);
    }

    protected void calcHighB() throws AtomException {
        Residue[] residueArray;
        this.highB = Double.NEGATIVE_INFINITY;
        for (Residue residue : residueArray = new Residue[]{this.r0, this.r1, this.r2, this.r3}) {
            for (Atom atom : residue.getAtoms()) {
                AtomState atomState = this.state.get(atom);
                if (!(atomState.getTempFactor() > this.highB)) continue;
                this.highB = atomState.getTempFactor();
            }
        }
    }

    protected void decideType() throws AtomException {
        Atom atom = this.r0.getAtom(" CA ");
        Atom atom2 = this.r1.getAtom(" CA ");
        Atom atom3 = this.r2.getAtom(" CA ");
        Atom atom4 = this.r3.getAtom(" CA ");
        if (atom == null || atom2 == null || atom3 == null || atom4 == null) {
            throw new AtomException("Can't find all atoms needed to determine type!");
        }
        AtomState atomState = this.state.get(atom);
        AtomState atomState2 = this.state.get(atom2);
        AtomState atomState3 = this.state.get(atom3);
        AtomState atomState4 = this.state.get(atom4);
        ArrayList<AtomState> arrayList = new ArrayList<AtomState>();
        arrayList.add(atomState);
        arrayList.add(atomState2);
        arrayList.add(atomState3);
        arrayList.add(atomState4);
        Triple triple = new Triple().likeNormal(atomState, atomState2, atomState3);
        Atom atom5 = this.r0.getAtom(" C  ");
        Atom atom6 = this.r0.getAtom(" O  ");
        Atom atom7 = this.r1.getAtom(" C  ");
        Atom atom8 = this.r1.getAtom(" O  ");
        AtomState atomState5 = this.state.get(atom5);
        AtomState atomState6 = this.state.get(atom6);
        AtomState atomState7 = this.state.get(atom7);
        AtomState atomState8 = this.state.get(atom8);
        if (atom5 == null || atom6 == null || atom7 == null || atom8 == null) {
            throw new AtomException("Can't find all atoms needed to determine type!");
        }
        Triple triple2 = new Triple().likeVector(atomState5, atomState6);
        Triple triple3 = new Triple().likeVector(atomState7, atomState8);
        this.pickType(triple2, triple3, arrayList, triple);
    }

    public String toString() {
        return "type " + this.type + " tight turn from " + this.r0 + " to " + this.r3;
    }
}

