/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import chiropraxis.mc.PseudoTurn;
import chiropraxis.mc.TightTurn;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;

public class TurnFinder {
    DecimalFormat df = new DecimalFormat("0.0##");
    ArrayList inputList = new ArrayList();
    boolean pseudo = false;

    public Collection findTightTurns(Model model, ModelState modelState) {
        ArrayList<TightTurn> arrayList = new ArrayList<TightTurn>();
        for (Residue residue : model.getResidues()) {
            Residue residue2;
            Residue residue3;
            Residue residue4;
            if (residue == null || (residue4 = residue.getNext(model)) == null || (residue3 = residue4.getNext(model)) == null || (residue2 = residue3.getNext(model)) == null) continue;
            try {
                TightTurn tightTurn = new TightTurn(model, modelState, residue, residue4, residue3, residue2);
                if (tightTurn.hbEnergy0to3 < -0.5 && tightTurn.hbEnergy0to4 >= -0.5 && Math.abs(tightTurn.dihedral) < 60.0) {
                    arrayList.add(tightTurn);
                    System.err.println("Added " + tightTurn);
                    continue;
                }
                tightTurn = null;
            }
            catch (AtomException atomException) {
            }
            catch (ResidueException residueException) {}
        }
        return arrayList;
    }

    public Collection findPseudoTurns(Model model, ModelState modelState) {
        ArrayList<PseudoTurn> arrayList = new ArrayList<PseudoTurn>();
        for (Residue residue : model.getResidues()) {
            Residue residue2;
            Residue residue3;
            if (residue == null || (residue3 = residue.getNext(model)) == null || (residue2 = residue3.getNext(model)) == null || !residue.getName().equals("ASN") && !residue.getName().equals("ASP")) continue;
            try {
                PseudoTurn pseudoTurn = new PseudoTurn(model, modelState, residue, residue3, residue2);
                if (pseudoTurn.hbEnergy0to3 < -0.5 && pseudoTurn.hbEnergy0to4 >= -0.5 && Math.abs(pseudoTurn.dihedral) < 60.0) {
                    arrayList.add(pseudoTurn);
                    System.err.println("Added " + pseudoTurn);
                    continue;
                }
                pseudoTurn = null;
            }
            catch (AtomException atomException) {
            }
            catch (ResidueException residueException) {}
        }
        return arrayList;
    }

    public void printTightTurns(Collection collection, Model model, ModelState modelState, String string) {
        System.err.println("Found " + collection.size() + " tight turns in " + string);
        for (TightTurn tightTurn : collection) {
            System.out.println(string + ":" + tightTurn.r0.getChain() + ":" + tightTurn.r0.getSequenceNumber().trim() + ":" + tightTurn.r0.getInsertionCode() + ":" + tightTurn.r0.getName() + ":" + tightTurn.r1.getChain() + ":" + tightTurn.r1.getSequenceNumber().trim() + ":" + tightTurn.r1.getInsertionCode() + ":" + tightTurn.r1.getName() + ":" + tightTurn.r2.getChain() + ":" + tightTurn.r2.getSequenceNumber().trim() + ":" + tightTurn.r2.getInsertionCode() + ":" + tightTurn.r2.getName() + ":" + tightTurn.r3.getChain() + ":" + tightTurn.r3.getSequenceNumber().trim() + ":" + tightTurn.r3.getInsertionCode() + ":" + tightTurn.r3.getName() + ":" + AminoAcid.isCisPeptide(model, tightTurn.r0, modelState) + ":" + AminoAcid.isCisPeptide(model, tightTurn.r1, modelState) + ":" + AminoAcid.isCisPeptide(model, tightTurn.r2, modelState) + ":" + AminoAcid.isCisPeptide(model, tightTurn.r3, modelState) + ":" + tightTurn.type + ":" + this.df.format(tightTurn.hbEnergy0to3) + ":" + this.df.format(tightTurn.hbEnergy0to4) + ":" + this.df.format(tightTurn.dihedral) + ":" + this.df.format(tightTurn.phi0) + ":" + this.df.format(tightTurn.psi0) + ":" + this.df.format(tightTurn.phi1) + ":" + this.df.format(tightTurn.psi1) + ":" + this.df.format(tightTurn.phi2) + ":" + this.df.format(tightTurn.psi2) + ":" + this.df.format(tightTurn.phi3) + ":" + this.df.format(tightTurn.psi3) + ":" + this.df.format(tightTurn.highB));
        }
    }

    public void printPseudoTurns(Collection collection, Model model, ModelState modelState, String string) {
        System.err.println("Found " + collection.size() + " pseudo-turns in " + string);
        for (PseudoTurn pseudoTurn : collection) {
            System.out.println(string + ":" + pseudoTurn.r1.getChain() + ":" + pseudoTurn.r1.getSequenceNumber().trim() + ":" + pseudoTurn.r1.getInsertionCode() + ":" + pseudoTurn.r1.getName() + ":" + pseudoTurn.r2.getChain() + ":" + pseudoTurn.r2.getSequenceNumber().trim() + ":" + pseudoTurn.r2.getInsertionCode() + ":" + pseudoTurn.r2.getName() + ":" + pseudoTurn.r3.getChain() + ":" + pseudoTurn.r3.getSequenceNumber().trim() + ":" + pseudoTurn.r3.getInsertionCode() + ":" + pseudoTurn.r3.getName() + ":" + AminoAcid.isCisPeptide(model, pseudoTurn.r1, modelState) + ":" + AminoAcid.isCisPeptide(model, pseudoTurn.r2, modelState) + ":" + AminoAcid.isCisPeptide(model, pseudoTurn.r3, modelState) + ":" + pseudoTurn.type + ":" + this.df.format(pseudoTurn.hbEnergy0to3) + ":" + this.df.format(pseudoTurn.hbEnergy0to4) + ":" + this.df.format(pseudoTurn.dihedral) + ":" + this.df.format(pseudoTurn.phi1) + ":" + this.df.format(pseudoTurn.psi1) + ":" + this.df.format(pseudoTurn.phi2) + ":" + this.df.format(pseudoTurn.psi2) + ":" + this.df.format(pseudoTurn.phi3) + ":" + this.df.format(pseudoTurn.psi3) + ":" + this.df.format(pseudoTurn.highB));
        }
    }

    public void Main() {
        PdbReader pdbReader = new PdbReader();
        for (String string : this.inputList) {
            try {
                Collection collection;
                CoordinateFile coordinateFile = pdbReader.read(new File(string));
                Model model = coordinateFile.getFirstModel();
                ModelState modelState = model.getState();
                if (this.pseudo) {
                    collection = this.findPseudoTurns(model, modelState);
                    this.printPseudoTurns(collection, model, modelState, string);
                    continue;
                }
                collection = this.findTightTurns(model, modelState);
                this.printTightTurns(collection, model, modelState, string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("Error reading " + string);
            }
        }
    }

    public static void main(String[] stringArray) {
        TurnFinder turnFinder = new TurnFinder();
        try {
            turnFinder.parseArguments(stringArray);
            turnFinder.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            turnFinder.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("TurnFinder.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'TurnFinder.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.TurnFinder");
        System.err.println("Copyright (C) 2010 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        this.inputList.add(string);
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-pseudo")) {
            this.pseudo = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

