/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.mc;

import driftwood.moldb2.Alignment;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableRegions {
    PrintStream out = System.out;
    DecimalFormat df = new DecimalFormat("#.###");
    DecimalFormat df2 = new DecimalFormat("#.#");
    DecimalFormat df3 = new DecimalFormat("###.#");
    String filename1 = null;
    String filename2 = null;
    String label1 = null;
    String label2 = null;
    String delim = ",";
    boolean verbose = false;
    boolean doKin = true;
    boolean absVal = false;
    boolean allRes = false;
    boolean hinges = true;
    double dCaMin = 0.1;
    double dCaScale = Double.NaN;
    double dPhiPsiScale = Double.NaN;
    double[] maxAbsMvmts = null;

    void searchOneModel(Model model) {
        if (this.verbose) {
            System.err.println("Looking for variable regions in " + this.filename1);
        }
        ModelState modelState = model.getState("A");
        ModelState modelState2 = model.getState("B");
        if (modelState2 != null) {
            TreeMap<Residue, double[]> treeMap = new TreeMap<Residue, double[]>();
            TreeMap<Residue, Triple> treeMap2 = new TreeMap<Residue, Triple>();
            for (Residue residue : model.getResidues()) {
                if (residue == null) continue;
                Residue residue2 = residue.getPrev(model);
                Residue residue3 = residue.getNext(model);
                try {
                    Atom atom = residue.getAtom(" CA ");
                    AtomState atomState = modelState.get(atom);
                    AtomState atomState2 = modelState2.get(atom);
                    double d = Triple.distance(atomState, atomState2);
                    double d2 = Double.NaN;
                    double d3 = Double.NaN;
                    if (residue2 != null && residue3 != null) {
                        double d4 = this.calcPhi(residue2, residue, modelState);
                        double d5 = this.calcPhi(residue2, residue, modelState2);
                        double d6 = this.calcPsi(residue, residue3, modelState);
                        double d7 = this.calcPsi(residue, residue3, modelState2);
                        d2 = this.angleDiff(d4, d5);
                        d3 = this.angleDiff(d6, d7);
                    }
                    if (!(this.hinges || !Double.isNaN(d2) && d2 != 0.0 || !Double.isNaN(d3) && d3 != 0.0) && d == 0.0) continue;
                    double[] dArray = new double[]{d2, d3, d};
                    treeMap.put(residue, dArray);
                    treeMap2.put(residue, atomState2);
                }
                catch (AtomException atomException) {}
            }
            if (this.hinges) {
                this.doHinges(model, treeMap);
            }
            this.printOneModelResults(model, modelState, treeMap, treeMap2);
        } else {
            System.err.println("No altB ModelState for Model " + model + "...");
        }
    }

    void printOneModelResults(Model model, ModelState modelState, TreeMap<Residue, double[]> treeMap, TreeMap<Residue, Triple> treeMap2) {
        double[] dArray;
        this.maxAbsMvmts = new double[3];
        this.maxAbsMvmts[0] = 0.0;
        this.maxAbsMvmts[1] = 0.0;
        this.maxAbsMvmts[2] = 0.0;
        for (Residue residue : model.getResidues()) {
            if (residue == null || !this.moves(residue, treeMap)) continue;
            dArray = treeMap.get(residue);
            if (Math.abs(dArray[0]) > this.maxAbsMvmts[0]) {
                this.maxAbsMvmts[0] = Math.abs(dArray[0]);
            }
            if (Math.abs(dArray[1]) > this.maxAbsMvmts[1]) {
                this.maxAbsMvmts[1] = Math.abs(dArray[1]);
            }
            if (!(Math.abs(dArray[2]) > this.maxAbsMvmts[2])) continue;
            this.maxAbsMvmts[2] = Math.abs(dArray[2]);
        }
        if (this.verbose) {
            System.err.println("Max d(phi): " + this.df2.format(this.maxAbsMvmts[0]));
            System.err.println("Max d(phi): " + this.df2.format(this.maxAbsMvmts[1]));
            System.err.println("Max d(Ca) : " + this.df2.format(this.maxAbsMvmts[2]));
        }
        if (this.doKin) {
            this.out.println("@group {var-reg} dominant");
        } else {
            this.out.println("label:model:chain:res_type:res_num:dPhi:dPsi:dCa");
        }
        for (Residue residue : model.getResidues()) {
            if (this.verbose) {
                System.err.println("seeing if " + residue + " moved...");
            }
            if (residue == null || !this.moves(residue, treeMap)) continue;
            dArray = treeMap.get(residue);
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            if (this.doKin) {
                if (d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
                    this.doKinForRes(residue, modelState, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, new Triple(treeMap2.get(residue)));
                    continue;
                }
                if (d3 == Double.POSITIVE_INFINITY) {
                    this.doKinForRes(residue, modelState, d, d2, null);
                    continue;
                }
                this.doKinForRes(residue, modelState, d, d2, new Triple(treeMap2.get(residue)));
                continue;
            }
            if (!this.allRes && (Double.isNaN(d) || Double.isNaN(d2) || d == 0.0 && d2 == 0.0 && d3 == 0.0)) continue;
            this.out.print(this.label1 + this.delim + model + this.delim + residue.getChain() + this.delim + residue.getName() + this.delim + residue.getSequenceInteger() + this.delim);
            if (!Double.isNaN(d)) {
                this.out.print(this.df.format(d) + this.delim);
            } else {
                this.out.print("__?__" + this.delim);
            }
            if (!Double.isNaN(d2)) {
                this.out.print(this.df.format(d2) + this.delim);
            } else {
                this.out.print("__?__" + this.delim);
            }
            if (!Double.isNaN(d3)) {
                this.out.println(this.df.format(d3));
                continue;
            }
            this.out.print("__?__");
        }
    }

    void searchTwoModels(Model model, Model model2) {
        if (this.verbose) {
            System.err.println("Looking for variable regions between " + this.filename1 + " and " + this.filename2 + "...");
        }
        Alignment alignment = Alignment.needlemanWunsch(model.getResidues().toArray(), model2.getResidues().toArray(), new SimpleResAligner());
        if (this.verbose) {
            System.err.println("Residue alignments:");
            for (int i = 0; i < alignment.a.length; ++i) {
                System.err.println("  " + alignment.a[i] + " <==> " + alignment.b[i]);
            }
            System.err.println();
        }
        ModelState modelState = model.getState();
        ModelState modelState2 = model2.getState();
        TreeMap<Residue, double[]> treeMap = new TreeMap<Residue, double[]>();
        TreeMap<Residue, Triple> treeMap2 = new TreeMap<Residue, Triple>();
        int n = alignment.a.length;
        for (int i = 0; i < n; ++i) {
            if (alignment.a[i] == null || alignment.b[i] == null) continue;
            Residue residue = (Residue)alignment.a[i];
            Residue residue2 = (Residue)alignment.b[i];
            if (!residue.getName().equals(residue2.getName())) continue;
            if (this.verbose) {
                System.err.println("Comparing " + residue + " to " + residue2 + "...");
            }
            Residue residue3 = residue.getPrev(model);
            Residue residue4 = residue.getNext(model);
            Residue residue5 = residue2.getPrev(model2);
            Residue residue6 = residue2.getNext(model2);
            try {
                Atom atom = residue.getAtom(" CA ");
                Atom atom2 = residue2.getAtom(" CA ");
                AtomState atomState = modelState.get(atom);
                AtomState atomState2 = modelState2.get(atom2);
                double d = Triple.distance(atomState, atomState2);
                if (this.verbose) {
                    System.err.println("Dist (" + atomState.getX() + "," + atomState.getY() + "," + atomState.getZ() + ") to (" + atomState2.getX() + "," + atomState2.getY() + "," + atomState2.getZ() + ") = " + d + " (caTravel)");
                }
                double d2 = Double.NaN;
                double d3 = Double.NaN;
                if (residue3 != null && residue4 != null) {
                    d2 = this.calcPhi(residue3, residue, modelState);
                    d3 = this.calcPsi(residue, residue4, modelState);
                }
                double d4 = Double.NaN;
                double d5 = Double.NaN;
                if (residue5 != null && residue6 != null) {
                    d4 = this.calcPhi(residue5, residue2, modelState2);
                    d5 = this.calcPsi(residue2, residue6, modelState2);
                }
                double d6 = Double.NaN;
                double d7 = Double.NaN;
                if (!(Double.isNaN(d2) || Double.isNaN(d3) || Double.isNaN(d4) || Double.isNaN(d5))) {
                    d6 = this.angleDiff(d2, d4);
                    d7 = this.angleDiff(d3, d5);
                }
                if (!this.hinges && Double.isNaN(d6) && Double.isNaN(d7) && d == 0.0) continue;
                double[] dArray = new double[]{d6, d7, d};
                treeMap.put(residue, dArray);
                treeMap2.put(residue, atomState2);
                continue;
            }
            catch (AtomException atomException) {
                // empty catch block
            }
        }
        if (this.hinges) {
            this.doHinges(model, treeMap);
        }
        this.printTwoModelsResults(model, model2, modelState, treeMap, treeMap2, alignment);
    }

    void printTwoModelsResults(Model model, Model model2, ModelState modelState, TreeMap<Residue, double[]> treeMap, TreeMap<Residue, Triple> treeMap2, Alignment alignment) {
        double[] dArray;
        Residue residue;
        Residue residue2;
        int n;
        this.maxAbsMvmts = new double[3];
        this.maxAbsMvmts[0] = 0.0;
        this.maxAbsMvmts[1] = 0.0;
        this.maxAbsMvmts[2] = 0.0;
        int n2 = alignment.a.length;
        for (n = 0; n < n2; ++n) {
            if (alignment.a[n] == null || alignment.b[n] == null) continue;
            residue2 = (Residue)alignment.a[n];
            residue = (Residue)alignment.b[n];
            if (residue2 == null || !this.moves(residue2, treeMap)) continue;
            dArray = treeMap.get(residue2);
            if (Math.abs(dArray[0]) > this.maxAbsMvmts[0]) {
                this.maxAbsMvmts[0] = Math.abs(dArray[0]);
            }
            if (Math.abs(dArray[1]) > this.maxAbsMvmts[1]) {
                this.maxAbsMvmts[1] = Math.abs(dArray[1]);
            }
            if (!(Math.abs(dArray[2]) > this.maxAbsMvmts[2])) continue;
            this.maxAbsMvmts[2] = Math.abs(dArray[2]);
        }
        if (this.verbose) {
            System.err.println("Max d(phi): " + this.df2.format(this.maxAbsMvmts[0]));
            System.err.println("Max d(phi): " + this.df2.format(this.maxAbsMvmts[1]));
            System.err.println("Max d(Ca) : " + this.df2.format(this.maxAbsMvmts[2]));
        }
        if (this.doKin) {
            this.out.println("@group {var-reg} dominant");
        } else {
            this.out.println("label1:label2:model1:model2:chain1:chain2:res_type1:res_type2:res_num1:res_num2:dPhi:dPsi:dCa");
        }
        n2 = alignment.a.length;
        for (n = 0; n < n2; ++n) {
            if (alignment.a[n] == null || alignment.b[n] == null) continue;
            residue2 = (Residue)alignment.a[n];
            residue = (Residue)alignment.b[n];
            if (residue2 == null || !this.moves(residue2, treeMap)) continue;
            dArray = treeMap.get(residue2);
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            if (this.doKin) {
                if (d == Double.POSITIVE_INFINITY && d2 == Double.POSITIVE_INFINITY) {
                    this.doKinForRes(residue2, modelState, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, new Triple(treeMap2.get(residue2)));
                    continue;
                }
                if (d3 == Double.POSITIVE_INFINITY) {
                    this.doKinForRes(residue2, modelState, d, d2, null);
                    continue;
                }
                this.doKinForRes(residue2, modelState, d, d2, new Triple(treeMap2.get(residue2)));
                continue;
            }
            if (!this.allRes && (Double.isNaN(d) || Double.isNaN(d2) || d == 0.0 && d2 == 0.0 && d3 == 0.0)) continue;
            this.out.print(this.label1 + this.delim + this.label2 + this.delim + model + this.delim + model2 + this.delim + residue2.getChain() + this.delim + residue.getChain() + this.delim + residue2.getName() + this.delim + residue.getName() + this.delim + residue2.getSequenceInteger() + this.delim + residue.getSequenceInteger() + this.delim);
            if (!Double.isNaN(d)) {
                this.out.print(this.df.format(d) + this.delim);
            } else {
                this.out.print("__?__" + this.delim);
            }
            if (!Double.isNaN(d2)) {
                this.out.print(this.df.format(d2) + this.delim);
            } else {
                this.out.print("__?__" + this.delim);
            }
            if (!Double.isNaN(d3)) {
                this.out.println(this.df.format(d3));
                continue;
            }
            this.out.print("__?__");
        }
    }

    TreeMap<Residue, double[]> doHinges(Model model, TreeMap<Residue, double[]> treeMap) {
        ArrayList<Object> arrayList2;
        Object object = null;
        for (ArrayList<Object> arrayList2 : model.getResidues()) {
            if (object == null) {
                object = arrayList2;
                continue;
            }
            if (((Residue)((Object)arrayList2)).getSequenceInteger() >= ((Residue)object).getSequenceInteger()) continue;
            object = arrayList2;
        }
        if (this.verbose) {
            System.err.println("Found first residue: " + object);
        }
        Object object2 = object;
        arrayList2 = new ArrayList();
        boolean bl = false;
        while (!bl) {
            if (((Residue)object2).getNext(model) != null) {
                Residue residue = ((Residue)object2).getNext(model);
                object2 = residue;
                boolean bl2 = false;
                if (this.caMovesEnough((Residue)object2, treeMap)) {
                    bl2 = true;
                } else if (this.moves((Residue)object2, treeMap)) {
                    bl2 = true;
                }
                if (bl2) {
                    arrayList2.add(object2);
                    continue;
                }
                if (arrayList2.size() <= 0) continue;
                if (this.verbose) {
                    System.err.println("Variable region from '" + arrayList2.get(0) + "' to '" + arrayList2.get(arrayList2.size() - 1) + "'");
                }
                if (arrayList2.size() > 2) {
                    double[] dArray = treeMap.get(arrayList2.get(0));
                    double[] dArray2 = new double[]{dArray[0], dArray[1], Double.POSITIVE_INFINITY};
                    treeMap.put((Residue)arrayList2.get(0), dArray2);
                    for (int i = 1; i < arrayList2.size() - 1; ++i) {
                        dArray = treeMap.get(arrayList2.get(i));
                        dArray2 = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, dArray[2]};
                        treeMap.put((Residue)arrayList2.get(i), dArray2);
                    }
                    dArray = treeMap.get(arrayList2.get(arrayList2.size() - 1));
                    dArray2 = new double[]{dArray[0], dArray[1], Double.POSITIVE_INFINITY};
                    treeMap.put((Residue)arrayList2.get(arrayList2.size() - 1), dArray2);
                }
                arrayList2 = new ArrayList<Object>();
                continue;
            }
            bl = true;
        }
        if (arrayList2.size() > 0) {
            for (int i = 1; i < arrayList2.size(); ++i) {
                double[] dArray = new double[]{0.0, 0.0, 0.0};
                treeMap.put((Residue)arrayList2.get(i), dArray);
            }
        }
        return treeMap;
    }

    boolean moves(Residue residue, TreeMap<Residue, double[]> treeMap) {
        DecimalFormat decimalFormat = new DecimalFormat("#.#");
        try {
            double[] dArray = treeMap.get(residue);
            if (!Double.isNaN(dArray[0]) && !Double.isNaN(dArray[1])) {
                if (dArray[0] != 0.0 || dArray[1] != 0.0 || dArray[2] != 0.0) {
                    if (this.verbose) {
                        System.err.println("moves(): " + residue + " mvmts = (" + decimalFormat.format(dArray[0]) + "," + decimalFormat.format(dArray[1]) + "," + decimalFormat.format(dArray[2]) + ") => MOVES");
                    }
                    return true;
                }
                if (this.verbose) {
                    System.err.println("moves(): " + residue + " mvmts = (" + decimalFormat.format(dArray[0]) + "," + decimalFormat.format(dArray[1]) + "," + decimalFormat.format(dArray[2]) + ") ...");
                }
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    boolean caMovesEnough(Residue residue, TreeMap<Residue, double[]> treeMap) {
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        try {
            double[] dArray = treeMap.get(residue);
            if (!Double.isNaN(dArray[2]) && dArray[2] > this.dCaMin) {
                if (this.verbose) {
                    System.err.println("caMovesEnough(): " + residue + "\tCa-Ca = " + decimalFormat.format(dArray[2]) + " > " + decimalFormat.format(this.dCaMin) + ") => MOVES");
                }
                return true;
            }
            if (this.verbose) {
                System.err.println("caMovesEnough(): " + residue + "\tCa-Ca = " + decimalFormat.format(dArray[2]) + " < " + decimalFormat.format(this.dCaMin) + ") ...");
            }
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    double calcPhi(Residue residue, Residue residue2, ModelState modelState) {
        try {
            Atom atom = residue.getAtom(" C  ");
            Atom atom2 = residue2.getAtom(" N  ");
            Atom atom3 = residue2.getAtom(" CA ");
            Atom atom4 = residue2.getAtom(" C  ");
            AtomState atomState = modelState.get(atom);
            AtomState atomState2 = modelState.get(atom2);
            AtomState atomState3 = modelState.get(atom3);
            AtomState atomState4 = modelState.get(atom4);
            return Triple.dihedral(atomState, atomState2, atomState4, atomState3);
        }
        catch (AtomException atomException) {
            return Double.NaN;
        }
    }

    double calcPsi(Residue residue, Residue residue2, ModelState modelState) {
        try {
            Atom atom = residue.getAtom(" N  ");
            Atom atom2 = residue.getAtom(" CA ");
            Atom atom3 = residue.getAtom(" C  ");
            Atom atom4 = residue2.getAtom(" N  ");
            AtomState atomState = modelState.get(atom);
            AtomState atomState2 = modelState.get(atom2);
            AtomState atomState3 = modelState.get(atom3);
            AtomState atomState4 = modelState.get(atom4);
            return Triple.dihedral(atomState, atomState3, atomState2, atomState4);
        }
        catch (AtomException atomException) {
            return Double.NaN;
        }
    }

    double angleDiff(double d, double d2) {
        double d3 = d2 - d;
        double d4 = d2 - 360.0 - d;
        double d5 = d2 - (d - 360.0);
        double d6 = d2 - 360.0 - (d - 360.0);
        double d7 = d3;
        if (Math.abs(d4) < Math.abs(d7)) {
            d7 = d4;
        }
        if (Math.abs(d5) < Math.abs(d7)) {
            d7 = d5;
        }
        if (Math.abs(d6) < Math.abs(d7)) {
            d7 = d6;
        }
        double d8 = this.absVal ? Math.abs(d7) : d7;
        return d8;
    }

    void doKinForRes(Residue residue, ModelState modelState, double d, double d2) {
        this.doKinForRes(residue, modelState, d, d2, null);
    }

    void doKinForRes(Residue residue, ModelState modelState, Triple triple) {
        this.doKinForRes(residue, modelState, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, triple);
    }

    void doKinForRes(Residue residue, ModelState modelState, double d, double d2, Triple triple) {
        try {
            Triple triple2;
            Triple triple3;
            Triple triple4;
            double d3;
            Transform transform;
            int n;
            Triple triple5;
            AtomState atomState = modelState.get(residue.getAtom(" N  "));
            AtomState atomState2 = modelState.get(residue.getAtom(" C  "));
            AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
            if (!Double.isNaN(d) && d != 0.0 && d != Double.POSITIVE_INFINITY) {
                triple5 = new Triple().likeVector(atomState, atomState3);
                for (n = 0; n < 3; ++n) {
                    transform = new Transform();
                    d3 = d / this.maxAbsMvmts[0] * this.dPhiPsiScale;
                    transform = transform.likeRotation(triple5, d3 *= 0.5 * (double)n);
                    triple4 = new Triple().likeMidpoint(atomState, atomState3);
                    triple3 = new Triple().likeNormal(atomState, atomState3, atomState2);
                    transform.transform(triple3);
                    triple2 = triple3.mult(1.0).add(triple4);
                    this.out.print("@vectorlist {" + residue + " d(phi)} master= {d(phi) norm'd->" + this.df2.format(this.dPhiPsiScale) + "} color= ");
                    this.out.print(d > 0.0 ? "{red}" : "{blue}");
                    this.out.println(" width= " + (n + 1));
                    this.out.println("{" + residue + " d(phi) = " + (d > 0.0 ? "+" : "") + this.df3.format(d) + " degrees " + this.label1 + " => " + this.label2 + "}P " + this.df.format(triple4.getX()) + " " + this.df.format(triple4.getY()) + " " + this.df.format(triple4.getZ()));
                    this.out.println("{" + residue + " d(phi) = " + (d > 0.0 ? "+" : "") + this.df3.format(d) + " degrees " + this.label1 + " => " + this.label2 + "}  " + this.df.format(triple2.getX()) + " " + this.df.format(triple2.getY()) + " " + this.df.format(triple2.getZ()));
                }
            }
            if (!Double.isNaN(d2) && d2 != 0.0 && d2 != Double.POSITIVE_INFINITY) {
                triple5 = new Triple().likeVector(atomState3, atomState2);
                for (n = 0; n < 3; ++n) {
                    transform = new Transform();
                    d3 = d2 / this.maxAbsMvmts[1] * this.dPhiPsiScale;
                    transform = transform.likeRotation(triple5, d3 *= 0.5 * (double)n);
                    triple4 = new Triple().likeMidpoint(atomState3, atomState2);
                    triple3 = new Triple().likeNormal(atomState2, atomState, atomState3);
                    transform.transform(triple3);
                    triple2 = triple3.mult(1.0).add(triple4);
                    this.out.print("@vectorlist {" + residue + " d(psi)} master= {d(psi) norm'd->" + this.df2.format(this.dPhiPsiScale) + "} color= ");
                    this.out.print(d2 > 0.0 ? "{red}" : "{blue}");
                    this.out.println(" width= " + (n + 1));
                    this.out.println("{" + residue + " d(psi) = " + (d2 > 0.0 ? "+" : "") + this.df3.format(d2) + " degrees " + this.label1 + " => " + this.label2 + "}P " + this.df.format(triple4.getX()) + " " + this.df.format(triple4.getY()) + " " + this.df.format(triple4.getZ()));
                    this.out.println("{" + residue + " d(psi) = " + (d2 > 0.0 ? "+" : "") + this.df3.format(d2) + " degrees " + this.label1 + " => " + this.label2 + "}  " + this.df.format(triple2.getX()) + " " + this.df.format(triple2.getY()) + " " + this.df.format(triple2.getZ()));
                }
            }
            if (triple != null) {
                double d4 = Triple.distance(atomState3, triple);
                double d5 = d4 / this.maxAbsMvmts[2] * this.dCaScale;
                Triple triple6 = new Triple().likeVector(atomState3, triple).unit().mult(d5);
                if (triple6.getX() != 0.0 || triple6.getY() != 0.0 || triple6.getZ() != 0.0) {
                    triple4 = new Triple().likeSum(atomState3, triple6);
                    this.out.println("@arrowlist {" + residue + " d(Ca)} master= {d(Ca) norm'd->" + this.df2.format(this.dCaScale) + "} color= {green}");
                    this.out.println("{" + residue + " d(Ca) = " + this.df3.format(d4) + " Angstroms " + this.label1 + " => " + this.label2 + "}P " + this.df.format(atomState3.getX()) + " " + this.df.format(atomState3.getY()) + " " + this.df.format(atomState3.getZ()));
                    this.out.println("{" + residue + " d(Ca) = " + this.df3.format(d4) + " Angstroms " + this.label1 + " => " + this.label2 + "}  " + this.df.format(triple4.getX()) + " " + this.df.format(triple4.getY()) + " " + this.df.format(triple4.getZ()));
                }
            }
        }
        catch (AtomException atomException) {
            System.err.println("Couldn't do kin for '" + residue + "'..");
        }
    }

    public void Main() {
        if (this.filename1 == null && this.filename2 == null) {
            System.err.println("Need at least one filename!");
            System.exit(0);
        }
        if (this.doKin) {
            if (!this.hinges) {
                this.dCaMin = 0.0;
            }
            if (this.filename1 != null) {
                if (this.filename2 == null) {
                    if (Double.isNaN(this.dCaScale)) {
                        this.dCaScale = 5.0;
                    }
                    if (Double.isNaN(this.dPhiPsiScale)) {
                        this.dPhiPsiScale = 1.0;
                    }
                } else {
                    if (Double.isNaN(this.dCaScale)) {
                        this.dCaScale = 10.0;
                    }
                    if (Double.isNaN(this.dPhiPsiScale)) {
                        this.dPhiPsiScale = 500.0;
                    }
                }
            }
            System.err.println("Kin parameters:");
            System.err.println("d(phi,psi) scale: " + (Double.isNaN(this.dPhiPsiScale) ? "1 (default)" : this.df2.format(this.dPhiPsiScale)));
            System.err.println("d(Ca)      scale: " + (Double.isNaN(this.dCaScale) ? "1 (default)" : this.df2.format(this.dCaScale)));
            System.err.println("d(Ca)      min  : " + this.df2.format(this.dCaMin));
        }
        try {
            if (this.filename1 != null && this.filename2 == null) {
                PdbReader pdbReader = new PdbReader();
                File file = new File(this.filename1);
                CoordinateFile coordinateFile = pdbReader.read(file);
                for (Model model : coordinateFile.getModels()) {
                    this.label1 = file.toString() + " altA";
                    this.label2 = this.label1 + " altB";
                    this.searchOneModel(model);
                }
            } else if (this.filename1 != null && this.filename2 != null) {
                PdbReader pdbReader = new PdbReader();
                File file = new File(this.filename1);
                File file2 = new File(this.filename2);
                CoordinateFile coordinateFile = pdbReader.read(file);
                CoordinateFile coordinateFile2 = pdbReader.read(file2);
                Model model = coordinateFile.getFirstModel();
                Model model2 = coordinateFile2.getFirstModel();
                this.label1 = file.toString();
                this.label2 = file2.toString();
                this.searchTwoModels(model, model2);
            }
        }
        catch (IOException iOException) {
            System.err.println("Trouble parsing files!");
        }
    }

    public static void main(String[] stringArray) {
        VariableRegions variableRegions = new VariableRegions();
        try {
            variableRegions.parseArguments(stringArray);
            variableRegions.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            variableRegions.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("VariableRegions.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'VariableRegions.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.mc.VariableRegions");
        System.err.println("Copyright (C) 2007 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename1 == null) {
            this.filename1 = string;
        } else if (this.filename2 == null) {
            this.filename2 = string;
        } else {
            throw new IllegalArgumentException("Only need 1 or 2 files!");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        }
        if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-kin")) {
            this.doKin = true;
        } else if (string.equals("-nokin") || string.equals("-csv")) {
            this.doKin = false;
        } else if (string.equals("-delim")) {
            this.delim = string2;
        } else if (string.equals("-absval") || string.equals("-abs")) {
            this.absVal = true;
        } else if (string.equals("-allres") || string.equals("-all")) {
            this.allRes = true;
        } else if (string.equals("-hinges")) {
            this.hinges = true;
        } else if (string.equals("-nohinges")) {
            this.hinges = false;
        } else if (string.equals("-dcamin")) {
            try {
                this.dCaMin = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Can't parse " + string2 + " as a double!");
            }
        } else if (string.equals("-dcascale")) {
            try {
                this.dCaScale = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Can't parse " + string2 + " as a double!");
            }
        } else if (string.equals("-dphipsiscale")) {
            try {
                this.dPhiPsiScale = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Can't parse " + string2 + " as a double!");
            }
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    static class SimpleResAligner
    implements Alignment.Scorer {
        SimpleResAligner() {
        }

        public double score(Object object, Object object2) {
            Residue residue = (Residue)object;
            Residue residue2 = (Residue)object2;
            if (residue == null || residue2 == null) {
                return -1.0;
            }
            if (residue.getName().equals(residue2.getName())) {
                return 2.0;
            }
            return 0.0;
        }

        public double open_gap(Object object) {
            return this.extend_gap(object);
        }

        public double extend_gap(Object object) {
            return this.score(object, null);
        }
    }
}

