/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.RotCor;
import chiropraxis.rotarama.Rotalyze;
import driftwood.moldb2.Model;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaspRotCor
extends RotCor {
    int numSegs = 0;

    public String getName(String string) {
        String[] stringArray = Strings.explode(string, '/');
        String string2 = stringArray[stringArray.length - 1];
        if (string2.length() < 15 || string2.indexOf(".pdb") == -1) {
            throw new IllegalArgumentException("Filename doesn't match CASP format! " + string);
        }
        if ((string2 = string2.substring(0, 14)).substring(12, 13).equals(".")) {
            return string2.substring(0, 12);
        }
        if (string2.substring(12, 13).equals("_")) {
            try {
                int n = Integer.parseInt(string2.substring(13, 14));
                return string2;
            }
            catch (NumberFormatException numberFormatException) {
                return string2.substring(0, 12);
            }
        }
        throw new IllegalArgumentException("Filename doesn't match CASP format! " + string);
    }

    public String getTargetID(String string) {
        return this.getName(string).substring(0, 5);
    }

    public String getTSorAL(String string) {
        return this.getName(string).substring(5, 7);
    }

    public String getGroupID(String string) {
        return this.getName(string).substring(7, 10);
    }

    public String getModelID(String string) {
        return this.getName(string).substring(10, 12);
    }

    public String getSegmentID(String string) {
        String string2 = this.getName(string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 14) {
            return string2.substring(12, 14);
        }
        if (string2.length() == 12) {
            return null;
        }
        return null;
    }

    @Override
    public void assessModels() {
        File file = new File(this.mdlsDirname);
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.err.println(this.mdlsDirname + " is an empty directory or does not exist!");
            System.exit(1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        Collections.sort(arrayList);
        if (this.mode == "residue-level output") {
            System.err.println("Ignoring -residue mode: supported by RotCor, not CaspRotCor");
        }
        System.out.println("Target:TargetCount:TSorAL:Group:Model:SegmentsUsed:TargetRotamers:ModelRotamers:Matches:RotCor");
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (string.indexOf(".pdb") == -1 || treeSet.contains(string)) continue;
            if (this.getSegmentID(string) != null) {
                TreeSet<String> treeSet2 = new TreeSet<String>();
                treeSet2.add(string);
                treeSet.add(string);
                for (int j = 0; j < arrayList.size(); ++j) {
                    String string2;
                    if (i == j || (string2 = (String)arrayList.get(j)).indexOf(".pdb") == -1 || !this.getTargetID(string2).equals(this.getTargetID(string)) || !this.getGroupID(string2).equals(this.getGroupID(string)) || !this.getModelID(string2).equals(this.getModelID(string))) continue;
                    treeSet2.add(string2);
                    treeSet.add(string2);
                }
                this.assessSegsModel(treeSet2);
                continue;
            }
            this.assessModel(string);
        }
    }

    public void assessSegsModel(TreeSet<String> treeSet) {
        Rotalyze rotalyze = new Rotalyze();
        String string = treeSet.iterator().next();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        for (String string2 : treeSet) {
            try {
                Model model = this.extractModel(this.mdlsDirname + "/" + string2);
                if (model == null) continue;
                HashMap<Residue, String> hashMap = rotalyze.getNames(model);
                HashMap<Residue, String> hashMap2 = this.alignModel(model, hashMap);
                int[] nArray = this.tallyRotamers(hashMap2);
                n += nArray[1];
                n2 += nArray[0];
                n3 += nArray[2];
                d += (double)nArray[2] / (double)nArray[0];
                if (!this.verbose) continue;
                System.err.println("new rotcor: " + this.df.format(d));
            }
            catch (IOException iOException) {
                System.err.println("Error reading file: " + string2);
            }
        }
        this.numSegs = treeSet.size();
        Object object = new int[]{n2, n, n3};
        this.outputModel(string, (int[])object, d);
        this.numSegs = 0;
    }

    @Override
    public void outputModel(String string, int[] nArray, double d) {
        System.out.println(this.trgName + ":" + this.trgCount + ":" + this.getTSorAL(string) + ":" + this.getGroupID(string) + ":" + this.getModelID(string) + ":" + this.numSegs + ":" + nArray[0] + ":" + nArray[1] + ":" + nArray[2] + ":" + this.df.format(d));
    }

    public static void main(String[] stringArray) {
        CaspRotCor caspRotCor = new CaspRotCor();
        try {
            caspRotCor.parseArguments(stringArray);
            caspRotCor.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            caspRotCor.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    @Override
    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    @Override
    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("CaspRotCor.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'CaspRotCor.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.rotarama.CaspRotCor version " + this.getVersion() + " build " + this.getBuild());
        System.err.println("Copyright (C) 2010 by Daniel Keedy. All rights reserved.");
    }

    @Override
    String getVersion() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("chiropraxis/version.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate version number in 'version.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("version=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "?.??";
    }

    @Override
    String getBuild() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("chiropraxis/buildnum.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate build number in 'buildnum.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("buildnum=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "yyyymmdd.????";
    }

    @Override
    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }
}

