/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.Ramalyze;
import chiropraxis.rotarama.Rotalyze;
import driftwood.moldb2.Alignment;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Neighborhood;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import molikin.logic.BallAndStickLogic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRotarama {
    private static final String ROTA = "rotamer";
    private static final String RAMA = "Ramachandran";
    private final String AVERAGES = "Average local rotarama";
    private final String KINEMAGE = "Local rotarama kinemage";
    private final DecimalFormat df = new DecimalFormat("#.###");
    private final String aaNames = "ALA ARG ASN ASP CYS GLU GLN GLY HIS ILELEU LYS MET PHE PRO SER THR TRP TYR VAL";
    private boolean verbose = false;
    private String mode = "Average local rotarama";
    private String filename;
    private String filenameRef;
    private Model model;
    private Model modelRef;
    private int nPrev = 2;
    private int nNext = 2;

    private void printKinColoredByScore() throws IOException {
        Object object;
        BallAndStickLogic ballAndStickLogic = new BallAndStickLogic();
        ballAndStickLogic.doProtein = true;
        ballAndStickLogic.doMainchain = true;
        ballAndStickLogic.doSidechains = true;
        ballAndStickLogic.colorBy = BallAndStickLogic.COLOR_BY_ROTARAMA;
        ballAndStickLogic.rota = this.getRotaScores();
        ballAndStickLogic.rama = this.getRamaScores();
        String string = "";
        ModelState modelState = this.model.getState();
        if (modelState != null && modelState.getName().length() >= 4) {
            string = string + modelState.getName().substring(0, 4).toLowerCase() + " ";
        }
        if (this.modelRef != null && (object = this.modelRef.getState()) != null && ((ModelState)object).getName().length() >= 4) {
            string = string + " vs. " + ((ModelState)object).getName().substring(0, 4).toLowerCase() + " ";
        }
        string = string + "rotarama";
        System.out.println("@kinemage {" + string + "}");
        System.out.println("@group {" + string + "} dominant");
        object = this.model.getChainIDs();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (this.model.getChain(string2) == null) continue;
            System.out.println("@subgroup {chain " + string2 + "} dominant");
            String string3 = "blue";
            Set set = this.model.getChain(string2);
            PrintWriter printWriter = new PrintWriter(System.out);
            ballAndStickLogic.printKinemage(printWriter, this.model, set, string3);
        }
    }

    private void printAverageLocalScores() throws IOException {
        if (this.modelRef != null) {
            System.exit(1);
        }
        System.out.println("res\tnearby\tscored\trota\trama\tavg");
        for (Residue residue : this.model.getResidues()) {
            if ("ALA ARG ASN ASP CYS GLU GLN GLY HIS ILELEU LYS MET PHE PRO SER THR TRP TYR VAL".indexOf(residue.getName()) == -1) continue;
            try {
                int n = new Neighborhood(residue, this.model, this.nPrev, this.nNext).getMembers().size();
                int n2 = LocalRotarama.calcLocalNumScored(residue, this.model);
                double d = LocalRotarama.calcLocalScore(residue, this.model, ROTA);
                double d2 = LocalRotarama.calcLocalScore(residue, this.model, RAMA);
                double d3 = 0.5 * (d + d2);
                System.out.println(residue + "," + n + "," + n2 + "," + this.df.format(d) + "," + this.df.format(d2) + "," + this.df.format(d3));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("bad local score type for " + residue);
            }
        }
    }

    private HashMap<Residue, Double> getRotaScores() throws IOException {
        HashMap<Residue, Double> hashMap = new Rotalyze().getEvals(this.model);
        if (this.modelRef == null) {
            return hashMap;
        }
        HashMap<Residue, Double> hashMap2 = new Rotalyze().getEvals(this.modelRef);
        return this.normalizeScores(this.model, hashMap, this.modelRef, hashMap2);
    }

    private HashMap<Residue, Double> getRamaScores() throws IOException {
        HashMap<Residue, Double> hashMap = new Ramalyze().getEvals(this.model);
        if (this.modelRef == null) {
            return hashMap;
        }
        HashMap<Residue, Double> hashMap2 = new Ramalyze().getEvals(this.modelRef);
        return this.normalizeScores(this.model, hashMap, this.modelRef, hashMap2);
    }

    private HashMap<Residue, Double> normalizeScores(Model model, HashMap<Residue, Double> hashMap, Model model2, HashMap<Residue, Double> hashMap2) {
        int n;
        Alignment alignment = Alignment.needlemanWunsch(model.getResidues().toArray(), model2.getResidues().toArray(), new SimpleResAligner());
        if (this.verbose) {
            System.err.println("Residue alignments:");
            for (n = 0; n < alignment.a.length; ++n) {
                System.err.println("  " + alignment.a[n] + " <==> " + alignment.b[n]);
            }
            System.err.println();
        }
        for (n = 0; n < alignment.a.length; ++n) {
            Residue residue = (Residue)alignment.a[n];
            Residue residue2 = (Residue)alignment.b[n];
            if (residue == null || "ALA ARG ASN ASP CYS GLU GLN GLY HIS ILELEU LYS MET PHE PRO SER THR TRP TYR VAL".indexOf(residue.getName()) == -1 || residue.getName().equals("GLY") || residue.getName().equals("ALA")) continue;
            Residue residue3 = null;
            Residue residue4 = null;
            for (Residue residue5 : hashMap.keySet()) {
                if (!residue5.getCNIT().equals(residue.getCNIT())) continue;
                residue3 = residue5;
            }
            for (Residue residue5 : hashMap2.keySet()) {
                if (!residue5.getCNIT().equals(residue2.getCNIT())) continue;
                residue4 = residue5;
            }
            if (residue3 == null || residue4 == null) {
                hashMap.remove(residue3);
                continue;
            }
            double d = hashMap.get(residue3) - hashMap2.get(residue4);
            hashMap.put(residue3, d);
        }
        return hashMap;
    }

    public static int calcLocalNumScored(Residue residue, Model model) throws IOException {
        HashMap<Residue, Double> hashMap = new Rotalyze().getEvals(model);
        HashMap<Residue, Double> hashMap2 = new Ramalyze().getEvals(model);
        int n = 0;
        for (Residue residue2 : new Neighborhood(residue, model, 2, 2).getMembers()) {
            if (!hashMap.keySet().contains(residue2) && !hashMap2.keySet().contains(residue2)) continue;
            ++n;
        }
        return n;
    }

    public static double calcLocalScore(Residue residue, Model model, String string) throws IOException, IllegalArgumentException {
        HashMap<Residue, Double> hashMap = null;
        if (string.equals(ROTA)) {
            hashMap = new Rotalyze().getEvals(model);
        } else if (string.equals(RAMA)) {
            hashMap = new Ramalyze().getEvals(model);
        } else {
            throw new IllegalArgumentException("argument 'type' must be one of the ROTA or RAMA String constants defined in LocalRotarama");
        }
        if (hashMap == null) {
            System.err.println("failed to produce " + string + " scores for " + model);
            return Double.NaN;
        }
        double d = 0.0;
        int n = 0;
        for (Residue residue2 : new Neighborhood(residue, model, 2, 2).getMembers()) {
            if (!hashMap.keySet().contains(residue2)) continue;
            d += hashMap.get(residue2).doubleValue();
            ++n;
        }
        if (n == 0) {
            return Double.NaN;
        }
        return d / (double)n;
    }

    public void Main() throws IOException {
        if (this.filename == null) {
            this.showHelp(true);
            System.exit(1);
        }
        try {
            File file = new File(this.filename);
            if (file.isDirectory()) {
                System.err.println(file + " is a directory, silly goose!");
                return;
            }
            CoordinateFile coordinateFile = new PdbReader().read(file);
            this.model = coordinateFile.getFirstModel();
            String[] stringArray = Strings.explode(file.getName(), '/');
            String string = stringArray[stringArray.length - 1];
            if (this.filenameRef != null) {
                File file2 = new File(this.filenameRef);
                if (file2.isDirectory()) {
                    System.err.println(file2 + " is a directory, silly goose!");
                    return;
                }
                CoordinateFile coordinateFile2 = new PdbReader().read(file2);
                this.modelRef = coordinateFile2.getFirstModel();
                String[] stringArray2 = Strings.explode(file2.getName(), '/');
                String string2 = stringArray2[stringArray2.length - 1];
            }
            if (this.filenameRef == null) {
                System.err.println(this.mode + " for " + string);
            } else {
                System.err.println(this.mode + " for " + string + " relative to " + this.filenameRef);
            }
            try {
                if (this.mode.equals("Local rotarama kinemage")) {
                    this.printKinColoredByScore();
                } else if (this.mode.equals("Average local rotarama")) {
                    this.printAverageLocalScores();
                }
            }
            catch (IOException iOException) {
                System.err.println("failed to rota/Ramalyze " + this.model);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error rotalyzing/Ramalyzing model: " + this.filename);
        }
    }

    public static void main(String[] stringArray) {
        LocalRotarama localRotarama = new LocalRotarama();
        try {
            localRotarama.parseArguments(stringArray);
            localRotarama.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            localRotarama.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("LocalRotarama.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'LocalRotarama.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.rotarama.LocalRotarama version " + this.getVersion() + " build " + this.getBuild());
        System.err.println("Copyright (C) 2010 by Daniel Keedy. All rights reserved.");
    }

    String getVersion() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("chiropraxis/version.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate version number in 'version.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("version=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "?.??";
    }

    String getBuild() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("chiropraxis/buildnum.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate build number in 'buildnum.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("buildnum=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "yyyymmdd.????";
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename == null) {
            this.filename = string;
        } else if (this.filenameRef == null) {
            this.filenameRef = string;
        } else {
            this.showHelp(true);
            System.exit(1);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-kin") || string.equals("-k")) {
            this.mode = "Local rotarama kinemage";
        } else if (string.equals("-avg") || string.equals("-a")) {
            this.mode = "Average local rotarama";
        } else if (string.equals("-n")) {
            try {
                String[] stringArray = Strings.explode(string2, ',');
                this.nPrev = Integer.parseInt(stringArray[0]);
                this.nNext = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Proper use of flag: -n=#,# (#s of residues N-ward and C-ward to include for averaging)");
            }
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }

    public static class SimpleResAligner
    implements Alignment.Scorer {
        public double score(Object object, Object object2) {
            Residue residue = (Residue)object;
            Residue residue2 = (Residue)object2;
            if (residue.getName().equals(residue2.getName())) {
                return 4.0;
            }
            return -1.0;
        }

        public double open_gap(Object object) {
            return -8.0;
        }

        public double extend_gap(Object object) {
            return -2.0;
        }
    }
}

