/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.Ramalyze;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.r3.Triple;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class RamaKinWriter {
    static final DecimalFormat df = new DecimalFormat("0.00");

    public void createRamaPlotKin(Map map, String string, PrintWriter printWriter) throws IOException {
        printWriter.println("@text");
        printWriter.println("Use the animate buttons or the 'a' key to cycle through the various Ramachandran plots.");
        printWriter.println();
        this.textSummary(map, printWriter);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("General case", "purple");
        hashMap.put("Isoleucine or valine", "red");
        hashMap.put("Pre-proline", "blue");
        hashMap.put("Glycine", "green");
        hashMap.put("Trans proline", "orange");
        hashMap.put("Cis proline", "gold");
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("rama8000/rama6-template.kin")));
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeAllData(map, hashMap, printWriter);
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeClass(map, "General case", hashMap.get("General case").toString(), printWriter);
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeClass(map, "Isoleucine or valine", hashMap.get("Isoleucine or valine").toString(), printWriter);
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeClass(map, "Pre-proline", hashMap.get("Pre-proline").toString(), printWriter);
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeClass(map, "Glycine", hashMap.get("Glycine").toString(), printWriter);
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeClass(map, "Trans proline", hashMap.get("Trans proline").toString(), printWriter);
            while ((string2 = bufferedReader.readLine()) != null && !string2.startsWith("@dotlist")) {
                printWriter.println(string2);
            }
            this.writeClass(map, "Cis proline", hashMap.get("Cis proline").toString(), printWriter);
            bufferedReader.close();
            printWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Error reading rama6-template.kin resource file!");
        }
    }

    public void textSummary(Map map, PrintWriter printWriter) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        for (Collection collection : map.keySet()) {
            for (Ramalyze.RamaEval ramaEval : collection) {
                if (ramaEval.score == "Favored") {
                    ++n;
                    ++n2;
                    continue;
                }
                if (ramaEval.score == "Allowed") {
                    ++n;
                    ++n3;
                    continue;
                }
                if (ramaEval.score != "OUTLIER") continue;
                ++n;
                ++n4;
            }
            printWriter.println("Model " + n5 + ":");
            printWriter.println(df.format(100.0 * (double)n2 / (double)n) + "% (" + n2 + "/" + n + ") of all residues were in favored (98%) regions.");
            printWriter.println(df.format(100.0 * (double)(n2 + n3) / (double)n) + "% (" + (n2 + n3) + "/" + n + ") of all residues were in allowed (>99.8%) regions.");
            if (n4 == 0) {
                printWriter.println("There were no outliers.");
            } else {
                printWriter.println("There were " + n4 + " outliers (phi, psi):");
                for (Ramalyze.RamaEval ramaEval : collection) {
                    if (ramaEval.score != "OUTLIER") continue;
                    printWriter.println("    " + ramaEval.name + " (" + df.format(ramaEval.phi) + ", " + df.format(ramaEval.psi) + ")");
                }
            }
            printWriter.println();
            ++n5;
        }
        printWriter.println("For more information, see Lovell, et al. (2003) Proteins: Struct Func Gen 50:437-450");
    }

    void writeAllData(Map map, Map map2, PrintWriter printWriter) {
        int n = 1;
        for (Collection collection : map.keySet()) {
            printWriter.println("@balllist {Good data} color= white radius= 1.5 master= {Data pts} nohilite" + (map.size() > 1 ? " master= {Model " + n + "}" : "") + (map.size() > 1 && n != 1 ? " off" : ""));
            for (Object object : collection) {
                if (((Ramalyze.RamaEval)object).score != "Favored" && ((Ramalyze.RamaEval)object).score != "Allowed") continue;
                printWriter.println("{" + ((Ramalyze.RamaEval)object).name + "} " + df.format(((Ramalyze.RamaEval)object).phi) + " " + df.format(((Ramalyze.RamaEval)object).psi) + " 0.0");
            }
            ++n;
        }
        n = 1;
        for (Collection collection : map.keySet()) {
            printWriter.println("@balllist {Bad data} color= white radius= 3.0 master= {Data pts} nohilite" + (map.size() > 1 ? " master= {Model " + n + "}" : "") + (map.size() > 1 && n != 1 ? " off" : ""));
            StringBuffer stringBuffer = new StringBuffer("@labellist {Outlier labels} color= white master= {Outlier Lbls}" + (map.size() > 1 ? " master= {Model " + n + "}" : "") + (map.size() > 1 && n != 1 ? " off" : ""));
            for (Ramalyze.RamaEval ramaEval : collection) {
                if (ramaEval.score != "OUTLIER") continue;
                String string = map2.get(ramaEval.type).toString();
                printWriter.println("{" + ramaEval.name + "} " + string + " " + df.format(ramaEval.phi) + " " + df.format(ramaEval.psi) + " 0.0");
                stringBuffer.append("{" + ramaEval.name + "} " + df.format((double)ramaEval.phi + 3.0) + " " + df.format(ramaEval.psi) + " 0.0\n");
            }
            printWriter.println(stringBuffer.toString());
            ++n;
        }
    }

    void writeClass(Map map, String string, String string2, PrintWriter printWriter) {
        int n = 1;
        for (Collection collection : map.keySet()) {
            printWriter.println("@balllist {Good data} color= white radius= 1.5 master= {Data pts} nohilite" + (map.size() > 1 ? " master= {Model " + n + "}" : "") + (map.size() > 1 && n != 1 ? " off" : ""));
            for (Object object : collection) {
                if (((Ramalyze.RamaEval)object).type != string || ((Ramalyze.RamaEval)object).score != "Favored" && ((Ramalyze.RamaEval)object).score != "Allowed") continue;
                printWriter.println("{" + ((Ramalyze.RamaEval)object).name + "} " + df.format(((Ramalyze.RamaEval)object).phi) + " " + df.format(((Ramalyze.RamaEval)object).psi) + " 0.0");
            }
            ++n;
        }
        n = 1;
        for (Collection collection : map.keySet()) {
            printWriter.println("@balllist {Bad data} color= white radius= 3.0 master= {Data pts} nohilite" + (map.size() > 1 ? " master= {Model " + n + "}" : "") + (map.size() > 1 && n != 1 ? " off" : ""));
            StringBuffer stringBuffer = new StringBuffer("@labellist {Outlier labels} color= white master= {Outlier Lbls}" + (map.size() > 1 ? " master= {Model " + n + "}" : "") + (map.size() > 1 && n != 1 ? " off" : ""));
            for (Ramalyze.RamaEval ramaEval : collection) {
                if (ramaEval.type != string || ramaEval.score != "OUTLIER") continue;
                printWriter.println("{" + ramaEval.name + "} " + string2 + " " + df.format(ramaEval.phi) + " " + df.format(ramaEval.psi) + " 0.0");
                stringBuffer.append("{" + ramaEval.name + "} " + df.format((double)ramaEval.phi + 3.0) + " " + df.format(ramaEval.psi) + " 0.0\n");
            }
            printWriter.println(stringBuffer.toString());
            ++n;
        }
    }

    public void drawRamaOutlierCaTraces(Collection collection, Model model, ModelState modelState, PrintWriter printWriter) {
        DecimalFormat decimalFormat = new DecimalFormat("0.###");
        printWriter.println("@vectorlist {bad Rama Ca} width= 4 color= green");
        for (Ramalyze.RamaEval ramaEval : collection) {
            if (ramaEval.score != "OUTLIER") continue;
            Residue residue = ramaEval.res;
            Atom atom = residue.getPrev(model).getAtom(" CA ");
            Atom atom2 = residue.getAtom(" CA ");
            Atom atom3 = residue.getNext(model).getAtom(" CA ");
            if (atom == null) {
                atom = residue.getAtom(" N  ");
            }
            if (atom3 == null) {
                atom3 = residue.getAtom(" C  ");
            }
            if (atom == null || atom2 == null || atom3 == null) {
                System.err.println("Unable to draw Ca-Ca for " + residue);
                continue;
            }
            try {
                AtomState atomState = modelState.get(atom);
                AtomState atomState2 = modelState.get(atom2);
                AtomState atomState3 = modelState.get(atom3);
                Triple triple = new Triple();
                triple.likeMidpoint(atomState, atomState2);
                printWriter.println("{" + residue.getPrev(model) + " CA}P " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
                triple = atomState2;
                printWriter.println("{" + residue + " CA} " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
                triple.likeMidpoint(atomState3, atomState2);
                printWriter.println("{" + residue.getNext(model) + " CA} " + decimalFormat.format(triple.getX()) + " " + decimalFormat.format(triple.getY()) + " " + decimalFormat.format(triple.getZ()));
            }
            catch (AtomException atomException) {
                System.err.println("Unable to draw Ca-Ca for " + residue);
            }
        }
        printWriter.flush();
    }

    public void Main() {
        try {
            String string;
            System.setProperty("java.awt.headless", "true");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("rama8000/rama6-template.kin")));
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
            bufferedReader.close();
            System.out.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        RamaKinWriter ramaKinWriter = new RamaKinWriter();
        ramaKinWriter.Main();
    }
}

