/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.Ramalyze;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RamaPdfWriter {
    static final float PLOT_EXTRA = 60.0f;
    static final float PLOT_SCALE = 0.45916668f;
    static final float PLOT_OFFSET = 27.550001f;

    public void createRamaPDF(Map map, String string, OutputStream outputStream) throws IOException {
        try {
            URL uRL = this.getClass().getResource("rama8000/rama6-template.pdf");
            PdfReader pdfReader = new PdfReader(uRL);
            Document document = new Document(PageSize.LETTER);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, outputStream);
            document.addCreator(this.getClass().getName() + " by Ian W. Davis");
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, 1);
            this.doModelByModel(map, string, document, pdfContentByte, pdfImportedPage);
            document.close();
        }
        catch (DocumentException documentException) {
            throw new IOException("Got DocumentException when trying to generate PDF.");
        }
    }

    void doModelByModel(Map map, String string, Document document, PdfContentByte pdfContentByte, PdfTemplate pdfTemplate) throws DocumentException {
        int n = 0;
        PdfTemplate[] pdfTemplateArray = new PdfTemplate[map.size()];
        PdfTemplate[] pdfTemplateArray2 = new PdfTemplate[map.size()];
        PdfTemplate[] pdfTemplateArray3 = new PdfTemplate[map.size()];
        PdfTemplate[] pdfTemplateArray4 = new PdfTemplate[map.size()];
        PdfTemplate[] pdfTemplateArray5 = new PdfTemplate[map.size()];
        PdfTemplate[] pdfTemplateArray6 = new PdfTemplate[map.size()];
        for (Object object : map.keySet()) {
            pdfTemplateArray[n] = this.makeAnalysisTemplate(pdfContentByte, "General case", (Collection)object);
            pdfTemplateArray2[n] = this.makeAnalysisTemplate(pdfContentByte, "Isoleucine or valine", (Collection)object);
            pdfTemplateArray3[n] = this.makeAnalysisTemplate(pdfContentByte, "Pre-proline", (Collection)object);
            pdfTemplateArray4[n] = this.makeAnalysisTemplate(pdfContentByte, "Glycine", (Collection)object);
            pdfTemplateArray5[n] = this.makeAnalysisTemplate(pdfContentByte, "Trans proline", (Collection)object);
            pdfTemplateArray6[n] = this.makeAnalysisTemplate(pdfContentByte, "Cis proline", (Collection)object);
            ++n;
        }
        if (map.size() > 1) {
            Object object;
            document.newPage();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            for (n = 0; n < map.size(); ++n) {
                pdfContentByte.addTemplate(pdfTemplateArray[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 80.75f, 531.15f);
                pdfContentByte.addTemplate(pdfTemplateArray3[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 80.75f, 330.35f);
                pdfContentByte.addTemplate(pdfTemplateArray5[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 80.75f, 128.45f);
                pdfContentByte.addTemplate(pdfTemplateArray2[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 323.65002f, 531.15f);
                pdfContentByte.addTemplate(pdfTemplateArray4[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 323.65002f, 330.35f);
                pdfContentByte.addTemplate(pdfTemplateArray6[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 323.65002f, 128.45f);
            }
            ArrayList arrayList = new ArrayList();
            object = map.keySet().iterator();
            while (object.hasNext()) {
                arrayList.addAll((Collection)object.next());
            }
            object = this.plotStatistics(pdfContentByte, 540.0f, 80.0f, arrayList);
            float f = Math.min(540.0f / ((PdfTemplate)object).getWidth(), 80.0f / ((PdfTemplate)object).getHeight());
            if (f > 1.0f) {
                f = 1.0f;
            }
            pdfContentByte.addTemplate((PdfTemplate)object, f, 0.0f, 0.0f, f, 50.0f, 50.0f);
            if (string != null) {
                this.addPageTitle(string + ", all models", pdfContentByte);
            } else {
                this.addPageTitle("All models", pdfContentByte);
            }
        }
        n = 0;
        for (Object object : map.keySet()) {
            String string2 = (String)map.get(object);
            document.newPage();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
            pdfContentByte.addTemplate(pdfTemplateArray[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 80.75f, 531.15f);
            pdfContentByte.addTemplate(pdfTemplateArray3[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 80.75f, 330.35f);
            pdfContentByte.addTemplate(pdfTemplateArray5[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 80.75f, 128.45f);
            pdfContentByte.addTemplate(pdfTemplateArray2[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 323.65002f, 531.15f);
            pdfContentByte.addTemplate(pdfTemplateArray4[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 323.65002f, 330.35f);
            pdfContentByte.addTemplate(pdfTemplateArray6[n], 0.45916668f, 0.0f, 0.0f, 0.45916668f, 323.65002f, 128.45f);
            PdfTemplate pdfTemplate2 = this.plotStatistics(pdfContentByte, 80.0f, 100.0f, (Collection)object);
            float f = Math.min(540.0f / pdfTemplate2.getWidth(), 80.0f / pdfTemplate2.getHeight());
            if (f > 1.0f) {
                f = 1.0f;
            }
            pdfContentByte.addTemplate(pdfTemplate2, f, 0.0f, 0.0f, f, 50.0f, 50.0f);
            if (string != null) {
                this.addPageTitle(string + ", model " + string2, pdfContentByte);
            } else {
                this.addPageTitle("Model " + string2, pdfContentByte);
            }
            ++n;
        }
    }

    PdfTemplate makeAnalysisTemplate(PdfContentByte pdfContentByte, String string, Collection collection) {
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(480.0f, 480.0f);
        Graphics2D graphics2D = pdfTemplate.createGraphics(pdfTemplate.getWidth(), pdfTemplate.getHeight());
        graphics2D.translate(240.0, 240.0);
        Color color = "General case".equals(string) ? new Color(0xCC00CC) : ("Isoleucine or valine".equals(string) ? new Color(0xFF0000) : ("Pre-proline".equals(string) ? new Color(0x3366CC) : ("Glycine".equals(string) ? new Color(52326) : ("Trans proline".equals(string) ? new Color(0xCC6600) : ("Cis proline".equals(string) ? new Color(0x999900) : new Color(0))))));
        this.plotAnalysis(graphics2D, color, string, collection);
        graphics2D.dispose();
        return pdfTemplate;
    }

    void plotAnalysis(Graphics graphics, Color color, String string, Collection collection) {
        Color color2 = new Color(0);
        Color color3 = new Color(0x333333);
        graphics.setFont(new Font("Serif", 0, 10));
        for (Ramalyze.RamaEval ramaEval : collection) {
            if (!string.equals(ramaEval.type)) continue;
            if (ramaEval.score == "OUTLIER") {
                graphics.setColor(color);
                graphics.drawOval((int)ramaEval.phi - 3, (int)(-ramaEval.psi) - 3, 6, 6);
                graphics.setColor(color2);
                graphics.drawString(ramaEval.name, (int)ramaEval.phi + 5, (int)(-ramaEval.psi) + 3);
                continue;
            }
            graphics.setColor(color3);
            graphics.drawOval((int)ramaEval.phi - 2, (int)(-ramaEval.psi) - 2, 4, 4);
        }
    }

    PdfTemplate plotStatistics(PdfContentByte pdfContentByte, float f, float f2, Collection collection) {
        Object object2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (Object object2 : collection) {
            if (((Ramalyze.RamaEval)object2).score == "Favored") {
                ++n;
                ++n2;
                continue;
            }
            if (((Ramalyze.RamaEval)object2).score == "Allowed") {
                ++n;
                ++n3;
                continue;
            }
            if (((Ramalyze.RamaEval)object2).score != "OUTLIER") continue;
            ++n;
            ++n4;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        object2 = new ArrayList();
        ((ArrayList)object2).add(decimalFormat.format(100.0 * (double)n2 / (double)n) + "% (" + n2 + "/" + n + ") of all residues were in favored (98%) regions.");
        ((ArrayList)object2).add(decimalFormat.format(100.0 * (double)(n2 + n3) / (double)n) + "% (" + (n2 + n3) + "/" + n + ") of all residues were in allowed (>99.8%) regions.");
        ((ArrayList)object2).add("");
        if (n4 == 0) {
            ((ArrayList)object2).add("There were no outliers.");
        } else {
            ((ArrayList)object2).add("There were " + n4 + " outliers (phi, psi):");
            for (Ramalyze.RamaEval ramaEval : collection) {
                if (ramaEval.score != "OUTLIER") continue;
                ((ArrayList)object2).add("    " + ramaEval.name + " (" + decimalFormat.format(ramaEval.phi) + ", " + decimalFormat.format(ramaEval.psi) + ")");
            }
        }
        Font font = new Font("Serif", 0, 10);
        return this.layoutColumns(pdfContentByte, f, f2, font, (Collection)object2);
    }

    PdfTemplate layoutColumns(PdfContentByte pdfContentByte, float f, float f2, Font font, Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(1.0f, 1.0f);
        Graphics2D graphics2D = pdfTemplate.createGraphics(pdfTemplate.getWidth(), pdfTemplate.getHeight());
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
        int n2 = arrayList.size() * n;
        int n3 = (arrayList.size() + 1) / 2 * n;
        int n4 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            n4 = Math.max(n4, fontMetrics.stringWidth((String)iterator.next()));
        }
        int n5 = 0;
        List list = arrayList.subList(0, arrayList.size() / 2);
        Iterator iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            n5 = Math.max(n5, fontMetrics.stringWidth((String)iterator2.next()));
        }
        int n6 = 0;
        List list2 = arrayList.subList(arrayList.size() / 2, arrayList.size());
        Iterator iterator3 = list2.iterator();
        while (iterator3.hasNext()) {
            n6 = Math.max(n6, fontMetrics.stringWidth((String)iterator3.next()));
        }
        int n7 = (int)Math.round(0.2 * (double)(n5 + n6));
        int n8 = n5 + n6 + n7;
        graphics2D.dispose();
        if (Math.min(f / (float)n4, f2 / (float)n2) > Math.min(f / (float)n8, f2 / (float)n3)) {
            pdfTemplate = pdfContentByte.createTemplate(n4, n2);
            graphics2D = pdfTemplate.createGraphics(pdfTemplate.getWidth(), pdfTemplate.getHeight());
            graphics2D.setFont(font);
            int n9 = fontMetrics.getMaxAscent();
            Iterator iterator4 = arrayList.iterator();
            while (iterator4.hasNext()) {
                graphics2D.drawString((String)iterator4.next(), 0, n9);
                n9 += n;
            }
        } else {
            pdfTemplate = pdfContentByte.createTemplate(n8, n3);
            graphics2D = pdfTemplate.createGraphics(pdfTemplate.getWidth(), pdfTemplate.getHeight());
            graphics2D.setFont(font);
            int n10 = fontMetrics.getMaxAscent();
            Iterator iterator5 = list.iterator();
            while (iterator5.hasNext()) {
                graphics2D.drawString((String)iterator5.next(), 0, n10);
                n10 += n;
            }
            n10 = fontMetrics.getMaxAscent();
            iterator5 = list2.iterator();
            while (iterator5.hasNext()) {
                graphics2D.drawString((String)iterator5.next(), n5 + n7, n10);
                n10 += n;
            }
        }
        graphics2D.dispose();
        return pdfTemplate;
    }

    void addPageTitle(String string, PdfContentByte pdfContentByte) {
        PdfDocument pdfDocument = pdfContentByte.getPdfDocument();
        PdfTemplate pdfTemplate = pdfContentByte.createTemplate(pdfDocument.getPageSize().getWidth(), pdfDocument.getPageSize().getHeight());
        Graphics2D graphics2D = pdfTemplate.createGraphics(pdfTemplate.getWidth(), pdfTemplate.getHeight());
        Font font = new Font("Serif", 0, 10);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.setFont(font);
        graphics2D.setColor(Color.black);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        int n3 = ((int)pdfTemplate.getWidth() - n) / 2;
        int n4 = 46 + n2 / 2;
        graphics2D.drawString(string, n3, n4);
        graphics2D.dispose();
        pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
    }

    public void Main() {
        try {
            System.setProperty("java.awt.headless", "true");
            URL uRL = this.getClass().getResource("rama/rama6-template.pdf");
            PdfReader pdfReader = new PdfReader(uRL);
            Document document = new Document(PageSize.LETTER);
            PdfWriter pdfWriter = PdfWriter.getInstance(document, System.out);
            document.addCreator(this.getClass().getName() + " by Ian W. Davis");
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            for (int i = 1; i <= pdfReader.getNumberOfPages(); ++i) {
                document.newPage();
                PdfImportedPage pdfImportedPage = pdfWriter.getImportedPage(pdfReader, i);
                pdfContentByte.addTemplate(pdfImportedPage, 0.0f, 0.0f);
            }
            document.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        RamaPdfWriter ramaPdfWriter = new RamaPdfWriter();
        ramaPdfWriter.Main();
    }
}

