/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.NDFloatTable;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Ramachandran {
    public static final double ALL_FAVORED = 0.02;
    public static final double GENERAL_ALLOWED = 5.0E-4;
    public static final double CISPRO_ALLOWED = 0.002;
    public static final double OTHER_ALLOWED = 0.001;
    private static Ramachandran instance = null;
    float[] phipsi = new float[2];
    NDFloatTable genTable = null;
    NDFloatTable ilevalTable = null;
    NDFloatTable preproTable = null;
    NDFloatTable glyTable = null;
    NDFloatTable transproTable = null;
    NDFloatTable cisproTable = null;

    public static Ramachandran getInstance() throws IOException {
        if (instance != null) {
            return instance;
        }
        instance = new Ramachandran();
        return instance;
    }

    public static void freeInstance() {
        instance = null;
    }

    private Ramachandran() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("rama8000/general.ndft");
        InputStream inputStream2 = this.getClass().getResourceAsStream("rama8000/ileval.ndft");
        InputStream inputStream3 = this.getClass().getResourceAsStream("rama8000/prepro.ndft");
        InputStream inputStream4 = this.getClass().getResourceAsStream("rama8000/glycine.ndft");
        InputStream inputStream5 = this.getClass().getResourceAsStream("rama8000/transpro.ndft");
        InputStream inputStream6 = this.getClass().getResourceAsStream("rama8000/cispro.ndft");
        if (inputStream == null || inputStream2 == null || inputStream3 == null || inputStream4 == null || inputStream5 == null || inputStream6 == null) {
            throw new IOException("Could not find required .ndft files");
        }
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        this.genTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream2));
        this.ilevalTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream3));
        this.preproTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream4));
        this.glyTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream5));
        this.transproTable = new NDFloatTable(dataInputStream);
        dataInputStream = new DataInputStream(new BufferedInputStream(inputStream6));
        this.cisproTable = new NDFloatTable(dataInputStream);
        inputStream.close();
        inputStream2.close();
        inputStream3.close();
        inputStream4.close();
        inputStream5.close();
        inputStream6.close();
    }

    public double rawScore(Model model, Residue residue, ModelState modelState) throws ResidueException {
        double d;
        double d2;
        try {
            d2 = AminoAcid.getPhi(model, residue, modelState);
            d = AminoAcid.getPsi(model, residue, modelState);
        }
        catch (AtomException atomException) {
            throw new ResidueException("Can't get Ramachandran score for " + residue + ": " + atomException.getMessage());
        }
        this.phipsi[0] = (float)d2;
        this.phipsi[1] = (float)d;
        String string = residue.getName();
        double d3 = string.equals("GLY") ? (double)this.glyTable.valueAt(this.phipsi) : (string.equals("PRO") ? (AminoAcid.isCisPeptide(model, residue, modelState) ? (double)this.cisproTable.valueAt(this.phipsi) : (double)this.transproTable.valueAt(this.phipsi)) : (AminoAcid.isPrepro(model, residue, modelState) ? (double)this.preproTable.valueAt(this.phipsi) : (string.equals("ILE") || string.equals("VAL") ? (double)this.ilevalTable.valueAt(this.phipsi) : (double)this.genTable.valueAt(this.phipsi))));
        return d3;
    }

    public boolean isOutlier(Model model, Residue residue, ModelState modelState) {
        String string = "GLY,ALA,VAL,LEU,ILE,PRO,PHE,TYR,TRP,SER,THR,CYS,MET,MSE,LYS,HIS,ARG,ASP,ASN,GLN,GLU";
        String string2 = residue.getName();
        if (string.indexOf(string2) == -1) {
            return false;
        }
        try {
            double d = this.rawScore(model, residue, modelState);
            if (string2.equals("PRO") && AminoAcid.isCisPeptide(model, residue, modelState)) {
                return d < 0.002;
            }
            if (string2.equals("GLY") || AminoAcid.isPrepro(model, residue, modelState) || string2.equals("ILE") || string2.equals("VAL")) {
                return d < 0.001;
            }
            return d < 5.0E-4;
        }
        catch (ResidueException residueException) {
            return false;
        }
    }
}

