/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.RamaKinWriter;
import chiropraxis.rotarama.RamaPdfWriter;
import chiropraxis.rotarama.Ramachandran;
import driftwood.data.UberMap;
import driftwood.data.UberSet;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ramalyze {
    public static final Object MODE_PDF = "PDF document";
    public static final Object MODE_KINPLOT = "Kinemage plot";
    public static final Object MODE_KINMARKUP = "Kinemage outlier markups";
    public static final Object MODE_RAW = "Raw csv output";
    public static final DecimalFormat df = new DecimalFormat("#.##");
    File infile = null;
    File outfile = null;
    Object mode = MODE_RAW;
    static boolean quietMode = false;

    static void improveResidueNames(Collection collection, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (RamaEval ramaEval : collection) {
            hashSet.add(ramaEval.res.getSegment());
            hashSet2.add(ramaEval.res.getChain());
        }
        boolean bl2 = hashSet.size() > 1;
        boolean bl3 = hashSet2.size() > 1;
        for (RamaEval ramaEval : collection) {
            Residue residue = ramaEval.res;
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("[").append(ramaEval.modelName).append("] ");
            }
            if (bl3) {
                if (" ".equals(residue.getChain())) {
                    stringBuffer.append("_ ");
                } else {
                    stringBuffer.append(residue.getChain()).append(' ');
                }
            }
            if (bl2) {
                stringBuffer.append(residue.getSegment().trim()).append(' ');
            }
            stringBuffer.append(residue.getSequenceNumber());
            if (!" ".equals(residue.getInsertionCode())) {
                stringBuffer.append(residue.getInsertionCode());
            }
            stringBuffer.append(' ');
            stringBuffer.append(residue.getName());
            ramaEval.name = stringBuffer.toString();
        }
    }

    public static Set analyzeModel(Model model, Collection collection) throws IOException {
        String string = "GLY,ALA,VAL,LEU,ILE,PRO,PHE,TYR,TRP,SER,THR,CYS,MET,MSE,LYS,HIS,ARG,ASP,ASN,GLN,GLU";
        UberSet uberSet = new UberSet();
        Ramachandran ramachandran = Ramachandran.getInstance();
        for (Residue residue : model.getResidues()) {
            if (string.indexOf(residue.getName()) == -1) continue;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                try {
                    ModelState modelState = (ModelState)iterator.next();
                    RamaEval ramaEval = new RamaEval(residue, model.getName());
                    ramaEval.phi = (float)AminoAcid.getPhi(model, residue, modelState);
                    ramaEval.psi = (float)AminoAcid.getPsi(model, residue, modelState);
                    ramaEval.numscore = (float)ramachandran.rawScore(model, residue, modelState);
                    ramaEval.type = residue.getName().equals("GLY") ? "Glycine" : (residue.getName().equals("PRO") ? (AminoAcid.isCisPeptide(model, residue, modelState) ? "Cis proline" : "Trans proline") : (AminoAcid.isPrepro(model, residue, modelState) ? "Pre-proline" : (residue.getName().equals("ILE") || residue.getName().equals("VAL") ? "Isoleucine or valine" : "General case")));
                    ramaEval.score = (double)ramaEval.numscore >= 0.02 ? "Favored" : (ramaEval.type == "General case" && (double)ramaEval.numscore >= 5.0E-4 ? "Allowed" : (ramaEval.type == "Cis proline" && (double)ramaEval.numscore >= 0.002 ? "Allowed" : (ramaEval.type != "General case" && ramaEval.type != "Cis proline" && (double)ramaEval.numscore >= 0.001 ? "Allowed" : "OUTLIER")));
                    uberSet.add(ramaEval);
                }
                catch (AtomException atomException) {
                }
                catch (ResidueException residueException) {}
            }
        }
        return uberSet;
    }

    public static void runAnalysis(InputStream inputStream, OutputStream outputStream, Object object) throws IOException {
        Ramalyze.runAnalysis(new PdbReader().read(inputStream), outputStream, object);
    }

    public static void runAnalysis(CoordinateFile coordinateFile, OutputStream outputStream, Object object) throws IOException {
        Object object2;
        Object object32;
        UberMap uberMap = new UberMap();
        for (Object object32 : coordinateFile.getModels()) {
            object2 = Ramalyze.analyzeModel((Model)object32, ((Model)object32).getStates().values());
            if (object == MODE_PDF || object == MODE_KINPLOT || object == MODE_KINMARKUP) {
                boolean bl = coordinateFile.getModels().size() > 1;
                Ramalyze.improveResidueNames((Collection)object2, bl);
            }
            uberMap.put(object2, ((Model)object32).getName());
        }
        Object object4 = null;
        if (coordinateFile.getFile() != null) {
            object4 = coordinateFile.getFile().getName();
        } else if (coordinateFile.getIdCode() != null) {
            object4 = coordinateFile.getIdCode();
        }
        if (object == MODE_PDF) {
            if (!quietMode) {
                System.err.println("Creating PDF document...");
            }
            object32 = new RamaPdfWriter();
            ((RamaPdfWriter)object32).createRamaPDF(uberMap, (String)object4, outputStream);
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
        } else if (object == MODE_KINPLOT) {
            if (!quietMode) {
                System.err.println("Creating kinemage plot...");
            }
            object32 = new RamaKinWriter();
            ((RamaKinWriter)object32).createRamaPlotKin(uberMap, (String)object4, new PrintWriter(outputStream));
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
        } else if (object == MODE_KINMARKUP) {
            if (!quietMode) {
                System.err.println("Creating kinemage outlier markups...");
            }
            object32 = coordinateFile.getFirstModel();
            object2 = ((Model)object32).getState();
            Collection collection = null;
            for (Collection collection2 : uberMap.keySet()) {
                String string = (String)uberMap.get(collection2);
                if (!string.equals(((Model)object32).getName())) continue;
                collection = collection2;
                break;
            }
            if (collection == null) {
                System.err.println("Can't find first model in " + (String)object4 + " so can't draw Ca-Ca traces!");
            }
            RamaKinWriter ramaKinWriter = new RamaKinWriter();
            ramaKinWriter.drawRamaOutlierCaTraces(collection, (Model)object32, (ModelState)object2, new PrintWriter(outputStream));
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {}
        } else if (object == MODE_RAW) {
            if (!quietMode) {
                System.err.println("Printing raw scores & evals...");
            }
            object32 = new PrintWriter(outputStream);
            int n = 0;
            ((PrintWriter)object32).println("#residue:score%:phi:psi:rama_eval:rama_type");
            for (Collection collection : uberMap.keySet()) {
                for (RamaEval ramaEval : collection) {
                    ((PrintWriter)object32).println(ramaEval.name + ":" + df.format(100.0f * ramaEval.numscore) + ":" + df.format(ramaEval.phi) + ":" + df.format(ramaEval.psi) + ":" + ramaEval.score + ":" + ramaEval.type);
                }
                ++n;
            }
            ((PrintWriter)object32).flush();
        } else {
            throw new IllegalArgumentException("Unknown output mode: " + object);
        }
    }

    public HashMap<Residue, Double> getEvals(Model model) throws IOException {
        Set set = Ramalyze.analyzeModel(model, model.getStates().values());
        HashMap<Residue, Double> hashMap = new HashMap<Residue, Double>();
        for (RamaEval ramaEval : set) {
            hashMap.put(ramaEval.res, Double.valueOf(ramaEval.numscore));
        }
        return hashMap;
    }

    public void Main() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = this.infile == null ? pdbReader.read(System.in) : pdbReader.read(this.infile);
        FilterOutputStream filterOutputStream = this.outfile == null ? System.out : new BufferedOutputStream(new FileOutputStream(this.outfile));
        Ramalyze.runAnalysis(coordinateFile, (OutputStream)filterOutputStream, this.mode);
        try {
            ((OutputStream)filterOutputStream).flush();
            ((OutputStream)filterOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("java.awt.headless", "true");
        Ramalyze ramalyze = new Ramalyze();
        try {
            ramalyze.parseArguments(stringArray);
            ramalyze.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            ramalyze.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Ramalyze.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'Ramalyze.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.rotarama.Ramalyze");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.infile == null) {
            this.infile = new File(string);
        } else if (this.outfile == null) {
            this.outfile = new File(string);
        } else {
            throw new IllegalArgumentException("Too many file names on cmd line: '" + string + "'");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-pdf")) {
            this.mode = MODE_PDF;
        } else if (string.equals("-kinplot")) {
            this.mode = MODE_KINPLOT;
        } else if (string.equals("-kinmarkup")) {
            this.mode = MODE_KINMARKUP;
        } else {
            if (string.equals("-kin")) {
                throw new IllegalArgumentException("-kin is no longer a valid flag; use -kinplot or -kinmarkup");
            }
            if (string.equals("-raw")) {
                this.mode = MODE_RAW;
            } else if (string.equals("-quiet") || string.equals("-q")) {
                quietMode = true;
            } else {
                throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
            }
        }
    }

    public static class RamaEval {
        public static final String FAVORED = "Favored";
        public static final String ALLOWED = "Allowed";
        public static final String OUTLIER = "OUTLIER";
        public static final String NOSCORE = "Not evaluated";
        public static final String GENERAL = "General case";
        public static final String ILEVAL = "Isoleucine or valine";
        public static final String PREPRO = "Pre-proline";
        public static final String GLYCINE = "Glycine";
        public static final String CISPRO = "Cis proline";
        public static final String TRANSPRO = "Trans proline";
        public static final String NOTYPE = "Unknown type";
        Residue res;
        String name;
        String modelName;
        public float phi = 0.0f;
        public float psi = 0.0f;
        public float numscore = 0.0f;
        public String score = "Not evaluated";
        public String type = "Unknown type";

        public RamaEval(Residue residue, String string) {
            this.res = residue;
            this.name = residue.toString();
            this.modelName = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof RamaEval)) {
                return false;
            }
            RamaEval ramaEval = (RamaEval)object;
            return this.res.toString().equals(ramaEval.res.toString()) && this.phi == ramaEval.phi && this.psi == ramaEval.psi;
        }

        public int hashCode() {
            return this.res.toString().hashCode();
        }
    }
}

