/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.mc.SubImpose;
import chiropraxis.rotarama.Rotalyze;
import driftwood.moldb2.Alignment;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotCor {
    DecimalFormat df = new DecimalFormat("0.000");
    public static final String NO_CONSENSUS_ROTNAME = "NO_CONSENSUS";
    public static final String MODEL = "model-level output";
    public static final String RESIDUE = "residue-level output";
    boolean verbose = false;
    Object mode = "model-level output";
    String trgFilename;
    String mdlsDirname;
    String homsDirname;
    Model trg;
    String trgName;
    int trgCount;
    HashMap<Residue, String[]> trgsRotNames;
    HashMap<Residue, String> trgRotNames;
    HashMap<Residue, String[]> mdlsRotNames;

    public void prepTarget() {
        if (this.trgFilename.indexOf(".pdb") == -1) {
            System.err.println(this.trgFilename + " must be a .pdb file!");
            System.exit(1);
        }
        File file = new File(this.trgFilename);
        Rotalyze rotalyze = new Rotalyze();
        String[] stringArray = Strings.explode(this.trgFilename, '/');
        this.trgName = stringArray[stringArray.length - 1];
        if (this.verbose) {
            System.err.println("Rotalyzing " + this.trgName);
        }
        this.trgName = this.trgName.substring(0, this.trgName.indexOf(".pdb"));
        try {
            CoordinateFile coordinateFile = new PdbReader().read(file);
            this.trg = coordinateFile.getFirstModel();
            this.trgCount = coordinateFile.getModels().size();
            if (this.trgCount == 1) {
                this.trgRotNames = rotalyze.getNames(this.trg);
                for (String string : coordinateFile.getHeaders()) {
                    if (string.indexOf("REMARK") == -1 || string.indexOf(" - MODEL ") == -1) continue;
                    System.err.println("Warning! Header suggests target may actually be multi-model: \"" + string + "\"");
                }
            } else {
                System.err.println("Found >1 PDB-style MODELs in target (" + this.trgFilename + ") -- calculating consensus rotamer at each position");
                this.trgsRotNames = new HashMap();
                for (Model model : coordinateFile.getModels()) {
                    this.trgRotNames = rotalyze.getNames(model);
                    this.storeTarget(model, this.trgRotNames);
                }
                this.conductTargetConsensus();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error rotalyzing target: " + this.trgFilename + "!");
        }
    }

    public void storeTarget(Model model, HashMap<Residue, String> hashMap) {
        for (Residue residue : hashMap.keySet()) {
            String[] stringArray3;
            String string = hashMap.get(residue);
            String[] stringArray2 = null;
            for (String[] stringArray3 : this.trg.getResidues()) {
                if (stringArray3 == null || !stringArray3.getCNIT().equals(residue.getCNIT())) continue;
                stringArray2 = stringArray3;
            }
            if (stringArray2 == null) continue;
            String[] stringArray4 = this.trgsRotNames.get(stringArray2);
            if (stringArray4 != null) {
                stringArray3 = new String[stringArray4.length + 1];
                for (int i = 0; i < stringArray4.length; ++i) {
                    stringArray3[i] = stringArray4[i];
                }
            } else {
                stringArray3 = new String[1];
            }
            stringArray3[stringArray3.length - 1] = string;
            this.trgsRotNames.put((Residue)stringArray2, stringArray3);
        }
    }

    public void conductTargetConsensus() {
        this.trgRotNames = new HashMap();
        for (Residue residue : this.trgsRotNames.keySet()) {
            String[] stringArray = this.trgsRotNames.get(residue);
            String string = this.calcModalRotName(stringArray);
            double d = this.calcModalRotFrac(stringArray);
            if (this.isConsensus(residue.getName(), d)) {
                this.trgRotNames.put(residue, string);
                continue;
            }
            this.trgRotNames.put(residue, NO_CONSENSUS_ROTNAME);
        }
    }

    public boolean isConsensus(String string, double d) {
        if ("CYS SER THR VAL PRO".indexOf(string) != -1 && d >= 0.85) {
            return true;
        }
        if ("ASN ASP HIS ILE LEU PHE TRP TYR".indexOf(string) != -1 && d >= 0.7) {
            return true;
        }
        if ("GLN GLU MET".indexOf(string) != -1 && d >= 0.55) {
            return true;
        }
        return "ARG LYS".indexOf(string) != -1 && d >= 0.4;
    }

    public String calcModalRotName(String[] stringArray) {
        int n;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        for (String string2 : stringArray) {
            if (hashMap.get(string2) != null) {
                n = (Integer)hashMap.get(string2);
                hashMap.put(string2, n + 1);
            } else {
                hashMap.put(string2, 1);
            }
            ++n2;
        }
        int n3 = -1;
        String string = null;
        for (String string2 : hashMap.keySet()) {
            n = (Integer)hashMap.get(string2);
            if (n <= n3) continue;
            n3 = n;
            string = string2;
        }
        return string;
    }

    public double calcModalRotFrac(String[] stringArray) {
        int n;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        for (String string2 : stringArray) {
            if (hashMap.get(string2) != null) {
                n = (Integer)hashMap.get(string2);
                hashMap.put(string2, n + 1);
            } else {
                hashMap.put(string2, 1);
            }
            ++n2;
        }
        int n3 = -1;
        String string = null;
        for (String string2 : hashMap.keySet()) {
            n = (Integer)hashMap.get(string2);
            if (n <= n3 || string2.equals("OUTLIER")) continue;
            n3 = n;
            string = string2;
        }
        return 1.0 * (double)n3 / (1.0 * (double)n2);
    }

    public Model extractModel(String string) throws IOException {
        CoordinateFile coordinateFile;
        File file = new File(string);
        if (file.isDirectory()) {
            return null;
        }
        if (this.verbose) {
            System.err.println("Rotalyzing " + file);
        }
        if ((coordinateFile = new PdbReader().read(file)).getModels().size() == 0) {
            System.err.println("Found 0 models in " + string + " ... skipping!");
            return null;
        }
        if (coordinateFile.getModels().size() > 1) {
            System.err.println("Found " + coordinateFile.getModels().size() + " models in " + string + " ... only considering first one");
        }
        Model model = coordinateFile.getFirstModel();
        return model;
    }

    public HashMap<Residue, String> alignModel(Model model, HashMap<Residue, String> hashMap) {
        Alignment alignment = Alignment.alignChains(SubImpose.getChains(model), SubImpose.getChains(this.trg), new Alignment.NeedlemanWunsch(), new SubImpose.SimpleResAligner());
        HashMap<Residue, String> hashMap2 = new HashMap<Residue, String>();
        for (Residue residue : hashMap.keySet()) {
            String string = hashMap.get(residue);
            Residue residue2 = null;
            for (int i = 0; i < alignment.a.length; ++i) {
                Residue residue3 = (Residue)alignment.a[i];
                Residue residue4 = (Residue)alignment.b[i];
                if (residue3 == null || !residue3.getCNIT().equals(residue.getCNIT())) continue;
                residue2 = residue4;
            }
            if (residue2 == null) continue;
            hashMap2.put(residue2, string);
        }
        return hashMap2;
    }

    public int[] tallyRotamers(HashMap<Residue, String> hashMap) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList<Residue> arrayList = new ArrayList<Residue>();
        for (Residue residue : this.trgRotNames.keySet()) {
            arrayList.add(residue);
        }
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl;
            Residue residue;
            residue = (Residue)arrayList.get(i);
            String string = this.trgRotNames.get(residue);
            String string2 = hashMap.get(residue);
            if (string == null || string.equals("OUTLIER")) continue;
            if (string.equals(NO_CONSENSUS_ROTNAME)) continue;
            ++n;
            if (string2 != null) {
                ++n2;
            }
            boolean bl2 = bl = string2 != null && string2.equals(string);
            if (bl) {
                ++n3;
            }
            if (!this.verbose) continue;
            System.err.println(residue + ": " + (bl ? "" : "(") + string + " " + (bl ? "=" : "!=") + " " + string2 + (bl ? "" : ")"));
        }
        return new int[]{n, n2, n3};
    }

    public void assessModels() {
        int n;
        File file = new File(this.mdlsDirname);
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.err.println(this.mdlsDirname + " is an empty directory or does not exist!");
            System.exit(1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n = 0; n < stringArray.length; ++n) {
            arrayList.add(stringArray[n]);
        }
        Collections.sort(arrayList);
        System.err.println("... " + this.mode);
        if (this.mode == MODEL) {
            System.out.println("Target:Model:TargetCount:TargetRotamers:ModelRotamers:Matches:RotCor");
            for (n = 0; n < arrayList.size(); ++n) {
                String string = (String)arrayList.get(n);
                if (string.indexOf(".pdb") == -1) continue;
                this.assessModel(string);
            }
        } else {
            Object object;
            this.mdlsRotNames = new HashMap();
            for (n = 0; n < arrayList.size(); ++n) {
                object = (String)arrayList.get(n);
                if (((String)object).indexOf(".pdb") == -1) continue;
                this.rotalyzeModel((String)object);
            }
            System.out.println("Target:Chain:ResNum:InsCode:ResType:TargetRotamer:TargetCount:ModelCount:FracMatch");
            ArrayList<Residue> arrayList2 = new ArrayList<Residue>();
            object = this.trgRotNames.keySet().iterator();
            while (object.hasNext()) {
                arrayList2.add((Residue)object.next());
            }
            Collections.sort(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                Residue residue = (Residue)arrayList2.get(i);
                this.assessResidue(residue);
            }
        }
    }

    public void assessModel(String string) {
        try {
            Model model = this.extractModel(this.mdlsDirname + "/" + string);
            if (model == null) {
                return;
            }
            Rotalyze rotalyze = new Rotalyze();
            HashMap<Residue, String> hashMap = rotalyze.getNames(model);
            HashMap<Residue, String> hashMap2 = this.alignModel(model, hashMap);
            int[] nArray = this.tallyRotamers(hashMap2);
            double d = (double)nArray[2] / (double)nArray[0];
            this.outputModel(string, nArray, d);
        }
        catch (IOException iOException) {
            System.err.println("Error reading file: " + string);
        }
    }

    public void outputModel(String string, int[] nArray, double d) {
        System.out.println(this.trgName + ":" + string + ":" + this.trgCount + ":" + nArray[0] + ":" + nArray[1] + ":" + nArray[2] + ":" + this.df.format(d));
    }

    public void rotalyzeModel(String string) {
        File file = new File(this.mdlsDirname + "/" + string);
        if (file.isDirectory()) {
            return;
        }
        if (this.verbose) {
            System.err.println("Rotalyzing " + file);
        }
        Rotalyze rotalyze = new Rotalyze();
        try {
            CoordinateFile coordinateFile = new PdbReader().read(file);
            for (Model model : coordinateFile.getModels()) {
                HashMap<Residue, String> hashMap = rotalyze.getNames(model);
                this.storeModelRotamers(model, hashMap);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error rotalyzing model: " + string + "!");
        }
    }

    public void storeModelRotamers(Model model, HashMap<Residue, String> hashMap) {
        Alignment alignment = Alignment.alignChains(SubImpose.getChains(model), SubImpose.getChains(this.trg), new Alignment.NeedlemanWunsch(), new SubImpose.SimpleResAligner());
        for (Residue residue : hashMap.keySet()) {
            String[] stringArray;
            String string = hashMap.get(residue);
            Residue residue2 = null;
            for (int i = 0; i < alignment.a.length; ++i) {
                stringArray = (String[])alignment.a[i];
                Residue residue3 = (Residue)alignment.b[i];
                if (stringArray == null || !stringArray.getCNIT().equals(residue.getCNIT())) continue;
                residue2 = residue3;
            }
            if (residue2 == null) continue;
            String[] stringArray2 = this.mdlsRotNames.get(residue2);
            if (stringArray2 != null) {
                stringArray = new String[stringArray2.length + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray[i] = stringArray2[i];
                }
            } else {
                stringArray = new String[1];
            }
            stringArray[stringArray.length - 1] = string;
            this.mdlsRotNames.put(residue2, stringArray);
        }
    }

    public void assessResidue(Residue residue) {
        double d;
        int n;
        String string = this.trgRotNames.get(residue);
        String[] stringArray = this.mdlsRotNames.get(residue);
        if (stringArray != null) {
            n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            for (String string2 : stringArray) {
                if (string2.equals(string) && !string.equals("OUTLIER")) {
                    if (!string.equals(NO_CONSENSUS_ROTNAME)) {
                        ++n2;
                    }
                }
                ++n3;
            }
            d = 1.0 * (double)n2 / (1.0 * (double)n3);
        } else {
            n = 0;
            d = 0.0;
        }
        this.outputResidue(residue, string, n, d);
    }

    public void outputResidue(Residue residue, String string, int n, double d) {
        System.out.println(this.trgName + ":" + residue.getChain() + ":" + residue.getSequenceInteger() + ":" + residue.getInsertionCode().trim() + ":" + residue.getName() + ":" + string + ":" + this.trgCount + ":" + n + ":" + this.df.format(d));
    }

    public void Main() throws IOException {
        if (this.trgFilename == null || this.mdlsDirname == null) {
            this.showHelp(true);
            System.exit(1);
        }
        while (this.mdlsDirname.endsWith("/")) {
            this.mdlsDirname = this.mdlsDirname.substring(0, this.mdlsDirname.length() - 1);
        }
        this.prepTarget();
        this.assessModels();
    }

    public static void main(String[] stringArray) {
        RotCor rotCor = new RotCor();
        try {
            rotCor.parseArguments(stringArray);
            rotCor.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            rotCor.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("RotCor.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'RotCor.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.err);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.rotarama.RotCor version " + this.getVersion() + " build " + this.getBuild());
        System.err.println("Copyright (C) 2010 by Daniel Keedy. All rights reserved.");
    }

    String getVersion() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("chiropraxis/version.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate version number in 'version.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("version=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "?.??";
    }

    String getBuild() {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("chiropraxis/buildnum.props");
        if (inputStream == null) {
            System.err.println("\n*** Unable to locate build number in 'buildnum.props' ***\n");
        } else {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string = bufferedReader.readLine();
                string = bufferedReader.readLine();
                if (string != null && string.indexOf("buildnum=") != -1) {
                    return string.substring(string.indexOf("=") + 1);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return "yyyymmdd.????";
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.mdlsDirname == null) {
            this.mdlsDirname = string;
        } else if (this.trgFilename == null) {
            this.trgFilename = string;
        } else {
            this.showHelp(true);
            System.exit(1);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (string.equals("-model") || string.equals("-mdl") || string.equals("-m")) {
            this.mode = MODEL;
        } else if (string.equals("-residue") || string.equals("-res") || string.equals("-r")) {
            this.mode = RESIDUE;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

