/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.rotarama;

import chiropraxis.rotarama.Rotamer;
import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rotalyze {
    File infile = null;
    File outfile = null;

    public void doCsvText(CoordinateFile coordinateFile, OutputStream outputStream) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("#residue:score%:chi1:chi2:chi3:chi4:rotamer");
        Rotamer rotamer = Rotamer.getInstance();
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        for (Model model : coordinateFile.getModels()) {
            ModelState modelState = model.getState();
            Iterator iterator = model.getResidues().iterator();
            while (iterator.hasNext()) {
                try {
                    int n;
                    Residue residue = (Residue)iterator.next();
                    double[] dArray = sidechainAngles2.measureChiAngles(residue, modelState);
                    double d = rotamer.evaluate(residue.getName(), dArray);
                    String string = "OUTLIER";
                    if (d >= 0.01) {
                        string = rotamer.identify(residue.getName(), dArray);
                    }
                    for (n = 0; n < dArray.length; ++n) {
                        dArray[n] = dArray[n] % 360.0;
                        if (!(dArray[n] < 0.0)) continue;
                        int n2 = n;
                        dArray[n2] = dArray[n2] + 360.0;
                    }
                    if ("ASP".equals(residue.getName()) || "GLU".equals(residue.getName()) || "PHE".equals(residue.getName()) || "TYR".equals(residue.getName())) {
                        n = dArray.length - 1;
                        dArray[n] = dArray[n] % 180.0;
                        if (dArray[n] < 0.0) {
                            int n3 = n;
                            dArray[n3] = dArray[n3] + 180.0;
                        }
                    }
                    printWriter.print(residue.getCNIT());
                    printWriter.print(":");
                    printWriter.print(decimalFormat.format(d * 100.0));
                    for (n = 0; n < 4; ++n) {
                        printWriter.print(":");
                        if (n >= dArray.length || Double.isNaN(dArray[n])) continue;
                        printWriter.print(decimalFormat.format(dArray[n]));
                    }
                    printWriter.print(":");
                    printWriter.print(string);
                    printWriter.println();
                }
                catch (Exception exception) {}
            }
        }
        printWriter.flush();
    }

    public HashMap<Residue, String> getNames(Model model) throws IOException {
        HashMap<Residue, String> hashMap = new HashMap<Residue, String>();
        Rotamer rotamer = Rotamer.getInstance();
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        ModelState modelState = model.getState();
        Iterator iterator = model.getResidues().iterator();
        while (iterator.hasNext()) {
            try {
                Residue residue = (Residue)iterator.next();
                double[] dArray = sidechainAngles2.measureChiAngles(residue, modelState);
                double d = rotamer.evaluate(residue.getName(), dArray);
                String string = "OUTLIER";
                if (d >= 0.01) {
                    string = rotamer.identify(residue.getName(), dArray);
                }
                hashMap.put(residue, string);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public HashMap<Residue, Double> getEvals(Model model) throws IOException {
        HashMap<Residue, Double> hashMap = new HashMap<Residue, Double>();
        Rotamer rotamer = Rotamer.getInstance();
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        ModelState modelState = model.getState();
        Iterator iterator = model.getResidues().iterator();
        while (iterator.hasNext()) {
            try {
                Residue residue = (Residue)iterator.next();
                double[] dArray = sidechainAngles2.measureChiAngles(residue, modelState);
                double d = rotamer.evaluate(residue.getName(), dArray);
                hashMap.put(residue, d);
            }
            catch (Exception exception) {}
        }
        return hashMap;
    }

    public void Main() throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = this.infile == null ? pdbReader.read(System.in) : pdbReader.read(this.infile);
        FilterOutputStream filterOutputStream = this.outfile == null ? System.out : new BufferedOutputStream(new FileOutputStream(this.outfile));
        this.doCsvText(coordinateFile, filterOutputStream);
        try {
            ((OutputStream)filterOutputStream).flush();
            ((OutputStream)filterOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        Rotalyze rotalyze = new Rotalyze();
        try {
            rotalyze.parseArguments(stringArray);
            rotalyze.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            rotalyze.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("Rotalyze.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'Rotalyze.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.rotarama.Rotalyze");
        System.err.println("Copyright (C) 2007 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.infile == null) {
            this.infile = new File(string);
        } else if (this.outfile == null) {
            this.outfile = new File(string);
        } else {
            throw new IllegalArgumentException("Too many file names on cmd line: '" + string + "'");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-dump_rotamer_bins") || string.equals("-dump")) {
            try {
                System.out.println(Rotamer.getInstance().dumpRotamerNames());
            }
            catch (IOException iOException) {
                System.out.println("Jar file is missing some resources");
            }
            System.exit(0);
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

