/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import driftwood.util.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Scanner;

public class DihedralPlotter {
    PrintStream o = System.out;
    PrintStream e = System.err;
    static DecimalFormat df = new DecimalFormat("###.#");
    static DecimalFormat df2 = new DecimalFormat("#.#########");
    boolean verbose = false;
    boolean append = false;
    String label = null;
    File pctFile = null;
    File sampFile = null;
    float sampCutoff = Float.NaN;
    float probFlor = 0.0f;
    float probCeil = 100.0f;
    float probMin = 5.0E-4f;
    int nDim = Integer.MAX_VALUE;
    float maxProb = Float.NaN;
    int[] bounds = null;

    public void doChecks() throws FileNotFoundException, IllegalArgumentException {
        if (this.pctFile == null) {
            throw new IllegalArgumentException("*** Must specify at least one filename");
        }
        Scanner scanner = new Scanner(this.pctFile);
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            if (string.startsWith("#")) continue;
            String[] stringArray = Strings.explode(string, ' ');
            if (stringArray.length == 1) {
                stringArray = Strings.explode(string, ':');
            }
            this.nDim = stringArray.length;
            float f = Float.parseFloat(stringArray[stringArray.length - 1]);
            if (Float.isNaN(this.maxProb)) {
                this.maxProb = f;
                continue;
            }
            if (!(f > this.maxProb)) continue;
            this.maxProb = f;
        }
        if (this.verbose) {
            this.e.println("Found " + (this.nDim - 1) + " dihedral(s) plus 1 value");
        }
        if (this.bounds == null) {
            if (this.verbose) {
                this.e.println("Didn't provide -bounds=xmin,xmax,... so using 0,360");
            }
            this.bounds = new int[2 * (this.nDim - 1)];
            for (int i = 0; i < 2 * (this.nDim - 1); ++i) {
                this.bounds[i] = i % 2 == 0 ? 0 : 360;
            }
        }
        if (this.nDim == Integer.MAX_VALUE) {
            System.err.println("*** Couldn't figure out number of dimensions!  Quitting...");
            System.exit(0);
        }
        if (this.label == null) {
            String string = this.pctFile.getName();
            this.label = string.indexOf(".") != -1 ? string.substring(0, string.indexOf(".")) : string;
        }
    }

    public void doKin() throws FileNotFoundException {
        if (!this.append) {
            this.o.println("@kinemage {" + this.label + "}");
            this.doAxes();
        }
        this.doHeader();
        this.doPct();
        if (this.sampFile != null) {
            this.doSamp();
        }
        this.o.flush();
    }

    public void doAxes() {
        this.o.print("@group {axes} dominant\n@vectorlist {axes} color= white width= 1\n");
        if (this.nDim == 2) {
            this.o.print("{  0 " + this.probFlor + "}P   0 " + this.probFlor + "\n" + "{  0 " + this.probCeil + "}    0 " + this.probCeil + "\n" + "{360 " + this.probCeil + "}  360 " + this.probCeil + "\n" + "{360 " + this.probFlor + "}  360 " + this.probFlor + "\n" + "{  0 " + this.probFlor + "}    0 " + this.probFlor + "\n");
        } else {
            this.o.print("{  0   0 " + this.probFlor + "}P   0   0 " + this.probFlor + "\n" + "{  0 360 " + this.probFlor + "}    0 360 " + this.probFlor + "\n" + "{360 360 " + this.probFlor + "}  360 360 " + this.probFlor + "\n" + "{360   0 " + this.probFlor + "}  360   0 " + this.probFlor + "\n" + "{  0   0 " + this.probFlor + "}    0   0 " + this.probFlor + "\n" + "{  0   0 " + this.probCeil + "}P   0   0 " + this.probCeil + "\n" + "{  0 360 " + this.probCeil + "}    0 360 " + this.probCeil + "\n" + "{360 360 " + this.probCeil + "}  360 360 " + this.probCeil + "\n" + "{360   0 " + this.probCeil + "}  360   0 " + this.probCeil + "\n" + "{  0   0 " + this.probCeil + "}    0   0 " + this.probCeil + "\n" + "{  0   0 " + this.probFlor + "}P   0   0 " + this.probFlor + "\n" + "{  0   0 " + this.probCeil + "}    0   0 " + this.probCeil + "\n" + "{  0 360 " + this.probFlor + "}P   0 360 " + this.probFlor + "\n" + "{  0 360 " + this.probCeil + "}    0 360 " + this.probCeil + "\n" + "{360 360 " + this.probFlor + "}P 360 360 " + this.probFlor + "\n" + "{360 360 " + this.probCeil + "}  360 360 " + this.probCeil + "\n" + "{360   0 " + this.probFlor + "}P 360   0 " + this.probFlor + "\n+" + "{360   0 " + this.probCeil + "}  360   0 " + this.probCeil + "\n");
        }
    }

    public void doHeader() {
        int n;
        if (this.nDim == 2) {
            this.o.println("@flat");
        }
        if (this.nDim >= 4) {
            this.o.println("@1axischoice 1 2 " + this.nDim);
        }
        this.o.print("@dimensions ");
        for (n = 1; n < this.nDim; ++n) {
            this.o.print(" {chi" + n + "?}");
        }
        this.o.println(" {norm'd probability}");
        this.o.print("@dimminmax ");
        for (n = 0; n < 2 * (this.nDim - 1); ++n) {
            this.o.print(" " + this.bounds[n]);
        }
        this.o.println();
        this.o.println("@group {" + this.label + "} animate dominant");
    }

    public void doPct() throws FileNotFoundException {
        this.o.println("@balllist {pct} master= {pct} dimension= " + this.nDim);
        Scanner scanner = new Scanner(this.pctFile);
        while (scanner.hasNextLine()) {
            int n;
            String string = scanner.nextLine();
            if (string.startsWith("#")) continue;
            String[] stringArray = Strings.explode(string, ' ');
            if (stringArray.length == 1) {
                stringArray = Strings.explode(string, ':');
            }
            if (stringArray.length == 1) {
                System.err.println("*** Error parsing line: " + string);
                continue;
            }
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            float f = fArray[fArray.length - 1];
            if (!(f >= this.probMin)) continue;
            this.o.print("{" + df.format(fArray[0]));
            for (int i = 1; i < fArray.length - 1; ++i) {
                this.o.print(", " + df.format(fArray[i]));
            }
            this.o.print(", pct=" + df2.format(f) + "} ");
            float f2 = f * 2.0f;
            this.o.print("r=" + f2 + " ");
            if ((double)f < 0.1) {
                this.o.print("peachtint ");
            } else if ((double)f >= 0.1 && (double)f < 0.2) {
                this.o.print("peach ");
            } else {
                this.o.print("orange ");
            }
            for (n = 0; n < fArray.length - 1; ++n) {
                fArray[n] = fArray[n] + (float)(0 - this.bounds[2 * n]);
                if (!(fArray[n] > 360.0f)) continue;
                fArray[n] = fArray[n] - 360.0f;
            }
            for (n = 0; n < fArray.length - 1; ++n) {
                this.o.print(df.format(fArray[n]) + " ");
            }
            float f3 = this.probCeil * (f / this.maxProb);
            this.o.println(df2.format(f3));
        }
    }

    public void doSamp() throws FileNotFoundException {
        this.o.println("@balllist {samp} radius= 2.0 color= green master= {samp} dimension= " + this.nDim);
        Scanner scanner = new Scanner(this.sampFile);
        while (scanner.hasNextLine()) {
            int n;
            String string = scanner.nextLine();
            if (string.startsWith("#")) continue;
            String[] stringArray = Strings.explode(string, ' ');
            if (stringArray.length == 1) {
                stringArray = Strings.explode(string, ':');
            }
            if (stringArray.length == 1) {
                System.err.println("*** Error parsing line: " + string);
                continue;
            }
            float[] fArray = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
            float f = fArray[fArray.length - 1];
            if (!(f >= this.probMin)) continue;
            this.o.print("{" + df.format(fArray[0]));
            for (n = 1; n < fArray.length - 2; ++n) {
                this.o.print(", " + df.format(fArray[n]));
            }
            this.o.print(", pct=" + df2.format(f) + "} ");
            for (n = 0; n < fArray.length - 2; ++n) {
                fArray[n] = fArray[n] + (float)(0 - this.bounds[2 * n]);
                if (!(fArray[n] > 360.0f)) continue;
                fArray[n] = fArray[n] - 360.0f;
            }
            for (n = 0; n < fArray.length - 2; ++n) {
                this.o.print(df.format(fArray[n]) + " ");
            }
            float f2 = this.probCeil * (f / this.maxProb);
            this.o.println(df2.format(f2));
        }
    }

    public void Main() throws IOException {
        this.doChecks();
        this.doKin();
    }

    public static void main(String[] stringArray) {
        DihedralPlotter dihedralPlotter = new DihedralPlotter();
        try {
            dihedralPlotter.parseArguments(stringArray);
            dihedralPlotter.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            dihedralPlotter.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            System.err.println("*** Error in execution: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("DihedralPlotter.help");
            if (inputStream == null) {
                System.err.println("\nUsage: java DihedralPlotter fromsilk.data [fromsilk-rotasamp.list] [opts]");
                System.err.println("\n*** Unable to locate help information in 'DihedralPlotter.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, this.o);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.sc.DihedralPlotter");
        System.err.println("Copyright (C) 2008 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.pctFile == null) {
            this.pctFile = new File(string);
        } else if (this.sampFile == null) {
            this.sampFile = new File(string);
        } else {
            throw new IllegalArgumentException("Too many file names: " + string);
        }
    }

    void interpretFlag(String string, String string2) {
        try {
            if (string.equals("-help") || string.equals("-h")) {
                this.showHelp(true);
                System.exit(0);
            } else if (string.equals("-verbose") || string.equals("-v")) {
                this.verbose = true;
            } else if (string.equals("-label")) {
                this.label = string2;
            } else if (string.equals("-cutoff")) {
                try {
                    this.sampCutoff = Float.parseFloat(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Can't parse -cutoff=" + string2 + " as a float");
                }
            } else if (string.equals("-bounds")) {
                String[] stringArray = Strings.explode(string2, ',');
                this.bounds = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    this.bounds[i] = Integer.parseInt(stringArray[i]);
                }
            } else if (string.equals("-append")) {
                this.append = true;
            } else if (!string.equals("-dummy_option")) {
                throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Non-number argument to " + string + ": '" + string2 + "'");
        }
    }
}

