/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import chiropraxis.sc.RotamerSampler;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;

public class DisulfSampler
extends RotamerSampler {
    String aaType = "CIS";
    public static final String REMOTENESS = "HZEDGBA ";
    File inFile = null;
    Residue res1 = null;
    Residue res2 = null;
    int nAngles = 5;
    String chisSupplied = "1,2,3";
    boolean plotChis = false;
    String group = null;
    String color = null;

    public ModelState setChi(int n, Residue residue, Residue residue2, ModelState modelState, double d) throws AtomException {
        ArrayList<Atom> arrayList = new ArrayList<Atom>();
        Object object = residue.getAtoms().iterator();
        while (object.hasNext()) {
            arrayList.add((Atom)object.next());
        }
        object = residue2.getAtoms().iterator();
        while (object.hasNext()) {
            arrayList.add((Atom)object.next());
        }
        object = null;
        AtomState atomState = null;
        AtomState atomState2 = null;
        AtomState atomState3 = null;
        if (n == 1) {
            object = modelState.get(residue.getAtom(" N  "));
            atomState = modelState.get(residue.getAtom(" CA "));
            atomState2 = modelState.get(residue.getAtom(" CB "));
            atomState3 = modelState.get(residue.getAtom(" SG "));
        }
        if (n == 2) {
            object = modelState.get(residue.getAtom(" CA "));
            atomState = modelState.get(residue.getAtom(" CB "));
            atomState2 = modelState.get(residue.getAtom(" SG "));
            atomState3 = modelState.get(residue2.getAtom(" SG "));
        }
        if (n == 3) {
            object = modelState.get(residue.getAtom(" CB "));
            atomState = modelState.get(residue.getAtom(" SG "));
            atomState2 = modelState.get(residue2.getAtom(" SG "));
            atomState3 = modelState.get(residue2.getAtom(" CB "));
        }
        if (n == 4) {
            object = modelState.get(residue.getAtom(" SG "));
            atomState = modelState.get(residue2.getAtom(" SG "));
            atomState2 = modelState.get(residue2.getAtom(" CB "));
            atomState3 = modelState.get(residue2.getAtom(" CA "));
        }
        if (n == 5) {
            object = modelState.get(residue2.getAtom(" SG "));
            atomState = modelState.get(residue2.getAtom(" CB "));
            atomState2 = modelState.get(residue2.getAtom(" CA "));
            atomState3 = modelState.get(residue2.getAtom(" N  "));
        }
        double d2 = Triple.dihedral((Tuple3)object, atomState, atomState2, atomState3);
        double d3 = d - d2;
        Transform transform = new Transform();
        transform.likeRotation(atomState, atomState2, d3);
        ModelState modelState2 = new ModelState(modelState);
        for (Atom atom : arrayList) {
            object = modelState.get(atom);
            atomState = (AtomState)((AtomState)object).clone();
            if (!this.areParentAndChild(atomState2.getAtom(), atom, atomState2.getAtom().getResidue(), atom.getResidue())) continue;
            transform.transform(atomState);
            modelState2.add(atomState);
        }
        return modelState2;
    }

    protected boolean areParentAndChild(Atom atom, Atom atom2, Residue residue, Residue residue2) {
        int n;
        int n2;
        int n3 = residue2.getSequenceInteger();
        if (n3 > (n2 = residue.getSequenceInteger())) {
            return true;
        }
        String string = atom.getName();
        String string2 = atom2.getName();
        int n4 = REMOTENESS.indexOf(string.charAt(2));
        return n4 > (n = REMOTENESS.indexOf(string2.charAt(2))) && n3 == 1 && n2 == 1 || n4 < n && n3 == 2 && n2 == 2 || n4 == n && n2 == n3 && (string.charAt(3) == ' ' || string.charAt(3) == string2.charAt(3)) && string.charAt(1) != 'H' && string2.charAt(1) == 'H';
    }

    public void Main() throws IOException, NumberFormatException {
        String string;
        Object object2;
        if (this.inFile == null) {
            throw new IllegalArgumentException("Not enough command line arguments");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(this.getClass().getResourceAsStream("disulf.pdb"));
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        for (Object object2 : model.getResidues()) {
            if (this.res1 == null) {
                this.res1 = object2;
                continue;
            }
            if (this.res2 == null) {
                this.res2 = object2;
                continue;
            }
            System.err.println("Oops, found more than two residues in the reference disulfide coordinates!");
        }
        if (this.res1 == null || this.res2 == null) {
            throw new IllegalArgumentException("Couldn't find enough residues in the the reference disulfide coordinates...");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.inFile));
        object2 = new ArrayList();
        int n = -1;
        while ((string = lineNumberReader.readLine()) != null) {
            int n2;
            if (string.startsWith("#")) continue;
            String[] stringArray = Strings.explode(string, ':');
            if (n < 0) {
                n = stringArray.length;
            } else if (n != stringArray.length) {
                throw new IllegalArgumentException("Data fields are of different lengths");
            }
            double[] dArray = new double[7];
            for (n2 = 0; n2 < 7; ++n2) {
                dArray[n2] = Double.NaN;
            }
            if (this.chisSupplied.equals("1,2,3")) {
                for (n2 = 0; n2 < n - 2; ++n2) {
                    dArray[n2] = Double.parseDouble(stringArray[n2]);
                }
                if (Double.isNaN(dArray[3])) {
                    dArray[3] = 290.0;
                }
                if (Double.isNaN(dArray[4])) {
                    dArray[4] = 300.0;
                }
                dArray[5] = Double.parseDouble(stringArray[n - 2]);
                dArray[6] = Double.parseDouble(stringArray[n - 1]);
            } else if (this.chisSupplied.equals("2,3,2") || this.chisSupplied.equals("2,3,2p")) {
                dArray[0] = 300.0;
                for (n2 = 0; n2 < n - 2; ++n2) {
                    dArray[n2 + 1] = Double.parseDouble(stringArray[n2]);
                }
                if (Double.isNaN(dArray[4])) {
                    dArray[4] = 300.0;
                }
                dArray[5] = Double.parseDouble(stringArray[n - 2]);
                dArray[6] = Double.parseDouble(stringArray[n - 1]);
            }
            ((ArrayList)object2).add(dArray);
        }
        lineNumberReader.close();
        double d = 0.0;
        Object object3 = ((ArrayList)object2).iterator();
        while (object3.hasNext()) {
            double[] dArray = (double[])object3.next();
            d = Math.max(d, dArray[5]);
        }
        if (this.plotChis) {
            int n3;
            object3 = new DecimalFormat("###.#");
            if (this.group == null) {
                this.group = "disulf samp chis";
            }
            if (this.color == null) {
                this.color = "yellow";
            }
            if (this.chisSupplied.equals("1,2,3")) {
                System.out.println("@1axischoice 1 2 3");
            }
            if (this.chisSupplied.equals("2,3,2") || this.chisSupplied.equals("2,3,2p")) {
                System.out.println("@1axischoice 2 3 4");
            }
            System.out.print("@dimensions ");
            for (n3 = 1; n3 <= this.nAngles; ++n3) {
                System.out.print(" {chi" + n3 + "}");
            }
            System.out.println();
            System.out.print("@dimminmax ");
            for (n3 = 1; n3 <= this.nAngles; ++n3) {
                System.out.print(" 0 360");
            }
            System.out.println();
            System.out.println("@group {" + this.group + "} dominant");
            System.out.println("@balllist {" + this.group + "} radius= 4 color= " + this.color + " dimension= " + this.nAngles);
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                int n4;
                double[] dArray = (double[])iterator.next();
                System.out.print("{");
                for (n4 = 0; n4 < this.nAngles; ++n4) {
                    System.out.print(((NumberFormat)object3).format(dArray[n4]) + ", ");
                }
                System.out.print("} ");
                for (n4 = 0; n4 < this.nAngles; ++n4) {
                    System.out.print(((NumberFormat)object3).format(dArray[n4]) + " ");
                }
                System.out.println();
            }
        } else {
            object3 = new PdbWriter(System.out);
            ((PdbWriter)object3).setRenumberAtoms(true);
            int n5 = 1;
            Iterator iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                try {
                    Residue residue = new Residue(this.res1, " ", "", Integer.toString(1), " ", this.res1.getName());
                    Residue residue2 = new Residue(this.res2, " ", "", Integer.toString(2), " ", this.res2.getName());
                    ModelState modelState2 = residue.cloneStates(this.res1, modelState, new ModelState(modelState));
                    modelState2 = residue2.cloneStates(this.res2, modelState, modelState2);
                    double[] dArray = (double[])iterator.next();
                    modelState2 = this.setChi(1, residue, residue2, new ModelState(modelState2), dArray[0]);
                    modelState2 = this.setChi(2, residue, residue2, new ModelState(modelState2), dArray[1]);
                    modelState2 = this.setChi(3, residue, residue2, new ModelState(modelState2), dArray[2]);
                    modelState2 = this.setChi(4, residue, residue2, new ModelState(modelState2), dArray[3]);
                    modelState2 = this.setChi(5, residue, residue2, new ModelState(modelState2), dArray[4]);
                    ArrayList<Residue> arrayList = new ArrayList<Residue>();
                    arrayList.add(residue);
                    arrayList.add(residue2);
                    if (n5 > 0 && n5 < 10) {
                        System.out.println("MODEL        " + n5);
                    } else if (n5 >= 10 && n5 < 100) {
                        System.out.println("MODEL       " + n5);
                    } else if (n5 >= 100) {
                        System.out.println("MODEL      " + n5);
                    }
                    ((PdbWriter)object3).writeResidues(arrayList, modelState2);
                    System.out.println("ENDMDL");
                }
                catch (AtomException atomException) {
                    atomException.printStackTrace();
                }
                ++n5;
            }
            System.out.flush();
            ((PdbWriter)object3).close();
        }
    }

    public static void main(String[] stringArray) {
        DisulfSampler disulfSampler = new DisulfSampler();
        try {
            disulfSampler.parseArguments(stringArray);
            disulfSampler.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            disulfSampler.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println();
            System.err.println("*** Error: " + throwable.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("DisulfSampler.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'DisulfSampler.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.sc.DisulfSampler");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.inFile != null) {
            throw new IllegalArgumentException("Too many command line arguments");
        }
        this.inFile = new File(string);
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-plotchis")) {
            this.plotChis = true;
        } else if (string.equals("-group")) {
            this.group = string2;
        } else if (string.equals("-color")) {
            this.color = string2;
        } else if (string.equals("-chis")) {
            this.chisSupplied = string2;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

