/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.r3.Quaternion;
import driftwood.r3.SuperPoser;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RotamerSampler {
    boolean verbose = false;
    String aaType;
    File inFile;
    Residue res;
    boolean allAngles = true;
    String group;
    String color;
    boolean inverse = false;
    boolean printSamples = false;
    boolean plotChis = false;
    boolean chi234 = false;
    boolean plotQuats = false;
    int keepCnt = Integer.MAX_VALUE;
    double keepFrc = Double.NaN;
    HashMap<double[], Residue> residues;
    HashMap<double[], ModelState> states;
    HashMap<double[], Quaternion> quats;
    HashMap<double[], Quaternion> quatsOrig;

    public void buildConformers(ArrayList<double[]> arrayList) throws IOException {
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(this.getClass().getResourceAsStream("singleres.pdb"));
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        Residue residue = null;
        for (Residue residue2 : model.getResidues()) {
            if (!this.aaType.equals(residue2.getName())) continue;
            residue = residue2;
        }
        if (residue == null) {
            throw new IllegalArgumentException("Couldn't find a residue called '" + this.aaType + "'");
        }
        SidechainAngles2 sidechainAngles2 = new SidechainAngles2();
        int n = this.allAngles ? sidechainAngles2.countAllAngles(residue) : sidechainAngles2.countChiAngles(residue);
        double d = 0.0;
        for (double[] object2 : arrayList) {
            d = Math.max(d, object2[n]);
        }
        this.residues = new HashMap();
        this.states = new HashMap();
        int n2 = 1;
        Iterator<double[]> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                double[] atomException = iterator.next();
                Residue residue2 = new Residue(residue, " ", "", Integer.toString(n2), " ", residue.getName());
                ModelState modelState2 = residue2.cloneStates(residue, modelState, new ModelState(modelState));
                modelState2 = this.allAngles ? sidechainAngles2.setAllAngles(residue2, modelState2, atomException) : sidechainAngles2.setChiAngles(residue2, modelState2, atomException);
                for (Atom atom : residue2.getAtoms()) {
                    double d2 = 999.0 * atomException[n] / d;
                    if (d2 >= 1000.0) {
                        throw new Error("Logical error in occupancy weighting scheme");
                    }
                    modelState2.get(atom).setOccupancy(d2);
                }
                this.residues.put(atomException, residue2);
                this.states.put(atomException, modelState2);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
            ++n2;
        }
    }

    public void calcQuats(ArrayList<double[]> arrayList) {
        String[] stringArray = null;
        if (this.aaType.equals("ASN")) {
            stringArray = new String[]{" CG ", " OD1", " ND2"};
        }
        if (this.aaType.equals("GLN")) {
            stringArray = new String[]{" CD ", " OE1", " NE2"};
        }
        if (this.aaType.equals("ARG")) {
            stringArray = new String[]{" CZ ", " NH1", " NH2"};
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("Unrecognized aa type: " + this.aaType + "!");
        }
        this.quats = new HashMap();
        this.quatsOrig = new HashMap();
        Iterator<double[]> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            try {
                Object object;
                Tuple3[] tuple3Array2;
                double[] dArray = iterator.next();
                Residue residue = this.residues.get(dArray);
                ModelState modelState = this.states.get(dArray);
                Triple triple = null;
                Triple triple2 = null;
                Triple triple3 = null;
                Triple triple4 = null;
                Triple triple5 = null;
                Triple triple6 = null;
                for (Tuple3[] tuple3Array2 : residue.getAtoms()) {
                    object = modelState.get((Atom)tuple3Array2);
                    if (tuple3Array2.getName().equals(" CA ")) {
                        triple = new Triple((Tuple3)object);
                    }
                    if (tuple3Array2.getName().equals(" N  ")) {
                        triple2 = new Triple((Tuple3)object);
                    }
                    if (tuple3Array2.getName().equals(" C  ")) {
                        triple3 = new Triple((Tuple3)object);
                    }
                    if (tuple3Array2.getName().equals(stringArray[0])) {
                        triple4 = new Triple((Tuple3)object);
                    }
                    if (tuple3Array2.getName().equals(stringArray[1])) {
                        triple5 = new Triple((Tuple3)object);
                    }
                    if (!tuple3Array2.getName().equals(stringArray[2])) continue;
                    triple6 = new Triple((Tuple3)object);
                }
                if (triple == null || triple2 == null || triple3 == null) {
                    throw new IllegalArgumentException("Can't find the 3 bb atoms in " + residue + "!");
                }
                if (triple4 == null || triple5 == null || triple6 == null) {
                    throw new IllegalArgumentException("Can't find the 3 sc atoms in " + residue + "!");
                }
                Tuple3[] tuple3Array3 = new Triple[]{triple, triple2, triple3};
                tuple3Array2 = new Triple[]{triple4, triple5, triple6};
                object = new SuperPoser(tuple3Array3, tuple3Array2);
                Transform transform = ((SuperPoser)object).superpos();
                Quaternion quaternion = new Quaternion().likeRotation(transform);
                this.quats.put(dArray, quaternion);
                this.quatsOrig.put(dArray, quaternion);
                if (!this.inverse) continue;
                for (Atom atom : residue.getAtoms()) {
                    AtomState atomState = modelState.get(atom);
                    transform.transform(atomState);
                }
                this.states.put(dArray, modelState);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
    }

    public void rmDuplicates(ArrayList<double[]> arrayList, ArrayList<double[]> arrayList2) {
        int n = this.keepCnt != Integer.MAX_VALUE ? this.keepCnt : (int)Math.floor((double)arrayList2.size() * this.keepFrc);
        System.err.println(arrayList.size() + "/" + arrayList2.size() + " samples, goal: " + n + "  (orig input)");
        boolean bl = false;
        while (!bl) {
            int n2 = this.rmOneDuplicate(arrayList);
            if (n2 == -1) {
                bl = true;
                continue;
            }
            double[] dArray = arrayList.get(n2);
            this.quats.remove(dArray);
            arrayList.remove(n2);
        }
    }

    public int rmOneDuplicate(ArrayList<double[]> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            double[] dArray = arrayList.get(i);
            Quaternion quaternion = this.quats.get(dArray);
            boolean bl = false;
            for (int j = 0; j < arrayList.size() && i != j; ++j) {
                double[] dArray2 = arrayList.get(j);
                Quaternion quaternion2 = this.quats.get(dArray2);
                if (!quaternion2.equals(quaternion)) continue;
                bl = true;
                if (this.verbose) {
                    System.err.println("Removing duplicate for " + Strings.arrayInParens(dArray));
                }
                return i;
            }
        }
        return -1;
    }

    public ArrayList<double[]> repulse(ArrayList<double[]> arrayList, ArrayList<double[]> arrayList2) {
        Cloneable cloneable;
        int n = this.keepCnt != Integer.MAX_VALUE ? this.keepCnt : (int)Math.floor((double)arrayList2.size() * this.keepFrc);
        System.err.println(arrayList.size() + "/" + arrayList2.size() + " samples, goal: " + n);
        if (arrayList.size() <= n) {
            return arrayList;
        }
        double d = Double.POSITIVE_INFINITY;
        int n2 = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            cloneable = new ArrayList<double[]>();
            for (int j = 0; j < arrayList.size(); ++j) {
                if (j == i) continue;
                ((ArrayList)cloneable).add((double[])arrayList.get(j));
            }
            double d2 = this.repulsion((ArrayList<double[]>)cloneable);
            if (!(d2 < d)) continue;
            d = d2;
            n2 = i;
        }
        if (n2 == -1 || d == Double.NEGATIVE_INFINITY) {
            System.err.println("Removing any sample would only increase \"energy\"!");
            return arrayList;
        }
        double[] dArray = arrayList.get(n2);
        arrayList.remove(n2);
        cloneable = new DecimalFormat("###.###");
        if (this.verbose) {
            System.err.println("Removed " + Strings.arrayInParens(dArray) + ",  E -> " + ((NumberFormat)cloneable).format(d));
        }
        return this.repulse(arrayList, arrayList2);
    }

    public double repulsion(ArrayList<double[]> arrayList) {
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            for (int j = 0; j < arrayList.size(); ++j) {
                Quaternion quaternion;
                if (j == i) continue;
                double[] dArray = arrayList.get(i);
                double[] dArray2 = arrayList.get(j);
                Quaternion quaternion2 = this.quats.get(dArray);
                if (quaternion2.equals(quaternion = this.quats.get(dArray2)) && this.verbose) {
                    System.err.println("found a duplicate: " + quaternion2);
                }
                double d2 = Math.sqrt(Math.pow(quaternion2.getX() - quaternion.getX(), 2.0) + Math.pow(quaternion2.getY() - quaternion.getY(), 2.0) + Math.pow(quaternion2.getZ() - quaternion.getZ(), 2.0) + Math.pow(quaternion2.getW() - quaternion.getW(), 2.0));
                double d3 = d2 * d2;
                d += 1.0 / d3;
            }
        }
        return d;
    }

    public void printSamples(ArrayList<double[]> arrayList) {
        Object object;
        Object object2;
        try {
            object2 = new LineNumberReader(new FileReader(this.inFile));
            while ((object = ((LineNumberReader)object2).readLine()) != null) {
                if (!((String)object).startsWith("#")) continue;
                System.out.println((String)object);
            }
            ((BufferedReader)object2).close();
        }
        catch (IOException iOException) {
            System.err.println("Error reading headers in " + this.inFile);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (double[])object2.next();
            for (int i = 0; i < ((Object)object).length - 1; ++i) {
                System.out.print((double)object[i] + ":");
            }
            System.out.println((double)object[((Object)object).length - 1]);
        }
    }

    public void plotChis(ArrayList<double[]> arrayList) {
        DecimalFormat decimalFormat = new DecimalFormat("###.#");
        if (this.group == null) {
            this.group = this.aaType + " samp chis";
        }
        if (this.color == null) {
            this.color = "blue";
        }
        System.out.println("@group {" + this.group + "} dominant");
        System.out.println("@balllist {" + this.group + "} radius= 3 color= " + this.color);
        for (double[] dArray : arrayList) {
            int n;
            System.out.print("{");
            for (n = 0; n < dArray.length - 2; ++n) {
                System.out.print(decimalFormat.format(dArray[n]) + ", ");
            }
            System.out.print("} ");
            n = dArray.length - 2 >= 4 ? 3 : dArray.length - 2;
            for (int i = this.chi234 ? 1 : 0; i < (this.chi234 ? n + 1 : n); ++i) {
                System.out.print(decimalFormat.format(dArray[i]) + " ");
            }
            System.out.println();
        }
    }

    public void plotQuats(ArrayList<double[]> arrayList, ArrayList<double[]> arrayList2) {
        System.out.println("@dimensions {X} {Y} {Z} {W}");
        System.out.println("@dimminmax -1 1 -1 1 -1 1 -1 1");
        System.out.println("@group {axis} dominant");
        System.out.println("@vectorlist {axis}");
        System.out.println("{axis}P -1 -1 -1");
        System.out.println("{axis}   1 -1 -1");
        System.out.println("{axis}   1  1 -1");
        System.out.println("{axis}  -1  1 -1");
        System.out.println("{axis}  -1 -1 -1");
        System.out.println("{axis}P -1 -1  1");
        System.out.println("{axis}   1 -1  1");
        System.out.println("{axis}   1  1  1");
        System.out.println("{axis}  -1  1  1");
        System.out.println("{axis}  -1 -1  1");
        System.out.println("{axis}P -1 -1 -1");
        System.out.println("{axis}  -1 -1  1");
        System.out.println("{axis}P  1 -1 -1");
        System.out.println("{axis}   1 -1  1");
        System.out.println("{axis}P -1  1 -1");
        System.out.println("{axis}  -1  1  1");
        System.out.println("{axis}P  1  1 -1");
        System.out.println("{axis}   1  1  1");
        System.out.println("@group {" + this.aaType + " quats " + arrayList2.size() + "/" + arrayList2.size() + "} dominant animate");
        System.out.println("@balllist {" + this.aaType + " quats} radius= 0.05 dimension= 4");
        for (double[] object22 : arrayList2) {
            Object object = this.quatsOrig.get(object22);
            System.out.println("{" + Strings.arrayInParens(object22) + "}" + (arrayList.contains(object22) ? " " : "gray ") + ((Quaternion)object).getX() + " " + ((Quaternion)object).getY() + " " + ((Quaternion)object).getZ() + " " + ((Quaternion)object).getW());
        }
        int n = this.keepCnt != Integer.MAX_VALUE ? this.keepCnt : (int)Math.floor((double)arrayList2.size() * this.keepFrc);
        System.out.println("@group {" + this.aaType + " quats " + n + "/" + arrayList2.size() + "} dominant animate");
        System.out.println("@balllist {" + this.aaType + " quats} radius= 0.05 dimension= 4");
        for (Object object : arrayList) {
            Quaternion quaternion = this.quats.get(object);
            System.out.println("{" + Strings.arrayInParens((double[])object) + "} " + quaternion.getX() + " " + quaternion.getY() + " " + quaternion.getZ() + " " + quaternion.getW());
        }
    }

    public void writePdb(ArrayList<double[]> arrayList) {
        PdbWriter pdbWriter = new PdbWriter(System.out);
        pdbWriter.setRenumberAtoms(true);
        int n = 1;
        for (double[] dArray : arrayList) {
            Residue residue = this.residues.get(dArray);
            ModelState modelState = this.states.get(dArray);
            System.out.println("MODEL     " + Strings.forceRight("" + n, 4));
            pdbWriter.writeResidues(Collections.singletonList(residue), modelState);
            System.out.println("ENDMDL");
            ++n;
        }
        System.out.flush();
        pdbWriter.close();
    }

    public void Main() throws IOException, NumberFormatException {
        String string;
        if (this.aaType == null || this.inFile == null) {
            throw new IllegalArgumentException("Not enough command line arguments - need aatype & listfile");
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.inFile));
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        ArrayList<double[]> arrayList2 = new ArrayList<double[]>();
        int n = -1;
        while ((string = lineNumberReader.readLine()) != null) {
            if (string.startsWith("#")) continue;
            String[] stringArray = Strings.explode(string, ':');
            if (n < 0) {
                n = stringArray.length;
            } else if (n != stringArray.length) {
                throw new IllegalArgumentException("Data fields are of different lengths");
            }
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = Double.parseDouble(stringArray[i]);
            }
            arrayList.add(dArray);
            arrayList2.add(dArray);
        }
        lineNumberReader.close();
        if (this.plotChis) {
            this.plotChis(arrayList);
            return;
        }
        this.buildConformers(arrayList);
        if (this.keepCnt != Integer.MAX_VALUE || !Double.isNaN(this.keepFrc)) {
            this.calcQuats(arrayList);
            this.rmDuplicates(arrayList, arrayList2);
            this.repulse(arrayList, arrayList2);
        }
        if (this.printSamples) {
            this.printSamples(arrayList);
        } else if (this.plotQuats) {
            this.plotQuats(arrayList, arrayList2);
        } else {
            this.writePdb(arrayList);
        }
    }

    public static void main(String[] stringArray) {
        RotamerSampler rotamerSampler = new RotamerSampler();
        try {
            rotamerSampler.parseArguments(stringArray);
            rotamerSampler.Main();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            System.err.println();
            rotamerSampler.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + illegalArgumentException.getMessage());
            System.exit(1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println();
            System.err.println("*** Error: " + throwable.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("RotamerSampler.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'RotamerSampler.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.sc.RotamerSampler");
        System.err.println("Copyright (C) 2004 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.aaType == null) {
            this.aaType = string.toUpperCase();
        } else if (this.inFile == null) {
            this.inFile = new File(string);
        } else {
            throw new IllegalArgumentException("Too many command line arguments");
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-chionly")) {
            this.allAngles = false;
        } else if (string.equals("-plotchis")) {
            this.plotChis = true;
        } else if (string.equals("-plotquats")) {
            this.plotQuats = true;
        } else if (string.equals("-printsamples")) {
            this.printSamples = true;
        } else if (string.equals("-group")) {
            this.group = string2;
        } else if (string.equals("-color")) {
            this.color = string2;
        } else if (string.equals("-chi234")) {
            this.chi234 = true;
        } else if (string.equals("-keep")) {
            try {
                double d = Double.parseDouble(string2);
                if (d < 0.0) {
                    System.err.println("D'oh!  -keep=" + string2 + " must be >= 0...  Ignoring flag");
                } else if (d <= 1.0) {
                    System.err.println("Treating -keep=" + string2 + " as a fraction");
                    this.keepFrc = d;
                } else if (d > 1.0) {
                    System.err.println("Treating -keep=" + string2 + " as an integer count");
                    this.keepCnt = (int)Math.floor(d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("*** Error: couldn't parse -keep=" + string2 + " as a double!");
            }
        } else if (string.equals("-inverse")) {
            this.inverse = true;
        } else if (string.equals("-v") || string.equals("-verbose")) {
            this.verbose = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

