/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import chiropraxis.sc.SidechainAngles2;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SidechainIdealizer {
    SidechainAngles2 scAngles;
    Map idealSidechainMap;
    Map idealResMap;
    Map idealResMapv23;
    ModelState idealResState;
    ModelState idealResStatev23;
    Builder builder = new Builder();

    public SidechainIdealizer() throws IOException {
        this.scAngles = new SidechainAngles2();
        this.loadIdealResidues();
        this.loadIdealResiduesv23();
    }

    Map loadIdealSidechains() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("singlesc.pdb");
        if (inputStream == null) {
            throw new IOException("File not found in JAR: singlesc.pdb");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(inputStream);
        Model model = coordinateFile.getFirstModel();
        ModelState modelState = model.getState();
        HashMap hashMap = new HashMap();
        Iterator iterator = model.getResidues().iterator();
        while (iterator.hasNext()) {
            try {
                Residue residue = (Residue)iterator.next();
                AtomState atomState = modelState.get(residue.getAtom(" CA "));
                HashMap<String, Triple> hashMap2 = new HashMap<String, Triple>();
                for (Atom atom : residue.getAtoms()) {
                    AtomState atomState2 = modelState.get(atom);
                    hashMap2.put(atom.getName(), new Triple(atomState2).sub(atomState));
                }
                hashMap.put(residue.getName(), hashMap2);
            }
            catch (AtomException atomException) {
                atomException.printStackTrace();
            }
        }
        return hashMap;
    }

    void loadIdealResidues() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("singleres.pdb");
        if (inputStream == null) {
            throw new IOException("File not found in JAR: singleres.pdb");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(inputStream);
        Model model = coordinateFile.getFirstModel();
        this.idealResState = model.getState();
        this.idealResMap = new TreeMap();
        for (Residue residue : model.getResidues()) {
            this.idealResMap.put(residue.getName(), residue);
        }
    }

    void loadIdealResiduesv23() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("singleres-v23.pdb");
        if (inputStream == null) {
            throw new IOException("File not found in JAR: singleres.pdb");
        }
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(inputStream);
        Model model = coordinateFile.getFirstModel();
        this.idealResStatev23 = model.getState();
        this.idealResMapv23 = new TreeMap();
        for (Residue residue : model.getResidues()) {
            this.idealResMapv23.put(residue.getName(), residue);
        }
    }

    public Collection getResidueTypes() {
        return Collections.unmodifiableCollection(this.idealResMap.keySet());
    }

    public static ModelState idealizeCB(Residue residue, ModelState modelState) throws AtomException {
        AtomState atomState;
        Object object;
        Triple triple;
        Triple triple2;
        Triple triple3 = new Triple();
        Builder builder = new Builder();
        ModelState modelState2 = new ModelState(modelState);
        AtomState atomState2 = modelState.get(residue.getAtom(" N  "));
        AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
        AtomState atomState4 = modelState.get(residue.getAtom(" C  "));
        Atom atom = residue.getAtom(" CB ");
        if (atom != null) {
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.536, 110.4, 123.1);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.536, 110.6, -123.0);
            if (residue.getName().equals("ALA")) {
                triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.536, 110.1, 122.9);
                triple = builder.construct4(atomState4, atomState2, atomState3, 1.536, 110.6, -122.6);
            } else if (residue.getName().equals("PRO")) {
                triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.53, 112.2, 115.1);
                triple = builder.construct4(atomState4, atomState2, atomState3, 1.53, 103.0, -120.7);
            } else if (residue.getName().equals("VAL") || residue.getName().equals("THR") || residue.getName().equals("ILE")) {
                triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.54, 111.5, 123.4);
                triple = builder.construct4(atomState4, atomState2, atomState3, 1.54, 109.1, -122.0);
            } else if (residue.getName().equals("GLY")) {
                triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 109.3, 121.6);
                triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 109.3, -121.6);
            } else {
                triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.53, 110.1, 122.8);
                triple = builder.construct4(atomState4, atomState2, atomState3, 1.53, 110.5, -122.6);
            }
            triple3.likeMidpoint(triple2, triple);
            object = modelState.get(atom);
            double d = Triple.angle(triple3, atomState3, (Tuple3)object);
            triple2.likeNormal(triple3, atomState3, (Tuple3)object).add(atomState3);
            Transform transform = new Transform().likeRotation(atomState3, triple2, d);
            for (Atom atom2 : residue.getAtoms()) {
                String string = atom2.getName();
                if (string.equals(" N  ") || string.equals(" H  ") || string.equals(" CA ") || string.equals(" HA ") || string.equals("1HA ") || string.equals("2HA ") || string.equals(" HA2") || string.equals(" HA3") || string.equals(" C  ") || string.equals(" O  ")) continue;
                AtomState atomState5 = modelState.get(atom2);
                AtomState atomState6 = (AtomState)atomState5.clone();
                transform.transform(atomState5, atomState6);
                modelState2.add(atomState6);
            }
        }
        if ((object = residue.getAtom(" HA ")) != null) {
            AtomState atomState7 = modelState.get((Atom)object);
            atomState = (AtomState)atomState7.clone();
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 107.9, -118.3);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 108.1, 118.2);
            atomState.likeMidpoint(triple2, triple).sub(atomState3).unit().mult(1.1).add(atomState3);
            modelState2.add(atomState);
        }
        if ((object = residue.getAtom("1HA ")) == null) {
            residue.getAtom(" HA2");
        }
        if (object != null) {
            AtomState atomState8 = modelState.get((Atom)object);
            atomState = (AtomState)atomState8.clone();
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 109.3, -121.6);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 109.3, 121.6);
            atomState.likeMidpoint(triple2, triple).sub(atomState3).unit().mult(1.1).add(atomState3);
            modelState2.add(atomState);
        }
        if ((object = residue.getAtom("2HA ")) == null) {
            residue.getAtom(" HA3");
        }
        if (object != null) {
            AtomState atomState9 = modelState.get((Atom)object);
            atomState = (AtomState)atomState9.clone();
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 109.3, 121.6);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 109.3, -121.6);
            atomState.likeMidpoint(triple2, triple).sub(atomState3).unit().mult(1.1).add(atomState3);
            modelState2.add(atomState);
        }
        return modelState2;
    }

    public ModelState idealizeSidechain(Residue residue, ModelState modelState) {
        Residue residue2 = (Residue)this.idealResMap.get(residue.getName());
        Residue residue3 = (Residue)this.idealResMapv23.get(residue.getName());
        if (residue2 == null || residue3 == null) {
            return modelState;
        }
        double[] dArray = this.scAngles.measureAllAngles(residue, modelState);
        try {
            ModelState modelState2 = new ModelState(modelState);
            AtomState atomState = modelState.get(residue.getAtom(" CA "));
            AtomState atomState2 = modelState.get(residue.getAtom(" N  "));
            AtomState atomState3 = modelState.get(residue.getAtom(" C  "));
            AtomState atomState4 = this.idealResState.get(residue2.getAtom(" CA "));
            AtomState atomState5 = this.idealResState.get(residue2.getAtom(" N  "));
            AtomState atomState6 = this.idealResState.get(residue2.getAtom(" C  "));
            Transform transform = this.builder.dock3on3(atomState, atomState2, atomState3, atomState4, atomState5, atomState6);
            Iterator iterator = residue.getAtoms().iterator();
            while (iterator.hasNext()) {
                try {
                    Atom atom = (Atom)iterator.next();
                    String string = atom.getName();
                    Atom atom2 = residue2.getAtom(string);
                    if (string.equals(" N  ") || string.equals(" H  ") || string.equals(" C  ") || string.equals(" O  ")) continue;
                    AtomState atomState7 = modelState.get(atom);
                    AtomState atomState8 = atom2 != null ? this.idealResState.get(atom2) : this.idealResStatev23.get(residue3.getAtom(string));
                    AtomState atomState9 = (AtomState)atomState7.clone();
                    transform.transform(atomState8, atomState9);
                    modelState2.add(atomState9);
                }
                catch (AtomException atomException) {}
            }
            modelState2 = SidechainIdealizer.idealizeCB(residue, modelState2);
            modelState2 = this.scAngles.setAllAngles(residue, modelState2, dArray);
            return modelState2;
        }
        catch (AtomException atomException) {
            return modelState;
        }
    }

    public Residue makeIdealResidue(String string, String string2, String string3, String string4, String string5, ModelState modelState, boolean bl) {
        ModelState modelState2;
        Map map;
        if (bl) {
            map = this.idealResMap;
            modelState2 = this.idealResState;
        } else {
            map = this.idealResMapv23;
            modelState2 = this.idealResStatev23;
        }
        if (!map.containsKey(string5)) {
            throw new IllegalArgumentException("'" + string5 + "' is not a known amino acid");
        }
        Residue residue = (Residue)map.get(string5);
        try {
            Residue residue2 = new Residue(residue, string, string2, string3, string4, string5);
            residue2.cloneStates(residue, modelState2, modelState);
            return residue2;
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
            return null;
        }
    }

    public Residue makeIdealResidue(String string, String string2, String string3, String string4, String string5, ModelState modelState) {
        return this.makeIdealResidue(string, string2, string3, string4, string5, modelState, false);
    }

    public ModelState dockResidue(Residue residue, ModelState modelState, Residue residue2, ModelState modelState2) throws AtomException {
        Triple triple;
        Transform transform = this.builder.dock3on3(modelState2.get(residue2.getAtom(" CA ")), modelState2.get(residue2.getAtom(" N  ")), modelState2.get(residue2.getAtom(" C  ")), modelState.get(residue.getAtom(" CA ")), modelState.get(residue.getAtom(" N  ")), modelState.get(residue.getAtom(" C  ")));
        ModelState modelState3 = new ModelState(modelState);
        for (Object object : residue.getAtoms()) {
            triple = modelState.get((Atom)object);
            AtomState atomState = (AtomState)triple.clone();
            modelState3.add(atomState);
            transform.transform(atomState);
        }
        modelState3.get(residue.getAtom(" N  ")).like(modelState2.get(residue2.getAtom(" N  ")));
        modelState3.get(residue.getAtom(" CA ")).like(modelState2.get(residue2.getAtom(" CA ")));
        modelState3.get(residue.getAtom(" C  ")).like(modelState2.get(residue2.getAtom(" C  ")));
        try {
            modelState3.get(residue.getAtom(" O  ")).like(modelState2.get(residue2.getAtom(" O  ")));
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        try {
            if (!residue.getName().equals("PRO") && residue2.getName().equals("PRO")) {
                Object object;
                AtomState atomState = modelState2.get(residue2.getAtom(" N  "));
                object = modelState2.get(residue2.getAtom(" CD "));
                triple = new Triple(atomState).add(new Triple().likeVector(atomState, (Tuple3)object).unit());
                modelState3.get(residue.getAtom(" H  ")).like(triple);
            } else {
                modelState3.get(residue.getAtom(" H  ")).like(modelState2.get(residue2.getAtom(" H  ")));
            }
        }
        catch (AtomException atomException) {
            // empty catch block
        }
        return SidechainIdealizer.idealizeCB(residue, modelState3);
    }
}

