/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.sc;

import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.CoordinateFile;
import driftwood.moldb2.Model;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.PdbReader;
import driftwood.moldb2.PdbWriter;
import driftwood.moldb2.Residue;
import driftwood.r3.Builder;
import driftwood.r3.Transform;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class SidechainsLtoD {
    boolean verbose;
    String filename;
    Model model;
    ArrayList<Residue> residues;

    ModelState loadPdb() throws IOException {
        File file = new File(this.filename);
        FileInputStream fileInputStream = new FileInputStream(file);
        PdbReader pdbReader = new PdbReader();
        CoordinateFile coordinateFile = pdbReader.read(fileInputStream);
        this.model = coordinateFile.getFirstModel();
        ModelState modelState = this.model.getState();
        this.residues = new ArrayList();
        for (Residue residue : this.model.getResidues()) {
            this.residues.add(residue);
        }
        return modelState;
    }

    public ModelState changeSidechainLtoD(Residue residue, ModelState modelState) throws AtomException {
        AtomState atomState;
        Object object;
        Triple triple;
        Triple triple2;
        if (residue == null) {
            System.err.println("Cannot recognize residue " + residue + "!");
            return modelState;
        }
        Triple triple3 = new Triple();
        Builder builder = new Builder();
        ModelState modelState2 = new ModelState(modelState);
        AtomState atomState2 = modelState.get(residue.getAtom(" N  "));
        AtomState atomState3 = modelState.get(residue.getAtom(" CA "));
        AtomState atomState4 = modelState.get(residue.getAtom(" C  "));
        Atom atom = residue.getAtom(" CB ");
        if (atom != null) {
            AtomState atomState5;
            Object object2;
            Atom atom22;
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.536, 110.4, -118.3);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.536, 110.6, 118.2);
            triple3.likeMidpoint(triple2, triple);
            object = modelState.get(atom);
            double d = Triple.angle(triple3, atomState3, (Tuple3)object);
            triple2.likeNormal(triple3, atomState3, (Tuple3)object).add(atomState3);
            Transform transform = new Transform().likeRotation(atomState3, triple2, d);
            for (Atom atom22 : residue.getAtoms()) {
                object2 = atom22.getName();
                if (((String)object2).equals(" N  ") || ((String)object2).equals(" H  ") || ((String)object2).equals(" CA ") || ((String)object2).equals(" HA ") || ((String)object2).equals("1HA ") || ((String)object2).equals("2HA ") || ((String)object2).equals(" HA2") || ((String)object2).equals(" HA3") || ((String)object2).equals(" C  ") || ((String)object2).equals(" O  ")) continue;
                atomState5 = modelState.get(atom22);
                AtomState atomState6 = (AtomState)atomState5.clone();
                transform.transform(atomState5, atomState6);
                modelState2.add(atomState6);
            }
            String string = residue.getName();
            atom22 = residue.getAtom(" CG ");
            if (string == "GLY" || string == "ALA") {
                atom22 = null;
            } else if (string == "ILE" || string == "VAL") {
                atom22 = residue.getAtom(" CG1");
            } else if (string == "SER") {
                atom22 = residue.getAtom(" OG ");
            } else if (string == "THR") {
                atom22 = residue.getAtom(" OG1");
            } else if (string == "CYS") {
                atom22 = residue.getAtom(" SG ");
            }
            if (atom22 != null) {
                object2 = modelState.get(atom22);
                atomState5 = modelState2.get(atom22);
                double d2 = Triple.dihedral(atomState2, atomState3, (Tuple3)object, (Tuple3)object2);
                double d3 = Triple.dihedral(atomState2, atomState3, triple3, atomState5);
                double d4 = -1.0 * d2;
                Transform transform2 = new Transform().likeRotation(atomState3, triple3, d4 - d3);
                for (Atom atom3 : residue.getAtoms()) {
                    String string2 = atom3.getName();
                    if (string2.equals(" N  ") || string2.equals(" H  ") || string2.equals(" CA ") || string2.equals(" HA ") || string2.equals("1HA ") || string2.equals("2HA ") || string2.equals(" HA2") || string2.equals(" HA3") || string2.equals(" C  ") || string2.equals(" O  ") || string2.equals(" CB ")) continue;
                    AtomState atomState7 = modelState2.get(atom3);
                    AtomState atomState8 = (AtomState)atomState7.clone();
                    transform2.transform(atomState7, atomState8);
                    modelState2.addOverwrite(atomState8);
                }
            }
        }
        if ((object = residue.getAtom(" HA ")) != null) {
            AtomState atomState9 = modelState.get((Atom)object);
            atomState = (AtomState)atomState9.clone();
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 107.9, 123.1);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 108.1, -123.0);
            atomState.likeMidpoint(triple2, triple).sub(atomState3).unit().mult(1.1).add(atomState3);
            modelState2.add(atomState);
        }
        if ((object = residue.getAtom("1HA ")) == null) {
            residue.getAtom(" HA2");
        }
        if (object != null) {
            AtomState atomState10 = modelState.get((Atom)object);
            atomState = (AtomState)atomState10.clone();
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 109.3, 121.6);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 109.3, -121.6);
            atomState.likeMidpoint(triple2, triple).sub(atomState3).unit().mult(1.1).add(atomState3);
            modelState2.add(atomState);
        }
        if ((object = residue.getAtom("2HA ")) == null) {
            residue.getAtom(" HA3");
        }
        if (object != null) {
            AtomState atomState11 = modelState.get((Atom)object);
            atomState = (AtomState)atomState11.clone();
            triple2 = builder.construct4(atomState2, atomState4, atomState3, 1.1, 109.3, -121.6);
            triple = builder.construct4(atomState4, atomState2, atomState3, 1.1, 109.3, 121.6);
            atomState.likeMidpoint(triple2, triple).sub(atomState3).unit().mult(1.1).add(atomState3);
            modelState2.add(atomState);
        }
        return modelState2;
    }

    public void Main() throws IOException {
        if (this.verbose) {
            System.err.println("Starting Main method...");
        }
        try {
            ModelState modelState = this.loadPdb();
            for (int i = 0; i < this.residues.size(); ++i) {
                Residue residue = this.residues.get(i);
                try {
                    modelState = this.changeSidechainLtoD(residue, modelState);
                    continue;
                }
                catch (AtomException atomException) {
                    System.err.println("Atom exception for residue " + residue);
                }
            }
            PdbWriter pdbWriter = new PdbWriter(System.out);
            pdbWriter.writeResidues(this.residues, modelState);
            pdbWriter.close();
        }
        catch (IOException iOException) {
            System.err.println("I/O exception in reading PDB file " + this.filename + " ... exiting!");
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        SidechainsLtoD sidechainsLtoD = new SidechainsLtoD();
        try {
            sidechainsLtoD.parseArguments(stringArray);
            sidechainsLtoD.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            sidechainsLtoD.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("SidechainsLtoD.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'SidechainsLtoD.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.sc.SidechainsLtoD");
        System.err.println("Copyright (C) 2008 by Daniel A. Keedy. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.filename == null) {
            this.filename = string;
        } else {
            System.out.println("Didn't need " + string + "; already have file " + this.filename);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-verbose") || string.equals("-v")) {
            this.verbose = true;
        } else if (!string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

