/*
 * Decompiled with CFR 0.152.
 */
package driftwood.data;

import driftwood.data.HashFunction;
import driftwood.data.NullNaturalComparator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UberMap
extends AbstractMap {
    static final int HASH_MULT = -1640531527;
    final HashFunction hashFunc;
    UberEntry[] mapEntries;
    UberEntry mapHead = null;
    UberEntry mapTail = null;
    int mapSize = 0;
    final double loadFactor;
    int log2Capacity;
    int hashMask;
    UberEntrySet mapEntrySet = null;
    int numChanges = 0;

    public UberMap() {
        this(16);
    }

    public UberMap(int n) {
        this(n, 0.75);
    }

    public UberMap(int n, double d) {
        this(n, d, null);
    }

    public UberMap(HashFunction hashFunction) {
        this(16, 0.75, null);
    }

    public UberMap(int n, HashFunction hashFunction) {
        this(n, 0.75, null);
    }

    public UberMap(int n, double d, HashFunction hashFunction) {
        this.hashFunc = hashFunction == null ? new NullNaturalComparator() : hashFunction;
        if (d < 0.1) {
            d = 0.1;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        this.loadFactor = d;
        this.log2Capacity = 4;
        while (1 << this.log2Capacity < n && this.log2Capacity < 30) {
            ++this.log2Capacity;
        }
        int n2 = 1 << this.log2Capacity;
        this.mapEntries = new UberEntry[n2];
        this.hashMask = this.mapEntries.length - 1;
    }

    public UberMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public Set entrySet() {
        if (this.mapEntrySet == null) {
            this.mapEntrySet = new UberEntrySet();
        }
        return this.mapEntrySet;
    }

    private final int index(int n) {
        n = -1640531527 * n;
        n = n >>> 32 - this.log2Capacity & this.hashMask;
        return n;
    }

    protected UberEntry fetchEntry(Object object) {
        int n = this.index(this.hashFunc.hashCodeFor(object));
        UberEntry uberEntry = this.mapEntries[n];
        while (uberEntry != null) {
            if (this.hashFunc.areEqual(uberEntry.getKey(), object)) {
                return uberEntry;
            }
            uberEntry = uberEntry.chain;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        return this.fetchEntry(object) != null;
    }

    public Object get(Object object) {
        UberEntry uberEntry = this.fetchEntry(object);
        if (uberEntry == null) {
            return null;
        }
        return uberEntry.getValue();
    }

    public Object remove(Object object) {
        int n = this.index(this.hashFunc.hashCodeFor(object));
        UberEntry uberEntry = this.mapEntries[n];
        UberEntry uberEntry2 = null;
        while (uberEntry != null) {
            if (this.hashFunc.areEqual(uberEntry.getKey(), object)) {
                if (uberEntry2 == null) {
                    this.mapEntries[n] = uberEntry.chain;
                } else {
                    uberEntry2.chain = uberEntry.chain;
                }
                if (uberEntry.before == null) {
                    this.mapHead = uberEntry.after;
                } else {
                    uberEntry.before.after = uberEntry.after;
                }
                if (uberEntry.after == null) {
                    this.mapTail = uberEntry.before;
                } else {
                    uberEntry.after.before = uberEntry.before;
                }
                ++this.numChanges;
                --this.mapSize;
                return uberEntry.getValue();
            }
            uberEntry2 = uberEntry;
            uberEntry = uberEntry.chain;
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.mapEntries.length; ++i) {
            this.mapEntries[i] = null;
        }
        this.mapTail = null;
        this.mapHead = null;
        this.mapSize = 0;
        ++this.numChanges;
    }

    public int size() {
        return this.mapSize;
    }

    protected Object putBeforeImpl(UberEntry uberEntry, Object object, Object object2) {
        if (uberEntry != null && this.hashFunc.areEqual(uberEntry.getKey(), object)) {
            Object object3 = uberEntry.getValue();
            uberEntry.setValue(object2);
            ++this.numChanges;
            return object3;
        }
        if ((double)(this.mapSize + 1) > this.loadFactor * (double)this.mapEntries.length) {
            this.rehash(this.mapEntries.length * 2);
        }
        Object object4 = this.remove(object);
        int n = this.hashFunc.hashCodeFor(object);
        int n2 = this.index(n);
        UberEntry uberEntry2 = new UberEntry(object, object2, n);
        UberEntry uberEntry3 = this.mapEntries[n2];
        if (uberEntry3 == null) {
            this.mapEntries[n2] = uberEntry2;
        } else {
            while (uberEntry3.chain != null) {
                uberEntry3 = uberEntry3.chain;
            }
            uberEntry3.chain = uberEntry2;
        }
        if (this.mapSize == 0) {
            this.mapHead = this.mapTail = uberEntry2;
        } else if (uberEntry == null) {
            uberEntry2.before = this.mapTail;
            uberEntry2.before.after = uberEntry2;
            this.mapTail = uberEntry2;
        } else if (uberEntry == this.mapHead) {
            uberEntry2.after = this.mapHead;
            uberEntry2.after.before = uberEntry2;
            this.mapHead = uberEntry2;
        } else {
            uberEntry2.before = uberEntry.before;
            uberEntry2.after = uberEntry;
            uberEntry2.before.after = uberEntry2;
            uberEntry2.after.before = uberEntry2;
        }
        ++this.numChanges;
        ++this.mapSize;
        return object4;
    }

    public Object put(Object object, Object object2) {
        return this.putBefore(object, object, object2);
    }

    public Object putAtEnd(Object object, Object object2) {
        return this.putBeforeImpl(null, object, object2);
    }

    public Object putBefore(Object object, Object object2, Object object3) {
        UberEntry uberEntry = this.fetchEntry(object);
        return this.putBeforeImpl(uberEntry, object2, object3);
    }

    public Object putAfter(Object object, Object object2, Object object3) {
        UberEntry uberEntry = this.fetchEntry(object);
        if (uberEntry == null) {
            return this.putBeforeImpl(uberEntry, object2, object3);
        }
        return this.putBeforeImpl(uberEntry.after, object2, object3);
    }

    private final void rehash(int n) {
        if (this.log2Capacity == 30) {
            return;
        }
        UberMap uberMap = new UberMap(n, this.loadFactor, this.hashFunc);
        uberMap.putAll(this);
        this.mapEntries = uberMap.mapEntries;
        this.mapHead = uberMap.mapHead;
        this.mapTail = uberMap.mapTail;
        this.mapSize = uberMap.mapSize;
        this.log2Capacity = uberMap.log2Capacity;
        this.hashMask = uberMap.hashMask;
        ++this.numChanges;
    }

    public void ensureCapacity(int n) {
        if (n > this.mapEntries.length) {
            this.rehash(n);
        }
    }

    public double getLoadFactor() {
        return this.loadFactor;
    }

    public Object firstKey() {
        if (this.mapHead == null) {
            throw new NoSuchElementException("No first key; map is empty.");
        }
        return this.mapHead.getKey();
    }

    public Object lastKey() {
        if (this.mapTail == null) {
            throw new NoSuchElementException("No last key; map is empty.");
        }
        return this.mapTail.getKey();
    }

    public Object keyBefore(Object object) {
        UberEntry uberEntry = this.fetchEntry(object);
        if (uberEntry == null) {
            throw new NoSuchElementException(object + " is not a key in this map");
        }
        if (uberEntry.before == null) {
            throw new NoSuchElementException(object + " is the first key in this map");
        }
        return uberEntry.before.getKey();
    }

    public Object keyAfter(Object object) {
        UberEntry uberEntry = this.fetchEntry(object);
        if (uberEntry == null) {
            throw new NoSuchElementException(object + " is not a key in this map");
        }
        if (uberEntry.after == null) {
            throw new NoSuchElementException(object + " is the last key in this map");
        }
        return uberEntry.after.getKey();
    }

    class UberEntryIterator
    implements Iterator {
        UberEntry prevEntry = null;
        UberEntry nextEntry;
        int expectedNumChanges;

        public UberEntryIterator() {
            this.expectedNumChanges = UberMap.this.numChanges;
            this.nextEntry = UberMap.this.mapHead;
        }

        public boolean hasNext() {
            this.checkForMods();
            return this.nextEntry != null;
        }

        public Object next() {
            this.checkForMods();
            if (this.nextEntry == null) {
                throw new NoSuchElementException("No more elements in iteration");
            }
            this.prevEntry = this.nextEntry;
            this.nextEntry = this.nextEntry.after;
            return this.prevEntry;
        }

        public void remove() {
            this.checkForMods();
            if (this.prevEntry == null) {
                throw new NoSuchElementException("No elements have yet been returned by this iterator");
            }
            UberMap.this.remove(this.prevEntry.getKey());
            this.expectedNumChanges = UberMap.this.numChanges;
        }

        private void checkForMods() {
            if (this.expectedNumChanges != UberMap.this.numChanges) {
                throw new ConcurrentModificationException("Backing map was changed during iteration");
            }
        }
    }

    class UberEntrySet
    extends AbstractSet {
        public void clear() {
            UberMap.this.clear();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return entry.equals(UberMap.this.fetchEntry(entry.getKey()));
        }

        public Iterator iterator() {
            return new UberEntryIterator();
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            UberEntry uberEntry = UberMap.this.fetchEntry(entry.getKey());
            if (entry.equals(uberEntry)) {
                UberMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        public int size() {
            return UberMap.this.size();
        }
    }

    static class UberEntry
    implements Map.Entry {
        final Object key;
        final int hashCode;
        Object value;
        UberEntry before = null;
        UberEntry after = null;
        UberEntry chain = null;

        public UberEntry(Object object, Object object2, int n) {
            this.key = object;
            this.value = object2;
            this.hashCode = n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public String toString() {
            return this.key + " -> " + this.value + " @ " + this.hashCode;
        }
    }
}

