/*
 * Decompiled with CFR 0.152.
 */
package driftwood.moldb2;

import driftwood.moldb2.Model;
import driftwood.moldb2.Residue;

public class Disulfide {
    public static final Object NOT_IN_DISULFIDE = "No SS bond detected";
    public static final Object INTRA_CHAIN = "SS bond within same chain";
    public static final Object INTER_CHAIN = "SS bond between two different chains";
    int disulfideIndex = 0;
    Object type = NOT_IN_DISULFIDE;
    String initChainId;
    String endChainId;
    int initSeqNum;
    int endSeqNum;
    String initICode = " ";
    String endICode = " ";

    public int getIndex() {
        return this.disulfideIndex;
    }

    public Object getType() {
        return this.type;
    }

    public String getInitChainId() {
        return this.initChainId;
    }

    public String getEndChainId() {
        return this.endChainId;
    }

    public int getInitSeqNum() {
        return this.initSeqNum;
    }

    public int getEndSeqNum() {
        return this.endSeqNum;
    }

    public String getInitICode() {
        return this.initICode;
    }

    public String getEndICode() {
        return this.endICode;
    }

    public boolean contains(Residue residue) {
        return this.matchesInit(residue) || this.matchesEnd(residue);
    }

    public boolean matchesInit(Residue residue) {
        if (!residue.getName().equals("CYS")) {
            return false;
        }
        if (!this.initChainId.equals(residue.getChain())) {
            return false;
        }
        if (residue.getSequenceInteger() != this.initSeqNum) {
            return false;
        }
        return residue.getInsertionCode().compareTo(this.initICode) >= 0;
    }

    public boolean matchesEnd(Residue residue) {
        if (!residue.getName().equals("CYS")) {
            return false;
        }
        if (!this.endChainId.equals(residue.getChain())) {
            return false;
        }
        if (residue.getSequenceInteger() != this.endSeqNum) {
            return false;
        }
        return residue.getInsertionCode().compareTo(this.endICode) <= 0;
    }

    public Residue otherEnd(Model model, Residue residue) {
        block4: {
            block3: {
                if (!this.contains(residue)) {
                    return null;
                }
                if (!this.matchesInit(residue)) break block3;
                for (Residue residue2 : model.getResidues()) {
                    if (!this.matchesEnd(residue2)) continue;
                    return residue2;
                }
                break block4;
            }
            if (!this.matchesEnd(residue)) break block4;
            for (Residue residue3 : model.getResidues()) {
                if (!this.matchesInit(residue3)) continue;
                return residue3;
            }
        }
        return null;
    }
}

