/*
 * Decompiled with CFR 0.152.
 */
package driftwood.r3;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;

public class LsqPlane {
    Triple anchor = new Triple();
    Triple normal = new Triple();
    double rmsd;

    public LsqPlane(Collection collection) {
        this.fitPlane(collection);
    }

    private void fitPlane(Collection collection) {
        this.anchor = LsqPlane.calcCentroid(collection);
        Matrix matrix = LsqPlane.buildMatrix(collection, this.anchor);
        SingularValueDecomposition singularValueDecomposition = matrix.svd();
        Matrix matrix2 = singularValueDecomposition.getV();
        this.normal = new Triple(matrix2.get(0, matrix2.getColumnDimension() - 1), matrix2.get(1, matrix2.getColumnDimension() - 1), matrix2.get(2, matrix2.getColumnDimension() - 1));
        this.normal.unit();
        this.rmsd = LsqPlane.calcRMSD(collection, this.anchor, this.normal);
    }

    static Triple calcCentroid(Collection collection) {
        Triple triple = new Triple();
        for (Tuple3 tuple3 : collection) {
            triple.add(tuple3);
        }
        triple.mult(1.0 / (double)collection.size());
        return triple;
    }

    static Matrix buildMatrix(Collection collection, Triple triple) {
        Matrix matrix = new Matrix(collection.size(), 3);
        int n = 0;
        for (Tuple3 tuple3 : collection) {
            matrix.set(n, 0, tuple3.getX() - triple.getX());
            matrix.set(n, 1, tuple3.getY() - triple.getY());
            matrix.set(n, 2, tuple3.getZ() - triple.getZ());
            ++n;
        }
        return matrix;
    }

    static double calcRMSD(Collection collection, Triple triple, Triple triple2) {
        Triple triple3 = new Triple();
        double d = 0.0;
        for (Tuple3 tuple3 : collection) {
            triple3.likeVector(triple, tuple3);
            double d2 = triple3.dot(triple2);
            d += d2 * d2;
        }
        return Math.sqrt(d / (double)collection.size());
    }

    public Tuple3 getNormal() {
        return this.normal;
    }

    public Tuple3 getAnchor() {
        return this.anchor;
    }

    public double getRMSD() {
        return this.rmsd;
    }

    public static void main(String[] stringArray) {
        try {
            Triple triple;
            Object object;
            String string;
            ArrayList<Triple> arrayList = new ArrayList<Triple>();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(System.in));
            while ((string = lineNumberReader.readLine()) != null) {
                try {
                    object = Strings.explode(string, ' ');
                    triple = new Triple(Double.parseDouble(object[0]), Double.parseDouble((String)object[1]), Double.parseDouble((String)object[2]));
                    arrayList.add(triple);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println(numberFormatException.getMessage());
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    System.err.println(indexOutOfBoundsException.getMessage());
                }
            }
            object = new LsqPlane(arrayList);
            System.out.println("Anchor: " + ((LsqPlane)object).getAnchor());
            System.out.println("Normal: " + ((LsqPlane)object).getNormal());
            triple = new Triple(((LsqPlane)object).getAnchor()).add(((LsqPlane)object).getNormal());
            System.out.println("Ar+Nm : " + triple);
            System.out.println("RMSD  : " + ((LsqPlane)object).getRMSD());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

